// This file is part of AsmJit project <https://asmjit.com>
//
// See <asmjit/core.h> or LICENSE.md for license and copyright information
// SPDX-License-Identifier: Zlib

#include <asmjit/core.h>
#if !defined(ASMJIT_NO_X86)

#include <asmjit/x86.h>

#include <asmjit-testing/tests/asmjit_test_assembler.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

using namespace asmjit;

#define TEST_INSTRUCTION(OPCODE, ...) \
  tester.test_valid_instruction(#__VA_ARGS__, OPCODE, tester.assembler.__VA_ARGS__)

static void ASMJIT_NOINLINE test_x64_assembler_base(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("80D101"                        , adc(cl, 1));
  TEST_INSTRUCTION("80D501"                        , adc(ch, 1));
  TEST_INSTRUCTION("8094118000000001"              , adc(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683D101"                      , adc(cx, 1));
  TEST_INSTRUCTION("668394118000000001"            , adc(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83D101"                        , adc(ecx, 1));
  TEST_INSTRUCTION("8394118000000001"              , adc(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4811D1"                        , adc(rcx, rdx));
  TEST_INSTRUCTION("4883D101"                      , adc(rcx, 1));
  TEST_INSTRUCTION("48119C1180000000"              , adc(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48119C1180000000"              , adc(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("488394118000000001"            , adc(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("10D1"                          , adc(cl, dl));
  TEST_INSTRUCTION("10F1"                          , adc(cl, dh));
  TEST_INSTRUCTION("10D5"                          , adc(ch, dl));
  TEST_INSTRUCTION("10F5"                          , adc(ch, dh));
  TEST_INSTRUCTION("109C1180000000"                , adc(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("10BC1180000000"                , adc(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("109C1180000000"                , adc(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("10BC1180000000"                , adc(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6611D1"                        , adc(cx, dx));
  TEST_INSTRUCTION("66119C1180000000"              , adc(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66119C1180000000"              , adc(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("11D1"                          , adc(ecx, edx));
  TEST_INSTRUCTION("119C1180000000"                , adc(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("119C1180000000"                , adc(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("128C1A80000000"                , adc(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("128C1A80000000"                , adc(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("12AC1A80000000"                , adc(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("12AC1A80000000"                , adc(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66138C1A80000000"              , adc(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66138C1A80000000"              , adc(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("138C1A80000000"                , adc(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("138C1A80000000"                , adc(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48138C1A80000000"              , adc(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48138C1A80000000"              , adc(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("80C101"                        , add(cl, 1));
  TEST_INSTRUCTION("80C501"                        , add(ch, 1));
  TEST_INSTRUCTION("8084118000000001"              , add(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683C101"                      , add(cx, 1));
  TEST_INSTRUCTION("668384118000000001"            , add(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83C101"                        , add(ecx, 1));
  TEST_INSTRUCTION("8384118000000001"              , add(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4801D1"                        , add(rcx, rdx));
  TEST_INSTRUCTION("4883C101"                      , add(rcx, 1));
  TEST_INSTRUCTION("48019C1180000000"              , add(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48019C1180000000"              , add(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("488384118000000001"            , add(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("00D1"                          , add(cl, dl));
  TEST_INSTRUCTION("00F1"                          , add(cl, dh));
  TEST_INSTRUCTION("00D5"                          , add(ch, dl));
  TEST_INSTRUCTION("00F5"                          , add(ch, dh));
  TEST_INSTRUCTION("009C1180000000"                , add(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("00BC1180000000"                , add(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("009C1180000000"                , add(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("00BC1180000000"                , add(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6601D1"                        , add(cx, dx));
  TEST_INSTRUCTION("66019C1180000000"              , add(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66019C1180000000"              , add(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("01D1"                          , add(ecx, edx));
  TEST_INSTRUCTION("019C1180000000"                , add(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("019C1180000000"                , add(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("028C1A80000000"                , add(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("028C1A80000000"                , add(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("02AC1A80000000"                , add(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("02AC1A80000000"                , add(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66038C1A80000000"              , add(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66038C1A80000000"              , add(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("038C1A80000000"                , add(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("038C1A80000000"                , add(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48038C1A80000000"              , add(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48038C1A80000000"              , add(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("80E101"                        , and_(cl, 1));
  TEST_INSTRUCTION("80E501"                        , and_(ch, 1));
  TEST_INSTRUCTION("6683E101"                      , and_(cx, 1));
  TEST_INSTRUCTION("83E101"                        , and_(ecx, 1));
  TEST_INSTRUCTION("4883E101"                      , and_(rcx, 1));
  TEST_INSTRUCTION("80A4118000000001"              , and_(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683A4118000000001"            , and_(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83A4118000000001"              , and_(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4883A4118000000001"            , and_(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4821D1"                        , and_(rcx, rdx));
  TEST_INSTRUCTION("48238C1A80000000"              , and_(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48238C1A80000000"              , and_(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48219C1180000000"              , and_(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48219C1180000000"              , and_(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("20D1"                          , and_(cl, dl));
  TEST_INSTRUCTION("20F1"                          , and_(cl, dh));
  TEST_INSTRUCTION("20D5"                          , and_(ch, dl));
  TEST_INSTRUCTION("20F5"                          , and_(ch, dh));
  TEST_INSTRUCTION("209C1180000000"                , and_(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("20BC1180000000"                , and_(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("209C1180000000"                , and_(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("20BC1180000000"                , and_(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6621D1"                        , and_(cx, dx));
  TEST_INSTRUCTION("66219C1180000000"              , and_(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66219C1180000000"              , and_(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("21D1"                          , and_(ecx, edx));
  TEST_INSTRUCTION("219C1180000000"                , and_(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("219C1180000000"                , and_(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("228C1A80000000"                , and_(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("228C1A80000000"                , and_(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("22AC1A80000000"                , and_(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("22AC1A80000000"                , and_(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66238C1A80000000"              , and_(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66238C1A80000000"              , and_(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("238C1A80000000"                , and_(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("238C1A80000000"                , and_(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FBCCA"                      , bsf(cx, dx));
  TEST_INSTRUCTION("660FBC8C1A80000000"            , bsf(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FBC8C1A80000000"            , bsf(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBCCA"                        , bsf(ecx, edx));
  TEST_INSTRUCTION("0FBC8C1A80000000"              , bsf(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBC8C1A80000000"              , bsf(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBCCA"                      , bsf(rcx, rdx));
  TEST_INSTRUCTION("480FBC8C1A80000000"            , bsf(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBC8C1A80000000"            , bsf(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FBDCA"                      , bsr(cx, dx));
  TEST_INSTRUCTION("660FBD8C1A80000000"            , bsr(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FBD8C1A80000000"            , bsr(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBDCA"                        , bsr(ecx, edx));
  TEST_INSTRUCTION("0FBD8C1A80000000"              , bsr(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBD8C1A80000000"              , bsr(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBDCA"                      , bsr(rcx, rdx));
  TEST_INSTRUCTION("480FBD8C1A80000000"            , bsr(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBD8C1A80000000"            , bsr(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FC9"                        , bswap(cx));
  TEST_INSTRUCTION("0FC9"                          , bswap(ecx));
  TEST_INSTRUCTION("480FC9"                        , bswap(rcx));
  TEST_INSTRUCTION("660FBAE101"                    , bt(cx, 1));
  TEST_INSTRUCTION("0FBAE101"                      , bt(ecx, 1));
  TEST_INSTRUCTION("480FBAE101"                    , bt(rcx, 1));
  TEST_INSTRUCTION("660FBAA4118000000001"          , bt(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("0FBAA4118000000001"            , bt(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("480FBAA4118000000001"          , bt(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FA3D1"                      , bt(cx, dx));
  TEST_INSTRUCTION("660FA39C1180000000"            , bt(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660FA39C1180000000"            , bt(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0FA3D1"                        , bt(ecx, edx));
  TEST_INSTRUCTION("0FA39C1180000000"              , bt(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FA39C1180000000"              , bt(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FA3D1"                      , bt(rcx, rdx));
  TEST_INSTRUCTION("480FA39C1180000000"            , bt(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FA39C1180000000"            , bt(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660FBAF901"                    , btc(cx, 1));
  TEST_INSTRUCTION("0FBAF901"                      , btc(ecx, 1));
  TEST_INSTRUCTION("480FBAF901"                    , btc(rcx, 1));
  TEST_INSTRUCTION("660FBABC118000000001"          , btc(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("0FBABC118000000001"            , btc(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("480FBABC118000000001"          , btc(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FBBD1"                      , btc(cx, dx));
  TEST_INSTRUCTION("660FBB9C1180000000"            , btc(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660FBB9C1180000000"            , btc(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0FBBD1"                        , btc(ecx, edx));
  TEST_INSTRUCTION("0FBB9C1180000000"              , btc(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FBB9C1180000000"              , btc(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FBBD1"                      , btc(rcx, rdx));
  TEST_INSTRUCTION("480FBB9C1180000000"            , btc(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FBB9C1180000000"            , btc(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660FBAF101"                    , btr(cx, 1));
  TEST_INSTRUCTION("0FBAF101"                      , btr(ecx, 1));
  TEST_INSTRUCTION("480FBAF101"                    , btr(rcx, 1));
  TEST_INSTRUCTION("660FBAB4118000000001"          , btr(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("0FBAB4118000000001"            , btr(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("480FBAB4118000000001"          , btr(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FB3D1"                      , btr(cx, dx));
  TEST_INSTRUCTION("660FB39C1180000000"            , btr(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660FB39C1180000000"            , btr(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0FB3D1"                        , btr(ecx, edx));
  TEST_INSTRUCTION("0FB39C1180000000"              , btr(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FB39C1180000000"              , btr(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FB3D1"                      , btr(rcx, rdx));
  TEST_INSTRUCTION("480FB39C1180000000"            , btr(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FB39C1180000000"            , btr(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660FBAE901"                    , bts(cx, 1));
  TEST_INSTRUCTION("0FBAE901"                      , bts(ecx, 1));
  TEST_INSTRUCTION("480FBAE901"                    , bts(rcx, 1));
  TEST_INSTRUCTION("660FBAAC118000000001"          , bts(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("0FBAAC118000000001"            , bts(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("480FBAAC118000000001"          , bts(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FABD1"                      , bts(cx, dx));
  TEST_INSTRUCTION("660FAB9C1180000000"            , bts(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660FAB9C1180000000"            , bts(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0FABD1"                        , bts(ecx, edx));
  TEST_INSTRUCTION("0FAB9C1180000000"              , bts(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FAB9C1180000000"              , bts(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FABD1"                      , bts(rcx, rdx));
  TEST_INSTRUCTION("480FAB9C1180000000"            , bts(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FAB9C1180000000"            , bts(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("6698"                          , cbw(ax));
  TEST_INSTRUCTION("99"                            , cdq(edx, eax));
  TEST_INSTRUCTION("4898"                          , cdqe(rax));
  TEST_INSTRUCTION("F8"                            , clc());
  TEST_INSTRUCTION("FC"                            , cld());
  TEST_INSTRUCTION("FA"                            , cli());
  TEST_INSTRUCTION("F5"                            , cmc());
  TEST_INSTRUCTION("660F47CA"                      , cmova(cx, dx));
  TEST_INSTRUCTION("660F478C1A80000000"            , cmova(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F478C1A80000000"            , cmova(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F47CA"                        , cmova(ecx, edx));
  TEST_INSTRUCTION("0F478C1A80000000"              , cmova(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F478C1A80000000"              , cmova(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F47CA"                      , cmova(rcx, rdx));
  TEST_INSTRUCTION("480F478C1A80000000"            , cmova(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F478C1A80000000"            , cmova(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F43CA"                      , cmovae(cx, dx));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovae(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovae(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F43CA"                        , cmovae(ecx, edx));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovae(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovae(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F43CA"                      , cmovae(rcx, rdx));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovae(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovae(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F42CA"                      , cmovb(cx, dx));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovb(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovb(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F42CA"                        , cmovb(ecx, edx));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovb(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovb(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F42CA"                      , cmovb(rcx, rdx));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovb(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovb(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F46CA"                      , cmovbe(cx, dx));
  TEST_INSTRUCTION("660F468C1A80000000"            , cmovbe(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F468C1A80000000"            , cmovbe(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F46CA"                        , cmovbe(ecx, edx));
  TEST_INSTRUCTION("0F468C1A80000000"              , cmovbe(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F468C1A80000000"              , cmovbe(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F46CA"                      , cmovbe(rcx, rdx));
  TEST_INSTRUCTION("480F468C1A80000000"            , cmovbe(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F468C1A80000000"            , cmovbe(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F42CA"                      , cmovc(cx, dx));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovc(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovc(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F42CA"                        , cmovc(ecx, edx));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovc(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovc(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F42CA"                      , cmovc(rcx, rdx));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovc(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovc(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F44CA"                      , cmove(cx, dx));
  TEST_INSTRUCTION("660F448C1A80000000"            , cmove(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F448C1A80000000"            , cmove(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F44CA"                        , cmove(ecx, edx));
  TEST_INSTRUCTION("0F448C1A80000000"              , cmove(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F448C1A80000000"              , cmove(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F44CA"                      , cmove(rcx, rdx));
  TEST_INSTRUCTION("480F448C1A80000000"            , cmove(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F448C1A80000000"            , cmove(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4FCA"                      , cmovg(cx, dx));
  TEST_INSTRUCTION("660F4F8C1A80000000"            , cmovg(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4F8C1A80000000"            , cmovg(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4FCA"                        , cmovg(ecx, edx));
  TEST_INSTRUCTION("0F4F8C1A80000000"              , cmovg(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4F8C1A80000000"              , cmovg(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4FCA"                      , cmovg(rcx, rdx));
  TEST_INSTRUCTION("480F4F8C1A80000000"            , cmovg(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4F8C1A80000000"            , cmovg(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4DCA"                      , cmovge(cx, dx));
  TEST_INSTRUCTION("660F4D8C1A80000000"            , cmovge(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4D8C1A80000000"            , cmovge(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4DCA"                        , cmovge(ecx, edx));
  TEST_INSTRUCTION("0F4D8C1A80000000"              , cmovge(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4D8C1A80000000"              , cmovge(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4DCA"                      , cmovge(rcx, rdx));
  TEST_INSTRUCTION("480F4D8C1A80000000"            , cmovge(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4D8C1A80000000"            , cmovge(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4CCA"                      , cmovl(cx, dx));
  TEST_INSTRUCTION("660F4C8C1A80000000"            , cmovl(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4C8C1A80000000"            , cmovl(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4CCA"                        , cmovl(ecx, edx));
  TEST_INSTRUCTION("0F4C8C1A80000000"              , cmovl(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4C8C1A80000000"              , cmovl(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4CCA"                      , cmovl(rcx, rdx));
  TEST_INSTRUCTION("480F4C8C1A80000000"            , cmovl(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4C8C1A80000000"            , cmovl(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4ECA"                      , cmovle(cx, dx));
  TEST_INSTRUCTION("660F4E8C1A80000000"            , cmovle(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4E8C1A80000000"            , cmovle(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4ECA"                        , cmovle(ecx, edx));
  TEST_INSTRUCTION("0F4E8C1A80000000"              , cmovle(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4E8C1A80000000"              , cmovle(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4ECA"                      , cmovle(rcx, rdx));
  TEST_INSTRUCTION("480F4E8C1A80000000"            , cmovle(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4E8C1A80000000"            , cmovle(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F46CA"                      , cmovna(cx, dx));
  TEST_INSTRUCTION("660F468C1A80000000"            , cmovna(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F468C1A80000000"            , cmovna(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F46CA"                        , cmovna(ecx, edx));
  TEST_INSTRUCTION("0F468C1A80000000"              , cmovna(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F468C1A80000000"              , cmovna(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F46CA"                      , cmovna(rcx, rdx));
  TEST_INSTRUCTION("480F468C1A80000000"            , cmovna(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F468C1A80000000"            , cmovna(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F42CA"                      , cmovnae(cx, dx));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovnae(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F428C1A80000000"            , cmovnae(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F42CA"                        , cmovnae(ecx, edx));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovnae(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F428C1A80000000"              , cmovnae(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F42CA"                      , cmovnae(rcx, rdx));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovnae(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F428C1A80000000"            , cmovnae(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F43CA"                      , cmovnb(cx, dx));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovnb(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovnb(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F43CA"                        , cmovnb(ecx, edx));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovnb(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovnb(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F43CA"                      , cmovnb(rcx, rdx));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovnb(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovnb(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F47CA"                      , cmovnbe(cx, dx));
  TEST_INSTRUCTION("660F478C1A80000000"            , cmovnbe(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F478C1A80000000"            , cmovnbe(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F47CA"                        , cmovnbe(ecx, edx));
  TEST_INSTRUCTION("0F478C1A80000000"              , cmovnbe(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F478C1A80000000"              , cmovnbe(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F47CA"                      , cmovnbe(rcx, rdx));
  TEST_INSTRUCTION("480F478C1A80000000"            , cmovnbe(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F478C1A80000000"            , cmovnbe(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F43CA"                      , cmovnc(cx, dx));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovnc(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F438C1A80000000"            , cmovnc(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F43CA"                        , cmovnc(ecx, edx));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovnc(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F438C1A80000000"              , cmovnc(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F43CA"                      , cmovnc(rcx, rdx));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovnc(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F438C1A80000000"            , cmovnc(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F45CA"                      , cmovne(cx, dx));
  TEST_INSTRUCTION("660F458C1A80000000"            , cmovne(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F458C1A80000000"            , cmovne(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F45CA"                        , cmovne(ecx, edx));
  TEST_INSTRUCTION("0F458C1A80000000"              , cmovne(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F458C1A80000000"              , cmovne(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F45CA"                      , cmovne(rcx, rdx));
  TEST_INSTRUCTION("480F458C1A80000000"            , cmovne(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F458C1A80000000"            , cmovne(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4ECA"                      , cmovng(cx, dx));
  TEST_INSTRUCTION("660F4E8C1A80000000"            , cmovng(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4E8C1A80000000"            , cmovng(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4ECA"                        , cmovng(ecx, edx));
  TEST_INSTRUCTION("0F4E8C1A80000000"              , cmovng(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4E8C1A80000000"              , cmovng(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4ECA"                      , cmovng(rcx, rdx));
  TEST_INSTRUCTION("480F4E8C1A80000000"            , cmovng(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4E8C1A80000000"            , cmovng(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4CCA"                      , cmovnge(cx, dx));
  TEST_INSTRUCTION("660F4C8C1A80000000"            , cmovnge(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4C8C1A80000000"            , cmovnge(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4CCA"                        , cmovnge(ecx, edx));
  TEST_INSTRUCTION("0F4C8C1A80000000"              , cmovnge(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4C8C1A80000000"              , cmovnge(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4CCA"                      , cmovnge(rcx, rdx));
  TEST_INSTRUCTION("480F4C8C1A80000000"            , cmovnge(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4C8C1A80000000"            , cmovnge(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4DCA"                      , cmovnl(cx, dx));
  TEST_INSTRUCTION("660F4D8C1A80000000"            , cmovnl(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4D8C1A80000000"            , cmovnl(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4DCA"                        , cmovnl(ecx, edx));
  TEST_INSTRUCTION("0F4D8C1A80000000"              , cmovnl(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4D8C1A80000000"              , cmovnl(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4DCA"                      , cmovnl(rcx, rdx));
  TEST_INSTRUCTION("480F4D8C1A80000000"            , cmovnl(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4D8C1A80000000"            , cmovnl(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4FCA"                      , cmovnle(cx, dx));
  TEST_INSTRUCTION("660F4F8C1A80000000"            , cmovnle(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4F8C1A80000000"            , cmovnle(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4FCA"                        , cmovnle(ecx, edx));
  TEST_INSTRUCTION("0F4F8C1A80000000"              , cmovnle(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4F8C1A80000000"              , cmovnle(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4FCA"                      , cmovnle(rcx, rdx));
  TEST_INSTRUCTION("480F4F8C1A80000000"            , cmovnle(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4F8C1A80000000"            , cmovnle(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F41CA"                      , cmovno(cx, dx));
  TEST_INSTRUCTION("660F418C1A80000000"            , cmovno(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F418C1A80000000"            , cmovno(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F41CA"                        , cmovno(ecx, edx));
  TEST_INSTRUCTION("0F418C1A80000000"              , cmovno(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F418C1A80000000"              , cmovno(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F41CA"                      , cmovno(rcx, rdx));
  TEST_INSTRUCTION("480F418C1A80000000"            , cmovno(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F418C1A80000000"            , cmovno(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4BCA"                      , cmovnp(cx, dx));
  TEST_INSTRUCTION("660F4B8C1A80000000"            , cmovnp(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4B8C1A80000000"            , cmovnp(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4BCA"                        , cmovnp(ecx, edx));
  TEST_INSTRUCTION("0F4B8C1A80000000"              , cmovnp(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4B8C1A80000000"              , cmovnp(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4BCA"                      , cmovnp(rcx, rdx));
  TEST_INSTRUCTION("480F4B8C1A80000000"            , cmovnp(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4B8C1A80000000"            , cmovnp(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F49CA"                      , cmovns(cx, dx));
  TEST_INSTRUCTION("660F498C1A80000000"            , cmovns(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F498C1A80000000"            , cmovns(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F49CA"                        , cmovns(ecx, edx));
  TEST_INSTRUCTION("0F498C1A80000000"              , cmovns(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F498C1A80000000"              , cmovns(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F49CA"                      , cmovns(rcx, rdx));
  TEST_INSTRUCTION("480F498C1A80000000"            , cmovns(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F498C1A80000000"            , cmovns(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F45CA"                      , cmovnz(cx, dx));
  TEST_INSTRUCTION("660F458C1A80000000"            , cmovnz(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F458C1A80000000"            , cmovnz(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F45CA"                        , cmovnz(ecx, edx));
  TEST_INSTRUCTION("0F458C1A80000000"              , cmovnz(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F458C1A80000000"              , cmovnz(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F45CA"                      , cmovnz(rcx, rdx));
  TEST_INSTRUCTION("480F458C1A80000000"            , cmovnz(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F458C1A80000000"            , cmovnz(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F40CA"                      , cmovo(cx, dx));
  TEST_INSTRUCTION("660F408C1A80000000"            , cmovo(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F408C1A80000000"            , cmovo(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F40CA"                        , cmovo(ecx, edx));
  TEST_INSTRUCTION("0F408C1A80000000"              , cmovo(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F408C1A80000000"              , cmovo(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F40CA"                      , cmovo(rcx, rdx));
  TEST_INSTRUCTION("480F408C1A80000000"            , cmovo(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F408C1A80000000"            , cmovo(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4ACA"                      , cmovp(cx, dx));
  TEST_INSTRUCTION("660F4A8C1A80000000"            , cmovp(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4A8C1A80000000"            , cmovp(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4ACA"                        , cmovp(ecx, edx));
  TEST_INSTRUCTION("0F4A8C1A80000000"              , cmovp(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4A8C1A80000000"              , cmovp(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4ACA"                      , cmovp(rcx, rdx));
  TEST_INSTRUCTION("480F4A8C1A80000000"            , cmovp(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4A8C1A80000000"            , cmovp(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4ACA"                      , cmovpe(cx, dx));
  TEST_INSTRUCTION("660F4A8C1A80000000"            , cmovpe(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4A8C1A80000000"            , cmovpe(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4ACA"                        , cmovpe(ecx, edx));
  TEST_INSTRUCTION("0F4A8C1A80000000"              , cmovpe(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4A8C1A80000000"              , cmovpe(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4ACA"                      , cmovpe(rcx, rdx));
  TEST_INSTRUCTION("480F4A8C1A80000000"            , cmovpe(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4A8C1A80000000"            , cmovpe(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4BCA"                      , cmovpo(cx, dx));
  TEST_INSTRUCTION("660F4B8C1A80000000"            , cmovpo(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F4B8C1A80000000"            , cmovpo(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4BCA"                        , cmovpo(ecx, edx));
  TEST_INSTRUCTION("0F4B8C1A80000000"              , cmovpo(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F4B8C1A80000000"              , cmovpo(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4BCA"                      , cmovpo(rcx, rdx));
  TEST_INSTRUCTION("480F4B8C1A80000000"            , cmovpo(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F4B8C1A80000000"            , cmovpo(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F48CA"                      , cmovs(cx, dx));
  TEST_INSTRUCTION("660F488C1A80000000"            , cmovs(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F488C1A80000000"            , cmovs(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F48CA"                        , cmovs(ecx, edx));
  TEST_INSTRUCTION("0F488C1A80000000"              , cmovs(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F488C1A80000000"              , cmovs(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F48CA"                      , cmovs(rcx, rdx));
  TEST_INSTRUCTION("480F488C1A80000000"            , cmovs(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F488C1A80000000"            , cmovs(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F44CA"                      , cmovz(cx, dx));
  TEST_INSTRUCTION("660F448C1A80000000"            , cmovz(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F448C1A80000000"            , cmovz(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F44CA"                        , cmovz(ecx, edx));
  TEST_INSTRUCTION("0F448C1A80000000"              , cmovz(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F448C1A80000000"              , cmovz(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F44CA"                      , cmovz(rcx, rdx));
  TEST_INSTRUCTION("480F448C1A80000000"            , cmovz(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F448C1A80000000"            , cmovz(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("80F901"                        , cmp(cl, 1));
  TEST_INSTRUCTION("80FD01"                        , cmp(ch, 1));
  TEST_INSTRUCTION("80BC118000000001"              , cmp(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683F901"                      , cmp(cx, 1));
  TEST_INSTRUCTION("6683BC118000000001"            , cmp(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83F901"                        , cmp(ecx, 1));
  TEST_INSTRUCTION("83BC118000000001"              , cmp(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4839D1"                        , cmp(rcx, rdx));
  TEST_INSTRUCTION("4883F901"                      , cmp(rcx, 1));
  TEST_INSTRUCTION("48399C1180000000"              , cmp(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48399C1180000000"              , cmp(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("4883BC118000000001"            , cmp(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("38D1"                          , cmp(cl, dl));
  TEST_INSTRUCTION("38F1"                          , cmp(cl, dh));
  TEST_INSTRUCTION("38D5"                          , cmp(ch, dl));
  TEST_INSTRUCTION("38F5"                          , cmp(ch, dh));
  TEST_INSTRUCTION("389C1180000000"                , cmp(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("38BC1180000000"                , cmp(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("389C1180000000"                , cmp(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("38BC1180000000"                , cmp(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6639D1"                        , cmp(cx, dx));
  TEST_INSTRUCTION("66399C1180000000"              , cmp(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66399C1180000000"              , cmp(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("39D1"                          , cmp(ecx, edx));
  TEST_INSTRUCTION("399C1180000000"                , cmp(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("399C1180000000"                , cmp(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("3A8C1A80000000"                , cmp(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("3A8C1A80000000"                , cmp(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("3AAC1A80000000"                , cmp(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("3AAC1A80000000"                , cmp(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("663B8C1A80000000"              , cmp(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("663B8C1A80000000"              , cmp(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("3B8C1A80000000"                , cmp(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("3B8C1A80000000"                , cmp(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("483B8C1A80000000"              , cmp(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("483B8C1A80000000"              , cmp(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("A6"                            , cmps(byte_ptr(rsi), byte_ptr(rdi)));
  TEST_INSTRUCTION("66A7"                          , cmps(word_ptr(rsi), word_ptr(rdi)));
  TEST_INSTRUCTION("A7"                            , cmps(dword_ptr(rsi), dword_ptr(rdi)));
  TEST_INSTRUCTION("48A7"                          , cmps(qword_ptr(rsi), qword_ptr(rdi)));
  TEST_INSTRUCTION("0FB0D1"                        , cmpxchg(cl, dl, al));
  TEST_INSTRUCTION("0FB0F1"                        , cmpxchg(cl, dh, al));
  TEST_INSTRUCTION("0FB0D5"                        , cmpxchg(ch, dl, al));
  TEST_INSTRUCTION("0FB0F5"                        , cmpxchg(ch, dh, al));
  TEST_INSTRUCTION("0FB09C1180000000"              , cmpxchg(ptr(rcx, rdx, 0, 128), bl, al));
  TEST_INSTRUCTION("0FB0BC1180000000"              , cmpxchg(ptr(rcx, rdx, 0, 128), bh, al));
  TEST_INSTRUCTION("0FB09C1180000000"              , cmpxchg(byte_ptr(rcx, rdx, 0, 128), bl, al));
  TEST_INSTRUCTION("0FB0BC1180000000"              , cmpxchg(byte_ptr(rcx, rdx, 0, 128), bh, al));
  TEST_INSTRUCTION("660FB1D1"                      , cmpxchg(cx, dx, ax));
  TEST_INSTRUCTION("660FB19C1180000000"            , cmpxchg(ptr(rcx, rdx, 0, 128), bx, ax));
  TEST_INSTRUCTION("660FB19C1180000000"            , cmpxchg(word_ptr(rcx, rdx, 0, 128), bx, ax));
  TEST_INSTRUCTION("0FB1D1"                        , cmpxchg(ecx, edx, eax));
  TEST_INSTRUCTION("0FB19C1180000000"              , cmpxchg(ptr(rcx, rdx, 0, 128), ebx, eax));
  TEST_INSTRUCTION("0FB19C1180000000"              , cmpxchg(dword_ptr(rcx, rdx, 0, 128), ebx, eax));
  TEST_INSTRUCTION("480FB1D1"                      , cmpxchg(rcx, rdx, rax));
  TEST_INSTRUCTION("480FB19C1180000000"            , cmpxchg(ptr(rcx, rdx, 0, 128), rbx, rax));
  TEST_INSTRUCTION("480FB19C1180000000"            , cmpxchg(qword_ptr(rcx, rdx, 0, 128), rbx, rax));
  TEST_INSTRUCTION("480FC78C1180000000"            , cmpxchg16b(ptr(rcx, rdx, 0, 128), rdx, rax, rcx, rbx));
  TEST_INSTRUCTION("480FC78C1180000000"            , cmpxchg16b(xmmword_ptr(rcx, rdx, 0, 128), rdx, rax, rcx, rbx));
  TEST_INSTRUCTION("0FC78C1180000000"              , cmpxchg8b(ptr(rcx, rdx, 0, 128), edx, eax, ecx, ebx));
  TEST_INSTRUCTION("0FC78C1180000000"              , cmpxchg8b(qword_ptr(rcx, rdx, 0, 128), edx, eax, ecx, ebx));
  TEST_INSTRUCTION("0FA2"                          , cpuid(eax, ebx, ecx, edx));
  TEST_INSTRUCTION("4899"                          , cqo(rdx, rax));
  TEST_INSTRUCTION("6699"                          , cwd(dx, ax));
  TEST_INSTRUCTION("98"                            , cwde(eax));
  TEST_INSTRUCTION("FEC9"                          , dec(cl));
  TEST_INSTRUCTION("FECD"                          , dec(ch));
  TEST_INSTRUCTION("66FFC9"                        , dec(cx));
  TEST_INSTRUCTION("FFC9"                          , dec(ecx));
  TEST_INSTRUCTION("48FFC9"                        , dec(rcx));
  TEST_INSTRUCTION("FE8C1180000000"                , dec(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66FF8C1180000000"              , dec(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("FF8C1180000000"                , dec(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48FF8C1180000000"              , dec(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6F1"                          , div(ax, cl));
  TEST_INSTRUCTION("F6F5"                          , div(ax, ch));
  TEST_INSTRUCTION("F6B41180000000"                , div(ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6B41180000000"                , div(ax, byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7F1"                        , div(dx, ax, cx));
  TEST_INSTRUCTION("66F7B41180000000"              , div(dx, ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7B41180000000"              , div(dx, ax, word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7F1"                          , div(edx, eax, ecx));
  TEST_INSTRUCTION("F7B41180000000"                , div(edx, eax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7B41180000000"                , div(edx, eax, dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7F1"                        , div(rdx, rax, rcx));
  TEST_INSTRUCTION("48F7B41180000000"              , div(rdx, rax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7B41180000000"              , div(rdx, rax, qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("C8010002"                      , enter(1, 2));
  TEST_INSTRUCTION("F4"                            , hlt());
  TEST_INSTRUCTION("F6F9"                          , idiv(ax, cl));
  TEST_INSTRUCTION("F6FD"                          , idiv(ax, ch));
  TEST_INSTRUCTION("F6BC1180000000"                , idiv(ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6BC1180000000"                , idiv(ax, byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7F9"                        , idiv(dx, ax, cx));
  TEST_INSTRUCTION("66F7BC1180000000"              , idiv(dx, ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7BC1180000000"              , idiv(dx, ax, word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7F9"                          , idiv(edx, eax, ecx));
  TEST_INSTRUCTION("F7BC1180000000"                , idiv(edx, eax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7BC1180000000"                , idiv(edx, eax, dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7F9"                        , idiv(rdx, rax, rcx));
  TEST_INSTRUCTION("48F7BC1180000000"              , idiv(rdx, rax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7BC1180000000"              , idiv(rdx, rax, qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6E9"                          , imul(ax, cl));
  TEST_INSTRUCTION("F6ED"                          , imul(ax, ch));
  TEST_INSTRUCTION("660FAF841180000000"            , imul(ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6AC1180000000"                , imul(ax, byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7E9"                        , imul(dx, ax, cx));
  TEST_INSTRUCTION("66F7AC1180000000"              , imul(dx, ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7AC1180000000"              , imul(dx, ax, word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7E9"                          , imul(edx, eax, ecx));
  TEST_INSTRUCTION("F7AC1180000000"                , imul(edx, eax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7AC1180000000"                , imul(edx, eax, dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7E9"                        , imul(rdx, rax, rcx));
  TEST_INSTRUCTION("48F7AC1180000000"              , imul(rdx, rax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7AC1180000000"              , imul(rdx, rax, qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660FAFCA"                      , imul(cx, dx));
  TEST_INSTRUCTION("666BC901"                      , imul(cx, 1));
  TEST_INSTRUCTION("660FAF8C1A80000000"            , imul(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FAF8C1A80000000"            , imul(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FAFCA"                        , imul(ecx, edx));
  TEST_INSTRUCTION("6BC901"                        , imul(ecx, 1));
  TEST_INSTRUCTION("0FAF8C1A80000000"              , imul(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FAF8C1A80000000"              , imul(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FAFCA"                      , imul(rcx, rdx));
  TEST_INSTRUCTION("486BC901"                      , imul(rcx, 1));
  TEST_INSTRUCTION("480FAF8C1A80000000"            , imul(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FAF8C1A80000000"            , imul(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("666BC901"                      , imul(cx, cx, 1));
  TEST_INSTRUCTION("666BCA01"                      , imul(cx, dx, 1));
  TEST_INSTRUCTION("666B8C1A8000000001"            , imul(cx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("666B8C1A8000000001"            , imul(cx, word_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("6BC901"                        , imul(ecx, ecx, 1));
  TEST_INSTRUCTION("6BCA01"                        , imul(ecx, edx, 1));
  TEST_INSTRUCTION("6B8C1A8000000001"              , imul(ecx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("6B8C1A8000000001"              , imul(ecx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("486BC901"                      , imul(rcx, rcx, 1));
  TEST_INSTRUCTION("486BCA01"                      , imul(rcx, rdx, 1));
  TEST_INSTRUCTION("486B8C1A8000000001"            , imul(rcx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("486B8C1A8000000001"            , imul(rcx, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("EC"                            , in(al, dx));
  TEST_INSTRUCTION("E401"                          , in(al, 1));
  TEST_INSTRUCTION("66ED"                          , in(ax, dx));
  TEST_INSTRUCTION("66E501"                        , in(ax, 1));
  TEST_INSTRUCTION("ED"                            , in(eax, dx));
  TEST_INSTRUCTION("E501"                          , in(eax, 1));
  TEST_INSTRUCTION("FEC1"                          , inc(cl));
  TEST_INSTRUCTION("FEC5"                          , inc(ch));
  TEST_INSTRUCTION("66FFC1"                        , inc(cx));
  TEST_INSTRUCTION("FFC1"                          , inc(ecx));
  TEST_INSTRUCTION("48FFC1"                        , inc(rcx));
  TEST_INSTRUCTION("FE841180000000"                , inc(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66FF841180000000"              , inc(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("FF841180000000"                , inc(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48FF841180000000"              , inc(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("6C"                            , ins(byte_ptr(rdi), dx));
  TEST_INSTRUCTION("666D"                          , ins(word_ptr(rdi), dx));
  TEST_INSTRUCTION("6D"                            , ins(dword_ptr(rdi), dx));
  TEST_INSTRUCTION("CD01"                          , int_(1));
  TEST_INSTRUCTION("CC"                            , int3());
  TEST_INSTRUCTION("0F08"                          , invd());
  TEST_INSTRUCTION("0F01BC1180000000"              , invlpg(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660F38828C1A80000000"          , invpcid(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38828C1A80000000"          , invpcid(rcx, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66CF"                          , iret());
  TEST_INSTRUCTION("CF"                            , iretd());
  TEST_INSTRUCTION("48CF"                          , iretq());
  TEST_INSTRUCTION("9F"                            , lahf(ah));
  TEST_INSTRUCTION("660F02CA"                      , lar(cx, dx));
  TEST_INSTRUCTION("660F028C1A80000000"            , lar(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F028C1A80000000"            , lar(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F02CA"                        , lar(ecx, edx));
  TEST_INSTRUCTION("0F028C1A80000000"              , lar(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F028C1A80000000"              , lar(ecx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48FF9C1180000000"              , lcall(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66FF9C1180000000"              , lcall(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("FF9C1180000000"                , lcall(fword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48FF9C1180000000"              , lcall(tbyte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("668D8C1A80000000"              , lea(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8D8C1A80000000"                , lea(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("488D8C1A80000000"              , lea(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C9"                            , leave());
  TEST_INSTRUCTION("660FB48C1A80000000"            , lfs(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FB48C1A80000000"            , lfs(cx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB48C1A80000000"              , lfs(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB48C1A80000000"              , lfs(ecx, fword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB48C1A80000000"            , lfs(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB48C1A80000000"            , lfs(rcx, tbyte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F01941180000000"              , lgdt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660FB58C1A80000000"            , lgs(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FB58C1A80000000"            , lgs(cx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB58C1A80000000"              , lgs(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB58C1A80000000"              , lgs(ecx, fword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB58C1A80000000"            , lgs(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB58C1A80000000"            , lgs(rcx, tbyte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F019C1180000000"              , lidt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48FFAC1180000000"              , ljmp(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66FFAC1180000000"              , ljmp(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("FFAC1180000000"                , ljmp(fword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48FFAC1180000000"              , ljmp(tbyte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00D1"                        , lldt(cx));
  TEST_INSTRUCTION("0F00941180000000"              , lldt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00941180000000"              , lldt(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01F1"                        , lmsw(cx));
  TEST_INSTRUCTION("0F01B41180000000"              , lmsw(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01B41180000000"              , lmsw(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("AC"                            , lods(al, ptr(rsi)));
  TEST_INSTRUCTION("AC"                            , lods(al, byte_ptr(rsi)));
  TEST_INSTRUCTION("66AD"                          , lods(ax, ptr(rsi)));
  TEST_INSTRUCTION("66AD"                          , lods(ax, word_ptr(rsi)));
  TEST_INSTRUCTION("AD"                            , lods(eax, ptr(rsi)));
  TEST_INSTRUCTION("AD"                            , lods(eax, dword_ptr(rsi)));
  TEST_INSTRUCTION("48AD"                          , lods(rax, ptr(rsi)));
  TEST_INSTRUCTION("48AD"                          , lods(rax, qword_ptr(rsi)));
  TEST_INSTRUCTION("660F03CA"                      , lsl(cx, dx));
  TEST_INSTRUCTION("660F038C1A80000000"            , lsl(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F038C1A80000000"            , lsl(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F03CA"                        , lsl(ecx, edx));
  TEST_INSTRUCTION("0F038C1A80000000"              , lsl(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F038C1A80000000"              , lsl(ecx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F03CA"                      , lsl(rcx, edx));
  TEST_INSTRUCTION("480F038C1A80000000"            , lsl(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F038C1A80000000"            , lsl(rcx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FB28C1A80000000"            , lss(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FB28C1A80000000"            , lss(cx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB28C1A80000000"              , lss(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB28C1A80000000"              , lss(ecx, fword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB28C1A80000000"            , lss(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB28C1A80000000"            , lss(rcx, tbyte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F00D9"                        , ltr(cx));
  TEST_INSTRUCTION("0F009C1180000000"              , ltr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F009C1180000000"              , ltr(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("88D1"                          , mov(cl, dl));
  TEST_INSTRUCTION("88F1"                          , mov(cl, dh));
  TEST_INSTRUCTION("88D5"                          , mov(ch, dl));
  TEST_INSTRUCTION("88F5"                          , mov(ch, dh));
  TEST_INSTRUCTION("889C1180000000"                , mov(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("88BC1180000000"                , mov(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("889C1180000000"                , mov(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("88BC1180000000"                , mov(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6689D1"                        , mov(cx, dx));
  TEST_INSTRUCTION("668EE2"                        , mov(fs, dx));
  TEST_INSTRUCTION("66899C1180000000"              , mov(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66899C1180000000"              , mov(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("89D1"                          , mov(ecx, edx));
  TEST_INSTRUCTION("8EE2"                          , mov(fs, edx));
  TEST_INSTRUCTION("899C1180000000"                , mov(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("899C1180000000"                , mov(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("4889D1"                        , mov(rcx, rdx));
  TEST_INSTRUCTION("488EE2"                        , mov(fs, rdx));
  TEST_INSTRUCTION("0F22CA"                        , mov(cr1, rdx));
  TEST_INSTRUCTION("0F23CA"                        , mov(dr1, rdx));
  TEST_INSTRUCTION("48899C1180000000"              , mov(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48899C1180000000"              , mov(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("B101"                          , mov(cl, 1));
  TEST_INSTRUCTION("B501"                          , mov(ch, 1));
  TEST_INSTRUCTION("C684118000000001"              , mov(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66B90100"                      , mov(cx, 1));
  TEST_INSTRUCTION("66C78411800000000100"          , mov(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("B901000000"                    , mov(ecx, 1));
  TEST_INSTRUCTION("C784118000000001000000"        , mov(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48C7C101000000"                , mov(rcx, 1));
  TEST_INSTRUCTION("48C784118000000001000000"      , mov(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("488CE1"                        , mov(rcx, fs));
  TEST_INSTRUCTION("0F20D1"                        , mov(rcx, cr2));
  TEST_INSTRUCTION("0F21D1"                        , mov(rcx, dr2));
  TEST_INSTRUCTION("488B8C1A80000000"              , mov(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("488B8C1A80000000"              , mov(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8A8C1A80000000"                , mov(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8A8C1A80000000"                , mov(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8AAC1A80000000"                , mov(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8AAC1A80000000"                , mov(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("668CE1"                        , mov(cx, fs));
  TEST_INSTRUCTION("668B8C1A80000000"              , mov(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("668B8C1A80000000"              , mov(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8CE1"                          , mov(ecx, fs));
  TEST_INSTRUCTION("8B8C1A80000000"                , mov(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8B8C1A80000000"                , mov(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8CA41180000000"                , mov(ptr(rcx, rdx, 0, 128), fs));
  TEST_INSTRUCTION("668CA41180000000"              , mov(word_ptr(rcx, rdx, 0, 128), fs));
  TEST_INSTRUCTION("8EA41A80000000"                , mov(fs, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("668EA41A80000000"              , mov(fs, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48B90100000000000000"          , movabs(rcx, 1));
  TEST_INSTRUCTION("A4"                            , movs(byte_ptr(rdi), byte_ptr(rsi)));
  TEST_INSTRUCTION("66A5"                          , movs(word_ptr(rdi), word_ptr(rsi)));
  TEST_INSTRUCTION("A5"                            , movs(dword_ptr(rdi), dword_ptr(rsi)));
  TEST_INSTRUCTION("48A5"                          , movs(qword_ptr(rdi), qword_ptr(rsi)));
  TEST_INSTRUCTION("660FBECA"                      , movsx(cx, dl));
  TEST_INSTRUCTION("660FBECE"                      , movsx(cx, dh));
  TEST_INSTRUCTION("660FBE8C1A80000000"            , movsx(cx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBECA"                        , movsx(ecx, dl));
  TEST_INSTRUCTION("0FBECE"                        , movsx(ecx, dh));
  TEST_INSTRUCTION("0FBFCA"                        , movsx(ecx, dx));
  TEST_INSTRUCTION("0FBE8C1A80000000"              , movsx(ecx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FBF8C1A80000000"              , movsx(ecx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBECA"                      , movsx(rcx, dl));
  TEST_INSTRUCTION("480FBFCA"                      , movsx(rcx, dx));
  TEST_INSTRUCTION("480FBE8C1A80000000"            , movsx(rcx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FBF8C1A80000000"            , movsx(rcx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("6663CA"                        , movsxd(cx, dx));
  TEST_INSTRUCTION("66638C1A80000000"              , movsxd(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66638C1A80000000"              , movsxd(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("63CA"                          , movsxd(ecx, edx));
  TEST_INSTRUCTION("638C1A80000000"                , movsxd(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("638C1A80000000"                , movsxd(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("4863CA"                        , movsxd(rcx, edx));
  TEST_INSTRUCTION("48638C1A80000000"              , movsxd(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48638C1A80000000"              , movsxd(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FB6CA"                      , movzx(cx, dl));
  TEST_INSTRUCTION("660FB6CE"                      , movzx(cx, dh));
  TEST_INSTRUCTION("660FB68C1A80000000"            , movzx(cx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB6CA"                        , movzx(ecx, dl));
  TEST_INSTRUCTION("0FB6CE"                        , movzx(ecx, dh));
  TEST_INSTRUCTION("0FB7CA"                        , movzx(ecx, dx));
  TEST_INSTRUCTION("0FB68C1A80000000"              , movzx(ecx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB78C1A80000000"              , movzx(ecx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB6CA"                      , movzx(rcx, dl));
  TEST_INSTRUCTION("480FB7CA"                      , movzx(rcx, dx));
  TEST_INSTRUCTION("480FB68C1A80000000"            , movzx(rcx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480FB78C1A80000000"            , movzx(rcx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F6E1"                          , mul(ax, cl));
  TEST_INSTRUCTION("F6E5"                          , mul(ax, ch));
  TEST_INSTRUCTION("F6A41180000000"                , mul(ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6A41180000000"                , mul(ax, byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7E1"                        , mul(dx, ax, cx));
  TEST_INSTRUCTION("66F7A41180000000"              , mul(dx, ax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7A41180000000"              , mul(dx, ax, word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7E1"                          , mul(edx, eax, ecx));
  TEST_INSTRUCTION("F7A41180000000"                , mul(edx, eax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7A41180000000"                , mul(edx, eax, dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7E1"                        , mul(rdx, rax, rcx));
  TEST_INSTRUCTION("48F7A41180000000"              , mul(rdx, rax, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7A41180000000"              , mul(rdx, rax, qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F6D9"                          , neg(cl));
  TEST_INSTRUCTION("F6DD"                          , neg(ch));
  TEST_INSTRUCTION("66F7D9"                        , neg(cx));
  TEST_INSTRUCTION("F7D9"                          , neg(ecx));
  TEST_INSTRUCTION("48F7D9"                        , neg(rcx));
  TEST_INSTRUCTION("F69C1180000000"                , neg(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F79C1180000000"              , neg(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F79C1180000000"                , neg(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F79C1180000000"              , neg(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("90"                            , nop());
  TEST_INSTRUCTION("660F1FC1"                      , nop(cx));
  TEST_INSTRUCTION("0F1FC1"                        , nop(ecx));
  TEST_INSTRUCTION("480F1FC1"                      , nop(rcx));
  TEST_INSTRUCTION("660F1F841180000000"            , nop(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F1F841180000000"              , nop(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("480F1F841180000000"            , nop(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660F1FD1"                      , nop(cx, dx));
  TEST_INSTRUCTION("660F1F9C1180000000"            , nop(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660F1F9C1180000000"            , nop(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0F1FD1"                        , nop(ecx, edx));
  TEST_INSTRUCTION("0F1F9C1180000000"              , nop(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0F1F9C1180000000"              , nop(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480F1FD1"                      , nop(rcx, rdx));
  TEST_INSTRUCTION("480F1F9C1180000000"            , nop(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480F1F9C1180000000"            , nop(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("F6D1"                          , not_(cl));
  TEST_INSTRUCTION("F6D5"                          , not_(ch));
  TEST_INSTRUCTION("66F7D1"                        , not_(cx));
  TEST_INSTRUCTION("F7D1"                          , not_(ecx));
  TEST_INSTRUCTION("48F7D1"                        , not_(rcx));
  TEST_INSTRUCTION("F6941180000000"                , not_(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("66F7941180000000"              , not_(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F7941180000000"                , not_(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("48F7941180000000"              , not_(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("80C901"                        , or_(cl, 1));
  TEST_INSTRUCTION("80CD01"                        , or_(ch, 1));
  TEST_INSTRUCTION("808C118000000001"              , or_(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683C901"                      , or_(cx, 1));
  TEST_INSTRUCTION("66838C118000000001"            , or_(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83C901"                        , or_(ecx, 1));
  TEST_INSTRUCTION("838C118000000001"              , or_(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4809D1"                        , or_(rcx, rdx));
  TEST_INSTRUCTION("4883C901"                      , or_(rcx, 1));
  TEST_INSTRUCTION("48099C1180000000"              , or_(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48099C1180000000"              , or_(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48838C118000000001"            , or_(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("08D1"                          , or_(cl, dl));
  TEST_INSTRUCTION("08F1"                          , or_(cl, dh));
  TEST_INSTRUCTION("08D5"                          , or_(ch, dl));
  TEST_INSTRUCTION("08F5"                          , or_(ch, dh));
  TEST_INSTRUCTION("089C1180000000"                , or_(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("08BC1180000000"                , or_(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("089C1180000000"                , or_(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("08BC1180000000"                , or_(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6609D1"                        , or_(cx, dx));
  TEST_INSTRUCTION("66099C1180000000"              , or_(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66099C1180000000"              , or_(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("09D1"                          , or_(ecx, edx));
  TEST_INSTRUCTION("099C1180000000"                , or_(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("099C1180000000"                , or_(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0A8C1A80000000"                , or_(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0A8C1A80000000"                , or_(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0AAC1A80000000"                , or_(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0AAC1A80000000"                , or_(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660B8C1A80000000"              , or_(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660B8C1A80000000"              , or_(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0B8C1A80000000"                , or_(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0B8C1A80000000"                , or_(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480B8C1A80000000"              , or_(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480B8C1A80000000"              , or_(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("EE"                            , out(dx, al));
  TEST_INSTRUCTION("66EF"                          , out(dx, ax));
  TEST_INSTRUCTION("EF"                            , out(dx, eax));
  TEST_INSTRUCTION("E601"                          , out(1, al));
  TEST_INSTRUCTION("66E701"                        , out(1, ax));
  TEST_INSTRUCTION("E701"                          , out(1, eax));
  TEST_INSTRUCTION("6E"                            , outs(dx, byte_ptr(rsi)));
  TEST_INSTRUCTION("666F"                          , outs(dx, word_ptr(rsi)));
  TEST_INSTRUCTION("6F"                            , outs(dx, dword_ptr(rsi)));
  TEST_INSTRUCTION("F390"                          , pause());
  TEST_INSTRUCTION("6659"                          , pop(cx));
  TEST_INSTRUCTION("59"                            , pop(rcx));
  TEST_INSTRUCTION("668F841180000000"              , pop(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("8F841180000000"                , pop(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FA1"                          , pop(fs));
  TEST_INSTRUCTION("669D"                          , popf());
  TEST_INSTRUCTION("9D"                            , popfq());
  TEST_INSTRUCTION("6651"                          , push(cx));
  TEST_INSTRUCTION("51"                            , push(rcx));
  TEST_INSTRUCTION("6A01"                          , push(1));
  TEST_INSTRUCTION("66FFB41180000000"              , push(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("FFB41180000000"                , push(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FA0"                          , push(fs));
  TEST_INSTRUCTION("669C"                          , pushf());
  TEST_INSTRUCTION("9C"                            , pushfq());
  TEST_INSTRUCTION("66680100"                      , pushw(1));
  TEST_INSTRUCTION("66683412"                      , pushw(0x1234));
  TEST_INSTRUCTION("D2D1"                          , rcl(cl, cl));
  TEST_INSTRUCTION("D0D1"                          , rcl(cl, 1));
  TEST_INSTRUCTION("D2D5"                          , rcl(ch, cl));
  TEST_INSTRUCTION("D0D5"                          , rcl(ch, 1));
  TEST_INSTRUCTION("66D3D1"                        , rcl(cx, cl));
  TEST_INSTRUCTION("66D1D1"                        , rcl(cx, 1));
  TEST_INSTRUCTION("D3D1"                          , rcl(ecx, cl));
  TEST_INSTRUCTION("D1D1"                          , rcl(ecx, 1));
  TEST_INSTRUCTION("48D3D1"                        , rcl(rcx, cl));
  TEST_INSTRUCTION("48D1D1"                        , rcl(rcx, 1));
  TEST_INSTRUCTION("D2941180000000"                , rcl(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0941180000000"                , rcl(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3941180000000"              , rcl(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1941180000000"              , rcl(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3941180000000"                , rcl(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1941180000000"                , rcl(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3941180000000"              , rcl(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1941180000000"              , rcl(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D2D9"                          , rcr(cl, cl));
  TEST_INSTRUCTION("D0D9"                          , rcr(cl, 1));
  TEST_INSTRUCTION("D2DD"                          , rcr(ch, cl));
  TEST_INSTRUCTION("D0DD"                          , rcr(ch, 1));
  TEST_INSTRUCTION("66D3D9"                        , rcr(cx, cl));
  TEST_INSTRUCTION("66D1D9"                        , rcr(cx, 1));
  TEST_INSTRUCTION("D3D9"                          , rcr(ecx, cl));
  TEST_INSTRUCTION("D1D9"                          , rcr(ecx, 1));
  TEST_INSTRUCTION("48D3D9"                        , rcr(rcx, cl));
  TEST_INSTRUCTION("48D1D9"                        , rcr(rcx, 1));
  TEST_INSTRUCTION("D29C1180000000"                , rcr(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D09C1180000000"                , rcr(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D39C1180000000"              , rcr(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D19C1180000000"              , rcr(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D39C1180000000"                , rcr(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D19C1180000000"                , rcr(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D39C1180000000"              , rcr(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D19C1180000000"              , rcr(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("0F32"                          , rdmsr(edx, eax, ecx));
  TEST_INSTRUCTION("C3"                            , ret());
  TEST_INSTRUCTION("C20100"                        , ret(1));
  TEST_INSTRUCTION("CB"                            , retf());
  TEST_INSTRUCTION("CA0100"                        , retf(1));
  TEST_INSTRUCTION("D2C1"                          , rol(cl, cl));
  TEST_INSTRUCTION("D0C1"                          , rol(cl, 1));
  TEST_INSTRUCTION("D2C5"                          , rol(ch, cl));
  TEST_INSTRUCTION("D0C5"                          , rol(ch, 1));
  TEST_INSTRUCTION("66D3C1"                        , rol(cx, cl));
  TEST_INSTRUCTION("66D1C1"                        , rol(cx, 1));
  TEST_INSTRUCTION("D3C1"                          , rol(ecx, cl));
  TEST_INSTRUCTION("D1C1"                          , rol(ecx, 1));
  TEST_INSTRUCTION("48D3C1"                        , rol(rcx, cl));
  TEST_INSTRUCTION("48D1C1"                        , rol(rcx, 1));
  TEST_INSTRUCTION("D2841180000000"                , rol(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0841180000000"                , rol(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3841180000000"              , rol(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1841180000000"              , rol(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3841180000000"                , rol(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1841180000000"                , rol(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3841180000000"              , rol(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1841180000000"              , rol(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D2C9"                          , ror(cl, cl));
  TEST_INSTRUCTION("D0C9"                          , ror(cl, 1));
  TEST_INSTRUCTION("D2CD"                          , ror(ch, cl));
  TEST_INSTRUCTION("D0CD"                          , ror(ch, 1));
  TEST_INSTRUCTION("66D3C9"                        , ror(cx, cl));
  TEST_INSTRUCTION("66D1C9"                        , ror(cx, 1));
  TEST_INSTRUCTION("D3C9"                          , ror(ecx, cl));
  TEST_INSTRUCTION("D1C9"                          , ror(ecx, 1));
  TEST_INSTRUCTION("48D3C9"                        , ror(rcx, cl));
  TEST_INSTRUCTION("48D1C9"                        , ror(rcx, 1));
  TEST_INSTRUCTION("D28C1180000000"                , ror(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D08C1180000000"                , ror(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D38C1180000000"              , ror(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D18C1180000000"              , ror(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D38C1180000000"                , ror(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D18C1180000000"                , ror(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D38C1180000000"              , ror(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D18C1180000000"              , ror(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("9E"                            , sahf(ah));
  TEST_INSTRUCTION("D2E1"                          , sal(cl, cl));
  TEST_INSTRUCTION("D0E1"                          , sal(cl, 1));
  TEST_INSTRUCTION("D2E5"                          , sal(ch, cl));
  TEST_INSTRUCTION("D0E5"                          , sal(ch, 1));
  TEST_INSTRUCTION("66D3E1"                        , sal(cx, cl));
  TEST_INSTRUCTION("66D1E1"                        , sal(cx, 1));
  TEST_INSTRUCTION("D3E1"                          , sal(ecx, cl));
  TEST_INSTRUCTION("D1E1"                          , sal(ecx, 1));
  TEST_INSTRUCTION("48D3E1"                        , sal(rcx, cl));
  TEST_INSTRUCTION("48D1E1"                        , sal(rcx, 1));
  TEST_INSTRUCTION("D2A41180000000"                , sal(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0A41180000000"                , sal(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3A41180000000"              , sal(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1A41180000000"              , sal(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3A41180000000"                , sal(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1A41180000000"                , sal(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3A41180000000"              , sal(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1A41180000000"              , sal(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D2F9"                          , sar(cl, cl));
  TEST_INSTRUCTION("D0F9"                          , sar(cl, 1));
  TEST_INSTRUCTION("D2FD"                          , sar(ch, cl));
  TEST_INSTRUCTION("D0FD"                          , sar(ch, 1));
  TEST_INSTRUCTION("66D3F9"                        , sar(cx, cl));
  TEST_INSTRUCTION("66D1F9"                        , sar(cx, 1));
  TEST_INSTRUCTION("D3F9"                          , sar(ecx, cl));
  TEST_INSTRUCTION("D1F9"                          , sar(ecx, 1));
  TEST_INSTRUCTION("48D3F9"                        , sar(rcx, cl));
  TEST_INSTRUCTION("48D1F9"                        , sar(rcx, 1));
  TEST_INSTRUCTION("D2BC1180000000"                , sar(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0BC1180000000"                , sar(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3BC1180000000"              , sar(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1BC1180000000"              , sar(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3BC1180000000"                , sar(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1BC1180000000"                , sar(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3BC1180000000"              , sar(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1BC1180000000"              , sar(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("80D901"                        , sbb(cl, 1));
  TEST_INSTRUCTION("80DD01"                        , sbb(ch, 1));
  TEST_INSTRUCTION("809C118000000001"              , sbb(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683D901"                      , sbb(cx, 1));
  TEST_INSTRUCTION("66839C118000000001"            , sbb(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83D901"                        , sbb(ecx, 1));
  TEST_INSTRUCTION("839C118000000001"              , sbb(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4819D1"                        , sbb(rcx, rdx));
  TEST_INSTRUCTION("4883D901"                      , sbb(rcx, 1));
  TEST_INSTRUCTION("48199C1180000000"              , sbb(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48199C1180000000"              , sbb(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48839C118000000001"            , sbb(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("18D1"                          , sbb(cl, dl));
  TEST_INSTRUCTION("18F1"                          , sbb(cl, dh));
  TEST_INSTRUCTION("18D5"                          , sbb(ch, dl));
  TEST_INSTRUCTION("18F5"                          , sbb(ch, dh));
  TEST_INSTRUCTION("189C1180000000"                , sbb(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("18BC1180000000"                , sbb(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("189C1180000000"                , sbb(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("18BC1180000000"                , sbb(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6619D1"                        , sbb(cx, dx));
  TEST_INSTRUCTION("66199C1180000000"              , sbb(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66199C1180000000"              , sbb(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("19D1"                          , sbb(ecx, edx));
  TEST_INSTRUCTION("199C1180000000"                , sbb(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("199C1180000000"                , sbb(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("1A8C1A80000000"                , sbb(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("1A8C1A80000000"                , sbb(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("1AAC1A80000000"                , sbb(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("1AAC1A80000000"                , sbb(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("661B8C1A80000000"              , sbb(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("661B8C1A80000000"              , sbb(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("1B8C1A80000000"                , sbb(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("1B8C1A80000000"                , sbb(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("481B8C1A80000000"              , sbb(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("481B8C1A80000000"              , sbb(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("AE"                            , scas(al, ptr(rdi)));
  TEST_INSTRUCTION("AE"                            , scas(al, byte_ptr(rdi)));
  TEST_INSTRUCTION("66AF"                          , scas(ax, ptr(rdi)));
  TEST_INSTRUCTION("66AF"                          , scas(ax, word_ptr(rdi)));
  TEST_INSTRUCTION("AF"                            , scas(eax, ptr(rdi)));
  TEST_INSTRUCTION("AF"                            , scas(eax, dword_ptr(rdi)));
  TEST_INSTRUCTION("48AF"                          , scas(rax, ptr(rdi)));
  TEST_INSTRUCTION("48AF"                          , scas(rax, qword_ptr(rdi)));
  TEST_INSTRUCTION("0F97C1"                        , seta(cl));
  TEST_INSTRUCTION("0F97C5"                        , seta(ch));
  TEST_INSTRUCTION("0F97841180000000"              , seta(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F97841180000000"              , seta(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93C1"                        , setae(cl));
  TEST_INSTRUCTION("0F93C5"                        , setae(ch));
  TEST_INSTRUCTION("0F93841180000000"              , setae(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93841180000000"              , setae(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92C1"                        , setb(cl));
  TEST_INSTRUCTION("0F92C5"                        , setb(ch));
  TEST_INSTRUCTION("0F92841180000000"              , setb(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92841180000000"              , setb(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F96C1"                        , setbe(cl));
  TEST_INSTRUCTION("0F96C5"                        , setbe(ch));
  TEST_INSTRUCTION("0F96841180000000"              , setbe(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F96841180000000"              , setbe(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92C1"                        , setc(cl));
  TEST_INSTRUCTION("0F92C5"                        , setc(ch));
  TEST_INSTRUCTION("0F92841180000000"              , setc(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92841180000000"              , setc(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F94C1"                        , sete(cl));
  TEST_INSTRUCTION("0F94C5"                        , sete(ch));
  TEST_INSTRUCTION("0F94841180000000"              , sete(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F94841180000000"              , sete(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9FC1"                        , setg(cl));
  TEST_INSTRUCTION("0F9FC5"                        , setg(ch));
  TEST_INSTRUCTION("0F9F841180000000"              , setg(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9F841180000000"              , setg(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9DC1"                        , setge(cl));
  TEST_INSTRUCTION("0F9DC5"                        , setge(ch));
  TEST_INSTRUCTION("0F9D841180000000"              , setge(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9D841180000000"              , setge(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9CC1"                        , setl(cl));
  TEST_INSTRUCTION("0F9CC5"                        , setl(ch));
  TEST_INSTRUCTION("0F9C841180000000"              , setl(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9C841180000000"              , setl(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9EC1"                        , setle(cl));
  TEST_INSTRUCTION("0F9EC5"                        , setle(ch));
  TEST_INSTRUCTION("0F9E841180000000"              , setle(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9E841180000000"              , setle(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F96C1"                        , setna(cl));
  TEST_INSTRUCTION("0F96C5"                        , setna(ch));
  TEST_INSTRUCTION("0F96841180000000"              , setna(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F96841180000000"              , setna(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92C1"                        , setnae(cl));
  TEST_INSTRUCTION("0F92C5"                        , setnae(ch));
  TEST_INSTRUCTION("0F92841180000000"              , setnae(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F92841180000000"              , setnae(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93C1"                        , setnb(cl));
  TEST_INSTRUCTION("0F93C5"                        , setnb(ch));
  TEST_INSTRUCTION("0F93841180000000"              , setnb(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93841180000000"              , setnb(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F97C1"                        , setnbe(cl));
  TEST_INSTRUCTION("0F97C5"                        , setnbe(ch));
  TEST_INSTRUCTION("0F97841180000000"              , setnbe(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F97841180000000"              , setnbe(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93C1"                        , setnc(cl));
  TEST_INSTRUCTION("0F93C5"                        , setnc(ch));
  TEST_INSTRUCTION("0F93841180000000"              , setnc(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F93841180000000"              , setnc(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F95C1"                        , setne(cl));
  TEST_INSTRUCTION("0F95C5"                        , setne(ch));
  TEST_INSTRUCTION("0F95841180000000"              , setne(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F95841180000000"              , setne(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9EC1"                        , setng(cl));
  TEST_INSTRUCTION("0F9EC5"                        , setng(ch));
  TEST_INSTRUCTION("0F9E841180000000"              , setng(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9E841180000000"              , setng(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9CC1"                        , setnge(cl));
  TEST_INSTRUCTION("0F9CC5"                        , setnge(ch));
  TEST_INSTRUCTION("0F9C841180000000"              , setnge(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9C841180000000"              , setnge(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9DC1"                        , setnl(cl));
  TEST_INSTRUCTION("0F9DC5"                        , setnl(ch));
  TEST_INSTRUCTION("0F9D841180000000"              , setnl(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9D841180000000"              , setnl(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9FC1"                        , setnle(cl));
  TEST_INSTRUCTION("0F9FC5"                        , setnle(ch));
  TEST_INSTRUCTION("0F9F841180000000"              , setnle(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9F841180000000"              , setnle(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F91C1"                        , setno(cl));
  TEST_INSTRUCTION("0F91C5"                        , setno(ch));
  TEST_INSTRUCTION("0F91841180000000"              , setno(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F91841180000000"              , setno(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9BC1"                        , setnp(cl));
  TEST_INSTRUCTION("0F9BC5"                        , setnp(ch));
  TEST_INSTRUCTION("0F9B841180000000"              , setnp(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9B841180000000"              , setnp(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F99C1"                        , setns(cl));
  TEST_INSTRUCTION("0F99C5"                        , setns(ch));
  TEST_INSTRUCTION("0F99841180000000"              , setns(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F99841180000000"              , setns(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F95C1"                        , setnz(cl));
  TEST_INSTRUCTION("0F95C5"                        , setnz(ch));
  TEST_INSTRUCTION("0F95841180000000"              , setnz(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F95841180000000"              , setnz(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F90C1"                        , seto(cl));
  TEST_INSTRUCTION("0F90C5"                        , seto(ch));
  TEST_INSTRUCTION("0F90841180000000"              , seto(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F90841180000000"              , seto(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9AC1"                        , setp(cl));
  TEST_INSTRUCTION("0F9AC5"                        , setp(ch));
  TEST_INSTRUCTION("0F9A841180000000"              , setp(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9A841180000000"              , setp(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9AC1"                        , setpe(cl));
  TEST_INSTRUCTION("0F9AC5"                        , setpe(ch));
  TEST_INSTRUCTION("0F9A841180000000"              , setpe(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9A841180000000"              , setpe(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9BC1"                        , setpo(cl));
  TEST_INSTRUCTION("0F9BC5"                        , setpo(ch));
  TEST_INSTRUCTION("0F9B841180000000"              , setpo(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F9B841180000000"              , setpo(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F98C1"                        , sets(cl));
  TEST_INSTRUCTION("0F98C5"                        , sets(ch));
  TEST_INSTRUCTION("0F98841180000000"              , sets(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F98841180000000"              , sets(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F94C1"                        , setz(cl));
  TEST_INSTRUCTION("0F94C5"                        , setz(ch));
  TEST_INSTRUCTION("0F94841180000000"              , setz(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F94841180000000"              , setz(byte_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01841180000000"              , sgdt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("D2E1"                          , shl(cl, cl));
  TEST_INSTRUCTION("D0E1"                          , shl(cl, 1));
  TEST_INSTRUCTION("D2E5"                          , shl(ch, cl));
  TEST_INSTRUCTION("D0E5"                          , shl(ch, 1));
  TEST_INSTRUCTION("66D3E1"                        , shl(cx, cl));
  TEST_INSTRUCTION("66D1E1"                        , shl(cx, 1));
  TEST_INSTRUCTION("D3E1"                          , shl(ecx, cl));
  TEST_INSTRUCTION("D1E1"                          , shl(ecx, 1));
  TEST_INSTRUCTION("48D3E1"                        , shl(rcx, cl));
  TEST_INSTRUCTION("48D1E1"                        , shl(rcx, 1));
  TEST_INSTRUCTION("D2A41180000000"                , shl(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0A41180000000"                , shl(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3A41180000000"              , shl(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1A41180000000"              , shl(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3A41180000000"                , shl(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1A41180000000"                , shl(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3A41180000000"              , shl(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1A41180000000"              , shl(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FA5D1"                      , shld(cx, dx, cl));
  TEST_INSTRUCTION("660FA4D101"                    , shld(cx, dx, 1));
  TEST_INSTRUCTION("660FA59C1180000000"            , shld(ptr(rcx, rdx, 0, 128), bx, cl));
  TEST_INSTRUCTION("660FA49C118000000001"          , shld(ptr(rcx, rdx, 0, 128), bx, 1));
  TEST_INSTRUCTION("660FA59C1180000000"            , shld(word_ptr(rcx, rdx, 0, 128), bx, cl));
  TEST_INSTRUCTION("660FA49C118000000001"          , shld(word_ptr(rcx, rdx, 0, 128), bx, 1));
  TEST_INSTRUCTION("0FA5D1"                        , shld(ecx, edx, cl));
  TEST_INSTRUCTION("0FA4D101"                      , shld(ecx, edx, 1));
  TEST_INSTRUCTION("0FA59C1180000000"              , shld(ptr(rcx, rdx, 0, 128), ebx, cl));
  TEST_INSTRUCTION("0FA49C118000000001"            , shld(ptr(rcx, rdx, 0, 128), ebx, 1));
  TEST_INSTRUCTION("0FA59C1180000000"              , shld(dword_ptr(rcx, rdx, 0, 128), ebx, cl));
  TEST_INSTRUCTION("0FA49C118000000001"            , shld(dword_ptr(rcx, rdx, 0, 128), ebx, 1));
  TEST_INSTRUCTION("480FA5D1"                      , shld(rcx, rdx, cl));
  TEST_INSTRUCTION("480FA4D101"                    , shld(rcx, rdx, 1));
  TEST_INSTRUCTION("480FA59C1180000000"            , shld(ptr(rcx, rdx, 0, 128), rbx, cl));
  TEST_INSTRUCTION("480FA49C118000000001"          , shld(ptr(rcx, rdx, 0, 128), rbx, 1));
  TEST_INSTRUCTION("480FA59C1180000000"            , shld(qword_ptr(rcx, rdx, 0, 128), rbx, cl));
  TEST_INSTRUCTION("480FA49C118000000001"          , shld(qword_ptr(rcx, rdx, 0, 128), rbx, 1));
  TEST_INSTRUCTION("D2E9"                          , shr(cl, cl));
  TEST_INSTRUCTION("D0E9"                          , shr(cl, 1));
  TEST_INSTRUCTION("D2ED"                          , shr(ch, cl));
  TEST_INSTRUCTION("D0ED"                          , shr(ch, 1));
  TEST_INSTRUCTION("66D3E9"                        , shr(cx, cl));
  TEST_INSTRUCTION("66D1E9"                        , shr(cx, 1));
  TEST_INSTRUCTION("D3E9"                          , shr(ecx, cl));
  TEST_INSTRUCTION("D1E9"                          , shr(ecx, 1));
  TEST_INSTRUCTION("48D3E9"                        , shr(rcx, cl));
  TEST_INSTRUCTION("48D1E9"                        , shr(rcx, 1));
  TEST_INSTRUCTION("D2AC1180000000"                , shr(byte_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D0AC1180000000"                , shr(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66D3AC1180000000"              , shr(word_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("66D1AC1180000000"              , shr(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("D3AC1180000000"                , shr(dword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("D1AC1180000000"                , shr(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("48D3AC1180000000"              , shr(qword_ptr(rcx, rdx, 0, 128), cl));
  TEST_INSTRUCTION("48D1AC1180000000"              , shr(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("660FADD1"                      , shrd(cx, dx, cl));
  TEST_INSTRUCTION("660FACD101"                    , shrd(cx, dx, 1));
  TEST_INSTRUCTION("660FAD9C1180000000"            , shrd(ptr(rcx, rdx, 0, 128), bx, cl));
  TEST_INSTRUCTION("660FAC9C118000000001"          , shrd(ptr(rcx, rdx, 0, 128), bx, 1));
  TEST_INSTRUCTION("660FAD9C1180000000"            , shrd(word_ptr(rcx, rdx, 0, 128), bx, cl));
  TEST_INSTRUCTION("660FAC9C118000000001"          , shrd(word_ptr(rcx, rdx, 0, 128), bx, 1));
  TEST_INSTRUCTION("0FADD1"                        , shrd(ecx, edx, cl));
  TEST_INSTRUCTION("0FACD101"                      , shrd(ecx, edx, 1));
  TEST_INSTRUCTION("0FAD9C1180000000"              , shrd(ptr(rcx, rdx, 0, 128), ebx, cl));
  TEST_INSTRUCTION("0FAC9C118000000001"            , shrd(ptr(rcx, rdx, 0, 128), ebx, 1));
  TEST_INSTRUCTION("0FAD9C1180000000"              , shrd(dword_ptr(rcx, rdx, 0, 128), ebx, cl));
  TEST_INSTRUCTION("0FAC9C118000000001"            , shrd(dword_ptr(rcx, rdx, 0, 128), ebx, 1));
  TEST_INSTRUCTION("480FADD1"                      , shrd(rcx, rdx, cl));
  TEST_INSTRUCTION("480FACD101"                    , shrd(rcx, rdx, 1));
  TEST_INSTRUCTION("480FAD9C1180000000"            , shrd(ptr(rcx, rdx, 0, 128), rbx, cl));
  TEST_INSTRUCTION("480FAC9C118000000001"          , shrd(ptr(rcx, rdx, 0, 128), rbx, 1));
  TEST_INSTRUCTION("480FAD9C1180000000"            , shrd(qword_ptr(rcx, rdx, 0, 128), rbx, cl));
  TEST_INSTRUCTION("480FAC9C118000000001"          , shrd(qword_ptr(rcx, rdx, 0, 128), rbx, 1));
  TEST_INSTRUCTION("0F018C1180000000"              , sidt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660F00C1"                      , sldt(cx));
  TEST_INSTRUCTION("0F00C1"                        , sldt(ecx));
  TEST_INSTRUCTION("480F00C1"                      , sldt(rcx));
  TEST_INSTRUCTION("0F00841180000000"              , sldt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00841180000000"              , sldt(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660F01E1"                      , smsw(cx));
  TEST_INSTRUCTION("0F01E1"                        , smsw(ecx));
  TEST_INSTRUCTION("480F01E1"                      , smsw(rcx));
  TEST_INSTRUCTION("0F01A41180000000"              , smsw(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01A41180000000"              , smsw(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F9"                            , stc());
  TEST_INSTRUCTION("FD"                            , std());
  TEST_INSTRUCTION("FB"                            , sti());
  TEST_INSTRUCTION("AA"                            , stos(ptr(rdi), al));
  TEST_INSTRUCTION("AA"                            , stos(byte_ptr(rdi), al));
  TEST_INSTRUCTION("66AB"                          , stos(ptr(rdi), ax));
  TEST_INSTRUCTION("66AB"                          , stos(word_ptr(rdi), ax));
  TEST_INSTRUCTION("AB"                            , stos(ptr(rdi), eax));
  TEST_INSTRUCTION("AB"                            , stos(dword_ptr(rdi), eax));
  TEST_INSTRUCTION("48AB"                          , stos(ptr(rdi), rax));
  TEST_INSTRUCTION("48AB"                          , stos(qword_ptr(rdi), rax));
  TEST_INSTRUCTION("660F00C9"                      , str(cx));
  TEST_INSTRUCTION("0F00C9"                        , str(ecx));
  TEST_INSTRUCTION("480F00C9"                      , str(rcx));
  TEST_INSTRUCTION("0F008C1180000000"              , str(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F008C1180000000"              , str(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("80E901"                        , sub(cl, 1));
  TEST_INSTRUCTION("80ED01"                        , sub(ch, 1));
  TEST_INSTRUCTION("80AC118000000001"              , sub(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683E901"                      , sub(cx, 1));
  TEST_INSTRUCTION("6683AC118000000001"            , sub(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83E901"                        , sub(ecx, 1));
  TEST_INSTRUCTION("83AC118000000001"              , sub(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4829D1"                        , sub(rcx, rdx));
  TEST_INSTRUCTION("4883E901"                      , sub(rcx, 1));
  TEST_INSTRUCTION("48299C1180000000"              , sub(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48299C1180000000"              , sub(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("4883AC118000000001"            , sub(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("28D1"                          , sub(cl, dl));
  TEST_INSTRUCTION("28F1"                          , sub(cl, dh));
  TEST_INSTRUCTION("28D5"                          , sub(ch, dl));
  TEST_INSTRUCTION("28F5"                          , sub(ch, dh));
  TEST_INSTRUCTION("289C1180000000"                , sub(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("28BC1180000000"                , sub(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("289C1180000000"                , sub(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("28BC1180000000"                , sub(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6629D1"                        , sub(cx, dx));
  TEST_INSTRUCTION("66299C1180000000"              , sub(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66299C1180000000"              , sub(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("29D1"                          , sub(ecx, edx));
  TEST_INSTRUCTION("299C1180000000"                , sub(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("299C1180000000"                , sub(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("2A8C1A80000000"                , sub(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("2A8C1A80000000"                , sub(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("2AAC1A80000000"                , sub(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("2AAC1A80000000"                , sub(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("662B8C1A80000000"              , sub(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("662B8C1A80000000"              , sub(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("2B8C1A80000000"                , sub(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("2B8C1A80000000"                , sub(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("482B8C1A80000000"              , sub(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("482B8C1A80000000"              , sub(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F6C101"                        , test(cl, 1));
  TEST_INSTRUCTION("F6C501"                        , test(ch, 1));
  TEST_INSTRUCTION("F684118000000001"              , test(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("66F7C10100"                    , test(cx, 1));
  TEST_INSTRUCTION("66F78411800000000100"          , test(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("F7C101000000"                  , test(ecx, 1));
  TEST_INSTRUCTION("F784118000000001000000"        , test(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4885D1"                        , test(rcx, rdx));
  TEST_INSTRUCTION("48F7C101000000"                , test(rcx, 1));
  TEST_INSTRUCTION("48859C1180000000"              , test(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48859C1180000000"              , test(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48F784118000000001000000"      , test(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("84D1"                          , test(cl, dl));
  TEST_INSTRUCTION("84F1"                          , test(cl, dh));
  TEST_INSTRUCTION("84D5"                          , test(ch, dl));
  TEST_INSTRUCTION("84F5"                          , test(ch, dh));
  TEST_INSTRUCTION("849C1180000000"                , test(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("84BC1180000000"                , test(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("849C1180000000"                , test(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("84BC1180000000"                , test(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6685D1"                        , test(cx, dx));
  TEST_INSTRUCTION("66859C1180000000"              , test(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66859C1180000000"              , test(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("85D1"                          , test(ecx, edx));
  TEST_INSTRUCTION("859C1180000000"                , test(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("859C1180000000"                , test(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FFFCA"                        , ud0(ecx, edx));
  TEST_INSTRUCTION("0FFF8C1A80000000"              , ud0(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFF8C1A80000000"              , ud0(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB9CA"                        , ud1(ecx, edx));
  TEST_INSTRUCTION("0FB98C1A80000000"              , ud1(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FB98C1A80000000"              , ud1(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0B"                          , ud2());
  TEST_INSTRUCTION("F30F01EC"                      , uiret());
  TEST_INSTRUCTION("0F00E1"                        , verr(cx));
  TEST_INSTRUCTION("0F00A41180000000"              , verr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00A41180000000"              , verr(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00E9"                        , verw(cx));
  TEST_INSTRUCTION("0F00AC1180000000"              , verw(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F00AC1180000000"              , verw(word_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F09"                          , wbinvd());
  TEST_INSTRUCTION("0F30"                          , wrmsr(edx, eax, ecx));
  TEST_INSTRUCTION("C6F801"                        , xabort(1));
  TEST_INSTRUCTION("0FC0D1"                        , xadd(cl, dl));
  TEST_INSTRUCTION("0FC0F1"                        , xadd(cl, dh));
  TEST_INSTRUCTION("0FC0D5"                        , xadd(ch, dl));
  TEST_INSTRUCTION("0FC0F5"                        , xadd(ch, dh));
  TEST_INSTRUCTION("0FC09C1180000000"              , xadd(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("0FC0BC1180000000"              , xadd(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("0FC09C1180000000"              , xadd(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("0FC0BC1180000000"              , xadd(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("660FC1D1"                      , xadd(cx, dx));
  TEST_INSTRUCTION("660FC19C1180000000"            , xadd(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660FC19C1180000000"            , xadd(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0FC1D1"                        , xadd(ecx, edx));
  TEST_INSTRUCTION("0FC19C1180000000"              , xadd(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FC19C1180000000"              , xadd(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FC1D1"                      , xadd(rcx, rdx));
  TEST_INSTRUCTION("480FC19C1180000000"            , xadd(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FC19C1180000000"            , xadd(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("86D1"                          , xchg(cl, dl));
  TEST_INSTRUCTION("86F1"                          , xchg(cl, dh));
  TEST_INSTRUCTION("86D5"                          , xchg(ch, dl));
  TEST_INSTRUCTION("86F5"                          , xchg(ch, dh));
  TEST_INSTRUCTION("869C1180000000"                , xchg(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("86BC1180000000"                , xchg(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("869C1180000000"                , xchg(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("86BC1180000000"                , xchg(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6687D1"                        , xchg(cx, dx));
  TEST_INSTRUCTION("66879C1180000000"              , xchg(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66879C1180000000"              , xchg(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("87D1"                          , xchg(ecx, edx));
  TEST_INSTRUCTION("879C1180000000"                , xchg(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("879C1180000000"                , xchg(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("4887D1"                        , xchg(rcx, rdx));
  TEST_INSTRUCTION("48879C1180000000"              , xchg(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48879C1180000000"              , xchg(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("868C1A80000000"                , xchg(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("868C1A80000000"                , xchg(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("86AC1A80000000"                , xchg(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("86AC1A80000000"                , xchg(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66878C1A80000000"              , xchg(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66878C1A80000000"              , xchg(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("878C1A80000000"                , xchg(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("878C1A80000000"                , xchg(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48878C1A80000000"              , xchg(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48878C1A80000000"              , xchg(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("D7"                            , xlatb());
  TEST_INSTRUCTION("80F101"                        , xor_(cl, 1));
  TEST_INSTRUCTION("80F501"                        , xor_(ch, 1));
  TEST_INSTRUCTION("80B4118000000001"              , xor_(byte_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("6683F101"                      , xor_(cx, 1));
  TEST_INSTRUCTION("6683B4118000000001"            , xor_(word_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("83F101"                        , xor_(ecx, 1));
  TEST_INSTRUCTION("83B4118000000001"              , xor_(dword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("4831D1"                        , xor_(rcx, rdx));
  TEST_INSTRUCTION("4883F101"                      , xor_(rcx, 1));
  TEST_INSTRUCTION("48319C1180000000"              , xor_(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("48319C1180000000"              , xor_(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("4883B4118000000001"            , xor_(qword_ptr(rcx, rdx, 0, 128), 1));
  TEST_INSTRUCTION("30D1"                          , xor_(cl, dl));
  TEST_INSTRUCTION("30F1"                          , xor_(cl, dh));
  TEST_INSTRUCTION("30D5"                          , xor_(ch, dl));
  TEST_INSTRUCTION("30F5"                          , xor_(ch, dh));
  TEST_INSTRUCTION("309C1180000000"                , xor_(ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("30BC1180000000"                , xor_(ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("309C1180000000"                , xor_(byte_ptr(rcx, rdx, 0, 128), bl));
  TEST_INSTRUCTION("30BC1180000000"                , xor_(byte_ptr(rcx, rdx, 0, 128), bh));
  TEST_INSTRUCTION("6631D1"                        , xor_(cx, dx));
  TEST_INSTRUCTION("66319C1180000000"              , xor_(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("66319C1180000000"              , xor_(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("31D1"                          , xor_(ecx, edx));
  TEST_INSTRUCTION("319C1180000000"                , xor_(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("319C1180000000"                , xor_(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("328C1A80000000"                , xor_(cl, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("328C1A80000000"                , xor_(cl, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("32AC1A80000000"                , xor_(ch, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("32AC1A80000000"                , xor_(ch, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66338C1A80000000"              , xor_(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66338C1A80000000"              , xor_(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("338C1A80000000"                , xor_(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("338C1A80000000"                , xor_(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48338C1A80000000"              , xor_(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("48338C1A80000000"              , xor_(rcx, qword_ptr(rdx, rbx, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_base_ext(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("0F38FC9C1180000000"            , aadd(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0F38FC9C1180000000"            , aadd(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480F38FC9C1180000000"          , aadd(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480F38FC9C1180000000"          , aadd(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660F38FC9C1180000000"          , aand(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("660F38FC9C1180000000"          , aand(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("66480F38FC9C1180000000"        , aand(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("66480F38FC9C1180000000"        , aand(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660F38F6CA"                    , adcx(ecx, edx));
  TEST_INSTRUCTION("660F38F68C1A80000000"          , adcx(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38F68C1A80000000"          , adcx(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66480F38F6CA"                  , adcx(rcx, rdx));
  TEST_INSTRUCTION("66480F38F68C1A80000000"        , adcx(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66480F38F68C1A80000000"        , adcx(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F38F6CA"                    , adox(ecx, edx));
  TEST_INSTRUCTION("F30F38F68C1A80000000"          , adox(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F38F68C1A80000000"          , adox(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F38F6CA"                  , adox(rcx, rdx));
  TEST_INSTRUCTION("F3480F38F68C1A80000000"        , adox(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F38F68C1A80000000"        , adox(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E268F2CB"                    , andn(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E268F28C2B80000000"          , andn(ecx, edx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268F28C2B80000000"          , andn(ecx, edx, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E8F2CB"                    , andn(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2E8F28C2B80000000"          , andn(rcx, rdx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E8F28C2B80000000"          , andn(rcx, rdx, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("F20F38FC9C1180000000"          , aor(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("F20F38FC9C1180000000"          , aor(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("F2480F38FC9C1180000000"        , aor(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("F2480F38FC9C1180000000"        , aor(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("F30F38FC9C1180000000"          , axor(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("F30F38FC9C1180000000"          , axor(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("F3480F38FC9C1180000000"        , axor(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("F3480F38FC9C1180000000"        , axor(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("C4E260F7CA"                    , bextr(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E258F78C1A80000000"          , bextr(ecx, ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E258F78C1A80000000"          , bextr(ecx, dword_ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E2E0F7CA"                    , bextr(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2D8F78C1A80000000"          , bextr(rcx, ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E2D8F78C1A80000000"          , bextr(rcx, qword_ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("8FE97001CA"                    , blcfill(ecx, edx));
  TEST_INSTRUCTION("8FE970018C1A80000000"          , blcfill(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE970018C1A80000000"          , blcfill(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001CA"                    , blcfill(rcx, rdx));
  TEST_INSTRUCTION("8FE9F0018C1A80000000"          , blcfill(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F0018C1A80000000"          , blcfill(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97002F2"                    , blci(ecx, edx));
  TEST_INSTRUCTION("8FE97002B41A80000000"          , blci(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97002B41A80000000"          , blci(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F002F2"                    , blci(rcx, rdx));
  TEST_INSTRUCTION("8FE9F002B41A80000000"          , blci(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F002B41A80000000"          , blci(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001EA"                    , blcic(ecx, edx));
  TEST_INSTRUCTION("8FE97001AC1A80000000"          , blcic(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001AC1A80000000"          , blcic(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001EA"                    , blcic(rcx, rdx));
  TEST_INSTRUCTION("8FE9F001AC1A80000000"          , blcic(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001AC1A80000000"          , blcic(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97002CA"                    , blcmsk(ecx, edx));
  TEST_INSTRUCTION("8FE970028C1A80000000"          , blcmsk(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE970028C1A80000000"          , blcmsk(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F002CA"                    , blcmsk(rcx, rdx));
  TEST_INSTRUCTION("8FE9F0028C1A80000000"          , blcmsk(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F0028C1A80000000"          , blcmsk(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001DA"                    , blcs(ecx, edx));
  TEST_INSTRUCTION("8FE970019C1A80000000"          , blcs(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE970019C1A80000000"          , blcs(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001DA"                    , blcs(rcx, rdx));
  TEST_INSTRUCTION("8FE9F0019C1A80000000"          , blcs(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F0019C1A80000000"          , blcs(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001D2"                    , blsfill(ecx, edx));
  TEST_INSTRUCTION("8FE97001941A80000000"          , blsfill(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001941A80000000"          , blsfill(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001D2"                    , blsfill(rcx, rdx));
  TEST_INSTRUCTION("8FE9F001941A80000000"          , blsfill(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001941A80000000"          , blsfill(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F3DA"                    , blsi(ecx, edx));
  TEST_INSTRUCTION("C4E270F39C1A80000000"          , blsi(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F39C1A80000000"          , blsi(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F3DA"                    , blsi(rcx, rdx));
  TEST_INSTRUCTION("C4E2F0F39C1A80000000"          , blsi(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F39C1A80000000"          , blsi(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001F2"                    , blsic(ecx, edx));
  TEST_INSTRUCTION("8FE97001B41A80000000"          , blsic(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001B41A80000000"          , blsic(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001F2"                    , blsic(rcx, rdx));
  TEST_INSTRUCTION("8FE9F001B41A80000000"          , blsic(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001B41A80000000"          , blsic(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F3D2"                    , blsmsk(ecx, edx));
  TEST_INSTRUCTION("C4E270F3941A80000000"          , blsmsk(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F3941A80000000"          , blsmsk(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F3D2"                    , blsmsk(rcx, rdx));
  TEST_INSTRUCTION("C4E2F0F3941A80000000"          , blsmsk(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F3941A80000000"          , blsmsk(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F3CA"                    , blsr(ecx, edx));
  TEST_INSTRUCTION("C4E270F38C1A80000000"          , blsr(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E270F38C1A80000000"          , blsr(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F3CA"                    , blsr(rcx, rdx));
  TEST_INSTRUCTION("C4E2F0F38C1A80000000"          , blsr(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2F0F38C1A80000000"          , blsr(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F1ACA"                      , bndcl(bnd1, rdx));
  TEST_INSTRUCTION("F30F1A8C1A80000000"            , bndcl(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F1A8C1A80000000"            , bndcl(bnd1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F1BCA"                      , bndcn(bnd1, rdx));
  TEST_INSTRUCTION("F20F1B8C1A80000000"            , bndcn(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F1B8C1A80000000"            , bndcn(bnd1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F1ACA"                      , bndcu(bnd1, rdx));
  TEST_INSTRUCTION("F20F1A8C1A80000000"            , bndcu(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F1A8C1A80000000"            , bndcu(bnd1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F1A8C1A80000000"              , bndldx(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F1B8C1A80000000"            , bndmk(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F1ACA"                      , bndmov(bnd1, bnd2));
  TEST_INSTRUCTION("660F1A8C1A80000000"            , bndmov(bnd1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F1B9C1180000000"            , bndmov(ptr(rcx, rdx, 0, 128), bnd3));
  TEST_INSTRUCTION("0F1B9C1180000000"              , bndstx(ptr(rcx, rdx, 0, 128), bnd3));
  TEST_INSTRUCTION("C4E260F5CA"                    , bzhi(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E258F58C1A80000000"          , bzhi(ecx, ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E258F58C1A80000000"          , bzhi(ecx, dword_ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E2E0F5CA"                    , bzhi(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2D8F58C1A80000000"          , bzhi(rcx, ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E2D8F58C1A80000000"          , bzhi(rcx, qword_ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("0F01CA"                        , clac());
  TEST_INSTRUCTION("0F1C841180000000"              , cldemote(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FAEBC1180000000"              , clflush(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660FAEBC1180000000"            , clflushopt(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01DD"                        , clgi());
  TEST_INSTRUCTION("F30FAEB41180000000"            , clrssbsy(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30FAEB41180000000"            , clrssbsy(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F06"                          , clts());
  TEST_INSTRUCTION("F30F01EE"                      , clui());
  TEST_INSTRUCTION("660FAEB41180000000"            , clwb(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01FC"                        , clzero(ptr(rax)));
  TEST_INSTRUCTION("0F01FC"                        , clzero(zmmword_ptr(rax)));
  TEST_INSTRUCTION("C4E259E69C1180000000"          , cmpbexadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E69C1180000000"          , cmpbexadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E69C1180000000"          , cmpbexadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E69C1180000000"          , cmpbexadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E29C1180000000"          , cmpbxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E29C1180000000"          , cmpbxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E29C1180000000"          , cmpbxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E29C1180000000"          , cmpbxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259EE9C1180000000"          , cmplexadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259EE9C1180000000"          , cmplexadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9EE9C1180000000"          , cmplexadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9EE9C1180000000"          , cmplexadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259EC9C1180000000"          , cmplxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259EC9C1180000000"          , cmplxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9EC9C1180000000"          , cmplxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9EC9C1180000000"          , cmplxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E79C1180000000"          , cmpnbexadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E79C1180000000"          , cmpnbexadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E79C1180000000"          , cmpnbexadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E79C1180000000"          , cmpnbexadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E39C1180000000"          , cmpnbxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E39C1180000000"          , cmpnbxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E39C1180000000"          , cmpnbxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E39C1180000000"          , cmpnbxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259EF9C1180000000"          , cmpnlexadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259EF9C1180000000"          , cmpnlexadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9EF9C1180000000"          , cmpnlexadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9EF9C1180000000"          , cmpnlexadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259ED9C1180000000"          , cmpnlxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259ED9C1180000000"          , cmpnlxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9ED9C1180000000"          , cmpnlxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9ED9C1180000000"          , cmpnlxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E19C1180000000"          , cmpnoxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E19C1180000000"          , cmpnoxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E19C1180000000"          , cmpnoxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E19C1180000000"          , cmpnoxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259EB9C1180000000"          , cmpnpxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259EB9C1180000000"          , cmpnpxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9EB9C1180000000"          , cmpnpxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9EB9C1180000000"          , cmpnpxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E99C1180000000"          , cmpnsxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E99C1180000000"          , cmpnsxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E99C1180000000"          , cmpnsxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E99C1180000000"          , cmpnsxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E59C1180000000"          , cmpnzxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E59C1180000000"          , cmpnzxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E59C1180000000"          , cmpnzxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E59C1180000000"          , cmpnzxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E09C1180000000"          , cmpoxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E09C1180000000"          , cmpoxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E09C1180000000"          , cmpoxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E09C1180000000"          , cmpoxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259EA9C1180000000"          , cmppxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259EA9C1180000000"          , cmppxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9EA9C1180000000"          , cmppxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9EA9C1180000000"          , cmppxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E259E89C1180000000"          , cmpsxadd(ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E259E89C1180000000"          , cmpsxadd(dword_ptr(rcx, rdx, 0, 128), ebx, esp));
  TEST_INSTRUCTION("C4E2D9E89C1180000000"          , cmpsxadd(ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("C4E2D9E89C1180000000"          , cmpsxadd(qword_ptr(rcx, rdx, 0, 128), rbx, rsp));
  TEST_INSTRUCTION("F20F38F0CA"                    , crc32(ecx, dl));
  TEST_INSTRUCTION("F20F38F0CE"                    , crc32(ecx, dh));
  TEST_INSTRUCTION("66F20F38F1CA"                  , crc32(ecx, dx));
  TEST_INSTRUCTION("F20F38F1CA"                    , crc32(ecx, edx));
  TEST_INSTRUCTION("F20F38F08C1A80000000"          , crc32(ecx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66F20F38F18C1A80000000"        , crc32(ecx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F38F18C1A80000000"          , crc32(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F38F0CA"                  , crc32(rcx, dl));
  TEST_INSTRUCTION("F2480F38F1CA"                  , crc32(rcx, rdx));
  TEST_INSTRUCTION("F2480F38F08C1A80000000"        , crc32(rcx, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F38F18C1A80000000"        , crc32(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F1EFB"                      , endbr32());
  TEST_INSTRUCTION("F30F1EFA"                      , endbr64());
  TEST_INSTRUCTION("F20F38F88C1A80000000"          , enqcmd(zmmword_ptr(rcx), zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F38F88C1A80000000"          , enqcmds(zmmword_ptr(rcx), zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FAE8C1180000000"              , fxrstor(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("480FAE8C1180000000"            , fxrstor64(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FAE841180000000"              , fxsave(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("480FAE841180000000"            , fxsave64(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("D9F4"                          , fxtract());
  TEST_INSTRUCTION("0F37"                          , getsec());
  TEST_INSTRUCTION("F30F3AF0C001"                  , hreset(1, eax));
  TEST_INSTRUCTION("F30FAEE9"                      , incsspd(ecx));
  TEST_INSTRUCTION("F3480FAEE9"                    , incsspq(rcx));
  TEST_INSTRUCTION("660F38808C1A80000000"          , invept(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38808C1A80000000"          , invept(rcx, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("670F01DF"                      , invlpga(eax, ecx));
  TEST_INSTRUCTION("0F01DF"                        , invlpga(rax, ecx));
  TEST_INSTRUCTION("660F38818C1A80000000"          , invvpid(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38818C1A80000000"          , invvpid(rcx, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FAE941180000000"              , ldmxcsr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FAE941180000000"              , ldmxcsr(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FAEE8"                        , lfence());
  TEST_INSTRUCTION("8FE97812C1"                    , llwpcb(ecx));
  TEST_INSTRUCTION("8FE9F812C1"                    , llwpcb(rcx));
  TEST_INSTRUCTION("8FEA7012C201000000"            , lwpins(ecx, edx, 1));
  TEST_INSTRUCTION("8FEA7012841A8000000001000000"  , lwpins(ecx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEA7012841A8000000001000000"  , lwpins(ecx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEAF012C201000000"            , lwpins(rcx, edx, 1));
  TEST_INSTRUCTION("8FEAF012841A8000000001000000"  , lwpins(rcx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEAF012841A8000000001000000"  , lwpins(rcx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEA7012CA01000000"            , lwpval(ecx, edx, 1));
  TEST_INSTRUCTION("8FEA70128C1A8000000001000000"  , lwpval(ecx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEA70128C1A8000000001000000"  , lwpval(ecx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEAF012CA01000000"            , lwpval(rcx, edx, 1));
  TEST_INSTRUCTION("8FEAF0128C1A8000000001000000"  , lwpval(rcx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FEAF0128C1A8000000001000000"  , lwpval(rcx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("66F30FBDCA"                    , lzcnt(cx, dx));
  TEST_INSTRUCTION("66F30FBD8C1A80000000"          , lzcnt(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66F30FBD8C1A80000000"          , lzcnt(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FBDCA"                      , lzcnt(ecx, edx));
  TEST_INSTRUCTION("F30FBD8C1A80000000"            , lzcnt(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FBD8C1A80000000"            , lzcnt(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FBDCA"                    , lzcnt(rcx, rdx));
  TEST_INSTRUCTION("F3480FBD8C1A80000000"          , lzcnt(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FBD8C1A80000000"          , lzcnt(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F01FA"                      , mcommit());
  TEST_INSTRUCTION("0FAEF0"                        , mfence());
  TEST_INSTRUCTION("0F01C8"                        , monitor(ptr(rax), ecx, edx));
  TEST_INSTRUCTION("0F01FA"                        , monitorx(ptr(rax), ecx, edx));
  TEST_INSTRUCTION("660F38F08C1A80000000"          , movbe(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38F08C1A80000000"          , movbe(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38F08C1A80000000"            , movbe(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38F08C1A80000000"            , movbe(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F38F08C1A80000000"          , movbe(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("480F38F08C1A80000000"          , movbe(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38F19C1180000000"          , movbe(ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("660F38F19C1180000000"          , movbe(word_ptr(rcx, rdx, 0, 128), bx));
  TEST_INSTRUCTION("0F38F19C1180000000"            , movbe(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0F38F19C1180000000"            , movbe(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480F38F19C1180000000"          , movbe(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480F38F19C1180000000"          , movbe(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660F38F88C1A80000000"          , movdir64b(zmmword_ptr(rcx), zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38F99C1180000000"            , movdiri(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0F38F99C1180000000"            , movdiri(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480F38F99C1180000000"          , movdiri(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480F38F99C1180000000"          , movdiri(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("0FC39C1180000000"              , movnti(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0FC39C1180000000"              , movnti(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480FC39C1180000000"            , movnti(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480FC39C1180000000"            , movnti(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("C4E26BF6CB"                    , mulx(ecx, edx, ebx, edx));
  TEST_INSTRUCTION("C4E26BF68C2B80000000"          , mulx(ecx, edx, ptr(rbx, rbp, 0, 128), edx));
  TEST_INSTRUCTION("C4E26BF68C2B80000000"          , mulx(ecx, edx, dword_ptr(rbx, rbp, 0, 128), edx));
  TEST_INSTRUCTION("C4E2EBF6CB"                    , mulx(rcx, rdx, rbx, rdx));
  TEST_INSTRUCTION("C4E2EBF68C2B80000000"          , mulx(rcx, rdx, ptr(rbx, rbp, 0, 128), rdx));
  TEST_INSTRUCTION("C4E2EBF68C2B80000000"          , mulx(rcx, rdx, qword_ptr(rbx, rbp, 0, 128), rdx));
  TEST_INSTRUCTION("0F01C9"                        , mwait(eax, ecx));
  TEST_INSTRUCTION("0F01FB"                        , mwaitx(eax, ecx, ebx));
  TEST_INSTRUCTION("0F01C5"                        , pconfig());
  TEST_INSTRUCTION("C4E26BF5CB"                    , pdep(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E26BF58C2B80000000"          , pdep(ecx, edx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26BF58C2B80000000"          , pdep(ecx, edx, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EBF5CB"                    , pdep(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2EBF58C2B80000000"          , pdep(rcx, rdx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EBF58C2B80000000"          , pdep(rcx, rdx, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26AF5CB"                    , pext(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E26AF58C2B80000000"          , pext(ecx, edx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26AF58C2B80000000"          , pext(ecx, edx, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EAF5CB"                    , pext(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2EAF58C2B80000000"          , pext(rcx, rdx, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EAF58C2B80000000"          , pext(rcx, rdx, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("66F30FB8CA"                    , popcnt(cx, dx));
  TEST_INSTRUCTION("66F30FB88C1A80000000"          , popcnt(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66F30FB88C1A80000000"          , popcnt(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FB8CA"                      , popcnt(ecx, edx));
  TEST_INSTRUCTION("F30FB88C1A80000000"            , popcnt(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FB88C1A80000000"            , popcnt(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FB8CA"                    , popcnt(rcx, rdx));
  TEST_INSTRUCTION("F3480FB88C1A80000000"          , popcnt(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FB88C1A80000000"          , popcnt(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0D841180000000"              , prefetch(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F18BC1180000000"              , prefetchit0(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F18B41180000000"              , prefetchit1(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F18841180000000"              , prefetchnta(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F188C1180000000"              , prefetcht0(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F18941180000000"              , prefetcht1(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F189C1180000000"              , prefetcht2(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F0D8C1180000000"              , prefetchw(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F0D941180000000"              , prefetchwt1(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30F01FF"                      , psmash());
  TEST_INSTRUCTION("F30FAEE1"                      , ptwrite(ecx));
  TEST_INSTRUCTION("F3480FAEE1"                    , ptwrite(rcx));
  TEST_INSTRUCTION("F30FAEA41180000000"            , ptwrite(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30FAEA41180000000"            , ptwrite(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F3480FAEA41180000000"          , ptwrite(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F20F01FF"                      , pvalidate());
  TEST_INSTRUCTION("F30FAEC1"                      , rdfsbase(ecx));
  TEST_INSTRUCTION("F3480FAEC1"                    , rdfsbase(rcx));
  TEST_INSTRUCTION("F30FAEC9"                      , rdgsbase(ecx));
  TEST_INSTRUCTION("F3480FAEC9"                    , rdgsbase(rcx));
  TEST_INSTRUCTION("F30FC7F9"                      , rdpid(rcx));
  TEST_INSTRUCTION("0F01EE"                        , rdpkru(edx, eax, ecx));
  TEST_INSTRUCTION("0F33"                          , rdpmc(edx, eax, ecx));
  TEST_INSTRUCTION("0F01FD"                        , rdpru(edx, eax, ecx));
  TEST_INSTRUCTION("660FC7F1"                      , rdrand(cx));
  TEST_INSTRUCTION("0FC7F1"                        , rdrand(ecx));
  TEST_INSTRUCTION("480FC7F1"                      , rdrand(rcx));
  TEST_INSTRUCTION("660FC7F9"                      , rdseed(cx));
  TEST_INSTRUCTION("0FC7F9"                        , rdseed(ecx));
  TEST_INSTRUCTION("480FC7F9"                      , rdseed(rcx));
  TEST_INSTRUCTION("F30F1EC9"                      , rdsspd(ecx));
  TEST_INSTRUCTION("F3480F1EC9"                    , rdsspq(rcx));
  TEST_INSTRUCTION("0F31"                          , rdtsc(edx, eax));
  TEST_INSTRUCTION("0F01F9"                        , rdtscp(edx, eax, ecx));
  TEST_INSTRUCTION("F30F01FE"                      , rmpadjust());
  TEST_INSTRUCTION("F20F01FE"                      , rmpupdate());
  TEST_INSTRUCTION("C4E37BF0CA01"                  , rorx(ecx, edx, 1));
  TEST_INSTRUCTION("C4E37BF08C1A8000000001"        , rorx(ecx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37BF08C1A8000000001"        , rorx(ecx, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3FBF0CA01"                  , rorx(rcx, rdx, 1));
  TEST_INSTRUCTION("C4E3FBF08C1A8000000001"        , rorx(rcx, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3FBF08C1A8000000001"        , rorx(rcx, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E262F7CA"                    , sarx(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E25AF78C1A80000000"          , sarx(ecx, ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E25AF78C1A80000000"          , sarx(ecx, dword_ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E2E2F7CA"                    , sarx(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2DAF78C1A80000000"          , sarx(rcx, ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E2DAF78C1A80000000"          , sarx(rcx, qword_ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("F30F01EA"                      , saveprevssp());
  TEST_INSTRUCTION("F30FC7F1"                      , senduipi(rcx));
  TEST_INSTRUCTION("0F01E8"                        , serialize());
  TEST_INSTRUCTION("F30F01E8"                      , setssbsy());
  TEST_INSTRUCTION("0FAEF8"                        , sfence());
  TEST_INSTRUCTION("C4E261F7CA"                    , shlx(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E259F78C1A80000000"          , shlx(ecx, ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E259F78C1A80000000"          , shlx(ecx, dword_ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E2E1F7CA"                    , shlx(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2D9F78C1A80000000"          , shlx(rcx, ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E2D9F78C1A80000000"          , shlx(rcx, qword_ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E263F7CA"                    , shrx(ecx, edx, ebx));
  TEST_INSTRUCTION("C4E25BF78C1A80000000"          , shrx(ecx, ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E25BF78C1A80000000"          , shrx(ecx, dword_ptr(rdx, rbx, 0, 128), esp));
  TEST_INSTRUCTION("C4E2E3F7CA"                    , shrx(rcx, rdx, rbx));
  TEST_INSTRUCTION("C4E2DBF78C1A80000000"          , shrx(rcx, ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("C4E2DBF78C1A80000000"          , shrx(rcx, qword_ptr(rdx, rbx, 0, 128), rsp));
  TEST_INSTRUCTION("0F01DE"                        , skinit(eax));
  TEST_INSTRUCTION("8FE97812C9"                    , slwpcb(ecx));
  TEST_INSTRUCTION("8FE9F812C9"                    , slwpcb(rcx));
  TEST_INSTRUCTION("0F01CB"                        , stac());
  TEST_INSTRUCTION("0F01DC"                        , stgi());
  TEST_INSTRUCTION("0FAE9C1180000000"              , stmxcsr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FAE9C1180000000"              , stmxcsr(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30F01EF"                      , stui());
  TEST_INSTRUCTION("0F01F8"                        , swapgs());
  TEST_INSTRUCTION("0F05"                          , syscall());
  TEST_INSTRUCTION("0F34"                          , sysenter());
  TEST_INSTRUCTION("0F35"                          , sysexit());
  TEST_INSTRUCTION("480F35"                        , sysexitq());
  TEST_INSTRUCTION("0F07"                          , sysret());
  TEST_INSTRUCTION("480F07"                        , sysretq());
  TEST_INSTRUCTION("8FE97001FA"                    , t1mskc(ecx, edx));
  TEST_INSTRUCTION("8FE97001BC1A80000000"          , t1mskc(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001BC1A80000000"          , t1mskc(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001FA"                    , t1mskc(rcx, rdx));
  TEST_INSTRUCTION("8FE9F001BC1A80000000"          , t1mskc(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001BC1A80000000"          , t1mskc(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F01ED"                      , testui());
  TEST_INSTRUCTION("660FAEF1"                      , tpause(ecx, edx, eax));
  TEST_INSTRUCTION("66F30FBCCA"                    , tzcnt(cx, dx));
  TEST_INSTRUCTION("66F30FBC8C1A80000000"          , tzcnt(cx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66F30FBC8C1A80000000"          , tzcnt(cx, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FBCCA"                      , tzcnt(ecx, edx));
  TEST_INSTRUCTION("F30FBC8C1A80000000"            , tzcnt(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FBC8C1A80000000"            , tzcnt(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FBCCA"                    , tzcnt(rcx, rdx));
  TEST_INSTRUCTION("F3480FBC8C1A80000000"          , tzcnt(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480FBC8C1A80000000"          , tzcnt(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001E2"                    , tzmsk(ecx, edx));
  TEST_INSTRUCTION("8FE97001A41A80000000"          , tzmsk(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97001A41A80000000"          , tzmsk(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001E2"                    , tzmsk(rcx, rdx));
  TEST_INSTRUCTION("8FE9F001A41A80000000"          , tzmsk(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE9F001A41A80000000"          , tzmsk(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FAEF1"                      , umonitor(ptr(rcx)));
  TEST_INSTRUCTION("F20FAEF1"                      , umwait(ecx, edx, eax));
  TEST_INSTRUCTION("0F01C1"                        , vmcall());
  TEST_INSTRUCTION("660FC7B41180000000"            , vmclear(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("660FC7B41180000000"            , vmclear(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F01D4"                        , vmfunc());
  TEST_INSTRUCTION("0F01C2"                        , vmlaunch());
  TEST_INSTRUCTION("0F01DA"                        , vmload(rax));
  TEST_INSTRUCTION("0F01D9"                        , vmmcall());
  TEST_INSTRUCTION("0FC7B41180000000"              , vmptrld(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FC7B41180000000"              , vmptrld(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FC7BC1180000000"              , vmptrst(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0FC7BC1180000000"              , vmptrst(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F78D1"                        , vmread(rcx, rdx));
  TEST_INSTRUCTION("0F789C1180000000"              , vmread(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("0F789C1180000000"              , vmread(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("0F01C3"                        , vmresume());
  TEST_INSTRUCTION("0F01D8"                        , vmrun(rax));
  TEST_INSTRUCTION("0F01DB"                        , vmsave(rax));
  TEST_INSTRUCTION("0F79CA"                        , vmwrite(rcx, rdx));
  TEST_INSTRUCTION("0F798C1A80000000"              , vmwrite(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F798C1A80000000"              , vmwrite(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FC7B41180000000"            , vmxon(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30FC7B41180000000"            , vmxon(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30F09"                        , wbnoinvd());
  TEST_INSTRUCTION("F30FAED1"                      , wrfsbase(ecx));
  TEST_INSTRUCTION("F3480FAED1"                    , wrfsbase(rcx));
  TEST_INSTRUCTION("F30FAED9"                      , wrgsbase(ecx));
  TEST_INSTRUCTION("F3480FAED9"                    , wrgsbase(rcx));
  TEST_INSTRUCTION("0F38F69C1180000000"            , wrssd(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("0F38F69C1180000000"            , wrssd(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("480F38F69C1180000000"          , wrssq(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("480F38F69C1180000000"          , wrssq(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("660F38F59C1180000000"          , wrussd(ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("660F38F59C1180000000"          , wrussd(dword_ptr(rcx, rdx, 0, 128), ebx));
  TEST_INSTRUCTION("66480F38F59C1180000000"        , wrussq(ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("66480F38F59C1180000000"        , wrussq(qword_ptr(rcx, rdx, 0, 128), rbx));
  TEST_INSTRUCTION("0F01D5"                        , xend());
  TEST_INSTRUCTION("0F01D0"                        , xgetbv(edx, eax, ecx));
  TEST_INSTRUCTION("F20F01E9"                      , xresldtrk());
  TEST_INSTRUCTION("0FAEAC1180000000"              , xrstor(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FAEAC1180000000"            , xrstor64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0FC79C1180000000"              , xrstors(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FC79C1180000000"            , xrstors64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0FAEA41180000000"              , xsave(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FAEA41180000000"            , xsave64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0FC7A41180000000"              , xsavec(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FC7A41180000000"            , xsavec64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0FAEB41180000000"              , xsaveopt(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FAEB41180000000"            , xsaveopt64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0FC7AC1180000000"              , xsaves(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("480FC7AC1180000000"            , xsaves64(ptr(rcx, rdx, 0, 128), edx, eax));
  TEST_INSTRUCTION("0F01D1"                        , xsetbv(edx, eax, ecx));
  TEST_INSTRUCTION("F20F01E8"                      , xsusldtrk());
  TEST_INSTRUCTION("0F01D6"                        , xtest());
}

static void ASMJIT_NOINLINE test_x64_assembler_mmx_sse(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("660F58CA"                      , addpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F588C1A80000000"            , addpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F588C1A80000000"            , addpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F58CA"                        , addps(xmm1, xmm2));
  TEST_INSTRUCTION("0F588C1A80000000"              , addps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F588C1A80000000"              , addps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F58CA"                      , addsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F588C1A80000000"            , addsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F588C1A80000000"            , addsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F58CA"                      , addss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F588C1A80000000"            , addss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F588C1A80000000"            , addss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD0CA"                      , addsubpd(xmm1, xmm2));
  TEST_INSTRUCTION("660FD08C1A80000000"            , addsubpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD08C1A80000000"            , addsubpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FD0CA"                      , addsubps(xmm1, xmm2));
  TEST_INSTRUCTION("F20FD08C1A80000000"            , addsubps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FD08C1A80000000"            , addsubps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DECA"                    , aesdec(xmm1, xmm2));
  TEST_INSTRUCTION("660F38DE8C1A80000000"          , aesdec(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DE8C1A80000000"          , aesdec(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DFCA"                    , aesdeclast(xmm1, xmm2));
  TEST_INSTRUCTION("660F38DF8C1A80000000"          , aesdeclast(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DF8C1A80000000"          , aesdeclast(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DCCA"                    , aesenc(xmm1, xmm2));
  TEST_INSTRUCTION("660F38DC8C1A80000000"          , aesenc(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DC8C1A80000000"          , aesenc(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DDCA"                    , aesenclast(xmm1, xmm2));
  TEST_INSTRUCTION("660F38DD8C1A80000000"          , aesenclast(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DD8C1A80000000"          , aesenclast(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DBCA"                    , aesimc(xmm1, xmm2));
  TEST_INSTRUCTION("660F38DB8C1A80000000"          , aesimc(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38DB8C1A80000000"          , aesimc(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3ADFCA01"                  , aeskeygenassist(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3ADF8C1A8000000001"        , aeskeygenassist(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3ADF8C1A8000000001"        , aeskeygenassist(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F55CA"                      , andnpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F558C1A80000000"            , andnpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F558C1A80000000"            , andnpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F55CA"                        , andnps(xmm1, xmm2));
  TEST_INSTRUCTION("0F558C1A80000000"              , andnps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F558C1A80000000"              , andnps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F54CA"                      , andpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F548C1A80000000"            , andpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F548C1A80000000"            , andpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F54CA"                        , andps(xmm1, xmm2));
  TEST_INSTRUCTION("0F548C1A80000000"              , andps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F548C1A80000000"              , andps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A0DCA01"                  , blendpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0D8C1A8000000001"        , blendpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0D8C1A8000000001"        , blendpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0CCA01"                  , blendps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0C8C1A8000000001"        , blendps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0C8C1A8000000001"        , blendps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3815CA"                    , blendvpd(xmm1, xmm2, xmm0));
  TEST_INSTRUCTION("660F38158C1A80000000"          , blendvpd(xmm1, ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660F38158C1A80000000"          , blendvpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660F3814CA"                    , blendvps(xmm1, xmm2, xmm0));
  TEST_INSTRUCTION("660F38148C1A80000000"          , blendvps(xmm1, ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660F38148C1A80000000"          , blendvps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660FC2CA01"                    , cmppd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660FC28C1A8000000001"          , cmppd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660FC28C1A8000000001"          , cmppd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC2CA01"                      , cmpps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("0FC28C1A8000000001"            , cmpps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC28C1A8000000001"            , cmpps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F20FC2CA01"                    , cmpsd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("F20FC28C1A8000000001"          , cmpsd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F20FC28C1A8000000001"          , cmpsd(xmm1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F30FC2CA01"                    , cmpss(xmm1, xmm2, 1));
  TEST_INSTRUCTION("F30FC28C1A8000000001"          , cmpss(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F30FC28C1A8000000001"          , cmpss(xmm1, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F2FCA"                      , comisd(xmm1, xmm2));
  TEST_INSTRUCTION("660F2F8C1A80000000"            , comisd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2F8C1A80000000"            , comisd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2FCA"                        , comiss(xmm1, xmm2));
  TEST_INSTRUCTION("0F2F8C1A80000000"              , comiss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2F8C1A80000000"              , comiss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FE6CA"                      , cvtdq2pd(xmm1, xmm2));
  TEST_INSTRUCTION("F30FE68C1A80000000"            , cvtdq2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30FE68C1A80000000"            , cvtdq2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5BCA"                        , cvtdq2ps(xmm1, xmm2));
  TEST_INSTRUCTION("0F5B8C1A80000000"              , cvtdq2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5B8C1A80000000"              , cvtdq2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FE6CA"                      , cvtpd2dq(xmm1, xmm2));
  TEST_INSTRUCTION("F20FE68C1A80000000"            , cvtpd2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FE68C1A80000000"            , cvtpd2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2DCA"                      , cvtpd2pi(mm1, xmm2));
  TEST_INSTRUCTION("660F2D8C1A80000000"            , cvtpd2pi(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2D8C1A80000000"            , cvtpd2pi(mm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5ACA"                      , cvtpd2ps(xmm1, xmm2));
  TEST_INSTRUCTION("660F5A8C1A80000000"            , cvtpd2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5A8C1A80000000"            , cvtpd2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2ACA"                      , cvtpi2pd(xmm1, mm2));
  TEST_INSTRUCTION("660F2A8C1A80000000"            , cvtpi2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2A8C1A80000000"            , cvtpi2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2ACA"                        , cvtpi2ps(xmm1, mm2));
  TEST_INSTRUCTION("0F2A8C1A80000000"              , cvtpi2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2A8C1A80000000"              , cvtpi2ps(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5BCA"                      , cvtps2dq(xmm1, xmm2));
  TEST_INSTRUCTION("660F5B8C1A80000000"            , cvtps2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5B8C1A80000000"            , cvtps2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5ACA"                        , cvtps2pd(xmm1, xmm2));
  TEST_INSTRUCTION("0F5A8C1A80000000"              , cvtps2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5A8C1A80000000"              , cvtps2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2DCA"                        , cvtps2pi(mm1, xmm2));
  TEST_INSTRUCTION("0F2D8C1A80000000"              , cvtps2pi(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2D8C1A80000000"              , cvtps2pi(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2DCA"                      , cvtsd2si(ecx, xmm2));
  TEST_INSTRUCTION("F20F2D8C1A80000000"            , cvtsd2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2D8C1A80000000"            , cvtsd2si(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F2DCA"                    , cvtsd2si(rcx, xmm2));
  TEST_INSTRUCTION("F2480F2D8C1A80000000"          , cvtsd2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F2D8C1A80000000"          , cvtsd2si(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5ACA"                      , cvtsd2ss(xmm1, xmm2));
  TEST_INSTRUCTION("F20F5A8C1A80000000"            , cvtsd2ss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5A8C1A80000000"            , cvtsd2ss(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2ACA"                      , cvtsi2sd(xmm1, edx));
  TEST_INSTRUCTION("F2480F2ACA"                    , cvtsi2sd(xmm1, rdx));
  TEST_INSTRUCTION("F20F2A8C1A80000000"            , cvtsi2sd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2A8C1A80000000"            , cvtsi2sd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F2A8C1A80000000"          , cvtsi2sd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2ACA"                      , cvtsi2ss(xmm1, edx));
  TEST_INSTRUCTION("F3480F2ACA"                    , cvtsi2ss(xmm1, rdx));
  TEST_INSTRUCTION("F30F2A8C1A80000000"            , cvtsi2ss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2A8C1A80000000"            , cvtsi2ss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F2A8C1A80000000"          , cvtsi2ss(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5ACA"                      , cvtss2sd(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5A8C1A80000000"            , cvtss2sd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5A8C1A80000000"            , cvtss2sd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2DCA"                      , cvtss2si(ecx, xmm2));
  TEST_INSTRUCTION("F30F2D8C1A80000000"            , cvtss2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2D8C1A80000000"            , cvtss2si(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F2DCA"                    , cvtss2si(rcx, xmm2));
  TEST_INSTRUCTION("F3480F2D8C1A80000000"          , cvtss2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F2D8C1A80000000"          , cvtss2si(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE6CA"                      , cvttpd2dq(xmm1, xmm2));
  TEST_INSTRUCTION("660FE68C1A80000000"            , cvttpd2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE68C1A80000000"            , cvttpd2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2CCA"                      , cvttpd2pi(mm1, xmm2));
  TEST_INSTRUCTION("660F2C8C1A80000000"            , cvttpd2pi(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2C8C1A80000000"            , cvttpd2pi(mm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5BCA"                      , cvttps2dq(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5B8C1A80000000"            , cvttps2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5B8C1A80000000"            , cvttps2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2CCA"                        , cvttps2pi(mm1, xmm2));
  TEST_INSTRUCTION("0F2C8C1A80000000"              , cvttps2pi(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2C8C1A80000000"              , cvttps2pi(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2CCA"                      , cvttsd2si(ecx, xmm2));
  TEST_INSTRUCTION("F20F2C8C1A80000000"            , cvttsd2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F2C8C1A80000000"            , cvttsd2si(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F2CCA"                    , cvttsd2si(rcx, xmm2));
  TEST_INSTRUCTION("F2480F2C8C1A80000000"          , cvttsd2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F2480F2C8C1A80000000"          , cvttsd2si(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2CCA"                      , cvttss2si(ecx, xmm2));
  TEST_INSTRUCTION("F30F2C8C1A80000000"            , cvttss2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F2C8C1A80000000"            , cvttss2si(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F2CCA"                    , cvttss2si(rcx, xmm2));
  TEST_INSTRUCTION("F3480F2C8C1A80000000"          , cvttss2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F3480F2C8C1A80000000"          , cvttss2si(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5ECA"                      , divpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F5E8C1A80000000"            , divpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5E8C1A80000000"            , divpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5ECA"                        , divps(xmm1, xmm2));
  TEST_INSTRUCTION("0F5E8C1A80000000"              , divps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5E8C1A80000000"              , divps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5ECA"                      , divsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F5E8C1A80000000"            , divsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5E8C1A80000000"            , divsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5ECA"                      , divss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5E8C1A80000000"            , divss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5E8C1A80000000"            , divss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A41CA01"                  , dppd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A418C1A8000000001"        , dppd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A418C1A8000000001"        , dppd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A40CA01"                  , dpps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A408C1A8000000001"        , dpps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A408C1A8000000001"        , dpps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F77"                          , emms());
  TEST_INSTRUCTION("660F3A17D101"                  , extractps(ecx, xmm2, 1));
  TEST_INSTRUCTION("660F3A179C118000000001"        , extractps(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F3A179C118000000001"        , extractps(dword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F78C10102"                  , extrq(xmm1, 1, 2));
  TEST_INSTRUCTION("660F79CA"                      , extrq(xmm1, xmm2));
  TEST_INSTRUCTION("660F3ACFCA01"                  , gf2p8affineinvqb(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3ACF8C1A8000000001"        , gf2p8affineinvqb(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3ACF8C1A8000000001"        , gf2p8affineinvqb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3ACECA01"                  , gf2p8affineqb(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3ACE8C1A8000000001"        , gf2p8affineqb(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3ACE8C1A8000000001"        , gf2p8affineqb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F38CFCA"                    , gf2p8mulb(xmm1, xmm2));
  TEST_INSTRUCTION("660F38CF8C1A80000000"          , gf2p8mulb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38CF8C1A80000000"          , gf2p8mulb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7CCA"                      , haddpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F7C8C1A80000000"            , haddpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7C8C1A80000000"            , haddpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F7CCA"                      , haddps(xmm1, xmm2));
  TEST_INSTRUCTION("F20F7C8C1A80000000"            , haddps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F7C8C1A80000000"            , haddps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7DCA"                      , hsubpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F7D8C1A80000000"            , hsubpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7D8C1A80000000"            , hsubpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F7DCA"                      , hsubps(xmm1, xmm2));
  TEST_INSTRUCTION("F20F7D8C1A80000000"            , hsubps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F7D8C1A80000000"            , hsubps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A21CA01"                  , insertps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A218C1A8000000001"        , insertps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A218C1A8000000001"        , insertps(xmm1, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F20F79CA"                      , insertq(xmm1, xmm2));
  TEST_INSTRUCTION("F20F78CA0102"                  , insertq(xmm1, xmm2, 1, 2));
  TEST_INSTRUCTION("F20FF08C1A80000000"            , lddqu(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FF08C1A80000000"            , lddqu(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF7CA"                      , maskmovdqu(xmm1, xmm2, ptr(rdi)));
  TEST_INSTRUCTION("660FF7CA"                      , maskmovdqu(xmm1, xmm2, xmmword_ptr(rdi)));
  TEST_INSTRUCTION("0FF7CA"                        , maskmovq(mm1, mm2, ptr(rdi)));
  TEST_INSTRUCTION("0FF7CA"                        , maskmovq(mm1, mm2, qword_ptr(rdi)));
  TEST_INSTRUCTION("660F5FCA"                      , maxpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F5F8C1A80000000"            , maxpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5F8C1A80000000"            , maxpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5FCA"                        , maxps(xmm1, xmm2));
  TEST_INSTRUCTION("0F5F8C1A80000000"              , maxps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5F8C1A80000000"              , maxps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5FCA"                      , maxsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F5F8C1A80000000"            , maxsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5F8C1A80000000"            , maxsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5FCA"                      , maxss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5F8C1A80000000"            , maxss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5F8C1A80000000"            , maxss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5DCA"                      , minpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F5D8C1A80000000"            , minpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5D8C1A80000000"            , minpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5DCA"                        , minps(xmm1, xmm2));
  TEST_INSTRUCTION("0F5D8C1A80000000"              , minps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5D8C1A80000000"              , minps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5DCA"                      , minsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F5D8C1A80000000"            , minsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5D8C1A80000000"            , minsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5DCA"                      , minss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5D8C1A80000000"            , minss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5D8C1A80000000"            , minss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F28CA"                      , movapd(xmm1, xmm2));
  TEST_INSTRUCTION("660F288C1A80000000"            , movapd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F288C1A80000000"            , movapd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F299C1180000000"            , movapd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F299C1180000000"            , movapd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F28CA"                        , movaps(xmm1, xmm2));
  TEST_INSTRUCTION("0F288C1A80000000"              , movaps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F288C1A80000000"              , movaps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F299C1180000000"              , movaps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F299C1180000000"              , movaps(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F6ECA"                      , movd(xmm1, edx));
  TEST_INSTRUCTION("660F6E8C1A80000000"            , movd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6E8C1A80000000"            , movd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6ECA"                        , movd(mm1, edx));
  TEST_INSTRUCTION("0F6E8C1A80000000"              , movd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6E8C1A80000000"              , movd(mm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7ED1"                      , movd(ecx, xmm2));
  TEST_INSTRUCTION("0F7ED1"                        , movd(ecx, mm2));
  TEST_INSTRUCTION("660F7E9C1180000000"            , movd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F7E9C1180000000"              , movd(ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("660F7E9C1180000000"            , movd(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F7E9C1180000000"              , movd(dword_ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("F20F12CA"                      , movddup(xmm1, xmm2));
  TEST_INSTRUCTION("F20F128C1A80000000"            , movddup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F128C1A80000000"            , movddup(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20FD6CA"                      , movdq2q(mm1, xmm2));
  TEST_INSTRUCTION("660F6FCA"                      , movdqa(xmm1, xmm2));
  TEST_INSTRUCTION("660F6F8C1A80000000"            , movdqa(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6F8C1A80000000"            , movdqa(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F7F9C1180000000"            , movdqa(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F7F9C1180000000"            , movdqa(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F6FCA"                      , movdqu(xmm1, xmm2));
  TEST_INSTRUCTION("F30F6F8C1A80000000"            , movdqu(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F6F8C1A80000000"            , movdqu(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F7F9C1180000000"            , movdqu(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F7F9C1180000000"            , movdqu(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F12CA"                        , movhlps(xmm1, xmm2));
  TEST_INSTRUCTION("660F179C1180000000"            , movhpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F179C1180000000"            , movhpd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F168C1A80000000"            , movhpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F168C1A80000000"            , movhpd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F179C1180000000"              , movhps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F179C1180000000"              , movhps(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F168C1A80000000"              , movhps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F168C1A80000000"              , movhps(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F16CA"                        , movlhps(xmm1, xmm2));
  TEST_INSTRUCTION("660F139C1180000000"            , movlpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F139C1180000000"            , movlpd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F128C1A80000000"            , movlpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F128C1A80000000"            , movlpd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F139C1180000000"              , movlps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F139C1180000000"              , movlps(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F128C1A80000000"              , movlps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F128C1A80000000"              , movlps(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F50CA"                      , movmskpd(ecx, xmm2));
  TEST_INSTRUCTION("0F50CA"                        , movmskps(ecx, xmm2));
  TEST_INSTRUCTION("660FE79C1180000000"            , movntdq(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660FE79C1180000000"            , movntdq(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F382A8C1A80000000"          , movntdqa(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F382A8C1A80000000"          , movntdqa(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2B9C1180000000"            , movntpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F2B9C1180000000"            , movntpd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F2B9C1180000000"              , movntps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F2B9C1180000000"              , movntps(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0FE79C1180000000"              , movntq(ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("0FE79C1180000000"              , movntq(qword_ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("F20F2B9C1180000000"            , movntsd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F20F2B9C1180000000"            , movntsd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F2B9C1180000000"            , movntss(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F2B9C1180000000"            , movntss(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("480F6ECA"                      , movq(mm1, rdx));
  TEST_INSTRUCTION("0F6FCA"                        , movq(mm1, mm2));
  TEST_INSTRUCTION("0F6F8C1A80000000"              , movq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6F8C1A80000000"              , movq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("66480F7ED1"                    , movq(rcx, xmm2));
  TEST_INSTRUCTION("480F7ED1"                      , movq(rcx, mm2));
  TEST_INSTRUCTION("660FD69C1180000000"            , movq(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F7F9C1180000000"              , movq(ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("660FD69C1180000000"            , movq(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F7F9C1180000000"              , movq(qword_ptr(rcx, rdx, 0, 128), mm3));
  TEST_INSTRUCTION("66480F6ECA"                    , movq(xmm1, rdx));
  TEST_INSTRUCTION("F30F7E8C1A80000000"            , movq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F7E8C1A80000000"            , movq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F7ECA"                      , movq(xmm1, xmm2));
  TEST_INSTRUCTION("F30FD6CA"                      , movq2dq(xmm1, mm2));
  TEST_INSTRUCTION("F20F10CA"                      , movsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F108C1A80000000"            , movsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F108C1A80000000"            , movsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F119C1180000000"            , movsd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F20F119C1180000000"            , movsd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F16CA"                      , movshdup(xmm1, xmm2));
  TEST_INSTRUCTION("F30F168C1A80000000"            , movshdup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F168C1A80000000"            , movshdup(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F12CA"                      , movsldup(xmm1, xmm2));
  TEST_INSTRUCTION("F30F128C1A80000000"            , movsldup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F128C1A80000000"            , movsldup(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F10CA"                      , movss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F108C1A80000000"            , movss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F108C1A80000000"            , movss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F119C1180000000"            , movss(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("F30F119C1180000000"            , movss(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F10CA"                      , movupd(xmm1, xmm2));
  TEST_INSTRUCTION("660F108C1A80000000"            , movupd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F108C1A80000000"            , movupd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F119C1180000000"            , movupd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F119C1180000000"            , movupd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F10CA"                        , movups(xmm1, xmm2));
  TEST_INSTRUCTION("0F108C1A80000000"              , movups(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F108C1A80000000"              , movups(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F119C1180000000"              , movups(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("0F119C1180000000"              , movups(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("660F3A42CA01"                  , mpsadbw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A428C1A8000000001"        , mpsadbw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A428C1A8000000001"        , mpsadbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F59CA"                      , mulpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F598C1A80000000"            , mulpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F598C1A80000000"            , mulpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F59CA"                        , mulps(xmm1, xmm2));
  TEST_INSTRUCTION("0F598C1A80000000"              , mulps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F598C1A80000000"              , mulps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F59CA"                      , mulsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F598C1A80000000"            , mulsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F598C1A80000000"            , mulsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F59CA"                      , mulss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F598C1A80000000"            , mulss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F598C1A80000000"            , mulss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F56CA"                      , orpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F568C1A80000000"            , orpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F568C1A80000000"            , orpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F56CA"                        , orps(xmm1, xmm2));
  TEST_INSTRUCTION("0F568C1A80000000"              , orps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F568C1A80000000"              , orps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381CCA"                      , pabsb(mm1, mm2));
  TEST_INSTRUCTION("0F381C8C1A80000000"            , pabsb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381C8C1A80000000"            , pabsb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381CCA"                    , pabsb(xmm1, xmm2));
  TEST_INSTRUCTION("660F381C8C1A80000000"          , pabsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381C8C1A80000000"          , pabsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381ECA"                      , pabsd(mm1, mm2));
  TEST_INSTRUCTION("0F381E8C1A80000000"            , pabsd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381E8C1A80000000"            , pabsd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381ECA"                    , pabsd(xmm1, xmm2));
  TEST_INSTRUCTION("660F381E8C1A80000000"          , pabsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381E8C1A80000000"          , pabsd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381DCA"                      , pabsw(mm1, mm2));
  TEST_INSTRUCTION("0F381D8C1A80000000"            , pabsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F381D8C1A80000000"            , pabsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381DCA"                    , pabsw(xmm1, xmm2));
  TEST_INSTRUCTION("660F381D8C1A80000000"          , pabsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F381D8C1A80000000"          , pabsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6BCA"                        , packssdw(mm1, mm2));
  TEST_INSTRUCTION("0F6B8C1A80000000"              , packssdw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6B8C1A80000000"              , packssdw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6BCA"                      , packssdw(xmm1, xmm2));
  TEST_INSTRUCTION("660F6B8C1A80000000"            , packssdw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6B8C1A80000000"            , packssdw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F63CA"                        , packsswb(mm1, mm2));
  TEST_INSTRUCTION("0F638C1A80000000"              , packsswb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F638C1A80000000"              , packsswb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F63CA"                      , packsswb(xmm1, xmm2));
  TEST_INSTRUCTION("660F638C1A80000000"            , packsswb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F638C1A80000000"            , packsswb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F382BCA"                    , packusdw(xmm1, xmm2));
  TEST_INSTRUCTION("660F382B8C1A80000000"          , packusdw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F382B8C1A80000000"          , packusdw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F67CA"                        , packuswb(mm1, mm2));
  TEST_INSTRUCTION("0F678C1A80000000"              , packuswb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F678C1A80000000"              , packuswb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F67CA"                      , packuswb(xmm1, xmm2));
  TEST_INSTRUCTION("660F678C1A80000000"            , packuswb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F678C1A80000000"            , packuswb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFCCA"                        , paddb(mm1, mm2));
  TEST_INSTRUCTION("0FFC8C1A80000000"              , paddb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFC8C1A80000000"              , paddb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFCCA"                      , paddb(xmm1, xmm2));
  TEST_INSTRUCTION("660FFC8C1A80000000"            , paddb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFC8C1A80000000"            , paddb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFECA"                        , paddd(mm1, mm2));
  TEST_INSTRUCTION("0FFE8C1A80000000"              , paddd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFE8C1A80000000"              , paddd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFECA"                      , paddd(xmm1, xmm2));
  TEST_INSTRUCTION("660FFE8C1A80000000"            , paddd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFE8C1A80000000"            , paddd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD4CA"                        , paddq(mm1, mm2));
  TEST_INSTRUCTION("0FD48C1A80000000"              , paddq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD48C1A80000000"              , paddq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD4CA"                      , paddq(xmm1, xmm2));
  TEST_INSTRUCTION("660FD48C1A80000000"            , paddq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD48C1A80000000"            , paddq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FECCA"                        , paddsb(mm1, mm2));
  TEST_INSTRUCTION("0FEC8C1A80000000"              , paddsb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEC8C1A80000000"              , paddsb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FECCA"                      , paddsb(xmm1, xmm2));
  TEST_INSTRUCTION("660FEC8C1A80000000"            , paddsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEC8C1A80000000"            , paddsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEDCA"                        , paddsw(mm1, mm2));
  TEST_INSTRUCTION("0FED8C1A80000000"              , paddsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FED8C1A80000000"              , paddsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEDCA"                      , paddsw(xmm1, xmm2));
  TEST_INSTRUCTION("660FED8C1A80000000"            , paddsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FED8C1A80000000"            , paddsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDCCA"                        , paddusb(mm1, mm2));
  TEST_INSTRUCTION("0FDC8C1A80000000"              , paddusb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDC8C1A80000000"              , paddusb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDCCA"                      , paddusb(xmm1, xmm2));
  TEST_INSTRUCTION("660FDC8C1A80000000"            , paddusb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDC8C1A80000000"            , paddusb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDDCA"                        , paddusw(mm1, mm2));
  TEST_INSTRUCTION("0FDD8C1A80000000"              , paddusw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDD8C1A80000000"              , paddusw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDDCA"                      , paddusw(xmm1, xmm2));
  TEST_INSTRUCTION("660FDD8C1A80000000"            , paddusw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDD8C1A80000000"            , paddusw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFDCA"                        , paddw(mm1, mm2));
  TEST_INSTRUCTION("0FFD8C1A80000000"              , paddw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFD8C1A80000000"              , paddw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFDCA"                      , paddw(xmm1, xmm2));
  TEST_INSTRUCTION("660FFD8C1A80000000"            , paddw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFD8C1A80000000"            , paddw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3A0FCA01"                    , palignr(mm1, mm2, 1));
  TEST_INSTRUCTION("0F3A0F8C1A8000000001"          , palignr(mm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F3A0F8C1A8000000001"          , palignr(mm1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0FCA01"                  , palignr(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0F8C1A8000000001"        , palignr(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0F8C1A8000000001"        , palignr(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FDBCA"                        , pand(mm1, mm2));
  TEST_INSTRUCTION("0FDB8C1A80000000"              , pand(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDB8C1A80000000"              , pand(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDBCA"                      , pand(xmm1, xmm2));
  TEST_INSTRUCTION("660FDB8C1A80000000"            , pand(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDB8C1A80000000"            , pand(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDFCA"                        , pandn(mm1, mm2));
  TEST_INSTRUCTION("0FDF8C1A80000000"              , pandn(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDF8C1A80000000"              , pandn(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDFCA"                      , pandn(xmm1, xmm2));
  TEST_INSTRUCTION("660FDF8C1A80000000"            , pandn(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDF8C1A80000000"            , pandn(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE0CA"                        , pavgb(mm1, mm2));
  TEST_INSTRUCTION("0FE08C1A80000000"              , pavgb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE08C1A80000000"              , pavgb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE0CA"                      , pavgb(xmm1, xmm2));
  TEST_INSTRUCTION("660FE08C1A80000000"            , pavgb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE08C1A80000000"            , pavgb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCABF"                      , pavgusb(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000BF"            , pavgusb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000BF"            , pavgusb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE3CA"                        , pavgw(mm1, mm2));
  TEST_INSTRUCTION("0FE38C1A80000000"              , pavgw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE38C1A80000000"              , pavgw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE3CA"                      , pavgw(xmm1, xmm2));
  TEST_INSTRUCTION("660FE38C1A80000000"            , pavgw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE38C1A80000000"            , pavgw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3810CA"                    , pblendvb(xmm1, xmm2, xmm0));
  TEST_INSTRUCTION("660F38108C1A80000000"          , pblendvb(xmm1, ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660F38108C1A80000000"          , pblendvb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660F3A0ECA01"                  , pblendw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0E8C1A8000000001"        , pblendw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0E8C1A8000000001"        , pblendw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A44CA01"                  , pclmulqdq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A448C1A8000000001"        , pclmulqdq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A448C1A8000000001"        , pclmulqdq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F74CA"                        , pcmpeqb(mm1, mm2));
  TEST_INSTRUCTION("0F748C1A80000000"              , pcmpeqb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F748C1A80000000"              , pcmpeqb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F74CA"                      , pcmpeqb(xmm1, xmm2));
  TEST_INSTRUCTION("660F748C1A80000000"            , pcmpeqb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F748C1A80000000"            , pcmpeqb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F76CA"                        , pcmpeqd(mm1, mm2));
  TEST_INSTRUCTION("0F768C1A80000000"              , pcmpeqd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F768C1A80000000"              , pcmpeqd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F76CA"                      , pcmpeqd(xmm1, xmm2));
  TEST_INSTRUCTION("660F768C1A80000000"            , pcmpeqd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F768C1A80000000"            , pcmpeqd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3829CA"                    , pcmpeqq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38298C1A80000000"          , pcmpeqq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38298C1A80000000"          , pcmpeqq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F75CA"                        , pcmpeqw(mm1, mm2));
  TEST_INSTRUCTION("0F758C1A80000000"              , pcmpeqw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F758C1A80000000"              , pcmpeqw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F75CA"                      , pcmpeqw(xmm1, xmm2));
  TEST_INSTRUCTION("660F758C1A80000000"            , pcmpeqw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F758C1A80000000"            , pcmpeqw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A61CA01"                  , pcmpestri(xmm1, xmm2, 1, ecx, eax, edx));
  TEST_INSTRUCTION("660F3A618C1A8000000001"        , pcmpestri(xmm1, ptr(rdx, rbx, 0, 128), 1, ecx, eax, edx));
  TEST_INSTRUCTION("660F3A618C1A8000000001"        , pcmpestri(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, ecx, eax, edx));
  TEST_INSTRUCTION("660F3A60CA01"                  , pcmpestrm(xmm1, xmm2, 1, xmm0, eax, edx));
  TEST_INSTRUCTION("660F3A608C1A8000000001"        , pcmpestrm(xmm1, ptr(rdx, rbx, 0, 128), 1, xmm0, eax, edx));
  TEST_INSTRUCTION("660F3A608C1A8000000001"        , pcmpestrm(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, xmm0, eax, edx));
  TEST_INSTRUCTION("0F64CA"                        , pcmpgtb(mm1, mm2));
  TEST_INSTRUCTION("0F648C1A80000000"              , pcmpgtb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F648C1A80000000"              , pcmpgtb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F64CA"                      , pcmpgtb(xmm1, xmm2));
  TEST_INSTRUCTION("660F648C1A80000000"            , pcmpgtb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F648C1A80000000"            , pcmpgtb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F66CA"                        , pcmpgtd(mm1, mm2));
  TEST_INSTRUCTION("0F668C1A80000000"              , pcmpgtd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F668C1A80000000"              , pcmpgtd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F66CA"                      , pcmpgtd(xmm1, xmm2));
  TEST_INSTRUCTION("660F668C1A80000000"            , pcmpgtd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F668C1A80000000"            , pcmpgtd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3837CA"                    , pcmpgtq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38378C1A80000000"          , pcmpgtq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38378C1A80000000"          , pcmpgtq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F65CA"                        , pcmpgtw(mm1, mm2));
  TEST_INSTRUCTION("0F658C1A80000000"              , pcmpgtw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F658C1A80000000"              , pcmpgtw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F65CA"                      , pcmpgtw(xmm1, xmm2));
  TEST_INSTRUCTION("660F658C1A80000000"            , pcmpgtw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F658C1A80000000"            , pcmpgtw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A63CA01"                  , pcmpistri(xmm1, xmm2, 1, ecx));
  TEST_INSTRUCTION("660F3A638C1A8000000001"        , pcmpistri(xmm1, ptr(rdx, rbx, 0, 128), 1, ecx));
  TEST_INSTRUCTION("660F3A638C1A8000000001"        , pcmpistri(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, ecx));
  TEST_INSTRUCTION("660F3A62CA01"                  , pcmpistrm(xmm1, xmm2, 1, xmm0));
  TEST_INSTRUCTION("660F3A628C1A8000000001"        , pcmpistrm(xmm1, ptr(rdx, rbx, 0, 128), 1, xmm0));
  TEST_INSTRUCTION("660F3A628C1A8000000001"        , pcmpistrm(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, xmm0));
  TEST_INSTRUCTION("660F3A14D101"                  , pextrb(ecx, xmm2, 1));
  TEST_INSTRUCTION("660F3A149C118000000001"        , pextrb(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F3A149C118000000001"        , pextrb(byte_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F3A16D101"                  , pextrd(ecx, xmm2, 1));
  TEST_INSTRUCTION("660F3A169C118000000001"        , pextrd(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F3A169C118000000001"        , pextrd(dword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("66480F3A16D101"                , pextrq(rcx, xmm2, 1));
  TEST_INSTRUCTION("66480F3A169C118000000001"      , pextrq(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("66480F3A169C118000000001"      , pextrq(qword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660FC5CA01"                    , pextrw(ecx, xmm2, 1));
  TEST_INSTRUCTION("0FC5CA01"                      , pextrw(ecx, mm2, 1));
  TEST_INSTRUCTION("660F3A159C118000000001"        , pextrw(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("660F3A159C118000000001"        , pextrw(word_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("0F0FCA1D"                      , pf2id(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000001D"            , pf2id(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000001D"            , pf2id(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA1C"                      , pf2iw(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000001C"            , pf2iw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000001C"            , pf2iw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAAE"                      , pfacc(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000AE"            , pfacc(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000AE"            , pfacc(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA9E"                      , pfadd(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000009E"            , pfadd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000009E"            , pfadd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAB0"                      , pfcmpeq(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000B0"            , pfcmpeq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000B0"            , pfcmpeq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA90"                      , pfcmpge(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000090"            , pfcmpge(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000090"            , pfcmpge(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAA0"                      , pfcmpgt(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000A0"            , pfcmpgt(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000A0"            , pfcmpgt(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAA4"                      , pfmax(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000A4"            , pfmax(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000A4"            , pfmax(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA94"                      , pfmin(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000094"            , pfmin(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000094"            , pfmin(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAB4"                      , pfmul(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000B4"            , pfmul(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000B4"            , pfmul(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA8A"                      , pfnacc(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000008A"            , pfnacc(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000008A"            , pfnacc(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA8E"                      , pfpnacc(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000008E"            , pfpnacc(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000008E"            , pfpnacc(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA96"                      , pfrcp(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000096"            , pfrcp(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000096"            , pfrcp(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAA6"                      , pfrcpit1(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000A6"            , pfrcpit1(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000A6"            , pfrcpit1(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAB6"                      , pfrcpit2(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000B6"            , pfrcpit2(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000B6"            , pfrcpit2(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA86"                      , pfrcpv(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000086"            , pfrcpv(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000086"            , pfrcpv(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAA7"                      , pfrsqit1(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000A7"            , pfrsqit1(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000A7"            , pfrsqit1(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA97"                      , pfrsqrt(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000097"            , pfrsqrt(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000097"            , pfrsqrt(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA87"                      , pfrsqrtv(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A8000000087"            , pfrsqrtv(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A8000000087"            , pfrsqrtv(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA9A"                      , pfsub(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000009A"            , pfsub(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000009A"            , pfsub(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAAA"                      , pfsubr(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000AA"            , pfsubr(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000AA"            , pfsubr(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3802CA"                      , phaddd(mm1, mm2));
  TEST_INSTRUCTION("0F38028C1A80000000"            , phaddd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38028C1A80000000"            , phaddd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3802CA"                    , phaddd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38028C1A80000000"          , phaddd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38028C1A80000000"          , phaddd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3803CA"                      , phaddsw(mm1, mm2));
  TEST_INSTRUCTION("0F38038C1A80000000"            , phaddsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38038C1A80000000"            , phaddsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3803CA"                    , phaddsw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38038C1A80000000"          , phaddsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38038C1A80000000"          , phaddsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3801CA"                      , phaddw(mm1, mm2));
  TEST_INSTRUCTION("0F38018C1A80000000"            , phaddw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38018C1A80000000"            , phaddw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3801CA"                    , phaddw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38018C1A80000000"          , phaddw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38018C1A80000000"          , phaddw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3841CA"                    , phminposuw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38418C1A80000000"          , phminposuw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38418C1A80000000"          , phminposuw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3806CA"                      , phsubd(mm1, mm2));
  TEST_INSTRUCTION("0F38068C1A80000000"            , phsubd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38068C1A80000000"            , phsubd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3806CA"                    , phsubd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38068C1A80000000"          , phsubd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38068C1A80000000"          , phsubd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3807CA"                      , phsubsw(mm1, mm2));
  TEST_INSTRUCTION("0F38078C1A80000000"            , phsubsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38078C1A80000000"            , phsubsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3807CA"                    , phsubsw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38078C1A80000000"          , phsubsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38078C1A80000000"          , phsubsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3805CA"                      , phsubw(mm1, mm2));
  TEST_INSTRUCTION("0F38058C1A80000000"            , phsubw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38058C1A80000000"            , phsubw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3805CA"                    , phsubw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38058C1A80000000"          , phsubw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38058C1A80000000"          , phsubw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA0D"                      , pi2fd(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000000D"            , pi2fd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000000D"            , pi2fd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCA0C"                      , pi2fw(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A800000000C"            , pi2fw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A800000000C"            , pi2fw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A20CA01"                  , pinsrb(xmm1, edx, 1));
  TEST_INSTRUCTION("660F3A208C1A8000000001"        , pinsrb(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A208C1A8000000001"        , pinsrb(xmm1, byte_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A22CA01"                  , pinsrd(xmm1, edx, 1));
  TEST_INSTRUCTION("660F3A228C1A8000000001"        , pinsrd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A228C1A8000000001"        , pinsrd(xmm1, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("66480F3A22CA01"                , pinsrq(xmm1, rdx, 1));
  TEST_INSTRUCTION("66480F3A228C1A8000000001"      , pinsrq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("66480F3A228C1A8000000001"      , pinsrq(xmm1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660FC4CA01"                    , pinsrw(xmm1, edx, 1));
  TEST_INSTRUCTION("660FC48C1A8000000001"          , pinsrw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660FC48C1A8000000001"          , pinsrw(xmm1, word_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC4CA01"                      , pinsrw(mm1, edx, 1));
  TEST_INSTRUCTION("0FC48C1A8000000001"            , pinsrw(mm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC48C1A8000000001"            , pinsrw(mm1, word_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F3804CA"                      , pmaddubsw(mm1, mm2));
  TEST_INSTRUCTION("0F38048C1A80000000"            , pmaddubsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38048C1A80000000"            , pmaddubsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3804CA"                    , pmaddubsw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38048C1A80000000"          , pmaddubsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38048C1A80000000"          , pmaddubsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF5CA"                        , pmaddwd(mm1, mm2));
  TEST_INSTRUCTION("0FF58C1A80000000"              , pmaddwd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF58C1A80000000"              , pmaddwd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF5CA"                      , pmaddwd(xmm1, xmm2));
  TEST_INSTRUCTION("660FF58C1A80000000"            , pmaddwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF58C1A80000000"            , pmaddwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383CCA"                    , pmaxsb(xmm1, xmm2));
  TEST_INSTRUCTION("660F383C8C1A80000000"          , pmaxsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383C8C1A80000000"          , pmaxsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383DCA"                    , pmaxsd(xmm1, xmm2));
  TEST_INSTRUCTION("660F383D8C1A80000000"          , pmaxsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383D8C1A80000000"          , pmaxsd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEECA"                        , pmaxsw(mm1, mm2));
  TEST_INSTRUCTION("0FEE8C1A80000000"              , pmaxsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEE8C1A80000000"              , pmaxsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEECA"                      , pmaxsw(xmm1, xmm2));
  TEST_INSTRUCTION("660FEE8C1A80000000"            , pmaxsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEE8C1A80000000"            , pmaxsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDECA"                        , pmaxub(mm1, mm2));
  TEST_INSTRUCTION("0FDE8C1A80000000"              , pmaxub(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDE8C1A80000000"              , pmaxub(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDECA"                      , pmaxub(xmm1, xmm2));
  TEST_INSTRUCTION("660FDE8C1A80000000"            , pmaxub(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDE8C1A80000000"            , pmaxub(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383FCA"                    , pmaxud(xmm1, xmm2));
  TEST_INSTRUCTION("660F383F8C1A80000000"          , pmaxud(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383F8C1A80000000"          , pmaxud(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383ECA"                    , pmaxuw(xmm1, xmm2));
  TEST_INSTRUCTION("660F383E8C1A80000000"          , pmaxuw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383E8C1A80000000"          , pmaxuw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3838CA"                    , pminsb(xmm1, xmm2));
  TEST_INSTRUCTION("660F38388C1A80000000"          , pminsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38388C1A80000000"          , pminsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3839CA"                    , pminsd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38398C1A80000000"          , pminsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38398C1A80000000"          , pminsd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEACA"                        , pminsw(mm1, mm2));
  TEST_INSTRUCTION("0FEA8C1A80000000"              , pminsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEA8C1A80000000"              , pminsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEACA"                      , pminsw(xmm1, xmm2));
  TEST_INSTRUCTION("660FEA8C1A80000000"            , pminsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEA8C1A80000000"            , pminsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDACA"                        , pminub(mm1, mm2));
  TEST_INSTRUCTION("0FDA8C1A80000000"              , pminub(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FDA8C1A80000000"              , pminub(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDACA"                      , pminub(xmm1, xmm2));
  TEST_INSTRUCTION("660FDA8C1A80000000"            , pminub(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FDA8C1A80000000"            , pminub(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383BCA"                    , pminud(xmm1, xmm2));
  TEST_INSTRUCTION("660F383B8C1A80000000"          , pminud(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383B8C1A80000000"          , pminud(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383ACA"                    , pminuw(xmm1, xmm2));
  TEST_INSTRUCTION("660F383A8C1A80000000"          , pminuw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F383A8C1A80000000"          , pminuw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD7CA"                      , pmovmskb(ecx, xmm2));
  TEST_INSTRUCTION("0FD7CA"                        , pmovmskb(ecx, mm2));
  TEST_INSTRUCTION("660F3821CA"                    , pmovsxbd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38218C1A80000000"          , pmovsxbd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38218C1A80000000"          , pmovsxbd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3822CA"                    , pmovsxbq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38228C1A80000000"          , pmovsxbq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38228C1A80000000"          , pmovsxbq(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3820CA"                    , pmovsxbw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38208C1A80000000"          , pmovsxbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38208C1A80000000"          , pmovsxbw(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3825CA"                    , pmovsxdq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38258C1A80000000"          , pmovsxdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38258C1A80000000"          , pmovsxdq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3823CA"                    , pmovsxwd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38238C1A80000000"          , pmovsxwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38238C1A80000000"          , pmovsxwd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3824CA"                    , pmovsxwq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38248C1A80000000"          , pmovsxwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38248C1A80000000"          , pmovsxwq(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3831CA"                    , pmovzxbd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38318C1A80000000"          , pmovzxbd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38318C1A80000000"          , pmovzxbd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3832CA"                    , pmovzxbq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38328C1A80000000"          , pmovzxbq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38328C1A80000000"          , pmovzxbq(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3830CA"                    , pmovzxbw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38308C1A80000000"          , pmovzxbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38308C1A80000000"          , pmovzxbw(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3835CA"                    , pmovzxdq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38358C1A80000000"          , pmovzxdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38358C1A80000000"          , pmovzxdq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3833CA"                    , pmovzxwd(xmm1, xmm2));
  TEST_INSTRUCTION("660F38338C1A80000000"          , pmovzxwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38338C1A80000000"          , pmovzxwd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3834CA"                    , pmovzxwq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38348C1A80000000"          , pmovzxwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38348C1A80000000"          , pmovzxwq(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3828CA"                    , pmuldq(xmm1, xmm2));
  TEST_INSTRUCTION("660F38288C1A80000000"          , pmuldq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38288C1A80000000"          , pmuldq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F380BCA"                      , pmulhrsw(mm1, mm2));
  TEST_INSTRUCTION("0F380B8C1A80000000"            , pmulhrsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F380B8C1A80000000"            , pmulhrsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F380BCA"                    , pmulhrsw(xmm1, xmm2));
  TEST_INSTRUCTION("660F380B8C1A80000000"          , pmulhrsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F380B8C1A80000000"          , pmulhrsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCAB7"                      , pmulhrw(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000B7"            , pmulhrw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000B7"            , pmulhrw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE4CA"                        , pmulhuw(mm1, mm2));
  TEST_INSTRUCTION("0FE48C1A80000000"              , pmulhuw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE48C1A80000000"              , pmulhuw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE4CA"                      , pmulhuw(xmm1, xmm2));
  TEST_INSTRUCTION("660FE48C1A80000000"            , pmulhuw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE48C1A80000000"            , pmulhuw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE5CA"                        , pmulhw(mm1, mm2));
  TEST_INSTRUCTION("0FE58C1A80000000"              , pmulhw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE58C1A80000000"              , pmulhw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE5CA"                      , pmulhw(xmm1, xmm2));
  TEST_INSTRUCTION("660FE58C1A80000000"            , pmulhw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE58C1A80000000"            , pmulhw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3840CA"                    , pmulld(xmm1, xmm2));
  TEST_INSTRUCTION("660F38408C1A80000000"          , pmulld(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38408C1A80000000"          , pmulld(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD5CA"                        , pmullw(mm1, mm2));
  TEST_INSTRUCTION("0FD58C1A80000000"              , pmullw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD58C1A80000000"              , pmullw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD5CA"                      , pmullw(xmm1, xmm2));
  TEST_INSTRUCTION("660FD58C1A80000000"            , pmullw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD58C1A80000000"            , pmullw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF4CA"                        , pmuludq(mm1, mm2));
  TEST_INSTRUCTION("0FF48C1A80000000"              , pmuludq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF48C1A80000000"              , pmuludq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF4CA"                      , pmuludq(xmm1, xmm2));
  TEST_INSTRUCTION("660FF48C1A80000000"            , pmuludq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF48C1A80000000"            , pmuludq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEBCA"                        , por(mm1, mm2));
  TEST_INSTRUCTION("0FEB8C1A80000000"              , por(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEB8C1A80000000"              , por(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEBCA"                      , por(xmm1, xmm2));
  TEST_INSTRUCTION("660FEB8C1A80000000"            , por(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEB8C1A80000000"            , por(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF6CA"                        , psadbw(mm1, mm2));
  TEST_INSTRUCTION("0FF68C1A80000000"              , psadbw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF68C1A80000000"              , psadbw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF6CA"                      , psadbw(xmm1, xmm2));
  TEST_INSTRUCTION("660FF68C1A80000000"            , psadbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF68C1A80000000"            , psadbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3800CA"                      , pshufb(mm1, mm2));
  TEST_INSTRUCTION("0F38008C1A80000000"            , pshufb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38008C1A80000000"            , pshufb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3800CA"                    , pshufb(xmm1, xmm2));
  TEST_INSTRUCTION("660F38008C1A80000000"          , pshufb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38008C1A80000000"          , pshufb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F70CA01"                    , pshufd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F708C1A8000000001"          , pshufd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F708C1A8000000001"          , pshufd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F30F70CA01"                    , pshufhw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("F30F708C1A8000000001"          , pshufhw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F30F708C1A8000000001"          , pshufhw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F20F70CA01"                    , pshuflw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("F20F708C1A8000000001"          , pshuflw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("F20F708C1A8000000001"          , pshuflw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F70CA01"                      , pshufw(mm1, mm2, 1));
  TEST_INSTRUCTION("0F708C1A8000000001"            , pshufw(mm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F708C1A8000000001"            , pshufw(mm1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F3808CA"                      , psignb(mm1, mm2));
  TEST_INSTRUCTION("0F38088C1A80000000"            , psignb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38088C1A80000000"            , psignb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3808CA"                    , psignb(xmm1, xmm2));
  TEST_INSTRUCTION("660F38088C1A80000000"          , psignb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38088C1A80000000"          , psignb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F380ACA"                      , psignd(mm1, mm2));
  TEST_INSTRUCTION("0F380A8C1A80000000"            , psignd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F380A8C1A80000000"            , psignd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F380ACA"                    , psignd(xmm1, xmm2));
  TEST_INSTRUCTION("660F380A8C1A80000000"          , psignd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F380A8C1A80000000"          , psignd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3809CA"                      , psignw(mm1, mm2));
  TEST_INSTRUCTION("0F38098C1A80000000"            , psignw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38098C1A80000000"            , psignw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3809CA"                    , psignw(xmm1, xmm2));
  TEST_INSTRUCTION("660F38098C1A80000000"          , psignw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38098C1A80000000"          , psignw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF2CA"                        , pslld(mm1, mm2));
  TEST_INSTRUCTION("0F72F101"                      , pslld(mm1, 1));
  TEST_INSTRUCTION("0FF28C1A80000000"              , pslld(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF28C1A80000000"              , pslld(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF2CA"                      , pslld(xmm1, xmm2));
  TEST_INSTRUCTION("660F72F101"                    , pslld(xmm1, 1));
  TEST_INSTRUCTION("660FF28C1A80000000"            , pslld(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF28C1A80000000"            , pslld(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F73F901"                    , pslldq(xmm1, 1));
  TEST_INSTRUCTION("0FF3CA"                        , psllq(mm1, mm2));
  TEST_INSTRUCTION("0F73F101"                      , psllq(mm1, 1));
  TEST_INSTRUCTION("0FF38C1A80000000"              , psllq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF38C1A80000000"              , psllq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF3CA"                      , psllq(xmm1, xmm2));
  TEST_INSTRUCTION("660F73F101"                    , psllq(xmm1, 1));
  TEST_INSTRUCTION("660FF38C1A80000000"            , psllq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF38C1A80000000"            , psllq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF1CA"                        , psllw(mm1, mm2));
  TEST_INSTRUCTION("0F71F101"                      , psllw(mm1, 1));
  TEST_INSTRUCTION("0FF18C1A80000000"              , psllw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF18C1A80000000"              , psllw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF1CA"                      , psllw(xmm1, xmm2));
  TEST_INSTRUCTION("660F71F101"                    , psllw(xmm1, 1));
  TEST_INSTRUCTION("660FF18C1A80000000"            , psllw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF18C1A80000000"            , psllw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE2CA"                        , psrad(mm1, mm2));
  TEST_INSTRUCTION("0F72E101"                      , psrad(mm1, 1));
  TEST_INSTRUCTION("0FE28C1A80000000"              , psrad(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE28C1A80000000"              , psrad(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE2CA"                      , psrad(xmm1, xmm2));
  TEST_INSTRUCTION("660F72E101"                    , psrad(xmm1, 1));
  TEST_INSTRUCTION("660FE28C1A80000000"            , psrad(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE28C1A80000000"            , psrad(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE1CA"                        , psraw(mm1, mm2));
  TEST_INSTRUCTION("0F71E101"                      , psraw(mm1, 1));
  TEST_INSTRUCTION("0FE18C1A80000000"              , psraw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE18C1A80000000"              , psraw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE1CA"                      , psraw(xmm1, xmm2));
  TEST_INSTRUCTION("660F71E101"                    , psraw(xmm1, 1));
  TEST_INSTRUCTION("660FE18C1A80000000"            , psraw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE18C1A80000000"            , psraw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD2CA"                        , psrld(mm1, mm2));
  TEST_INSTRUCTION("0F72D101"                      , psrld(mm1, 1));
  TEST_INSTRUCTION("0FD28C1A80000000"              , psrld(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD28C1A80000000"              , psrld(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD2CA"                      , psrld(xmm1, xmm2));
  TEST_INSTRUCTION("660F72D101"                    , psrld(xmm1, 1));
  TEST_INSTRUCTION("660FD28C1A80000000"            , psrld(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD28C1A80000000"            , psrld(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F73D901"                    , psrldq(xmm1, 1));
  TEST_INSTRUCTION("0FD3CA"                        , psrlq(mm1, mm2));
  TEST_INSTRUCTION("0F73D101"                      , psrlq(mm1, 1));
  TEST_INSTRUCTION("0FD38C1A80000000"              , psrlq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD38C1A80000000"              , psrlq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD3CA"                      , psrlq(xmm1, xmm2));
  TEST_INSTRUCTION("660F73D101"                    , psrlq(xmm1, 1));
  TEST_INSTRUCTION("660FD38C1A80000000"            , psrlq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD38C1A80000000"            , psrlq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD1CA"                        , psrlw(mm1, mm2));
  TEST_INSTRUCTION("0F71D101"                      , psrlw(mm1, 1));
  TEST_INSTRUCTION("0FD18C1A80000000"              , psrlw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD18C1A80000000"              , psrlw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD1CA"                      , psrlw(xmm1, xmm2));
  TEST_INSTRUCTION("660F71D101"                    , psrlw(xmm1, 1));
  TEST_INSTRUCTION("660FD18C1A80000000"            , psrlw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD18C1A80000000"            , psrlw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF8CA"                        , psubb(mm1, mm2));
  TEST_INSTRUCTION("0FF88C1A80000000"              , psubb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF88C1A80000000"              , psubb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF8CA"                      , psubb(xmm1, xmm2));
  TEST_INSTRUCTION("660FF88C1A80000000"            , psubb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF88C1A80000000"            , psubb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFACA"                        , psubd(mm1, mm2));
  TEST_INSTRUCTION("0FFA8C1A80000000"              , psubd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFA8C1A80000000"              , psubd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFACA"                      , psubd(xmm1, xmm2));
  TEST_INSTRUCTION("660FFA8C1A80000000"            , psubd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFA8C1A80000000"            , psubd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFBCA"                        , psubq(mm1, mm2));
  TEST_INSTRUCTION("0FFB8C1A80000000"              , psubq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FFB8C1A80000000"              , psubq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFBCA"                      , psubq(xmm1, xmm2));
  TEST_INSTRUCTION("660FFB8C1A80000000"            , psubq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FFB8C1A80000000"            , psubq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE8CA"                        , psubsb(mm1, mm2));
  TEST_INSTRUCTION("0FE88C1A80000000"              , psubsb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE88C1A80000000"              , psubsb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE8CA"                      , psubsb(xmm1, xmm2));
  TEST_INSTRUCTION("660FE88C1A80000000"            , psubsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE88C1A80000000"            , psubsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE9CA"                        , psubsw(mm1, mm2));
  TEST_INSTRUCTION("0FE98C1A80000000"              , psubsw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FE98C1A80000000"              , psubsw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE9CA"                      , psubsw(xmm1, xmm2));
  TEST_INSTRUCTION("660FE98C1A80000000"            , psubsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FE98C1A80000000"            , psubsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD8CA"                        , psubusb(mm1, mm2));
  TEST_INSTRUCTION("0FD88C1A80000000"              , psubusb(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD88C1A80000000"              , psubusb(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD8CA"                      , psubusb(xmm1, xmm2));
  TEST_INSTRUCTION("660FD88C1A80000000"            , psubusb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD88C1A80000000"            , psubusb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD9CA"                        , psubusw(mm1, mm2));
  TEST_INSTRUCTION("0FD98C1A80000000"              , psubusw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FD98C1A80000000"              , psubusw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD9CA"                      , psubusw(xmm1, xmm2));
  TEST_INSTRUCTION("660FD98C1A80000000"            , psubusw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FD98C1A80000000"            , psubusw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF9CA"                        , psubw(mm1, mm2));
  TEST_INSTRUCTION("0FF98C1A80000000"              , psubw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FF98C1A80000000"              , psubw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF9CA"                      , psubw(xmm1, xmm2));
  TEST_INSTRUCTION("660FF98C1A80000000"            , psubw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FF98C1A80000000"            , psubw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0FCABB"                      , pswapd(mm1, mm2));
  TEST_INSTRUCTION("0F0F8C1A80000000BB"            , pswapd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F0F8C1A80000000BB"            , pswapd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3817CA"                    , ptest(xmm1, xmm2));
  TEST_INSTRUCTION("660F38178C1A80000000"          , ptest(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F38178C1A80000000"          , ptest(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F68CA"                        , punpckhbw(mm1, mm2));
  TEST_INSTRUCTION("0F688C1A80000000"              , punpckhbw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F688C1A80000000"              , punpckhbw(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F68CA"                      , punpckhbw(xmm1, xmm2));
  TEST_INSTRUCTION("660F688C1A80000000"            , punpckhbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F688C1A80000000"            , punpckhbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6ACA"                        , punpckhdq(mm1, mm2));
  TEST_INSTRUCTION("0F6A8C1A80000000"              , punpckhdq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F6A8C1A80000000"              , punpckhdq(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6ACA"                      , punpckhdq(xmm1, xmm2));
  TEST_INSTRUCTION("660F6A8C1A80000000"            , punpckhdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6A8C1A80000000"            , punpckhdq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6DCA"                      , punpckhqdq(xmm1, xmm2));
  TEST_INSTRUCTION("660F6D8C1A80000000"            , punpckhqdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6D8C1A80000000"            , punpckhqdq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F69CA"                        , punpckhwd(mm1, mm2));
  TEST_INSTRUCTION("0F698C1A80000000"              , punpckhwd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F698C1A80000000"              , punpckhwd(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F69CA"                      , punpckhwd(xmm1, xmm2));
  TEST_INSTRUCTION("660F698C1A80000000"            , punpckhwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F698C1A80000000"            , punpckhwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F60CA"                        , punpcklbw(mm1, mm2));
  TEST_INSTRUCTION("0F608C1A80000000"              , punpcklbw(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F608C1A80000000"              , punpcklbw(mm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F60CA"                      , punpcklbw(xmm1, xmm2));
  TEST_INSTRUCTION("660F608C1A80000000"            , punpcklbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F608C1A80000000"            , punpcklbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F62CA"                        , punpckldq(mm1, mm2));
  TEST_INSTRUCTION("0F628C1A80000000"              , punpckldq(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F628C1A80000000"              , punpckldq(mm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F62CA"                      , punpckldq(xmm1, xmm2));
  TEST_INSTRUCTION("660F628C1A80000000"            , punpckldq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F628C1A80000000"            , punpckldq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6CCA"                      , punpcklqdq(xmm1, xmm2));
  TEST_INSTRUCTION("660F6C8C1A80000000"            , punpcklqdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F6C8C1A80000000"            , punpcklqdq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F61CA"                        , punpcklwd(mm1, mm2));
  TEST_INSTRUCTION("0F618C1A80000000"              , punpcklwd(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F618C1A80000000"              , punpcklwd(mm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F61CA"                      , punpcklwd(xmm1, xmm2));
  TEST_INSTRUCTION("660F618C1A80000000"            , punpcklwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F618C1A80000000"            , punpcklwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEFCA"                        , pxor(mm1, mm2));
  TEST_INSTRUCTION("0FEF8C1A80000000"              , pxor(mm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0FEF8C1A80000000"              , pxor(mm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEFCA"                      , pxor(xmm1, xmm2));
  TEST_INSTRUCTION("660FEF8C1A80000000"            , pxor(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660FEF8C1A80000000"            , pxor(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F53CA"                        , rcpps(xmm1, xmm2));
  TEST_INSTRUCTION("0F538C1A80000000"              , rcpps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F538C1A80000000"              , rcpps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F53CA"                      , rcpss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F538C1A80000000"            , rcpss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F538C1A80000000"            , rcpss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F3A09CA01"                  , roundpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A098C1A8000000001"        , roundpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A098C1A8000000001"        , roundpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A08CA01"                  , roundps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A088C1A8000000001"        , roundps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A088C1A8000000001"        , roundps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0BCA01"                  , roundsd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0B8C1A8000000001"        , roundsd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0B8C1A8000000001"        , roundsd(xmm1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0ACA01"                  , roundss(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660F3A0A8C1A8000000001"        , roundss(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F3A0A8C1A8000000001"        , roundss(xmm1, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F52CA"                        , rsqrtps(xmm1, xmm2));
  TEST_INSTRUCTION("0F528C1A80000000"              , rsqrtps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F528C1A80000000"              , rsqrtps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F52CA"                      , rsqrtss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F528C1A80000000"            , rsqrtss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F528C1A80000000"            , rsqrtss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F01AC1180000000"            , rstorssp(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("F30F01AC1180000000"            , rstorssp(qword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("0F38C9CA"                      , sha1msg1(xmm1, xmm2));
  TEST_INSTRUCTION("0F38C98C1A80000000"            , sha1msg1(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38C98C1A80000000"            , sha1msg1(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CACA"                      , sha1msg2(xmm1, xmm2));
  TEST_INSTRUCTION("0F38CA8C1A80000000"            , sha1msg2(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CA8C1A80000000"            , sha1msg2(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38C8CA"                      , sha1nexte(xmm1, xmm2));
  TEST_INSTRUCTION("0F38C88C1A80000000"            , sha1nexte(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38C88C1A80000000"            , sha1nexte(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F3ACCCA01"                    , sha1rnds4(xmm1, xmm2, 1));
  TEST_INSTRUCTION("0F3ACC8C1A8000000001"          , sha1rnds4(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F3ACC8C1A8000000001"          , sha1rnds4(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0F38CCCA"                      , sha256msg1(xmm1, xmm2));
  TEST_INSTRUCTION("0F38CC8C1A80000000"            , sha256msg1(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CC8C1A80000000"            , sha256msg1(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CDCA"                      , sha256msg2(xmm1, xmm2));
  TEST_INSTRUCTION("0F38CD8C1A80000000"            , sha256msg2(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CD8C1A80000000"            , sha256msg2(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F38CBCA"                      , sha256rnds2(xmm1, xmm2, xmm0));
  TEST_INSTRUCTION("0F38CB8C1A80000000"            , sha256rnds2(xmm1, ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("0F38CB8C1A80000000"            , sha256rnds2(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm0));
  TEST_INSTRUCTION("660FC6CA01"                    , shufpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("660FC68C1A8000000001"          , shufpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660FC68C1A8000000001"          , shufpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC6CA01"                      , shufps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("0FC68C1A8000000001"            , shufps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("0FC68C1A8000000001"            , shufps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("660F51CA"                      , sqrtpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F518C1A80000000"            , sqrtpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F518C1A80000000"            , sqrtpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F51CA"                        , sqrtps(xmm1, xmm2));
  TEST_INSTRUCTION("0F518C1A80000000"              , sqrtps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F518C1A80000000"              , sqrtps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F51CA"                      , sqrtsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F518C1A80000000"            , sqrtsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F518C1A80000000"            , sqrtsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F51CA"                      , sqrtss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F518C1A80000000"            , sqrtss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F518C1A80000000"            , sqrtss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5CCA"                      , subpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F5C8C1A80000000"            , subpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F5C8C1A80000000"            , subpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5CCA"                        , subps(xmm1, xmm2));
  TEST_INSTRUCTION("0F5C8C1A80000000"              , subps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F5C8C1A80000000"              , subps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5CCA"                      , subsd(xmm1, xmm2));
  TEST_INSTRUCTION("F20F5C8C1A80000000"            , subsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F20F5C8C1A80000000"            , subsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5CCA"                      , subss(xmm1, xmm2));
  TEST_INSTRUCTION("F30F5C8C1A80000000"            , subss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("F30F5C8C1A80000000"            , subss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2ECA"                      , ucomisd(xmm1, xmm2));
  TEST_INSTRUCTION("660F2E8C1A80000000"            , ucomisd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F2E8C1A80000000"            , ucomisd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2ECA"                        , ucomiss(xmm1, xmm2));
  TEST_INSTRUCTION("0F2E8C1A80000000"              , ucomiss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F2E8C1A80000000"              , ucomiss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F15CA"                      , unpckhpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F158C1A80000000"            , unpckhpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F158C1A80000000"            , unpckhpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F15CA"                        , unpckhps(xmm1, xmm2));
  TEST_INSTRUCTION("0F158C1A80000000"              , unpckhps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F158C1A80000000"              , unpckhps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F14CA"                      , unpcklpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F148C1A80000000"            , unpcklpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F148C1A80000000"            , unpcklpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F14CA"                        , unpcklps(xmm1, xmm2));
  TEST_INSTRUCTION("0F148C1A80000000"              , unpcklps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F148C1A80000000"              , unpcklps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F57CA"                      , xorpd(xmm1, xmm2));
  TEST_INSTRUCTION("660F578C1A80000000"            , xorpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("660F578C1A80000000"            , xorpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F57CA"                        , xorps(xmm1, xmm2));
  TEST_INSTRUCTION("0F578C1A80000000"              , xorps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("0F578C1A80000000"              , xorps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C5E958CB"                      , vaddpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9588C2B80000000"            , vaddpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9588C2B80000000"            , vaddpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED58CB"                      , vaddpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED588C2B80000000"            , vaddpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED588C2B80000000"            , vaddpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E858CB"                      , vaddps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8588C2B80000000"            , vaddps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8588C2B80000000"            , vaddps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC58CB"                      , vaddps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC588C2B80000000"            , vaddps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC588C2B80000000"            , vaddps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB58CB"                      , vaddsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB588C2B80000000"            , vaddsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB588C2B80000000"            , vaddsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA58CB"                      , vaddss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA588C2B80000000"            , vaddss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA588C2B80000000"            , vaddss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D0CB"                      , vaddsubpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9D08C2B80000000"            , vaddsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D08C2B80000000"            , vaddsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD0CB"                      , vaddsubpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDD08C2B80000000"            , vaddsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD08C2B80000000"            , vaddsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EBD0CB"                      , vaddsubps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EBD08C2B80000000"            , vaddsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EBD08C2B80000000"            , vaddsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EFD0CB"                      , vaddsubps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EFD08C2B80000000"            , vaddsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EFD08C2B80000000"            , vaddsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DECB"                    , vaesdec(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269DE8C2B80000000"          , vaesdec(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DE8C2B80000000"          , vaesdec(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDECB"                    , vaesdec(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DDE8C2B80000000"          , vaesdec(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDE8C2B80000000"          , vaesdec(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DFCB"                    , vaesdeclast(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269DF8C2B80000000"          , vaesdeclast(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DF8C2B80000000"          , vaesdeclast(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDFCB"                    , vaesdeclast(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DDF8C2B80000000"          , vaesdeclast(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDF8C2B80000000"          , vaesdeclast(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DCCB"                    , vaesenc(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269DC8C2B80000000"          , vaesenc(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DC8C2B80000000"          , vaesenc(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDCCB"                    , vaesenc(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DDC8C2B80000000"          , vaesenc(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDC8C2B80000000"          , vaesenc(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DDCB"                    , vaesenclast(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269DD8C2B80000000"          , vaesenclast(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DD8C2B80000000"          , vaesenclast(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDDCB"                    , vaesenclast(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DDD8C2B80000000"          , vaesenclast(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DDD8C2B80000000"          , vaesenclast(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E279DBCA"                    , vaesimc(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279DB8C1A80000000"          , vaesimc(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279DB8C1A80000000"          , vaesimc(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E379DFCA01"                  , vaeskeygenassist(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E379DF8C1A8000000001"        , vaeskeygenassist(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E379DF8C1A8000000001"        , vaeskeygenassist(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5E955CB"                      , vandnpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9558C2B80000000"            , vandnpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9558C2B80000000"            , vandnpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED55CB"                      , vandnpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED558C2B80000000"            , vandnpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED558C2B80000000"            , vandnpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E855CB"                      , vandnps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8558C2B80000000"            , vandnps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8558C2B80000000"            , vandnps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC55CB"                      , vandnps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC558C2B80000000"            , vandnps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC558C2B80000000"            , vandnps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E954CB"                      , vandpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9548C2B80000000"            , vandpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9548C2B80000000"            , vandpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED54CB"                      , vandpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED548C2B80000000"            , vandpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED548C2B80000000"            , vandpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E854CB"                      , vandps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8548C2B80000000"            , vandps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8548C2B80000000"            , vandps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC54CB"                      , vandps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC548C2B80000000"            , vandps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC548C2B80000000"            , vandps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E3690DCB01"                  , vblendpd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690D8C2B8000000001"        , vblendpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690D8C2B8000000001"        , vblendpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0DCB01"                  , vblendpd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D0D8C2B8000000001"        , vblendpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0D8C2B8000000001"        , vblendpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690CCB01"                  , vblendps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690C8C2B8000000001"        , vblendps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690C8C2B8000000001"        , vblendps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0CCB01"                  , vblendps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D0C8C2B8000000001"        , vblendps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0C8C2B8000000001"        , vblendps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3694BCB40"                  , vblendvpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3694B8C2B8000000060"        , vblendvpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3694B8C2B8000000060"        , vblendvpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E36D4BCB40"                  , vblendvpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E36D4B8C2B8000000060"        , vblendvpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D4B8C2B8000000060"        , vblendvpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3694ACB40"                  , vblendvps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3694A8C2B8000000060"        , vblendvps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3694A8C2B8000000060"        , vblendvps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E36D4ACB40"                  , vblendvps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E36D4A8C2B8000000060"        , vblendvps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D4A8C2B8000000060"        , vblendvps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E27D1A8C1A80000000"          , vbroadcastf128(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1A8C1A80000000"          , vbroadcastf128(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D5A8C1A80000000"          , vbroadcasti128(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D5A8C1A80000000"          , vbroadcasti128(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D19CA"                    , vbroadcastsd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D198C1A80000000"          , vbroadcastsd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D198C1A80000000"          , vbroadcastsd(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27918CA"                    , vbroadcastss(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279188C1A80000000"          , vbroadcastss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279188C1A80000000"          , vbroadcastss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D18CA"                    , vbroadcastss(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D188C1A80000000"          , vbroadcastss(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D188C1A80000000"          , vbroadcastss(ymm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5E9C2CB01"                    , vcmppd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5E9C28C2B8000000001"          , vcmppd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E9C28C2B8000000001"          , vcmppd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EDC2CB01"                    , vcmppd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C5EDC28C2B8000000001"          , vcmppd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EDC28C2B8000000001"          , vcmppd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E8C2CB01"                    , vcmpps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5E8C28C2B8000000001"          , vcmpps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E8C28C2B8000000001"          , vcmpps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5ECC2CB01"                    , vcmpps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C5ECC28C2B8000000001"          , vcmpps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5ECC28C2B8000000001"          , vcmpps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EBC2CB01"                    , vcmpsd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5EBC28C2B8000000001"          , vcmpsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EBC28C2B8000000001"          , vcmpsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EAC2CB01"                    , vcmpss(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5EAC28C2B8000000001"          , vcmpss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EAC28C2B8000000001"          , vcmpss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5F92FCA"                      , vcomisd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F92F8C1A80000000"            , vcomisd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F92F8C1A80000000"            , vcomisd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F82FCA"                      , vcomiss(xmm1, xmm2));
  TEST_INSTRUCTION("C5F82F8C1A80000000"            , vcomiss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F82F8C1A80000000"            , vcomiss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FAE6CA"                      , vcvtdq2pd(xmm1, xmm2));
  TEST_INSTRUCTION("C5FAE68C1A80000000"            , vcvtdq2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FAE68C1A80000000"            , vcvtdq2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FEE6CA"                      , vcvtdq2pd(ymm1, xmm2));
  TEST_INSTRUCTION("C5FEE68C1A80000000"            , vcvtdq2pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FEE68C1A80000000"            , vcvtdq2pd(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F85BCA"                      , vcvtdq2ps(xmm1, xmm2));
  TEST_INSTRUCTION("C5F85B8C1A80000000"            , vcvtdq2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F85B8C1A80000000"            , vcvtdq2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC5BCA"                      , vcvtdq2ps(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC5B8C1A80000000"            , vcvtdq2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC5B8C1A80000000"            , vcvtdq2ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FBE6CA"                      , vcvtpd2dq(xmm1, xmm2));
  TEST_INSTRUCTION("C5FFE6CA"                      , vcvtpd2dq(xmm1, ymm2));
  TEST_INSTRUCTION("C5FBE68C1A80000000"            , vcvtpd2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FFE68C1A80000000"            , vcvtpd2dq(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F95ACA"                      , vcvtpd2ps(xmm1, xmm2));
  TEST_INSTRUCTION("C5FD5ACA"                      , vcvtpd2ps(xmm1, ymm2));
  TEST_INSTRUCTION("C5F95A8C1A80000000"            , vcvtpd2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD5A8C1A80000000"            , vcvtpd2ps(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27913CA"                    , vcvtph2ps(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279138C1A80000000"          , vcvtph2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279138C1A80000000"          , vcvtph2ps(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D13CA"                    , vcvtph2ps(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D138C1A80000000"          , vcvtph2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D138C1A80000000"          , vcvtph2ps(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F95BCA"                      , vcvtps2dq(xmm1, xmm2));
  TEST_INSTRUCTION("C5F95B8C1A80000000"            , vcvtps2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F95B8C1A80000000"            , vcvtps2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD5BCA"                      , vcvtps2dq(ymm1, ymm2));
  TEST_INSTRUCTION("C5FD5B8C1A80000000"            , vcvtps2dq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD5B8C1A80000000"            , vcvtps2dq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F85ACA"                      , vcvtps2pd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F85A8C1A80000000"            , vcvtps2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F85A8C1A80000000"            , vcvtps2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC5ACA"                      , vcvtps2pd(ymm1, xmm2));
  TEST_INSTRUCTION("C5FC5A8C1A80000000"            , vcvtps2pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC5A8C1A80000000"            , vcvtps2pd(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E3791DD101"                  , vcvtps2ph(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E3791D9C118000000001"        , vcvtps2ph(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E3791D9C118000000001"        , vcvtps2ph(qword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E37D1DD101"                  , vcvtps2ph(xmm1, ymm2, 1));
  TEST_INSTRUCTION("C4E37D1D9C118000000001"        , vcvtps2ph(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C4E37D1D9C118000000001"        , vcvtps2ph(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C5FB2DCA"                      , vcvtsd2si(ecx, xmm2));
  TEST_INSTRUCTION("C5FB2D8C1A80000000"            , vcvtsd2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB2D8C1A80000000"            , vcvtsd2si(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FB2DCA"                    , vcvtsd2si(rcx, xmm2));
  TEST_INSTRUCTION("C4E1FB2D8C1A80000000"          , vcvtsd2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FB2D8C1A80000000"          , vcvtsd2si(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EB5ACB"                      , vcvtsd2ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB5A8C2B80000000"            , vcvtsd2ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5A8C2B80000000"            , vcvtsd2ss(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB2ACB"                      , vcvtsi2sd(xmm1, xmm2, ebx));
  TEST_INSTRUCTION("C4E1EB2ACB"                    , vcvtsi2sd(xmm1, xmm2, rbx));
  TEST_INSTRUCTION("C5EB2A8C2B80000000"            , vcvtsi2sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB2A8C2B80000000"            , vcvtsi2sd(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E1EB2A8C2B80000000"          , vcvtsi2sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA2ACB"                      , vcvtsi2ss(xmm1, xmm2, ebx));
  TEST_INSTRUCTION("C4E1EA2ACB"                    , vcvtsi2ss(xmm1, xmm2, rbx));
  TEST_INSTRUCTION("C5EA2A8C2B80000000"            , vcvtsi2ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA2A8C2B80000000"            , vcvtsi2ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E1EA2A8C2B80000000"          , vcvtsi2ss(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5ACB"                      , vcvtss2sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA5A8C2B80000000"            , vcvtss2sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5A8C2B80000000"            , vcvtss2sd(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5FA2DCA"                      , vcvtss2si(ecx, xmm2));
  TEST_INSTRUCTION("C5FA2D8C1A80000000"            , vcvtss2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA2D8C1A80000000"            , vcvtss2si(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FA2DCA"                    , vcvtss2si(rcx, xmm2));
  TEST_INSTRUCTION("C4E1FA2D8C1A80000000"          , vcvtss2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FA2D8C1A80000000"          , vcvtss2si(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9E6CA"                      , vcvttpd2dq(xmm1, xmm2));
  TEST_INSTRUCTION("C5FDE6CA"                      , vcvttpd2dq(xmm1, ymm2));
  TEST_INSTRUCTION("C5F9E68C1A80000000"            , vcvttpd2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FDE68C1A80000000"            , vcvttpd2dq(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA5BCA"                      , vcvttps2dq(xmm1, xmm2));
  TEST_INSTRUCTION("C5FA5B8C1A80000000"            , vcvttps2dq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA5B8C1A80000000"            , vcvttps2dq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE5BCA"                      , vcvttps2dq(ymm1, ymm2));
  TEST_INSTRUCTION("C5FE5B8C1A80000000"            , vcvttps2dq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE5B8C1A80000000"            , vcvttps2dq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB2CCA"                      , vcvttsd2si(ecx, xmm2));
  TEST_INSTRUCTION("C5FB2C8C1A80000000"            , vcvttsd2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB2C8C1A80000000"            , vcvttsd2si(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FB2CCA"                    , vcvttsd2si(rcx, xmm2));
  TEST_INSTRUCTION("C4E1FB2C8C1A80000000"          , vcvttsd2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FB2C8C1A80000000"          , vcvttsd2si(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA2CCA"                      , vcvttss2si(ecx, xmm2));
  TEST_INSTRUCTION("C5FA2C8C1A80000000"            , vcvttss2si(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA2C8C1A80000000"            , vcvttss2si(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FA2CCA"                    , vcvttss2si(rcx, xmm2));
  TEST_INSTRUCTION("C4E1FA2C8C1A80000000"          , vcvttss2si(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FA2C8C1A80000000"          , vcvttss2si(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5E95ECB"                      , vdivpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E95E8C2B80000000"            , vdivpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95E8C2B80000000"            , vdivpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5ECB"                      , vdivpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED5E8C2B80000000"            , vdivpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5E8C2B80000000"            , vdivpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85ECB"                      , vdivps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E85E8C2B80000000"            , vdivps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85E8C2B80000000"            , vdivps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5ECB"                      , vdivps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC5E8C2B80000000"            , vdivps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5E8C2B80000000"            , vdivps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5ECB"                      , vdivsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB5E8C2B80000000"            , vdivsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5E8C2B80000000"            , vdivsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5ECB"                      , vdivss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA5E8C2B80000000"            , vdivss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5E8C2B80000000"            , vdivss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E36941CB01"                  , vdppd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369418C2B8000000001"        , vdppd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369418C2B8000000001"        , vdppd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36940CB01"                  , vdpps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369408C2B8000000001"        , vdpps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369408C2B8000000001"        , vdpps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D40CB01"                  , vdpps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D408C2B8000000001"        , vdpps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D408C2B8000000001"        , vdpps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D19D101"                  , vextractf128(xmm1, ymm2, 1));
  TEST_INSTRUCTION("C4E37D199C118000000001"        , vextractf128(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C4E37D199C118000000001"        , vextractf128(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C4E37D39D101"                  , vextracti128(xmm1, ymm2, 1));
  TEST_INSTRUCTION("C4E37D399C118000000001"        , vextracti128(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C4E37D399C118000000001"        , vextracti128(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("C4E37917D101"                  , vextractps(ecx, xmm2, 1));
  TEST_INSTRUCTION("C4E379179C118000000001"        , vextractps(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E379179C118000000001"        , vextractps(dword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E2D9928C1A80000000"          , vgatherdpd(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E2DD928C1A80000000"          , vgatherdpd(ymm1, ptr(rdx, xmm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E259928C1A80000000"          , vgatherdps(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E25D928C1A80000000"          , vgatherdps(ymm1, ptr(rdx, ymm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E2D9938C1A80000000"          , vgatherqpd(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E2DD938C1A80000000"          , vgatherqpd(ymm1, ptr(rdx, ymm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E259938C1A80000000"          , vgatherqps(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E25D938C1A80000000"          , vgatherqps(xmm1, ptr(rdx, ymm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E3E9CFCB01"                  , vgf2p8affineinvqb(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3E9CF8C2B8000000001"        , vgf2p8affineinvqb(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9CF8C2B8000000001"        , vgf2p8affineinvqb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3EDCFCB01"                  , vgf2p8affineinvqb(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E3EDCF8C2B8000000001"        , vgf2p8affineinvqb(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3EDCF8C2B8000000001"        , vgf2p8affineinvqb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9CECB01"                  , vgf2p8affineqb(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3E9CE8C2B8000000001"        , vgf2p8affineqb(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9CE8C2B8000000001"        , vgf2p8affineqb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3EDCECB01"                  , vgf2p8affineqb(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E3EDCE8C2B8000000001"        , vgf2p8affineqb(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3EDCE8C2B8000000001"        , vgf2p8affineqb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E269CFCB"                    , vgf2p8mulb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269CF8C2B80000000"          , vgf2p8mulb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269CF8C2B80000000"          , vgf2p8mulb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DCFCB"                    , vgf2p8mulb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DCF8C2B80000000"          , vgf2p8mulb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DCF8C2B80000000"          , vgf2p8mulb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E97CCB"                      , vhaddpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E97C8C2B80000000"            , vhaddpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E97C8C2B80000000"            , vhaddpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED7CCB"                      , vhaddpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED7C8C2B80000000"            , vhaddpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED7C8C2B80000000"            , vhaddpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB7CCB"                      , vhaddps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB7C8C2B80000000"            , vhaddps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB7C8C2B80000000"            , vhaddps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EF7CCB"                      , vhaddps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EF7C8C2B80000000"            , vhaddps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EF7C8C2B80000000"            , vhaddps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E97DCB"                      , vhsubpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E97D8C2B80000000"            , vhsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E97D8C2B80000000"            , vhsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED7DCB"                      , vhsubpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED7D8C2B80000000"            , vhsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED7D8C2B80000000"            , vhsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB7DCB"                      , vhsubps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB7D8C2B80000000"            , vhsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB7D8C2B80000000"            , vhsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EF7DCB"                      , vhsubps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EF7D8C2B80000000"            , vhsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EF7D8C2B80000000"            , vhsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E36D18CB01"                  , vinsertf128(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("C4E36D188C2B8000000001"        , vinsertf128(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D188C2B8000000001"        , vinsertf128(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D38CB01"                  , vinserti128(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("C4E36D388C2B8000000001"        , vinserti128(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D388C2B8000000001"        , vinserti128(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36921CB01"                  , vinsertps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369218C2B8000000001"        , vinsertps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369218C2B8000000001"        , vinsertps(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5FBF08C1A80000000"            , vlddqu(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FBF08C1A80000000"            , vlddqu(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FFF08C1A80000000"            , vlddqu(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FFF08C1A80000000"            , vlddqu(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8AE941180000000"            , vldmxcsr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("C5F8AE941180000000"            , vldmxcsr(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("C5F9F7CA"                      , vmaskmovdqu(xmm1, xmm2, ptr(rdi)));
  TEST_INSTRUCTION("C5F9F7CA"                      , vmaskmovdqu(xmm1, xmm2, xmmword_ptr(rdi)));
  TEST_INSTRUCTION("C4E2612FA41180000000"          , vmaskmovpd(ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2612FA41180000000"          , vmaskmovpd(xmmword_ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2652FA41180000000"          , vmaskmovpd(ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2652FA41180000000"          , vmaskmovpd(ymmword_ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2692D8C2B80000000"          , vmaskmovpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2692D8C2B80000000"          , vmaskmovpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2D8C2B80000000"          , vmaskmovpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2D8C2B80000000"          , vmaskmovpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2612EA41180000000"          , vmaskmovps(ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2612EA41180000000"          , vmaskmovps(xmmword_ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2652EA41180000000"          , vmaskmovps(ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2652EA41180000000"          , vmaskmovps(ymmword_ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2692C8C2B80000000"          , vmaskmovps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2692C8C2B80000000"          , vmaskmovps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2C8C2B80000000"          , vmaskmovps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2C8C2B80000000"          , vmaskmovps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95FCB"                      , vmaxpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E95F8C2B80000000"            , vmaxpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95F8C2B80000000"            , vmaxpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5FCB"                      , vmaxpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED5F8C2B80000000"            , vmaxpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5F8C2B80000000"            , vmaxpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85FCB"                      , vmaxps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E85F8C2B80000000"            , vmaxps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85F8C2B80000000"            , vmaxps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5FCB"                      , vmaxps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC5F8C2B80000000"            , vmaxps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5F8C2B80000000"            , vmaxps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5FCB"                      , vmaxsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB5F8C2B80000000"            , vmaxsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5F8C2B80000000"            , vmaxsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5FCB"                      , vmaxss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA5F8C2B80000000"            , vmaxss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5F8C2B80000000"            , vmaxss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95DCB"                      , vminpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E95D8C2B80000000"            , vminpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95D8C2B80000000"            , vminpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5DCB"                      , vminpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED5D8C2B80000000"            , vminpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5D8C2B80000000"            , vminpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85DCB"                      , vminps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E85D8C2B80000000"            , vminps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85D8C2B80000000"            , vminps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5DCB"                      , vminps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC5D8C2B80000000"            , vminps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5D8C2B80000000"            , vminps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5DCB"                      , vminsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB5D8C2B80000000"            , vminsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5D8C2B80000000"            , vminsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5DCB"                      , vminss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA5D8C2B80000000"            , vminss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5D8C2B80000000"            , vminss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F928CA"                      , vmovapd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F9288C1A80000000"            , vmovapd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9288C1A80000000"            , vmovapd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9299C1180000000"            , vmovapd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9299C1180000000"            , vmovapd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FD28CA"                      , vmovapd(ymm1, ymm2));
  TEST_INSTRUCTION("C5FD288C1A80000000"            , vmovapd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD288C1A80000000"            , vmovapd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD299C1180000000"            , vmovapd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FD299C1180000000"            , vmovapd(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5F828CA"                      , vmovaps(xmm1, xmm2));
  TEST_INSTRUCTION("C5F8288C1A80000000"            , vmovaps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8288C1A80000000"            , vmovaps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8299C1180000000"            , vmovaps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F8299C1180000000"            , vmovaps(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FC28CA"                      , vmovaps(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC288C1A80000000"            , vmovaps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC288C1A80000000"            , vmovaps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC299C1180000000"            , vmovaps(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FC299C1180000000"            , vmovaps(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5F97ED1"                      , vmovd(ecx, xmm2));
  TEST_INSTRUCTION("C5F97E9C1180000000"            , vmovd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F97E9C1180000000"            , vmovd(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F96ECA"                      , vmovd(xmm1, edx));
  TEST_INSTRUCTION("C5F96E8C1A80000000"            , vmovd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F96E8C1A80000000"            , vmovd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB12CA"                      , vmovddup(xmm1, xmm2));
  TEST_INSTRUCTION("C5FB128C1A80000000"            , vmovddup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB128C1A80000000"            , vmovddup(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FF12CA"                      , vmovddup(ymm1, ymm2));
  TEST_INSTRUCTION("C5FF128C1A80000000"            , vmovddup(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FF128C1A80000000"            , vmovddup(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F96FCA"                      , vmovdqa(xmm1, xmm2));
  TEST_INSTRUCTION("C5F96F8C1A80000000"            , vmovdqa(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F96F8C1A80000000"            , vmovdqa(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F97F9C1180000000"            , vmovdqa(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F97F9C1180000000"            , vmovdqa(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FD6FCA"                      , vmovdqa(ymm1, ymm2));
  TEST_INSTRUCTION("C5FD6F8C1A80000000"            , vmovdqa(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD6F8C1A80000000"            , vmovdqa(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD7F9C1180000000"            , vmovdqa(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FD7F9C1180000000"            , vmovdqa(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FA6FCA"                      , vmovdqu(xmm1, xmm2));
  TEST_INSTRUCTION("C5FA6F8C1A80000000"            , vmovdqu(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA6F8C1A80000000"            , vmovdqu(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA7F9C1180000000"            , vmovdqu(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FA7F9C1180000000"            , vmovdqu(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FE6FCA"                      , vmovdqu(ymm1, ymm2));
  TEST_INSTRUCTION("C5FE6F8C1A80000000"            , vmovdqu(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE6F8C1A80000000"            , vmovdqu(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE7F9C1180000000"            , vmovdqu(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FE7F9C1180000000"            , vmovdqu(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5E812CB"                      , vmovhlps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F9179C1180000000"            , vmovhpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9179C1180000000"            , vmovhpd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5E9168C2B80000000"            , vmovhpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9168C2B80000000"            , vmovhpd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F8179C1180000000"            , vmovhps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F8179C1180000000"            , vmovhps(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5E8168C2B80000000"            , vmovhps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8168C2B80000000"            , vmovhps(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E816CB"                      , vmovlhps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F9139C1180000000"            , vmovlpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9139C1180000000"            , vmovlpd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5E9128C2B80000000"            , vmovlpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9128C2B80000000"            , vmovlpd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F8139C1180000000"            , vmovlps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F8139C1180000000"            , vmovlps(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5E8128C2B80000000"            , vmovlps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8128C2B80000000"            , vmovlps(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F950CA"                      , vmovmskpd(ecx, xmm2));
  TEST_INSTRUCTION("C5FD50CA"                      , vmovmskpd(ecx, ymm2));
  TEST_INSTRUCTION("C5F850CA"                      , vmovmskps(ecx, xmm2));
  TEST_INSTRUCTION("C5FC50CA"                      , vmovmskps(ecx, ymm2));
  TEST_INSTRUCTION("C5F9E79C1180000000"            , vmovntdq(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9E79C1180000000"            , vmovntdq(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FDE79C1180000000"            , vmovntdq(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FDE79C1180000000"            , vmovntdq(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C4E2792A8C1A80000000"          , vmovntdqa(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2792A8C1A80000000"          , vmovntdqa(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D2A8C1A80000000"          , vmovntdqa(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D2A8C1A80000000"          , vmovntdqa(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F92B9C1180000000"            , vmovntpd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F92B9C1180000000"            , vmovntpd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FD2B9C1180000000"            , vmovntpd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FD2B9C1180000000"            , vmovntpd(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C4E1F97ED1"                    , vmovq(rcx, xmm2));
  TEST_INSTRUCTION("C5F9D69C1180000000"            , vmovq(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9D69C1180000000"            , vmovq(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C4E1F96ECA"                    , vmovq(xmm1, rdx));
  TEST_INSTRUCTION("C5FA7ECA"                      , vmovq(xmm1, xmm2));
  TEST_INSTRUCTION("C5FA7E8C1A80000000"            , vmovq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA7E8C1A80000000"            , vmovq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB119C1180000000"            , vmovsd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FB119C1180000000"            , vmovsd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FB108C1A80000000"            , vmovsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB108C1A80000000"            , vmovsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EB10CB"                      , vmovsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5FA16CA"                      , vmovshdup(xmm1, xmm2));
  TEST_INSTRUCTION("C5FA168C1A80000000"            , vmovshdup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA168C1A80000000"            , vmovshdup(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE16CA"                      , vmovshdup(ymm1, ymm2));
  TEST_INSTRUCTION("C5FE168C1A80000000"            , vmovshdup(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE168C1A80000000"            , vmovshdup(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA12CA"                      , vmovsldup(xmm1, xmm2));
  TEST_INSTRUCTION("C5FA128C1A80000000"            , vmovsldup(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA128C1A80000000"            , vmovsldup(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE12CA"                      , vmovsldup(ymm1, ymm2));
  TEST_INSTRUCTION("C5FE128C1A80000000"            , vmovsldup(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FE128C1A80000000"            , vmovsldup(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA119C1180000000"            , vmovss(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FA119C1180000000"            , vmovss(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FA108C1A80000000"            , vmovss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FA108C1A80000000"            , vmovss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EA10CB"                      , vmovss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F910CA"                      , vmovupd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F9108C1A80000000"            , vmovupd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9108C1A80000000"            , vmovupd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9119C1180000000"            , vmovupd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F9119C1180000000"            , vmovupd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FD10CA"                      , vmovupd(ymm1, ymm2));
  TEST_INSTRUCTION("C5FD108C1A80000000"            , vmovupd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD108C1A80000000"            , vmovupd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD119C1180000000"            , vmovupd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FD119C1180000000"            , vmovupd(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5F810CA"                      , vmovups(xmm1, xmm2));
  TEST_INSTRUCTION("C5F8108C1A80000000"            , vmovups(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8108C1A80000000"            , vmovups(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8119C1180000000"            , vmovups(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F8119C1180000000"            , vmovups(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FC10CA"                      , vmovups(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC108C1A80000000"            , vmovups(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC108C1A80000000"            , vmovups(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC119C1180000000"            , vmovups(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FC119C1180000000"            , vmovups(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C4E36942CB01"                  , vmpsadbw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369428C2B8000000001"        , vmpsadbw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369428C2B8000000001"        , vmpsadbw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D42CB01"                  , vmpsadbw(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D428C2B8000000001"        , vmpsadbw(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D428C2B8000000001"        , vmpsadbw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E959CB"                      , vmulpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9598C2B80000000"            , vmulpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9598C2B80000000"            , vmulpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED59CB"                      , vmulpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED598C2B80000000"            , vmulpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED598C2B80000000"            , vmulpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E859CB"                      , vmulps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8598C2B80000000"            , vmulps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8598C2B80000000"            , vmulps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC59CB"                      , vmulps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC598C2B80000000"            , vmulps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC598C2B80000000"            , vmulps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB59CB"                      , vmulsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB598C2B80000000"            , vmulsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB598C2B80000000"            , vmulsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA59CB"                      , vmulss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA598C2B80000000"            , vmulss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA598C2B80000000"            , vmulss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E956CB"                      , vorpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9568C2B80000000"            , vorpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9568C2B80000000"            , vorpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED56CB"                      , vorpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED568C2B80000000"            , vorpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED568C2B80000000"            , vorpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E856CB"                      , vorps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8568C2B80000000"            , vorps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8568C2B80000000"            , vorps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC56CB"                      , vorps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC568C2B80000000"            , vorps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC568C2B80000000"            , vorps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2791CCA"                    , vpabsb(xmm1, xmm2));
  TEST_INSTRUCTION("C4E2791C8C1A80000000"          , vpabsb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2791C8C1A80000000"          , vpabsb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1CCA"                    , vpabsb(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D1C8C1A80000000"          , vpabsb(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1C8C1A80000000"          , vpabsb(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2791ECA"                    , vpabsd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E2791E8C1A80000000"          , vpabsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2791E8C1A80000000"          , vpabsd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1ECA"                    , vpabsd(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D1E8C1A80000000"          , vpabsd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1E8C1A80000000"          , vpabsd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2791DCA"                    , vpabsw(xmm1, xmm2));
  TEST_INSTRUCTION("C4E2791D8C1A80000000"          , vpabsw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2791D8C1A80000000"          , vpabsw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1DCA"                    , vpabsw(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D1D8C1A80000000"          , vpabsw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D1D8C1A80000000"          , vpabsw(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5E96BCB"                      , vpackssdw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E96B8C2B80000000"            , vpackssdw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96B8C2B80000000"            , vpackssdw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6BCB"                      , vpackssdw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED6B8C2B80000000"            , vpackssdw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6B8C2B80000000"            , vpackssdw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E963CB"                      , vpacksswb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9638C2B80000000"            , vpacksswb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9638C2B80000000"            , vpacksswb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED63CB"                      , vpacksswb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED638C2B80000000"            , vpacksswb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED638C2B80000000"            , vpacksswb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2692BCB"                    , vpackusdw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2692B8C2B80000000"          , vpackusdw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2692B8C2B80000000"          , vpackusdw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2BCB"                    , vpackusdw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D2B8C2B80000000"          , vpackusdw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D2B8C2B80000000"          , vpackusdw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E967CB"                      , vpackuswb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9678C2B80000000"            , vpackuswb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9678C2B80000000"            , vpackuswb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED67CB"                      , vpackuswb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED678C2B80000000"            , vpackuswb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED678C2B80000000"            , vpackuswb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FCCB"                      , vpaddb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9FC8C2B80000000"            , vpaddb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FC8C2B80000000"            , vpaddb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFCCB"                      , vpaddb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDFC8C2B80000000"            , vpaddb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFC8C2B80000000"            , vpaddb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FECB"                      , vpaddd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9FE8C2B80000000"            , vpaddd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FE8C2B80000000"            , vpaddd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFECB"                      , vpaddd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDFE8C2B80000000"            , vpaddd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFE8C2B80000000"            , vpaddd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D4CB"                      , vpaddq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9D48C2B80000000"            , vpaddq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D48C2B80000000"            , vpaddq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD4CB"                      , vpaddq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDD48C2B80000000"            , vpaddq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD48C2B80000000"            , vpaddq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9ECCB"                      , vpaddsb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9EC8C2B80000000"            , vpaddsb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EC8C2B80000000"            , vpaddsb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDECCB"                      , vpaddsb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDEC8C2B80000000"            , vpaddsb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEC8C2B80000000"            , vpaddsb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EDCB"                      , vpaddsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9ED8C2B80000000"            , vpaddsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9ED8C2B80000000"            , vpaddsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEDCB"                      , vpaddsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDED8C2B80000000"            , vpaddsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDED8C2B80000000"            , vpaddsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DCCB"                      , vpaddusb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DC8C2B80000000"            , vpaddusb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DC8C2B80000000"            , vpaddusb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDCCB"                      , vpaddusb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDC8C2B80000000"            , vpaddusb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDC8C2B80000000"            , vpaddusb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DDCB"                      , vpaddusw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DD8C2B80000000"            , vpaddusw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DD8C2B80000000"            , vpaddusw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDDCB"                      , vpaddusw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDD8C2B80000000"            , vpaddusw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDD8C2B80000000"            , vpaddusw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FDCB"                      , vpaddw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9FD8C2B80000000"            , vpaddw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FD8C2B80000000"            , vpaddw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFDCB"                      , vpaddw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDFD8C2B80000000"            , vpaddw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFD8C2B80000000"            , vpaddw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E3690FCB01"                  , vpalignr(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690F8C2B8000000001"        , vpalignr(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690F8C2B8000000001"        , vpalignr(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0FCB01"                  , vpalignr(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D0F8C2B8000000001"        , vpalignr(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0F8C2B8000000001"        , vpalignr(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E9DBCB"                      , vpand(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DB8C2B80000000"            , vpand(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DB8C2B80000000"            , vpand(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDBCB"                      , vpand(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDB8C2B80000000"            , vpand(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDB8C2B80000000"            , vpand(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DFCB"                      , vpandn(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DF8C2B80000000"            , vpandn(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DF8C2B80000000"            , vpandn(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDFCB"                      , vpandn(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDF8C2B80000000"            , vpandn(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDF8C2B80000000"            , vpandn(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E0CB"                      , vpavgb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E08C2B80000000"            , vpavgb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E08C2B80000000"            , vpavgb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE0CB"                      , vpavgb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE08C2B80000000"            , vpavgb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE08C2B80000000"            , vpavgb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E3CB"                      , vpavgw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E38C2B80000000"            , vpavgw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E38C2B80000000"            , vpavgw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE3CB"                      , vpavgw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE38C2B80000000"            , vpavgw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE38C2B80000000"            , vpavgw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E36902CB01"                  , vpblendd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369028C2B8000000001"        , vpblendd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369028C2B8000000001"        , vpblendd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D02CB01"                  , vpblendd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D028C2B8000000001"        , vpblendd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D028C2B8000000001"        , vpblendd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3694CCB40"                  , vpblendvb(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3694C8C2B8000000060"        , vpblendvb(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3694C8C2B8000000060"        , vpblendvb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E36D4CCB40"                  , vpblendvb(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E36D4C8C2B8000000060"        , vpblendvb(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D4C8C2B8000000060"        , vpblendvb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3690ECB01"                  , vpblendw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690E8C2B8000000001"        , vpblendw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690E8C2B8000000001"        , vpblendw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0ECB01"                  , vpblendw(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D0E8C2B8000000001"        , vpblendw(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D0E8C2B8000000001"        , vpblendw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E27978CA"                    , vpbroadcastb(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279788C1A80000000"          , vpbroadcastb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279788C1A80000000"          , vpbroadcastb(xmm1, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D78CA"                    , vpbroadcastb(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D788C1A80000000"          , vpbroadcastb(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D788C1A80000000"          , vpbroadcastb(ymm1, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27958CA"                    , vpbroadcastd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279588C1A80000000"          , vpbroadcastd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279588C1A80000000"          , vpbroadcastd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D58CA"                    , vpbroadcastd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D588C1A80000000"          , vpbroadcastd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D588C1A80000000"          , vpbroadcastd(ymm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27959CA"                    , vpbroadcastq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279598C1A80000000"          , vpbroadcastq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279598C1A80000000"          , vpbroadcastq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D59CA"                    , vpbroadcastq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D598C1A80000000"          , vpbroadcastq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D598C1A80000000"          , vpbroadcastq(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27979CA"                    , vpbroadcastw(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279798C1A80000000"          , vpbroadcastw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279798C1A80000000"          , vpbroadcastw(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D79CA"                    , vpbroadcastw(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D798C1A80000000"          , vpbroadcastw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D798C1A80000000"          , vpbroadcastw(ymm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E36944CB01"                  , vpclmulqdq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369448C2B8000000001"        , vpclmulqdq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369448C2B8000000001"        , vpclmulqdq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D44CB01"                  , vpclmulqdq(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D448C2B8000000001"        , vpclmulqdq(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D448C2B8000000001"        , vpclmulqdq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E974CB"                      , vpcmpeqb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9748C2B80000000"            , vpcmpeqb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9748C2B80000000"            , vpcmpeqb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED74CB"                      , vpcmpeqb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED748C2B80000000"            , vpcmpeqb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED748C2B80000000"            , vpcmpeqb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E976CB"                      , vpcmpeqd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9768C2B80000000"            , vpcmpeqd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9768C2B80000000"            , vpcmpeqd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED76CB"                      , vpcmpeqd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED768C2B80000000"            , vpcmpeqd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED768C2B80000000"            , vpcmpeqd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26929CB"                    , vpcmpeqq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269298C2B80000000"          , vpcmpeqq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269298C2B80000000"          , vpcmpeqq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D29CB"                    , vpcmpeqq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D298C2B80000000"          , vpcmpeqq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D298C2B80000000"          , vpcmpeqq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E975CB"                      , vpcmpeqw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9758C2B80000000"            , vpcmpeqw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9758C2B80000000"            , vpcmpeqw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED75CB"                      , vpcmpeqw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED758C2B80000000"            , vpcmpeqw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED758C2B80000000"            , vpcmpeqw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E37961CA01"                  , vpcmpestri(xmm1, xmm2, 1, ecx, eax, edx));
  TEST_INSTRUCTION("C4E379618C1A8000000001"        , vpcmpestri(xmm1, ptr(rdx, rbx, 0, 128), 1, ecx, eax, edx));
  TEST_INSTRUCTION("C4E379618C1A8000000001"        , vpcmpestri(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, ecx, eax, edx));
  TEST_INSTRUCTION("C4E37960CA01"                  , vpcmpestrm(xmm1, xmm2, 1, xmm0, eax, edx));
  TEST_INSTRUCTION("C4E379608C1A8000000001"        , vpcmpestrm(xmm1, ptr(rdx, rbx, 0, 128), 1, xmm0, eax, edx));
  TEST_INSTRUCTION("C4E379608C1A8000000001"        , vpcmpestrm(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, xmm0, eax, edx));
  TEST_INSTRUCTION("C5E964CB"                      , vpcmpgtb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9648C2B80000000"            , vpcmpgtb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9648C2B80000000"            , vpcmpgtb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED64CB"                      , vpcmpgtb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED648C2B80000000"            , vpcmpgtb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED648C2B80000000"            , vpcmpgtb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E966CB"                      , vpcmpgtd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9668C2B80000000"            , vpcmpgtd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9668C2B80000000"            , vpcmpgtd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED66CB"                      , vpcmpgtd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED668C2B80000000"            , vpcmpgtd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED668C2B80000000"            , vpcmpgtd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26937CB"                    , vpcmpgtq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269378C2B80000000"          , vpcmpgtq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269378C2B80000000"          , vpcmpgtq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D37CB"                    , vpcmpgtq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D378C2B80000000"          , vpcmpgtq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D378C2B80000000"          , vpcmpgtq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E965CB"                      , vpcmpgtw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9658C2B80000000"            , vpcmpgtw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9658C2B80000000"            , vpcmpgtw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED65CB"                      , vpcmpgtw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED658C2B80000000"            , vpcmpgtw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED658C2B80000000"            , vpcmpgtw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E37963CA01"                  , vpcmpistri(xmm1, xmm2, 1, ecx));
  TEST_INSTRUCTION("C4E379638C1A8000000001"        , vpcmpistri(xmm1, ptr(rdx, rbx, 0, 128), 1, ecx));
  TEST_INSTRUCTION("C4E379638C1A8000000001"        , vpcmpistri(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, ecx));
  TEST_INSTRUCTION("C4E37962CA01"                  , vpcmpistrm(xmm1, xmm2, 1, xmm0));
  TEST_INSTRUCTION("C4E379628C1A8000000001"        , vpcmpistrm(xmm1, ptr(rdx, rbx, 0, 128), 1, xmm0));
  TEST_INSTRUCTION("C4E379628C1A8000000001"        , vpcmpistrm(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1, xmm0));
  TEST_INSTRUCTION("C4E36D06CB01"                  , vperm2f128(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D068C2B8000000001"        , vperm2f128(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D068C2B8000000001"        , vperm2f128(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D46CB01"                  , vperm2i128(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C4E36D468C2B8000000001"        , vperm2i128(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D468C2B8000000001"        , vperm2i128(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E26D36CB"                    , vpermd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D368C2B80000000"          , vpermd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D368C2B80000000"          , vpermd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E36949CB41"                  , vpermil2pd(xmm1, xmm2, xmm3, xmm4, 1));
  TEST_INSTRUCTION("C4E369498C2B8000000061"        , vpermil2pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6, 1));
  TEST_INSTRUCTION("C4E369498C2B8000000061"        , vpermil2pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6, 1));
  TEST_INSTRUCTION("C4E3E9498C358000000031"        , vpermil2pd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9498C358000000031"        , vpermil2pd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D49CB41"                  , vpermil2pd(ymm1, ymm2, ymm3, ymm4, 1));
  TEST_INSTRUCTION("C4E36D498C2B8000000061"        , vpermil2pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6, 1));
  TEST_INSTRUCTION("C4E36D498C2B8000000061"        , vpermil2pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6, 1));
  TEST_INSTRUCTION("C4E3ED498C358000000031"        , vpermil2pd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E3ED498C358000000031"        , vpermil2pd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E36948CB41"                  , vpermil2ps(xmm1, xmm2, xmm3, xmm4, 1));
  TEST_INSTRUCTION("C4E369488C2B8000000061"        , vpermil2ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6, 1));
  TEST_INSTRUCTION("C4E369488C2B8000000061"        , vpermil2ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6, 1));
  TEST_INSTRUCTION("C4E3E9488C358000000031"        , vpermil2ps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9488C358000000031"        , vpermil2ps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E36D48CB41"                  , vpermil2ps(ymm1, ymm2, ymm3, ymm4, 1));
  TEST_INSTRUCTION("C4E36D488C2B8000000061"        , vpermil2ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6, 1));
  TEST_INSTRUCTION("C4E36D488C2B8000000061"        , vpermil2ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6, 1));
  TEST_INSTRUCTION("C4E3ED488C358000000031"        , vpermil2ps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E3ED488C358000000031"        , vpermil2ps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128), 1));
  TEST_INSTRUCTION("C4E2690DCB"                    , vpermilpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E37905CA01"                  , vpermilpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E2690D8C2B80000000"          , vpermilpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690D8C2B80000000"          , vpermilpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E379058C1A8000000001"        , vpermilpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E379058C1A8000000001"        , vpermilpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E26D0DCB"                    , vpermilpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E37D05CA01"                  , vpermilpd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E26D0D8C2B80000000"          , vpermilpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0D8C2B80000000"          , vpermilpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E37D058C1A8000000001"        , vpermilpd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D058C1A8000000001"        , vpermilpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E2690CCB"                    , vpermilps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E37904CA01"                  , vpermilps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E2690C8C2B80000000"          , vpermilps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690C8C2B80000000"          , vpermilps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E379048C1A8000000001"        , vpermilps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E379048C1A8000000001"        , vpermilps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E26D0CCB"                    , vpermilps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E37D04CA01"                  , vpermilps(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E26D0C8C2B80000000"          , vpermilps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0C8C2B80000000"          , vpermilps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E37D048C1A8000000001"        , vpermilps(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D048C1A8000000001"        , vpermilps(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3FD01CA01"                  , vpermpd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E3FD018C1A8000000001"        , vpermpd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3FD018C1A8000000001"        , vpermpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E26D16CB"                    , vpermps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D168C2B80000000"          , vpermps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D168C2B80000000"          , vpermps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E3FD00CA01"                  , vpermq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E3FD008C1A8000000001"        , vpermq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3FD008C1A8000000001"        , vpermq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37914D101"                  , vpextrb(ecx, xmm2, 1));
  TEST_INSTRUCTION("C4E379149C118000000001"        , vpextrb(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E379149C118000000001"        , vpextrb(byte_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E37916D101"                  , vpextrd(ecx, xmm2, 1));
  TEST_INSTRUCTION("C4E379169C118000000001"        , vpextrd(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E379169C118000000001"        , vpextrd(dword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E3F916D101"                  , vpextrq(rcx, xmm2, 1));
  TEST_INSTRUCTION("C4E3F9169C118000000001"        , vpextrq(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E3F9169C118000000001"        , vpextrq(qword_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C5F9C5CA01"                    , vpextrw(ecx, xmm2, 1));
  TEST_INSTRUCTION("C4E379159C118000000001"        , vpextrw(ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E379159C118000000001"        , vpextrw(word_ptr(rcx, rdx, 0, 128), xmm3, 1));
  TEST_INSTRUCTION("C4E259908C1A80000000"          , vpgatherdd(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E25D908C1A80000000"          , vpgatherdd(ymm1, ptr(rdx, ymm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E2D9908C1A80000000"          , vpgatherdq(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E2DD908C1A80000000"          , vpgatherdq(ymm1, ptr(rdx, xmm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E259918C1A80000000"          , vpgatherqd(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E25D918C1A80000000"          , vpgatherqd(xmm1, ptr(rdx, ymm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E2D9918C1A80000000"          , vpgatherqq(xmm1, ptr(rdx, xmm3, 0, 128), xmm4));
  TEST_INSTRUCTION("C4E2DD918C1A80000000"          , vpgatherqq(ymm1, ptr(rdx, ymm3, 0, 128), ymm4));
  TEST_INSTRUCTION("C4E26902CB"                    , vphaddd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269028C2B80000000"          , vphaddd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269028C2B80000000"          , vphaddd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D02CB"                    , vphaddd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D028C2B80000000"          , vphaddd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D028C2B80000000"          , vphaddd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26903CB"                    , vphaddsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269038C2B80000000"          , vphaddsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269038C2B80000000"          , vphaddsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D03CB"                    , vphaddsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D038C2B80000000"          , vphaddsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D038C2B80000000"          , vphaddsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26901CB"                    , vphaddw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269018C2B80000000"          , vphaddw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269018C2B80000000"          , vphaddw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D01CB"                    , vphaddw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D018C2B80000000"          , vphaddw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D018C2B80000000"          , vphaddw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E27941CA"                    , vphminposuw(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279418C1A80000000"          , vphminposuw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279418C1A80000000"          , vphminposuw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E26906CB"                    , vphsubd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269068C2B80000000"          , vphsubd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269068C2B80000000"          , vphsubd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D06CB"                    , vphsubd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D068C2B80000000"          , vphsubd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D068C2B80000000"          , vphsubd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26907CB"                    , vphsubsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269078C2B80000000"          , vphsubsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269078C2B80000000"          , vphsubsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D07CB"                    , vphsubsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D078C2B80000000"          , vphsubsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D078C2B80000000"          , vphsubsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26905CB"                    , vphsubw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269058C2B80000000"          , vphsubw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269058C2B80000000"          , vphsubw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D05CB"                    , vphsubw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D058C2B80000000"          , vphsubw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D058C2B80000000"          , vphsubw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E36920CB01"                  , vpinsrb(xmm1, xmm2, ebx, 1));
  TEST_INSTRUCTION("C4E369208C2B8000000001"        , vpinsrb(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369208C2B8000000001"        , vpinsrb(xmm1, xmm2, byte_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E36922CB01"                  , vpinsrd(xmm1, xmm2, ebx, 1));
  TEST_INSTRUCTION("C4E369228C2B8000000001"        , vpinsrd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369228C2B8000000001"        , vpinsrd(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E922CB01"                  , vpinsrq(xmm1, xmm2, rbx, 1));
  TEST_INSTRUCTION("C4E3E9228C2B8000000001"        , vpinsrq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3E9228C2B8000000001"        , vpinsrq(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E9C4CB01"                    , vpinsrw(xmm1, xmm2, ebx, 1));
  TEST_INSTRUCTION("C5E9C48C2B8000000001"          , vpinsrw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E9C48C2B8000000001"          , vpinsrw(xmm1, xmm2, word_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E26904CB"                    , vpmaddubsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269048C2B80000000"          , vpmaddubsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269048C2B80000000"          , vpmaddubsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D04CB"                    , vpmaddubsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D048C2B80000000"          , vpmaddubsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D048C2B80000000"          , vpmaddubsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F5CB"                      , vpmaddwd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9F58C2B80000000"            , vpmaddwd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F58C2B80000000"            , vpmaddwd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF5CB"                      , vpmaddwd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDF58C2B80000000"            , vpmaddwd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF58C2B80000000"            , vpmaddwd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2618EA41180000000"          , vpmaskmovd(ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2618EA41180000000"          , vpmaskmovd(xmmword_ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2658EA41180000000"          , vpmaskmovd(ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2658EA41180000000"          , vpmaskmovd(ymmword_ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2698C8C2B80000000"          , vpmaskmovd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2698C8C2B80000000"          , vpmaskmovd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D8C8C2B80000000"          , vpmaskmovd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D8C8C2B80000000"          , vpmaskmovd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E18EA41180000000"          , vpmaskmovq(ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2E18EA41180000000"          , vpmaskmovq(xmmword_ptr(rcx, rdx, 0, 128), xmm3, xmm4));
  TEST_INSTRUCTION("C4E2E58EA41180000000"          , vpmaskmovq(ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2E58EA41180000000"          , vpmaskmovq(ymmword_ptr(rcx, rdx, 0, 128), ymm3, ymm4));
  TEST_INSTRUCTION("C4E2E98C8C2B80000000"          , vpmaskmovq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E98C8C2B80000000"          , vpmaskmovq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED8C8C2B80000000"          , vpmaskmovq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED8C8C2B80000000"          , vpmaskmovq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693CCB"                    , vpmaxsb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693C8C2B80000000"          , vpmaxsb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693C8C2B80000000"          , vpmaxsb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3CCB"                    , vpmaxsb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3C8C2B80000000"          , vpmaxsb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3C8C2B80000000"          , vpmaxsb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693DCB"                    , vpmaxsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693D8C2B80000000"          , vpmaxsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693D8C2B80000000"          , vpmaxsd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3DCB"                    , vpmaxsd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3D8C2B80000000"          , vpmaxsd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3D8C2B80000000"          , vpmaxsd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EECB"                      , vpmaxsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9EE8C2B80000000"            , vpmaxsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EE8C2B80000000"            , vpmaxsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEECB"                      , vpmaxsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDEE8C2B80000000"            , vpmaxsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEE8C2B80000000"            , vpmaxsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DECB"                      , vpmaxub(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DE8C2B80000000"            , vpmaxub(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DE8C2B80000000"            , vpmaxub(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDECB"                      , vpmaxub(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDE8C2B80000000"            , vpmaxub(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDE8C2B80000000"            , vpmaxub(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693FCB"                    , vpmaxud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693F8C2B80000000"          , vpmaxud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693F8C2B80000000"          , vpmaxud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3FCB"                    , vpmaxud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3F8C2B80000000"          , vpmaxud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3F8C2B80000000"          , vpmaxud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693ECB"                    , vpmaxuw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693E8C2B80000000"          , vpmaxuw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693E8C2B80000000"          , vpmaxuw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3ECB"                    , vpmaxuw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3E8C2B80000000"          , vpmaxuw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3E8C2B80000000"          , vpmaxuw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26938CB"                    , vpminsb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269388C2B80000000"          , vpminsb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269388C2B80000000"          , vpminsb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D38CB"                    , vpminsb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D388C2B80000000"          , vpminsb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D388C2B80000000"          , vpminsb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26939CB"                    , vpminsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269398C2B80000000"          , vpminsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269398C2B80000000"          , vpminsd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D39CB"                    , vpminsd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D398C2B80000000"          , vpminsd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D398C2B80000000"          , vpminsd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EACB"                      , vpminsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9EA8C2B80000000"            , vpminsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EA8C2B80000000"            , vpminsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEACB"                      , vpminsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDEA8C2B80000000"            , vpminsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEA8C2B80000000"            , vpminsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DACB"                      , vpminub(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9DA8C2B80000000"            , vpminub(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9DA8C2B80000000"            , vpminub(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDACB"                      , vpminub(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDDA8C2B80000000"            , vpminub(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDDA8C2B80000000"            , vpminub(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693BCB"                    , vpminud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693B8C2B80000000"          , vpminud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693B8C2B80000000"          , vpminud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3BCB"                    , vpminud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3B8C2B80000000"          , vpminud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3B8C2B80000000"          , vpminud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693ACB"                    , vpminuw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2693A8C2B80000000"          , vpminuw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2693A8C2B80000000"          , vpminuw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3ACB"                    , vpminuw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D3A8C2B80000000"          , vpminuw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D3A8C2B80000000"          , vpminuw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F9D7CA"                      , vpmovmskb(ecx, xmm2));
  TEST_INSTRUCTION("C5FDD7CA"                      , vpmovmskb(ecx, ymm2));
  TEST_INSTRUCTION("C4E27921CA"                    , vpmovsxbd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279218C1A80000000"          , vpmovsxbd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279218C1A80000000"          , vpmovsxbd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D21CA"                    , vpmovsxbd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D218C1A80000000"          , vpmovsxbd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D218C1A80000000"          , vpmovsxbd(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27922CA"                    , vpmovsxbq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279228C1A80000000"          , vpmovsxbq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279228C1A80000000"          , vpmovsxbq(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D22CA"                    , vpmovsxbq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D228C1A80000000"          , vpmovsxbq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D228C1A80000000"          , vpmovsxbq(ymm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27920CA"                    , vpmovsxbw(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279208C1A80000000"          , vpmovsxbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279208C1A80000000"          , vpmovsxbw(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D20CA"                    , vpmovsxbw(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D208C1A80000000"          , vpmovsxbw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D208C1A80000000"          , vpmovsxbw(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27925CA"                    , vpmovsxdq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279258C1A80000000"          , vpmovsxdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279258C1A80000000"          , vpmovsxdq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D25CA"                    , vpmovsxdq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D258C1A80000000"          , vpmovsxdq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D258C1A80000000"          , vpmovsxdq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27923CA"                    , vpmovsxwd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279238C1A80000000"          , vpmovsxwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279238C1A80000000"          , vpmovsxwd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D23CA"                    , vpmovsxwd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D238C1A80000000"          , vpmovsxwd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D238C1A80000000"          , vpmovsxwd(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27924CA"                    , vpmovsxwq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279248C1A80000000"          , vpmovsxwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279248C1A80000000"          , vpmovsxwq(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D24CA"                    , vpmovsxwq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D248C1A80000000"          , vpmovsxwq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D248C1A80000000"          , vpmovsxwq(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27931CA"                    , vpmovzxbd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279318C1A80000000"          , vpmovzxbd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279318C1A80000000"          , vpmovzxbd(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D31CA"                    , vpmovzxbd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D318C1A80000000"          , vpmovzxbd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D318C1A80000000"          , vpmovzxbd(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27932CA"                    , vpmovzxbq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279328C1A80000000"          , vpmovzxbq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279328C1A80000000"          , vpmovzxbq(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D32CA"                    , vpmovzxbq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D328C1A80000000"          , vpmovzxbq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D328C1A80000000"          , vpmovzxbq(ymm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27930CA"                    , vpmovzxbw(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279308C1A80000000"          , vpmovzxbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279308C1A80000000"          , vpmovzxbw(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D30CA"                    , vpmovzxbw(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D308C1A80000000"          , vpmovzxbw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D308C1A80000000"          , vpmovzxbw(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27935CA"                    , vpmovzxdq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279358C1A80000000"          , vpmovzxdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279358C1A80000000"          , vpmovzxdq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D35CA"                    , vpmovzxdq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D358C1A80000000"          , vpmovzxdq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D358C1A80000000"          , vpmovzxdq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27933CA"                    , vpmovzxwd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279338C1A80000000"          , vpmovzxwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279338C1A80000000"          , vpmovzxwd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D33CA"                    , vpmovzxwd(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D338C1A80000000"          , vpmovzxwd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D338C1A80000000"          , vpmovzxwd(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27934CA"                    , vpmovzxwq(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279348C1A80000000"          , vpmovzxwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279348C1A80000000"          , vpmovzxwq(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D34CA"                    , vpmovzxwq(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27D348C1A80000000"          , vpmovzxwq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D348C1A80000000"          , vpmovzxwq(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E26928CB"                    , vpmuldq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269288C2B80000000"          , vpmuldq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269288C2B80000000"          , vpmuldq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D28CB"                    , vpmuldq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D288C2B80000000"          , vpmuldq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D288C2B80000000"          , vpmuldq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690BCB"                    , vpmulhrsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2690B8C2B80000000"          , vpmulhrsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690B8C2B80000000"          , vpmulhrsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0BCB"                    , vpmulhrsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D0B8C2B80000000"          , vpmulhrsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0B8C2B80000000"          , vpmulhrsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E4CB"                      , vpmulhuw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E48C2B80000000"            , vpmulhuw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E48C2B80000000"            , vpmulhuw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE4CB"                      , vpmulhuw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE48C2B80000000"            , vpmulhuw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE48C2B80000000"            , vpmulhuw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E5CB"                      , vpmulhw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E58C2B80000000"            , vpmulhw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E58C2B80000000"            , vpmulhw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE5CB"                      , vpmulhw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE58C2B80000000"            , vpmulhw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE58C2B80000000"            , vpmulhw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26940CB"                    , vpmulld(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269408C2B80000000"          , vpmulld(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269408C2B80000000"          , vpmulld(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D40CB"                    , vpmulld(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D408C2B80000000"          , vpmulld(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D408C2B80000000"          , vpmulld(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D5CB"                      , vpmullw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9D58C2B80000000"            , vpmullw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D58C2B80000000"            , vpmullw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD5CB"                      , vpmullw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDD58C2B80000000"            , vpmullw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD58C2B80000000"            , vpmullw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F4CB"                      , vpmuludq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9F48C2B80000000"            , vpmuludq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F48C2B80000000"            , vpmuludq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF4CB"                      , vpmuludq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDF48C2B80000000"            , vpmuludq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF48C2B80000000"            , vpmuludq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EBCB"                      , vpor(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9EB8C2B80000000"            , vpor(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EB8C2B80000000"            , vpor(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEBCB"                      , vpor(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDEB8C2B80000000"            , vpor(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEB8C2B80000000"            , vpor(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F6CB"                      , vpsadbw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9F68C2B80000000"            , vpsadbw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F68C2B80000000"            , vpsadbw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF6CB"                      , vpsadbw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDF68C2B80000000"            , vpsadbw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF68C2B80000000"            , vpsadbw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26900CB"                    , vpshufb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269008C2B80000000"          , vpshufb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269008C2B80000000"          , vpshufb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D00CB"                    , vpshufb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D008C2B80000000"          , vpshufb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D008C2B80000000"          , vpshufb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F970CA01"                    , vpshufd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5F9708C1A8000000001"          , vpshufd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5F9708C1A8000000001"          , vpshufd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FD70CA01"                    , vpshufd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5FD708C1A8000000001"          , vpshufd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FD708C1A8000000001"          , vpshufd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FA70CA01"                    , vpshufhw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5FA708C1A8000000001"          , vpshufhw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FA708C1A8000000001"          , vpshufhw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FE70CA01"                    , vpshufhw(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5FE708C1A8000000001"          , vpshufhw(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FE708C1A8000000001"          , vpshufhw(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FB70CA01"                    , vpshuflw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5FB708C1A8000000001"          , vpshuflw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FB708C1A8000000001"          , vpshuflw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FF70CA01"                    , vpshuflw(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5FF708C1A8000000001"          , vpshuflw(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C5FF708C1A8000000001"          , vpshuflw(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E26908CB"                    , vpsignb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269088C2B80000000"          , vpsignb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269088C2B80000000"          , vpsignb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D08CB"                    , vpsignb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D088C2B80000000"          , vpsignb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D088C2B80000000"          , vpsignb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690ACB"                    , vpsignd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2690A8C2B80000000"          , vpsignd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2690A8C2B80000000"          , vpsignd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0ACB"                    , vpsignd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D0A8C2B80000000"          , vpsignd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D0A8C2B80000000"          , vpsignd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26909CB"                    , vpsignw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269098C2B80000000"          , vpsignw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269098C2B80000000"          , vpsignw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D09CB"                    , vpsignw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D098C2B80000000"          , vpsignw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D098C2B80000000"          , vpsignw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F2CB"                      , vpslld(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F172F201"                    , vpslld(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9F28C2B80000000"            , vpslld(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F28C2B80000000"            , vpslld(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF2CB"                      , vpslld(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F572F201"                    , vpslld(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDF28C2B80000000"            , vpslld(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF28C2B80000000"            , vpslld(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F173FA01"                    , vpslldq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5F573FA01"                    , vpslldq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5E9F3CB"                      , vpsllq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F173F201"                    , vpsllq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9F38C2B80000000"            , vpsllq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F38C2B80000000"            , vpsllq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF3CB"                      , vpsllq(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F573F201"                    , vpsllq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDF38C2B80000000"            , vpsllq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF38C2B80000000"            , vpsllq(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26947CB"                    , vpsllvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269478C2B80000000"          , vpsllvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269478C2B80000000"          , vpsllvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D47CB"                    , vpsllvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D478C2B80000000"          , vpsllvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D478C2B80000000"          , vpsllvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E947CB"                    , vpsllvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9478C2B80000000"          , vpsllvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9478C2B80000000"          , vpsllvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED47CB"                    , vpsllvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED478C2B80000000"          , vpsllvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED478C2B80000000"          , vpsllvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F1CB"                      , vpsllw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F171F201"                    , vpsllw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9F18C2B80000000"            , vpsllw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F18C2B80000000"            , vpsllw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF1CB"                      , vpsllw(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F571F201"                    , vpsllw(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDF18C2B80000000"            , vpsllw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF18C2B80000000"            , vpsllw(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E2CB"                      , vpsrad(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F172E201"                    , vpsrad(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9E28C2B80000000"            , vpsrad(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E28C2B80000000"            , vpsrad(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE2CB"                      , vpsrad(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F572E201"                    , vpsrad(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDE28C2B80000000"            , vpsrad(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE28C2B80000000"            , vpsrad(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26946CB"                    , vpsravd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269468C2B80000000"          , vpsravd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269468C2B80000000"          , vpsravd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D46CB"                    , vpsravd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D468C2B80000000"          , vpsravd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D468C2B80000000"          , vpsravd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E1CB"                      , vpsraw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F171E201"                    , vpsraw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9E18C2B80000000"            , vpsraw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E18C2B80000000"            , vpsraw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE1CB"                      , vpsraw(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F571E201"                    , vpsraw(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDE18C2B80000000"            , vpsraw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE18C2B80000000"            , vpsraw(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D2CB"                      , vpsrld(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F172D201"                    , vpsrld(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9D28C2B80000000"            , vpsrld(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D28C2B80000000"            , vpsrld(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD2CB"                      , vpsrld(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F572D201"                    , vpsrld(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDD28C2B80000000"            , vpsrld(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD28C2B80000000"            , vpsrld(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F173DA01"                    , vpsrldq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5F573DA01"                    , vpsrldq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5E9D3CB"                      , vpsrlq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F173D201"                    , vpsrlq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9D38C2B80000000"            , vpsrlq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D38C2B80000000"            , vpsrlq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD3CB"                      , vpsrlq(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F573D201"                    , vpsrlq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDD38C2B80000000"            , vpsrlq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD38C2B80000000"            , vpsrlq(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26945CB"                    , vpsrlvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269458C2B80000000"          , vpsrlvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269458C2B80000000"          , vpsrlvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D45CB"                    , vpsrlvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D458C2B80000000"          , vpsrlvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D458C2B80000000"          , vpsrlvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E945CB"                    , vpsrlvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9458C2B80000000"          , vpsrlvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9458C2B80000000"          , vpsrlvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED45CB"                    , vpsrlvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED458C2B80000000"          , vpsrlvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED458C2B80000000"          , vpsrlvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D1CB"                      , vpsrlw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5F171D201"                    , vpsrlw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C5E9D18C2B80000000"            , vpsrlw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D18C2B80000000"            , vpsrlw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD1CB"                      , vpsrlw(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("C5F571D201"                    , vpsrlw(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C5EDD18C2B80000000"            , vpsrlw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD18C2B80000000"            , vpsrlw(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F8CB"                      , vpsubb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9F88C2B80000000"            , vpsubb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F88C2B80000000"            , vpsubb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF8CB"                      , vpsubb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDF88C2B80000000"            , vpsubb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF88C2B80000000"            , vpsubb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FACB"                      , vpsubd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9FA8C2B80000000"            , vpsubd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FA8C2B80000000"            , vpsubd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFACB"                      , vpsubd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDFA8C2B80000000"            , vpsubd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFA8C2B80000000"            , vpsubd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FBCB"                      , vpsubq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9FB8C2B80000000"            , vpsubq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9FB8C2B80000000"            , vpsubq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFBCB"                      , vpsubq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDFB8C2B80000000"            , vpsubq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDFB8C2B80000000"            , vpsubq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E8CB"                      , vpsubsb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E88C2B80000000"            , vpsubsb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E88C2B80000000"            , vpsubsb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE8CB"                      , vpsubsb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE88C2B80000000"            , vpsubsb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE88C2B80000000"            , vpsubsb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E9CB"                      , vpsubsw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9E98C2B80000000"            , vpsubsw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9E98C2B80000000"            , vpsubsw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE9CB"                      , vpsubsw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDE98C2B80000000"            , vpsubsw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDE98C2B80000000"            , vpsubsw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D8CB"                      , vpsubusb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9D88C2B80000000"            , vpsubusb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D88C2B80000000"            , vpsubusb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD8CB"                      , vpsubusb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDD88C2B80000000"            , vpsubusb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD88C2B80000000"            , vpsubusb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D9CB"                      , vpsubusw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9D98C2B80000000"            , vpsubusw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9D98C2B80000000"            , vpsubusw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD9CB"                      , vpsubusw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDD98C2B80000000"            , vpsubusw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDD98C2B80000000"            , vpsubusw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F9CB"                      , vpsubw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9F98C2B80000000"            , vpsubw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9F98C2B80000000"            , vpsubw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF9CB"                      , vpsubw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDF98C2B80000000"            , vpsubw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDF98C2B80000000"            , vpsubw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E27917CA"                    , vptest(xmm1, xmm2));
  TEST_INSTRUCTION("C4E279178C1A80000000"          , vptest(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279178C1A80000000"          , vptest(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D17CA"                    , vptest(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D178C1A80000000"          , vptest(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D178C1A80000000"          , vptest(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5E968CB"                      , vpunpckhbw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9688C2B80000000"            , vpunpckhbw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9688C2B80000000"            , vpunpckhbw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED68CB"                      , vpunpckhbw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED688C2B80000000"            , vpunpckhbw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED688C2B80000000"            , vpunpckhbw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96ACB"                      , vpunpckhdq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E96A8C2B80000000"            , vpunpckhdq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96A8C2B80000000"            , vpunpckhdq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6ACB"                      , vpunpckhdq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED6A8C2B80000000"            , vpunpckhdq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6A8C2B80000000"            , vpunpckhdq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96DCB"                      , vpunpckhqdq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E96D8C2B80000000"            , vpunpckhqdq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96D8C2B80000000"            , vpunpckhqdq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6DCB"                      , vpunpckhqdq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED6D8C2B80000000"            , vpunpckhqdq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6D8C2B80000000"            , vpunpckhqdq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E969CB"                      , vpunpckhwd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9698C2B80000000"            , vpunpckhwd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9698C2B80000000"            , vpunpckhwd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED69CB"                      , vpunpckhwd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED698C2B80000000"            , vpunpckhwd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED698C2B80000000"            , vpunpckhwd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E960CB"                      , vpunpcklbw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9608C2B80000000"            , vpunpcklbw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9608C2B80000000"            , vpunpcklbw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED60CB"                      , vpunpcklbw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED608C2B80000000"            , vpunpcklbw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED608C2B80000000"            , vpunpcklbw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E962CB"                      , vpunpckldq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9628C2B80000000"            , vpunpckldq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9628C2B80000000"            , vpunpckldq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED62CB"                      , vpunpckldq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED628C2B80000000"            , vpunpckldq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED628C2B80000000"            , vpunpckldq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96CCB"                      , vpunpcklqdq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E96C8C2B80000000"            , vpunpcklqdq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E96C8C2B80000000"            , vpunpcklqdq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6CCB"                      , vpunpcklqdq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED6C8C2B80000000"            , vpunpcklqdq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED6C8C2B80000000"            , vpunpcklqdq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E961CB"                      , vpunpcklwd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9618C2B80000000"            , vpunpcklwd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9618C2B80000000"            , vpunpcklwd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED61CB"                      , vpunpcklwd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED618C2B80000000"            , vpunpcklwd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED618C2B80000000"            , vpunpcklwd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EFCB"                      , vpxor(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9EF8C2B80000000"            , vpxor(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9EF8C2B80000000"            , vpxor(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEFCB"                      , vpxor(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EDEF8C2B80000000"            , vpxor(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EDEF8C2B80000000"            , vpxor(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F853CA"                      , vrcpps(xmm1, xmm2));
  TEST_INSTRUCTION("C5F8538C1A80000000"            , vrcpps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8538C1A80000000"            , vrcpps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC53CA"                      , vrcpps(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC538C1A80000000"            , vrcpps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC538C1A80000000"            , vrcpps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EA53CB"                      , vrcpss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA538C2B80000000"            , vrcpss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA538C2B80000000"            , vrcpss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E37909CA01"                  , vroundpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E379098C1A8000000001"        , vroundpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E379098C1A8000000001"        , vroundpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D09CA01"                  , vroundpd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E37D098C1A8000000001"        , vroundpd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D098C1A8000000001"        , vroundpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37908CA01"                  , vroundps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("C4E379088C1A8000000001"        , vroundps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E379088C1A8000000001"        , vroundps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D08CA01"                  , vroundps(ymm1, ymm2, 1));
  TEST_INSTRUCTION("C4E37D088C1A8000000001"        , vroundps(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E37D088C1A8000000001"        , vroundps(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690BCB01"                  , vroundsd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690B8C2B8000000001"        , vroundsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690B8C2B8000000001"        , vroundsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690ACB01"                  , vroundss(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E3690A8C2B8000000001"        , vroundss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E3690A8C2B8000000001"        , vroundss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5F852CA"                      , vrsqrtps(xmm1, xmm2));
  TEST_INSTRUCTION("C5F8528C1A80000000"            , vrsqrtps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8528C1A80000000"            , vrsqrtps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC52CA"                      , vrsqrtps(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC528C1A80000000"            , vrsqrtps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC528C1A80000000"            , vrsqrtps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EA52CB"                      , vrsqrtss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA528C2B80000000"            , vrsqrtss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA528C2B80000000"            , vrsqrtss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9C6CB01"                    , vshufpd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5E9C68C2B8000000001"          , vshufpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E9C68C2B8000000001"          , vshufpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EDC6CB01"                    , vshufpd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C5EDC68C2B8000000001"          , vshufpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5EDC68C2B8000000001"          , vshufpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E8C6CB01"                    , vshufps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C5E8C68C2B8000000001"          , vshufps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5E8C68C2B8000000001"          , vshufps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5ECC6CB01"                    , vshufps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("C5ECC68C2B8000000001"          , vshufps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5ECC68C2B8000000001"          , vshufps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C5F951CA"                      , vsqrtpd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F9518C1A80000000"            , vsqrtpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9518C1A80000000"            , vsqrtpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD51CA"                      , vsqrtpd(ymm1, ymm2));
  TEST_INSTRUCTION("C5FD518C1A80000000"            , vsqrtpd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FD518C1A80000000"            , vsqrtpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F851CA"                      , vsqrtps(xmm1, xmm2));
  TEST_INSTRUCTION("C5F8518C1A80000000"            , vsqrtps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8518C1A80000000"            , vsqrtps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC51CA"                      , vsqrtps(ymm1, ymm2));
  TEST_INSTRUCTION("C5FC518C1A80000000"            , vsqrtps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FC518C1A80000000"            , vsqrtps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5EB51CB"                      , vsqrtsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB518C2B80000000"            , vsqrtsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB518C2B80000000"            , vsqrtsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA51CB"                      , vsqrtss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA518C2B80000000"            , vsqrtss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA518C2B80000000"            , vsqrtss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5F8AE9C1180000000"            , vstmxcsr(ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("C5F8AE9C1180000000"            , vstmxcsr(dword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("C5E95CCB"                      , vsubpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E95C8C2B80000000"            , vsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E95C8C2B80000000"            , vsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5CCB"                      , vsubpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED5C8C2B80000000"            , vsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED5C8C2B80000000"            , vsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85CCB"                      , vsubps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E85C8C2B80000000"            , vsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E85C8C2B80000000"            , vsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5CCB"                      , vsubps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC5C8C2B80000000"            , vsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC5C8C2B80000000"            , vsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5CCB"                      , vsubsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EB5C8C2B80000000"            , vsubsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EB5C8C2B80000000"            , vsubsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5CCB"                      , vsubss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5EA5C8C2B80000000"            , vsubss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EA5C8C2B80000000"            , vsubss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2790FCA"                    , vtestpd(xmm1, xmm2));
  TEST_INSTRUCTION("C4E2790F8C1A80000000"          , vtestpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2790F8C1A80000000"          , vtestpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D0FCA"                    , vtestpd(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D0F8C1A80000000"          , vtestpd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D0F8C1A80000000"          , vtestpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2790ECA"                    , vtestps(xmm1, xmm2));
  TEST_INSTRUCTION("C4E2790E8C1A80000000"          , vtestps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E2790E8C1A80000000"          , vtestps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D0ECA"                    , vtestps(ymm1, ymm2));
  TEST_INSTRUCTION("C4E27D0E8C1A80000000"          , vtestps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27D0E8C1A80000000"          , vtestps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F92ECA"                      , vucomisd(xmm1, xmm2));
  TEST_INSTRUCTION("C5F92E8C1A80000000"            , vucomisd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F92E8C1A80000000"            , vucomisd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F82ECA"                      , vucomiss(xmm1, xmm2));
  TEST_INSTRUCTION("C5F82E8C1A80000000"            , vucomiss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F82E8C1A80000000"            , vucomiss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5E915CB"                      , vunpckhpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9158C2B80000000"            , vunpckhpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9158C2B80000000"            , vunpckhpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED15CB"                      , vunpckhpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED158C2B80000000"            , vunpckhpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED158C2B80000000"            , vunpckhpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E815CB"                      , vunpckhps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8158C2B80000000"            , vunpckhps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8158C2B80000000"            , vunpckhps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC15CB"                      , vunpckhps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC158C2B80000000"            , vunpckhps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC158C2B80000000"            , vunpckhps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E914CB"                      , vunpcklpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9148C2B80000000"            , vunpcklpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9148C2B80000000"            , vunpcklpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED14CB"                      , vunpcklpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED148C2B80000000"            , vunpcklpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED148C2B80000000"            , vunpcklpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E814CB"                      , vunpcklps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8148C2B80000000"            , vunpcklps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8148C2B80000000"            , vunpcklps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC14CB"                      , vunpcklps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC148C2B80000000"            , vunpcklps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC148C2B80000000"            , vunpcklps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E957CB"                      , vxorpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E9578C2B80000000"            , vxorpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E9578C2B80000000"            , vxorpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED57CB"                      , vxorpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5ED578C2B80000000"            , vxorpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5ED578C2B80000000"            , vxorpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E857CB"                      , vxorps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C5E8578C2B80000000"            , vxorps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5E8578C2B80000000"            , vxorps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC57CB"                      , vxorps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C5EC578C2B80000000"            , vxorps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5EC578C2B80000000"            , vxorps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C5FC77"                        , vzeroall());
  TEST_INSTRUCTION("C5F877"                        , vzeroupper());
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_ne_convert(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E27AB18C1A80000000"          , vbcstnebf162ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27AB18C1A80000000"          , vbcstnebf162ps(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27EB18C1A80000000"          , vbcstnebf162ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27EB18C1A80000000"          , vbcstnebf162ps(ymm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279B18C1A80000000"          , vbcstnesh2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279B18C1A80000000"          , vbcstnesh2ps(xmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27DB18C1A80000000"          , vbcstnesh2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27DB18C1A80000000"          , vbcstnesh2ps(ymm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27AB08C1A80000000"          , vcvtneebf162ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27AB08C1A80000000"          , vcvtneebf162ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27EB08C1A80000000"          , vcvtneebf162ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27EB08C1A80000000"          , vcvtneebf162ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279B08C1A80000000"          , vcvtneeph2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E279B08C1A80000000"          , vcvtneeph2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27DB08C1A80000000"          , vcvtneeph2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27DB08C1A80000000"          , vcvtneeph2ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27BB08C1A80000000"          , vcvtneobf162ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27BB08C1A80000000"          , vcvtneobf162ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27FB08C1A80000000"          , vcvtneobf162ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27FB08C1A80000000"          , vcvtneobf162ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E278B08C1A80000000"          , vcvtneoph2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E278B08C1A80000000"          , vcvtneoph2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27CB08C1A80000000"          , vcvtneoph2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27CB08C1A80000000"          , vcvtneoph2ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27A72CA"                    , vex().vcvtneps2bf16(xmm1, xmm2));
  TEST_INSTRUCTION("C4E27E72CA"                    , vex().vcvtneps2bf16(xmm1, ymm2));
  TEST_INSTRUCTION("C4E27A728C1A80000000"          , vex().vcvtneps2bf16(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E27E728C1A80000000"          , vex().vcvtneps2bf16(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_vnni(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E25150F4"                    , vex().vpdpbusd(xmm6, xmm5, xmm4));
  TEST_INSTRUCTION("C4E25550F4"                    , vex().vpdpbusd(ymm6, ymm5, ymm4));
  TEST_INSTRUCTION("C4E25151F4"                    , vex().vpdpbusds(xmm6, xmm5, xmm4));
  TEST_INSTRUCTION("C4E25551F4"                    , vex().vpdpbusds(ymm6, ymm5, ymm4));
  TEST_INSTRUCTION("C4E25152F4"                    , vex().vpdpwssd(xmm6, xmm5, xmm4));
  TEST_INSTRUCTION("C4E25552F4"                    , vex().vpdpwssd(ymm6, ymm5, ymm4));
  TEST_INSTRUCTION("C4E25153F4"                    , vex().vpdpwssds(xmm6, xmm5, xmm4));
  TEST_INSTRUCTION("C4E25553F4"                    , vex().vpdpwssds(ymm6, ymm5, ymm4));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_vnni_int8(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E26B50CB"                    , vpdpbssd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26B508C2B80000000"          , vpdpbssd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26B508C2B80000000"          , vpdpbssd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26F50CB"                    , vpdpbssd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26F508C2B80000000"          , vpdpbssd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26F508C2B80000000"          , vpdpbssd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26B51CB"                    , vpdpbssds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26B518C2B80000000"          , vpdpbssds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26B518C2B80000000"          , vpdpbssds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26F51CB"                    , vpdpbssds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26F518C2B80000000"          , vpdpbssds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26F518C2B80000000"          , vpdpbssds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26A50CB"                    , vpdpbsud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26A508C2B80000000"          , vpdpbsud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26A508C2B80000000"          , vpdpbsud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26E50CB"                    , vpdpbsud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26E508C2B80000000"          , vpdpbsud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26E508C2B80000000"          , vpdpbsud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26A51CB"                    , vpdpbsuds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26A518C2B80000000"          , vpdpbsuds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26A518C2B80000000"          , vpdpbsuds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26E51CB"                    , vpdpbsuds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26E518C2B80000000"          , vpdpbsuds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26E518C2B80000000"          , vpdpbsuds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26850CB"                    , vpdpbuud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E268508C2B80000000"          , vpdpbuud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268508C2B80000000"          , vpdpbuud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26C50CB"                    , vpdpbuud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26C508C2B80000000"          , vpdpbuud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26C508C2B80000000"          , vpdpbuud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26851CB"                    , vpdpbuuds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E268518C2B80000000"          , vpdpbuuds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268518C2B80000000"          , vpdpbuuds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26C51CB"                    , vpdpbuuds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26C518C2B80000000"          , vpdpbuuds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26C518C2B80000000"          , vpdpbuuds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_vnni_int16(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E26AD2CB"                    , vpdpwsud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26AD28C2B80000000"          , vpdpwsud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26AD28C2B80000000"          , vpdpwsud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26ED2CB"                    , vpdpwsud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26ED28C2B80000000"          , vpdpwsud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26ED28C2B80000000"          , vpdpwsud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26AD3CB"                    , vpdpwsuds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26AD38C2B80000000"          , vpdpwsuds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26AD38C2B80000000"          , vpdpwsuds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26ED3CB"                    , vpdpwsuds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26ED38C2B80000000"          , vpdpwsuds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26ED38C2B80000000"          , vpdpwsuds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269D2CB"                    , vpdpwusd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269D28C2B80000000"          , vpdpwusd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269D28C2B80000000"          , vpdpwusd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DD2CB"                    , vpdpwusd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DD28C2B80000000"          , vpdpwusd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DD28C2B80000000"          , vpdpwusd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269D3CB"                    , vpdpwusds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269D38C2B80000000"          , vpdpwusds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269D38C2B80000000"          , vpdpwusds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DD3CB"                    , vpdpwusds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DD38C2B80000000"          , vpdpwusds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DD38C2B80000000"          , vpdpwusds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268D2CB"                    , vpdpwuud(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E268D28C2B80000000"          , vpdpwuud(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268D28C2B80000000"          , vpdpwuud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26CD2CB"                    , vpdpwuud(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26CD28C2B80000000"          , vpdpwuud(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26CD28C2B80000000"          , vpdpwuud(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268D3CB"                    , vpdpwuuds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E268D38C2B80000000"          , vpdpwuuds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268D38C2B80000000"          , vpdpwuuds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26CD3CB"                    , vpdpwuuds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26CD38C2B80000000"          , vpdpwuuds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26CD38C2B80000000"          , vpdpwuuds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_sha512(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E27FCCCA"                    , vsha512msg1(ymm1, xmm2));
  TEST_INSTRUCTION("C4E27FCDCA"                    , vsha512msg2(ymm1, ymm2));
  TEST_INSTRUCTION("C4E26FCBCB"                    , vsha512rnds2(ymm1, ymm2, xmm3));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_sm3(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E268DACB"                    , vsm3msg1(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E268DA8C2B80000000"          , vsm3msg1(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E268DA8C2B80000000"          , vsm3msg1(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DACB"                    , vsm3msg2(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269DA8C2B80000000"          , vsm3msg2(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269DA8C2B80000000"          , vsm3msg2(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E369DECB01"                  , vsm3rnds2(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("C4E369DE8C2B8000000001"        , vsm3rnds2(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("C4E369DE8C2B8000000001"        , vsm3rnds2(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx_sm4(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E26ADACB"                    , vsm4key4(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26ADA8C2B80000000"          , vsm4key4(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26ADA8C2B80000000"          , vsm4key4(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26EDACB"                    , vsm4key4(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26EDA8C2B80000000"          , vsm4key4(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26EDA8C2B80000000"          , vsm4key4(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26BDACB"                    , vsm4rnds4(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E26BDA8C2B80000000"          , vsm4rnds4(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26BDA8C2B80000000"          , vsm4rnds4(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26FDACB"                    , vsm4rnds4(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26FDA8C2B80000000"          , vsm4rnds4(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26FDA8C2B80000000"          , vsm4rnds4(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_fma(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E2E998CB"                    , vfmadd132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9988C2B80000000"          , vfmadd132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9988C2B80000000"          , vfmadd132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED98CB"                    , vfmadd132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED988C2B80000000"          , vfmadd132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED988C2B80000000"          , vfmadd132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26998CB"                    , vfmadd132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269988C2B80000000"          , vfmadd132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269988C2B80000000"          , vfmadd132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D98CB"                    , vfmadd132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D988C2B80000000"          , vfmadd132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D988C2B80000000"          , vfmadd132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E999CB"                    , vfmadd132sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9998C2B80000000"          , vfmadd132sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9998C2B80000000"          , vfmadd132sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26999CB"                    , vfmadd132ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269998C2B80000000"          , vfmadd132ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269998C2B80000000"          , vfmadd132ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A8CB"                    , vfmadd213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9A88C2B80000000"          , vfmadd213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A88C2B80000000"          , vfmadd213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA8CB"                    , vfmadd213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDA88C2B80000000"          , vfmadd213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA88C2B80000000"          , vfmadd213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A8CB"                    , vfmadd213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269A88C2B80000000"          , vfmadd213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A88C2B80000000"          , vfmadd213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA8CB"                    , vfmadd213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DA88C2B80000000"          , vfmadd213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA88C2B80000000"          , vfmadd213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A9CB"                    , vfmadd213sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9A98C2B80000000"          , vfmadd213sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A98C2B80000000"          , vfmadd213sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A9CB"                    , vfmadd213ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269A98C2B80000000"          , vfmadd213ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A98C2B80000000"          , vfmadd213ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B8CB"                    , vfmadd231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9B88C2B80000000"          , vfmadd231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B88C2B80000000"          , vfmadd231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB8CB"                    , vfmadd231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDB88C2B80000000"          , vfmadd231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB88C2B80000000"          , vfmadd231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B8CB"                    , vfmadd231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269B88C2B80000000"          , vfmadd231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B88C2B80000000"          , vfmadd231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB8CB"                    , vfmadd231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DB88C2B80000000"          , vfmadd231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB88C2B80000000"          , vfmadd231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B9CB"                    , vfmadd231sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9B98C2B80000000"          , vfmadd231sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B98C2B80000000"          , vfmadd231sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B9CB"                    , vfmadd231ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269B98C2B80000000"          , vfmadd231ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B98C2B80000000"          , vfmadd231ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E996CB"                    , vfmaddsub132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9968C2B80000000"          , vfmaddsub132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9968C2B80000000"          , vfmaddsub132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED96CB"                    , vfmaddsub132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED968C2B80000000"          , vfmaddsub132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED968C2B80000000"          , vfmaddsub132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26996CB"                    , vfmaddsub132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269968C2B80000000"          , vfmaddsub132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269968C2B80000000"          , vfmaddsub132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D96CB"                    , vfmaddsub132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D968C2B80000000"          , vfmaddsub132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D968C2B80000000"          , vfmaddsub132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A6CB"                    , vfmaddsub213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9A68C2B80000000"          , vfmaddsub213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A68C2B80000000"          , vfmaddsub213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA6CB"                    , vfmaddsub213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDA68C2B80000000"          , vfmaddsub213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA68C2B80000000"          , vfmaddsub213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A6CB"                    , vfmaddsub213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269A68C2B80000000"          , vfmaddsub213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A68C2B80000000"          , vfmaddsub213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA6CB"                    , vfmaddsub213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DA68C2B80000000"          , vfmaddsub213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA68C2B80000000"          , vfmaddsub213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B6CB"                    , vfmaddsub231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9B68C2B80000000"          , vfmaddsub231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B68C2B80000000"          , vfmaddsub231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB6CB"                    , vfmaddsub231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDB68C2B80000000"          , vfmaddsub231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB68C2B80000000"          , vfmaddsub231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B6CB"                    , vfmaddsub231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269B68C2B80000000"          , vfmaddsub231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B68C2B80000000"          , vfmaddsub231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB6CB"                    , vfmaddsub231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DB68C2B80000000"          , vfmaddsub231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB68C2B80000000"          , vfmaddsub231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99ACB"                    , vfmsub132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99A8C2B80000000"          , vfmsub132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99A8C2B80000000"          , vfmsub132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9ACB"                    , vfmsub132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED9A8C2B80000000"          , vfmsub132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9A8C2B80000000"          , vfmsub132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699ACB"                    , vfmsub132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699A8C2B80000000"          , vfmsub132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699A8C2B80000000"          , vfmsub132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9ACB"                    , vfmsub132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D9A8C2B80000000"          , vfmsub132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9A8C2B80000000"          , vfmsub132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99BCB"                    , vfmsub132sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99B8C2B80000000"          , vfmsub132sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99B8C2B80000000"          , vfmsub132sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699BCB"                    , vfmsub132ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699B8C2B80000000"          , vfmsub132ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699B8C2B80000000"          , vfmsub132ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AACB"                    , vfmsub213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AA8C2B80000000"          , vfmsub213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AA8C2B80000000"          , vfmsub213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDAACB"                    , vfmsub213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDAA8C2B80000000"          , vfmsub213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDAA8C2B80000000"          , vfmsub213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AACB"                    , vfmsub213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AA8C2B80000000"          , vfmsub213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AA8C2B80000000"          , vfmsub213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DAACB"                    , vfmsub213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DAA8C2B80000000"          , vfmsub213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DAA8C2B80000000"          , vfmsub213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9ABCB"                    , vfmsub213sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AB8C2B80000000"          , vfmsub213sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AB8C2B80000000"          , vfmsub213sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269ABCB"                    , vfmsub213ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AB8C2B80000000"          , vfmsub213ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AB8C2B80000000"          , vfmsub213ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BACB"                    , vfmsub231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BA8C2B80000000"          , vfmsub231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BA8C2B80000000"          , vfmsub231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBACB"                    , vfmsub231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDBA8C2B80000000"          , vfmsub231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBA8C2B80000000"          , vfmsub231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BACB"                    , vfmsub231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BA8C2B80000000"          , vfmsub231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BA8C2B80000000"          , vfmsub231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBACB"                    , vfmsub231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DBA8C2B80000000"          , vfmsub231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBA8C2B80000000"          , vfmsub231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BBCB"                    , vfmsub231sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BB8C2B80000000"          , vfmsub231sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BB8C2B80000000"          , vfmsub231sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BBCB"                    , vfmsub231ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BB8C2B80000000"          , vfmsub231ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BB8C2B80000000"          , vfmsub231ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E997CB"                    , vfmsubadd132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9978C2B80000000"          , vfmsubadd132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9978C2B80000000"          , vfmsubadd132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED97CB"                    , vfmsubadd132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED978C2B80000000"          , vfmsubadd132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED978C2B80000000"          , vfmsubadd132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26997CB"                    , vfmsubadd132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269978C2B80000000"          , vfmsubadd132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269978C2B80000000"          , vfmsubadd132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D97CB"                    , vfmsubadd132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D978C2B80000000"          , vfmsubadd132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D978C2B80000000"          , vfmsubadd132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A7CB"                    , vfmsubadd213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9A78C2B80000000"          , vfmsubadd213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9A78C2B80000000"          , vfmsubadd213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA7CB"                    , vfmsubadd213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDA78C2B80000000"          , vfmsubadd213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDA78C2B80000000"          , vfmsubadd213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A7CB"                    , vfmsubadd213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269A78C2B80000000"          , vfmsubadd213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269A78C2B80000000"          , vfmsubadd213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA7CB"                    , vfmsubadd213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DA78C2B80000000"          , vfmsubadd213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DA78C2B80000000"          , vfmsubadd213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B7CB"                    , vfmsubadd231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9B78C2B80000000"          , vfmsubadd231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9B78C2B80000000"          , vfmsubadd231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB7CB"                    , vfmsubadd231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDB78C2B80000000"          , vfmsubadd231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDB78C2B80000000"          , vfmsubadd231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B7CB"                    , vfmsubadd231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269B78C2B80000000"          , vfmsubadd231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269B78C2B80000000"          , vfmsubadd231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB7CB"                    , vfmsubadd231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DB78C2B80000000"          , vfmsubadd231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DB78C2B80000000"          , vfmsubadd231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99CCB"                    , vfnmadd132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99C8C2B80000000"          , vfnmadd132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99C8C2B80000000"          , vfnmadd132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9CCB"                    , vfnmadd132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED9C8C2B80000000"          , vfnmadd132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9C8C2B80000000"          , vfnmadd132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699CCB"                    , vfnmadd132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699C8C2B80000000"          , vfnmadd132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699C8C2B80000000"          , vfnmadd132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9CCB"                    , vfnmadd132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D9C8C2B80000000"          , vfnmadd132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9C8C2B80000000"          , vfnmadd132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99DCB"                    , vfnmadd132sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99D8C2B80000000"          , vfnmadd132sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99D8C2B80000000"          , vfnmadd132sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699DCB"                    , vfnmadd132ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699D8C2B80000000"          , vfnmadd132ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699D8C2B80000000"          , vfnmadd132ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9ACCB"                    , vfnmadd213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AC8C2B80000000"          , vfnmadd213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AC8C2B80000000"          , vfnmadd213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDACCB"                    , vfnmadd213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDAC8C2B80000000"          , vfnmadd213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDAC8C2B80000000"          , vfnmadd213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269ACCB"                    , vfnmadd213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AC8C2B80000000"          , vfnmadd213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AC8C2B80000000"          , vfnmadd213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DACCB"                    , vfnmadd213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DAC8C2B80000000"          , vfnmadd213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DAC8C2B80000000"          , vfnmadd213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9ADCB"                    , vfnmadd213sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AD8C2B80000000"          , vfnmadd213sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AD8C2B80000000"          , vfnmadd213sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269ADCB"                    , vfnmadd213ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AD8C2B80000000"          , vfnmadd213ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AD8C2B80000000"          , vfnmadd213ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BCCB"                    , vfnmadd231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BC8C2B80000000"          , vfnmadd231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BC8C2B80000000"          , vfnmadd231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBCCB"                    , vfnmadd231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDBC8C2B80000000"          , vfnmadd231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBC8C2B80000000"          , vfnmadd231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BCCB"                    , vfnmadd231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BC8C2B80000000"          , vfnmadd231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BC8C2B80000000"          , vfnmadd231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBCCB"                    , vfnmadd231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DBC8C2B80000000"          , vfnmadd231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBC8C2B80000000"          , vfnmadd231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BDCB"                    , vfnmadd231sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BD8C2B80000000"          , vfnmadd231sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BD8C2B80000000"          , vfnmadd231sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BDCB"                    , vfnmadd231ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BD8C2B80000000"          , vfnmadd231ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BD8C2B80000000"          , vfnmadd231ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99ECB"                    , vfnmsub132pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99E8C2B80000000"          , vfnmsub132pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99E8C2B80000000"          , vfnmsub132pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9ECB"                    , vfnmsub132pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2ED9E8C2B80000000"          , vfnmsub132pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2ED9E8C2B80000000"          , vfnmsub132pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699ECB"                    , vfnmsub132ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699E8C2B80000000"          , vfnmsub132ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699E8C2B80000000"          , vfnmsub132ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9ECB"                    , vfnmsub132ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26D9E8C2B80000000"          , vfnmsub132ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26D9E8C2B80000000"          , vfnmsub132ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99FCB"                    , vfnmsub132sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E99F8C2B80000000"          , vfnmsub132sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E99F8C2B80000000"          , vfnmsub132sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699FCB"                    , vfnmsub132ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2699F8C2B80000000"          , vfnmsub132ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2699F8C2B80000000"          , vfnmsub132ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AECB"                    , vfnmsub213pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AE8C2B80000000"          , vfnmsub213pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AE8C2B80000000"          , vfnmsub213pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDAECB"                    , vfnmsub213pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDAE8C2B80000000"          , vfnmsub213pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDAE8C2B80000000"          , vfnmsub213pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AECB"                    , vfnmsub213ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AE8C2B80000000"          , vfnmsub213ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AE8C2B80000000"          , vfnmsub213ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DAECB"                    , vfnmsub213ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DAE8C2B80000000"          , vfnmsub213ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DAE8C2B80000000"          , vfnmsub213ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AFCB"                    , vfnmsub213sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9AF8C2B80000000"          , vfnmsub213sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9AF8C2B80000000"          , vfnmsub213sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AFCB"                    , vfnmsub213ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269AF8C2B80000000"          , vfnmsub213ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269AF8C2B80000000"          , vfnmsub213ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BECB"                    , vfnmsub231pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BE8C2B80000000"          , vfnmsub231pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BE8C2B80000000"          , vfnmsub231pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBECB"                    , vfnmsub231pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E2EDBE8C2B80000000"          , vfnmsub231pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2EDBE8C2B80000000"          , vfnmsub231pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BECB"                    , vfnmsub231ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BE8C2B80000000"          , vfnmsub231ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BE8C2B80000000"          , vfnmsub231ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBECB"                    , vfnmsub231ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("C4E26DBE8C2B80000000"          , vfnmsub231ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E26DBE8C2B80000000"          , vfnmsub231ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BFCB"                    , vfnmsub231sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E2E9BF8C2B80000000"          , vfnmsub231sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E2E9BF8C2B80000000"          , vfnmsub231sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BFCB"                    , vfnmsub231ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("C4E269BF8C2B80000000"          , vfnmsub231ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("C4E269BF8C2B80000000"          , vfnmsub231ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_fma4(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C4E3E969CC30"                  , vfmaddpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E9698C358000000030"        , vfmaddpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E9698C358000000030"        , vfmaddpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E369698C2B8000000060"        , vfmaddpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E369698C2B8000000060"        , vfmaddpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED69CC30"                  , vfmaddpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED698C358000000030"        , vfmaddpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED698C358000000030"        , vfmaddpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D698C2B8000000060"        , vfmaddpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D698C2B8000000060"        , vfmaddpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E968CC30"                  , vfmaddps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E9688C358000000030"        , vfmaddps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E9688C358000000030"        , vfmaddps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E369688C2B8000000060"        , vfmaddps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E369688C2B8000000060"        , vfmaddps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED68CC30"                  , vfmaddps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED688C358000000030"        , vfmaddps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED688C358000000030"        , vfmaddps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D688C2B8000000060"        , vfmaddps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D688C2B8000000060"        , vfmaddps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E96BCC30"                  , vfmaddsd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96B8C358000000030"        , vfmaddsd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96B8C358000000030"        , vfmaddsd(xmm1, xmm2, xmm3, qword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696B8C2B8000000060"        , vfmaddsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696B8C2B8000000060"        , vfmaddsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E96ACC30"                  , vfmaddss(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96A8C358000000030"        , vfmaddss(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96A8C358000000030"        , vfmaddss(xmm1, xmm2, xmm3, dword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696A8C2B8000000060"        , vfmaddss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696A8C2B8000000060"        , vfmaddss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E95DCC30"                  , vfmaddsubpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E95D8C358000000030"        , vfmaddsubpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E95D8C358000000030"        , vfmaddsubpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3695D8C2B8000000060"        , vfmaddsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3695D8C2B8000000060"        , vfmaddsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED5DCC30"                  , vfmaddsubpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED5D8C358000000030"        , vfmaddsubpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED5D8C358000000030"        , vfmaddsubpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D5D8C2B8000000060"        , vfmaddsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D5D8C2B8000000060"        , vfmaddsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E95CCC30"                  , vfmaddsubps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E95C8C358000000030"        , vfmaddsubps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E95C8C358000000030"        , vfmaddsubps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3695C8C2B8000000060"        , vfmaddsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3695C8C2B8000000060"        , vfmaddsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED5CCC30"                  , vfmaddsubps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED5C8C358000000030"        , vfmaddsubps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED5C8C358000000030"        , vfmaddsubps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D5C8C2B8000000060"        , vfmaddsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D5C8C2B8000000060"        , vfmaddsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E95FCC30"                  , vfmsubaddpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E95F8C358000000030"        , vfmsubaddpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E95F8C358000000030"        , vfmsubaddpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3695F8C2B8000000060"        , vfmsubaddpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3695F8C2B8000000060"        , vfmsubaddpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED5FCC30"                  , vfmsubaddpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED5F8C358000000030"        , vfmsubaddpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED5F8C358000000030"        , vfmsubaddpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D5F8C2B8000000060"        , vfmsubaddpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D5F8C2B8000000060"        , vfmsubaddpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E95ECC30"                  , vfmsubaddps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E95E8C358000000030"        , vfmsubaddps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E95E8C358000000030"        , vfmsubaddps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3695E8C2B8000000060"        , vfmsubaddps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3695E8C2B8000000060"        , vfmsubaddps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED5ECC30"                  , vfmsubaddps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED5E8C358000000030"        , vfmsubaddps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED5E8C358000000030"        , vfmsubaddps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D5E8C2B8000000060"        , vfmsubaddps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D5E8C2B8000000060"        , vfmsubaddps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E96DCC30"                  , vfmsubpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96D8C358000000030"        , vfmsubpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96D8C358000000030"        , vfmsubpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696D8C2B8000000060"        , vfmsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696D8C2B8000000060"        , vfmsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED6DCC30"                  , vfmsubpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED6D8C358000000030"        , vfmsubpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED6D8C358000000030"        , vfmsubpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D6D8C2B8000000060"        , vfmsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D6D8C2B8000000060"        , vfmsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E96CCC30"                  , vfmsubps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96C8C358000000030"        , vfmsubps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96C8C358000000030"        , vfmsubps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696C8C2B8000000060"        , vfmsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696C8C2B8000000060"        , vfmsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED6CCC30"                  , vfmsubps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED6C8C358000000030"        , vfmsubps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED6C8C358000000030"        , vfmsubps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D6C8C2B8000000060"        , vfmsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D6C8C2B8000000060"        , vfmsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E96FCC30"                  , vfmsubsd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96F8C358000000030"        , vfmsubsd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96F8C358000000030"        , vfmsubsd(xmm1, xmm2, xmm3, qword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696F8C2B8000000060"        , vfmsubsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696F8C2B8000000060"        , vfmsubsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E96ECC30"                  , vfmsubss(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E96E8C358000000030"        , vfmsubss(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E96E8C358000000030"        , vfmsubss(xmm1, xmm2, xmm3, dword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3696E8C2B8000000060"        , vfmsubss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3696E8C2B8000000060"        , vfmsubss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E979CC30"                  , vfnmaddpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E9798C358000000030"        , vfnmaddpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E9798C358000000030"        , vfnmaddpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E369798C2B8000000060"        , vfnmaddpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E369798C2B8000000060"        , vfnmaddpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED79CC30"                  , vfnmaddpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED798C358000000030"        , vfnmaddpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED798C358000000030"        , vfnmaddpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D798C2B8000000060"        , vfnmaddpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D798C2B8000000060"        , vfnmaddpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E978CC30"                  , vfnmaddps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E9788C358000000030"        , vfnmaddps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E9788C358000000030"        , vfnmaddps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E369788C2B8000000060"        , vfnmaddps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E369788C2B8000000060"        , vfnmaddps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED78CC30"                  , vfnmaddps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED788C358000000030"        , vfnmaddps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED788C358000000030"        , vfnmaddps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D788C2B8000000060"        , vfnmaddps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D788C2B8000000060"        , vfnmaddps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E97BCC30"                  , vfnmaddsd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97B8C358000000030"        , vfnmaddsd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97B8C358000000030"        , vfnmaddsd(xmm1, xmm2, xmm3, qword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697B8C2B8000000060"        , vfnmaddsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697B8C2B8000000060"        , vfnmaddsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E97ACC30"                  , vfnmaddss(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97A8C358000000030"        , vfnmaddss(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97A8C358000000030"        , vfnmaddss(xmm1, xmm2, xmm3, dword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697A8C2B8000000060"        , vfnmaddss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697A8C2B8000000060"        , vfnmaddss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E97DCC30"                  , vfnmsubpd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97D8C358000000030"        , vfnmsubpd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97D8C358000000030"        , vfnmsubpd(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697D8C2B8000000060"        , vfnmsubpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697D8C2B8000000060"        , vfnmsubpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED7DCC30"                  , vfnmsubpd(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED7D8C358000000030"        , vfnmsubpd(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED7D8C358000000030"        , vfnmsubpd(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D7D8C2B8000000060"        , vfnmsubpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D7D8C2B8000000060"        , vfnmsubpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E97CCC30"                  , vfnmsubps(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97C8C358000000030"        , vfnmsubps(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97C8C358000000030"        , vfnmsubps(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697C8C2B8000000060"        , vfnmsubps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697C8C2B8000000060"        , vfnmsubps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3ED7CCC30"                  , vfnmsubps(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("C4E3ED7C8C358000000030"        , vfnmsubps(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3ED7C8C358000000030"        , vfnmsubps(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E36D7C8C2B8000000060"        , vfnmsubps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E36D7C8C2B8000000060"        , vfnmsubps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("C4E3E97FCC30"                  , vfnmsubsd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97F8C358000000030"        , vfnmsubsd(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97F8C358000000030"        , vfnmsubsd(xmm1, xmm2, xmm3, qword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697F8C2B8000000060"        , vfnmsubsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697F8C2B8000000060"        , vfnmsubsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3E97ECC30"                  , vfnmsubss(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("C4E3E97E8C358000000030"        , vfnmsubss(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3E97E8C358000000030"        , vfnmsubss(xmm1, xmm2, xmm3, dword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("C4E3697E8C2B8000000060"        , vfnmsubss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("C4E3697E8C2B8000000060"        , vfnmsubss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), xmm6));
}

static void ASMJIT_NOINLINE test_x64_assembler_xop(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("8FE97881CA"                    , vfrczpd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978818C1A80000000"          , vfrczpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978818C1A80000000"          , vfrczpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97C81CA"                    , vfrczpd(ymm1, ymm2));
  TEST_INSTRUCTION("8FE97C818C1A80000000"          , vfrczpd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97C818C1A80000000"          , vfrczpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97880CA"                    , vfrczps(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978808C1A80000000"          , vfrczps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978808C1A80000000"          , vfrczps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97C80CA"                    , vfrczps(ymm1, ymm2));
  TEST_INSTRUCTION("8FE97C808C1A80000000"          , vfrczps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97C808C1A80000000"          , vfrczps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97883CA"                    , vfrczsd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978838C1A80000000"          , vfrczsd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978838C1A80000000"          , vfrczsd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE97882CA"                    , vfrczss(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978828C1A80000000"          , vfrczss(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978828C1A80000000"          , vfrczss(xmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE868A2CB40"                  , vpcmov(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8E8A28C358000000030"        , vpcmov(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE8E8A28C358000000030"        , vpcmov(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE868A28C2B8000000060"        , vpcmov(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868A28C2B8000000060"        , vpcmov(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86CA2CB40"                  , vpcmov(ymm1, ymm2, ymm3, ymm4));
  TEST_INSTRUCTION("8FE8ECA28C358000000030"        , vpcmov(ymm1, ymm2, ymm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE8ECA28C358000000030"        , vpcmov(ymm1, ymm2, ymm3, ymmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE86CA28C2B8000000060"        , vpcmov(ymm1, ymm2, ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("8FE86CA28C2B8000000060"        , vpcmov(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), ymm6));
  TEST_INSTRUCTION("8FE868CCCB01"                  , vpcomb(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868CC8C2B8000000001"        , vpcomb(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CC8C2B8000000001"        , vpcomb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CECB01"                  , vpcomd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868CE8C2B8000000001"        , vpcomd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CE8C2B8000000001"        , vpcomd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CFCB01"                  , vpcomq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868CF8C2B8000000001"        , vpcomq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CF8C2B8000000001"        , vpcomq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868ECCB01"                  , vpcomub(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868EC8C2B8000000001"        , vpcomub(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EC8C2B8000000001"        , vpcomub(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EECB01"                  , vpcomud(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868EE8C2B8000000001"        , vpcomud(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EE8C2B8000000001"        , vpcomud(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EFCB01"                  , vpcomuq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868EF8C2B8000000001"        , vpcomuq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EF8C2B8000000001"        , vpcomuq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868EDCB01"                  , vpcomuw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868ED8C2B8000000001"        , vpcomuw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868ED8C2B8000000001"        , vpcomuw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CDCB01"                  , vpcomw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("8FE868CD8C2B8000000001"        , vpcomw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE868CD8C2B8000000001"        , vpcomw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("8FE978C2CA"                    , vphaddbd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978C28C1A80000000"          , vphaddbd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C28C1A80000000"          , vphaddbd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C3CA"                    , vphaddbq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978C38C1A80000000"          , vphaddbq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C38C1A80000000"          , vphaddbq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C1CA"                    , vphaddbw(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978C18C1A80000000"          , vphaddbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C18C1A80000000"          , vphaddbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978CBCA"                    , vphadddq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978CB8C1A80000000"          , vphadddq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978CB8C1A80000000"          , vphadddq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D2CA"                    , vphaddubd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978D28C1A80000000"          , vphaddubd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D28C1A80000000"          , vphaddubd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D3CA"                    , vphaddubq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978D38C1A80000000"          , vphaddubq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D38C1A80000000"          , vphaddubq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D1CA"                    , vphaddubw(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978D18C1A80000000"          , vphaddubw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D18C1A80000000"          , vphaddubw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978DBCA"                    , vphaddudq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978DB8C1A80000000"          , vphaddudq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978DB8C1A80000000"          , vphaddudq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D6CA"                    , vphadduwd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978D68C1A80000000"          , vphadduwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D68C1A80000000"          , vphadduwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D7CA"                    , vphadduwq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978D78C1A80000000"          , vphadduwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978D78C1A80000000"          , vphadduwq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C6CA"                    , vphaddwd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978C68C1A80000000"          , vphaddwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C68C1A80000000"          , vphaddwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C7CA"                    , vphaddwq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978C78C1A80000000"          , vphaddwq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978C78C1A80000000"          , vphaddwq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E1CA"                    , vphsubbw(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978E18C1A80000000"          , vphsubbw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E18C1A80000000"          , vphsubbw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E3CA"                    , vphsubdq(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978E38C1A80000000"          , vphsubdq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E38C1A80000000"          , vphsubdq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E2CA"                    , vphsubwd(xmm1, xmm2));
  TEST_INSTRUCTION("8FE978E28C1A80000000"          , vphsubwd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE978E28C1A80000000"          , vphsubwd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("8FE8689ECB40"                  , vpmacsdd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8689E8C2B8000000060"        , vpmacsdd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8689E8C2B8000000060"        , vpmacsdd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8689FCB40"                  , vpmacsdqh(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8689F8C2B8000000060"        , vpmacsdqh(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8689F8C2B8000000060"        , vpmacsdqh(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86897CB40"                  , vpmacsdql(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868978C2B8000000060"        , vpmacsdql(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868978C2B8000000060"        , vpmacsdql(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8688ECB40"                  , vpmacssdd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8688E8C2B8000000060"        , vpmacssdd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8688E8C2B8000000060"        , vpmacssdd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8688FCB40"                  , vpmacssdqh(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8688F8C2B8000000060"        , vpmacssdqh(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE8688F8C2B8000000060"        , vpmacssdqh(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86887CB40"                  , vpmacssdql(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868878C2B8000000060"        , vpmacssdql(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868878C2B8000000060"        , vpmacssdql(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86886CB40"                  , vpmacsswd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868868C2B8000000060"        , vpmacsswd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868868C2B8000000060"        , vpmacsswd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86885CB40"                  , vpmacssww(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868858C2B8000000060"        , vpmacssww(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868858C2B8000000060"        , vpmacssww(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86896CB40"                  , vpmacswd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868968C2B8000000060"        , vpmacswd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868968C2B8000000060"        , vpmacswd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE86895CB40"                  , vpmacsww(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868958C2B8000000060"        , vpmacsww(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868958C2B8000000060"        , vpmacsww(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868A6CB40"                  , vpmadcsswd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868A68C2B8000000060"        , vpmadcsswd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868A68C2B8000000060"        , vpmadcsswd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868B6CB40"                  , vpmadcswd(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE868B68C2B8000000060"        , vpmadcswd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868B68C2B8000000060"        , vpmadcswd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868A3CB40"                  , vpperm(xmm1, xmm2, xmm3, xmm4));
  TEST_INSTRUCTION("8FE8E8A38C358000000030"        , vpperm(xmm1, xmm2, xmm3, ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE8E8A38C358000000030"        , vpperm(xmm1, xmm2, xmm3, xmmword_ptr(rbp, rsi, 0, 128)));
  TEST_INSTRUCTION("8FE868A38C2B8000000060"        , vpperm(xmm1, xmm2, ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE868A38C2B8000000060"        , vpperm(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), xmm6));
  TEST_INSTRUCTION("8FE96090CA"                    , vprotb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE878C0CA01"                  , vprotb(xmm1, xmm2, 1));
  TEST_INSTRUCTION("8FE9E8908C2B80000000"          , vprotb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8908C2B80000000"          , vprotb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958908C1A80000000"          , vprotb(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C08C1A8000000001"        , vprotb(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE958908C1A80000000"          , vprotb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C08C1A8000000001"        , vprotb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE96092CA"                    , vprotd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE878C2CA01"                  , vprotd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("8FE9E8928C2B80000000"          , vprotd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8928C2B80000000"          , vprotd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958928C1A80000000"          , vprotd(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C28C1A8000000001"        , vprotd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE958928C1A80000000"          , vprotd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C28C1A8000000001"        , vprotd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE96093CA"                    , vprotq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE878C3CA01"                  , vprotq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("8FE9E8938C2B80000000"          , vprotq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8938C2B80000000"          , vprotq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958938C1A80000000"          , vprotq(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C38C1A8000000001"        , vprotq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE958938C1A80000000"          , vprotq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C38C1A8000000001"        , vprotq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE96091CA"                    , vprotw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE878C1CA01"                  , vprotw(xmm1, xmm2, 1));
  TEST_INSTRUCTION("8FE9E8918C2B80000000"          , vprotw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8918C2B80000000"          , vprotw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958918C1A80000000"          , vprotw(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C18C1A8000000001"        , vprotw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE958918C1A80000000"          , vprotw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE878C18C1A8000000001"        , vprotw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("8FE96098CA"                    , vpshab(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8988C2B80000000"          , vpshab(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8988C2B80000000"          , vpshab(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958988C1A80000000"          , vpshab(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958988C1A80000000"          , vpshab(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE9609ACA"                    , vpshad(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E89A8C2B80000000"          , vpshad(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E89A8C2B80000000"          , vpshad(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9589A8C1A80000000"          , vpshad(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE9589A8C1A80000000"          , vpshad(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE9609BCA"                    , vpshaq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E89B8C2B80000000"          , vpshaq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E89B8C2B80000000"          , vpshaq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9589B8C1A80000000"          , vpshaq(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE9589B8C1A80000000"          , vpshaq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE96099CA"                    , vpshaw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8998C2B80000000"          , vpshaw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8998C2B80000000"          , vpshaw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958998C1A80000000"          , vpshaw(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958998C1A80000000"          , vpshaw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE96094CA"                    , vpshlb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8948C2B80000000"          , vpshlb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8948C2B80000000"          , vpshlb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958948C1A80000000"          , vpshlb(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958948C1A80000000"          , vpshlb(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE96096CA"                    , vpshld(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8968C2B80000000"          , vpshld(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8968C2B80000000"          , vpshld(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958968C1A80000000"          , vpshld(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958968C1A80000000"          , vpshld(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE96097CA"                    , vpshlq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8978C2B80000000"          , vpshlq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8978C2B80000000"          , vpshlq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958978C1A80000000"          , vpshlq(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958978C1A80000000"          , vpshlq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE96095CA"                    , vpshlw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("8FE9E8958C2B80000000"          , vpshlw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE9E8958C2B80000000"          , vpshlw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("8FE958958C1A80000000"          , vpshlw(xmm1, ptr(rdx, rbx, 0, 128), xmm4));
  TEST_INSTRUCTION("8FE958958C1A80000000"          , vpshlw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), xmm4));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx512(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("C5ED4ACB"                      , kaddb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED4ACB"                    , kaddd(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC4ACB"                    , kaddq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC4ACB"                      , kaddw(k1, k2, k3));
  TEST_INSTRUCTION("C5ED41CB"                      , kandb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED41CB"                    , kandd(k1, k2, k3));
  TEST_INSTRUCTION("C5ED42CB"                      , kandnb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED42CB"                    , kandnd(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC42CB"                    , kandnq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC42CB"                      , kandnw(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC41CB"                    , kandq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC41CB"                      , kandw(k1, k2, k3));
  TEST_INSTRUCTION("C5F992CA"                      , kmovb(k1, edx));
  TEST_INSTRUCTION("C5F990CA"                      , kmovb(k1, k2));
  TEST_INSTRUCTION("C5F9908C1A80000000"            , kmovb(k1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F9908C1A80000000"            , kmovb(k1, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F993CA"                      , kmovb(ecx, k2));
  TEST_INSTRUCTION("C5F9919C1180000000"            , kmovb(ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C5F9919C1180000000"            , kmovb(byte_ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C5FB92CA"                      , kmovd(k1, edx));
  TEST_INSTRUCTION("C4E1F990CA"                    , kmovd(k1, k2));
  TEST_INSTRUCTION("C4E1F9908C1A80000000"          , kmovd(k1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1F9908C1A80000000"          , kmovd(k1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5FB93CA"                      , kmovd(ecx, k2));
  TEST_INSTRUCTION("C4E1F9919C1180000000"          , kmovd(ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C4E1F9919C1180000000"          , kmovd(dword_ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C4E1FB92CA"                    , kmovq(k1, rdx));
  TEST_INSTRUCTION("C4E1F890CA"                    , kmovq(k1, k2));
  TEST_INSTRUCTION("C4E1F8908C1A80000000"          , kmovq(k1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1F8908C1A80000000"          , kmovq(k1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C4E1FB93CA"                    , kmovq(rcx, k2));
  TEST_INSTRUCTION("C4E1F8919C1180000000"          , kmovq(ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C4E1F8919C1180000000"          , kmovq(qword_ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C5F892CA"                      , kmovw(k1, edx));
  TEST_INSTRUCTION("C5F890CA"                      , kmovw(k1, k2));
  TEST_INSTRUCTION("C5F8908C1A80000000"            , kmovw(k1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F8908C1A80000000"            , kmovw(k1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("C5F893CA"                      , kmovw(ecx, k2));
  TEST_INSTRUCTION("C5F8919C1180000000"            , kmovw(ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C5F8919C1180000000"            , kmovw(word_ptr(rcx, rdx, 0, 128), k3));
  TEST_INSTRUCTION("C5F944CA"                      , knotb(k1, k2));
  TEST_INSTRUCTION("C4E1F944CA"                    , knotd(k1, k2));
  TEST_INSTRUCTION("C4E1F844CA"                    , knotq(k1, k2));
  TEST_INSTRUCTION("C5F844CA"                      , knotw(k1, k2));
  TEST_INSTRUCTION("C5ED45CB"                      , korb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED45CB"                    , kord(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC45CB"                    , korq(k1, k2, k3));
  TEST_INSTRUCTION("C5F998CA"                      , kortestb(k1, k2));
  TEST_INSTRUCTION("C4E1F998CA"                    , kortestd(k1, k2));
  TEST_INSTRUCTION("C4E1F898CA"                    , kortestq(k1, k2));
  TEST_INSTRUCTION("C5F898CA"                      , kortestw(k1, k2));
  TEST_INSTRUCTION("C5EC45CB"                      , korw(k1, k2, k3));
  TEST_INSTRUCTION("C4E37932CA01"                  , kshiftlb(k1, k2, 1));
  TEST_INSTRUCTION("C4E37933CA01"                  , kshiftld(k1, k2, 1));
  TEST_INSTRUCTION("C4E3F933CA01"                  , kshiftlq(k1, k2, 1));
  TEST_INSTRUCTION("C4E3F932CA01"                  , kshiftlw(k1, k2, 1));
  TEST_INSTRUCTION("C4E37930CA01"                  , kshiftrb(k1, k2, 1));
  TEST_INSTRUCTION("C4E37931CA01"                  , kshiftrd(k1, k2, 1));
  TEST_INSTRUCTION("C4E3F931CA01"                  , kshiftrq(k1, k2, 1));
  TEST_INSTRUCTION("C4E3F930CA01"                  , kshiftrw(k1, k2, 1));
  TEST_INSTRUCTION("C5F999CA"                      , ktestb(k1, k2));
  TEST_INSTRUCTION("C4E1F999CA"                    , ktestd(k1, k2));
  TEST_INSTRUCTION("C4E1F899CA"                    , ktestq(k1, k2));
  TEST_INSTRUCTION("C5F899CA"                      , ktestw(k1, k2));
  TEST_INSTRUCTION("C5ED4BCB"                      , kunpckbw(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC4BCB"                    , kunpckdq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC4BCB"                      , kunpckwd(k1, k2, k3));
  TEST_INSTRUCTION("C5ED46CB"                      , kxnorb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED46CB"                    , kxnord(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC46CB"                    , kxnorq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC46CB"                      , kxnorw(k1, k2, k3));
  TEST_INSTRUCTION("C5ED47CB"                      , kxorb(k1, k2, k3));
  TEST_INSTRUCTION("C4E1ED47CB"                    , kxord(k1, k2, k3));
  TEST_INSTRUCTION("C4E1EC47CB"                    , kxorq(k1, k2, k3));
  TEST_INSTRUCTION("C5EC47CB"                      , kxorw(k1, k2, k3));
  TEST_INSTRUCTION("62F1ED4858CB"                  , vaddpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48584C2B02"              , vaddpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48584C2B02"              , vaddpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4858CB"                  , vaddps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48584C2B02"              , vaddps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48584C2B02"              , vaddps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DECB"                  , vaesdec(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48DE4C2B02"              , vaesdec(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DE4C2B02"              , vaesdec(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DFCB"                  , vaesdeclast(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48DF4C2B02"              , vaesdeclast(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DF4C2B02"              , vaesdeclast(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DCCB"                  , vaesenc(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48DC4C2B02"              , vaesenc(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DC4C2B02"              , vaesenc(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DDCB"                  , vaesenclast(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48DD4C2B02"              , vaesenclast(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48DD4C2B02"              , vaesenclast(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F36D0803CB01"                , valignd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08034C2B0801"            , valignd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08034C2B0801"            , valignd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2803CB01"                , valignd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28034C2B0401"            , valignd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28034C2B0401"            , valignd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4803CB01"                , valignd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48034C2B0201"            , valignd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48034C2B0201"            , valignd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0803CB01"                , valignq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08034C2B0801"            , valignq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08034C2B0801"            , valignq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2803CB01"                , valignq(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28034C2B0401"            , valignq(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28034C2B0401"            , valignq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4803CB01"                , valignq(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48034C2B0201"            , valignq(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48034C2B0201"            , valignq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED4855CB"                  , vandnpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48554C2B02"              , vandnpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48554C2B02"              , vandnpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4855CB"                  , vandnps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48554C2B02"              , vandnps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48554C2B02"              , vandnps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED4854CB"                  , vandpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48544C2B02"              , vandpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48544C2B02"              , vandpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4854CB"                  , vandps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48544C2B02"              , vandps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48544C2B02"              , vandps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0865CB"                  , vblendmpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08654C2B08"              , vblendmpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08654C2B08"              , vblendmpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2865CB"                  , vblendmpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28654C2B04"              , vblendmpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28654C2B04"              , vblendmpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4865CB"                  , vblendmpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48654C2B02"              , vblendmpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48654C2B02"              , vblendmpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0865CB"                  , vblendmps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08654C2B08"              , vblendmps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08654C2B08"              , vblendmps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2865CB"                  , vblendmps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28654C2B04"              , vblendmps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28654C2B04"              , vblendmps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4865CB"                  , vblendmps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48654C2B02"              , vblendmps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48654C2B02"              , vblendmps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27D2819CA"                  , vbroadcastf32x2(ymm1, xmm2));
  TEST_INSTRUCTION("62F27D28194C1A10"              , vbroadcastf32x2(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28194C1A10"              , vbroadcastf32x2(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4819CA"                  , vbroadcastf32x2(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48194C1A10"              , vbroadcastf32x2(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48194C1A10"              , vbroadcastf32x2(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D281A4C1A08"              , vbroadcastf32x4(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D281A4C1A08"              , vbroadcastf32x4(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481A4C1A08"              , vbroadcastf32x4(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481A4C1A08"              , vbroadcastf32x4(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481B4C1A04"              , vbroadcastf32x8(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481B4C1A04"              , vbroadcastf32x8(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD281A4C1A08"              , vbroadcastf64x2(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD281A4C1A08"              , vbroadcastf64x2(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481A4C1A08"              , vbroadcastf64x2(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481A4C1A08"              , vbroadcastf64x2(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481B4C1A04"              , vbroadcastf64x4(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481B4C1A04"              , vbroadcastf64x4(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D0859CA"                  , vbroadcasti32x2(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08594C1A10"              , vbroadcasti32x2(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08594C1A10"              , vbroadcasti32x2(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2859CA"                  , vbroadcasti32x2(ymm1, xmm2));
  TEST_INSTRUCTION("62F27D28594C1A10"              , vbroadcasti32x2(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28594C1A10"              , vbroadcasti32x2(ymm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4859CA"                  , vbroadcasti32x2(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48594C1A10"              , vbroadcasti32x2(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48594C1A10"              , vbroadcasti32x2(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D285A4C1A08"              , vbroadcasti32x4(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D285A4C1A08"              , vbroadcasti32x4(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D485A4C1A08"              , vbroadcasti32x4(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D485A4C1A08"              , vbroadcasti32x4(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D485B4C1A04"              , vbroadcasti32x8(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D485B4C1A04"              , vbroadcasti32x8(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD285A4C1A08"              , vbroadcasti64x2(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD285A4C1A08"              , vbroadcasti64x2(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD485A4C1A08"              , vbroadcasti64x2(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD485A4C1A08"              , vbroadcasti64x2(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD485B4C1A04"              , vbroadcasti64x4(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD485B4C1A04"              , vbroadcasti64x4(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4819CA"                  , vbroadcastsd(zmm1, xmm2));
  TEST_INSTRUCTION("62F2FD48194C1A10"              , vbroadcastsd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48194C1A10"              , vbroadcastsd(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4818CA"                  , vbroadcastss(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48184C1A20"              , vbroadcastss(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48184C1A20"              , vbroadcastss(zmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1ED08C2CB01"                , vcmppd(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F1ED08C24C2B0801"            , vcmppd(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED08C24C2B0801"            , vcmppd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED28C2CB01"                , vcmppd(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F1ED28C24C2B0401"            , vcmppd(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED28C24C2B0401"            , vcmppd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48C2CB01"                , vcmppd(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F1ED48C24C2B0201"            , vcmppd(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48C24C2B0201"            , vcmppd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C08C2CB01"                , vcmpps(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F16C08C24C2B0801"            , vcmpps(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C08C24C2B0801"            , vcmpps(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C28C2CB01"                , vcmpps(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F16C28C24C2B0401"            , vcmpps(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C28C24C2B0401"            , vcmpps(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C48C2CB01"                , vcmpps(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F16C48C24C2B0201"            , vcmpps(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C48C24C2B0201"            , vcmpps(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1EF08C2CB01"                , vcmpsd(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F1EF08C24C2B1001"            , vcmpsd(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1EF08C24C2B1001"            , vcmpsd(k1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16E08C2CB01"                , vcmpss(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F16E08C24C2B2001"            , vcmpss(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16E08C24C2B2001"            , vcmpss(k1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F2FD088AD1"                  , vcompresspd(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD088A5C1110"              , vcompresspd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD088A5C1110"              , vcompresspd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD288AD1"                  , vcompresspd(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD288A5C1110"              , vcompresspd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD288A5C1110"              , vcompresspd(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD488AD1"                  , vcompresspd(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD488A5C1110"              , vcompresspd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD488A5C1110"              , vcompresspd(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D088AD1"                  , vcompressps(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D088A5C1120"              , vcompressps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D088A5C1120"              , vcompressps(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D288AD1"                  , vcompressps(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D288A5C1120"              , vcompressps(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D288A5C1120"              , vcompressps(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D488AD1"                  , vcompressps(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D488A5C1120"              , vcompressps(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D488A5C1120"              , vcompressps(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17E48E6CA"                  , vcvtdq2pd(zmm1, ymm2));
  TEST_INSTRUCTION("62F17E48E64C1A04"              , vcvtdq2pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E48E64C1A04"              , vcvtdq2pd(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C485BCA"                  , vcvtdq2ps(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C485B4C1A02"              , vcvtdq2ps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C485B4C1A02"              , vcvtdq2ps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F26F0872CB"                  , vcvtne2ps2bf16(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26F08724C2B08"              , vcvtne2ps2bf16(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26F08724C2B08"              , vcvtne2ps2bf16(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26F2872CB"                  , vcvtne2ps2bf16(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26F28724C2B04"              , vcvtne2ps2bf16(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26F28724C2B04"              , vcvtne2ps2bf16(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26F4872CB"                  , vcvtne2ps2bf16(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26F48724C2B02"              , vcvtne2ps2bf16(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26F48724C2B02"              , vcvtne2ps2bf16(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27E0872CA"                  , vcvtneps2bf16(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E2872CA"                  , vcvtneps2bf16(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E08724C1A08"              , vcvtneps2bf16(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27E28724C1A04"              , vcvtneps2bf16(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27E4872CA"                  , vcvtneps2bf16(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48724C1A02"              , vcvtneps2bf16(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF48E6CA"                  , vcvtpd2dq(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FF48E64C1A02"              , vcvtpd2dq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF48E64C1A02"              , vcvtpd2dq(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD485ACA"                  , vcvtpd2ps(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FD485A4C1A02"              , vcvtpd2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD485A4C1A02"              , vcvtpd2ps(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD087BCA"                  , vcvtpd2qq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FD087B4C1A08"              , vcvtpd2qq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD087B4C1A08"              , vcvtpd2qq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD287BCA"                  , vcvtpd2qq(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FD287B4C1A04"              , vcvtpd2qq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD287B4C1A04"              , vcvtpd2qq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD487BCA"                  , vcvtpd2qq(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD487B4C1A02"              , vcvtpd2qq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD487B4C1A02"              , vcvtpd2qq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC0879CA"                  , vcvtpd2udq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FC2879CA"                  , vcvtpd2udq(xmm1, ymm2));
  TEST_INSTRUCTION("62F1FC08794C1A08"              , vcvtpd2udq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC28794C1A04"              , vcvtpd2udq(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC4879CA"                  , vcvtpd2udq(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FC48794C1A02"              , vcvtpd2udq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC48794C1A02"              , vcvtpd2udq(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD0879CA"                  , vcvtpd2uqq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FD08794C1A08"              , vcvtpd2uqq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD08794C1A08"              , vcvtpd2uqq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD2879CA"                  , vcvtpd2uqq(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FD28794C1A04"              , vcvtpd2uqq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD28794C1A04"              , vcvtpd2uqq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD4879CA"                  , vcvtpd2uqq(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD48794C1A02"              , vcvtpd2uqq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48794C1A02"              , vcvtpd2uqq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4813CA"                  , vcvtph2ps(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48134C1A04"              , vcvtph2ps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48134C1A04"              , vcvtph2ps(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D485BCA"                  , vcvtps2dq(zmm1, zmm2));
  TEST_INSTRUCTION("62F17D485B4C1A02"              , vcvtps2dq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D485B4C1A02"              , vcvtps2dq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C485ACA"                  , vcvtps2pd(zmm1, ymm2));
  TEST_INSTRUCTION("62F17C485A4C1A04"              , vcvtps2pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C485A4C1A04"              , vcvtps2pd(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F37D481DD101"                , vcvtps2ph(ymm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D481D5C110401"            , vcvtps2ph(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D481D5C110401"            , vcvtps2ph(ymmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F17D087BCA"                  , vcvtps2qq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17D087B4C1A10"              , vcvtps2qq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D087B4C1A10"              , vcvtps2qq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D287BCA"                  , vcvtps2qq(ymm1, xmm2));
  TEST_INSTRUCTION("62F17D287B4C1A08"              , vcvtps2qq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D287B4C1A08"              , vcvtps2qq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D487BCA"                  , vcvtps2qq(zmm1, ymm2));
  TEST_INSTRUCTION("62F17D487B4C1A04"              , vcvtps2qq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D487B4C1A04"              , vcvtps2qq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C0879CA"                  , vcvtps2udq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17C08794C1A08"              , vcvtps2udq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C08794C1A08"              , vcvtps2udq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C2879CA"                  , vcvtps2udq(ymm1, ymm2));
  TEST_INSTRUCTION("62F17C28794C1A04"              , vcvtps2udq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C28794C1A04"              , vcvtps2udq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C4879CA"                  , vcvtps2udq(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C48794C1A02"              , vcvtps2udq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48794C1A02"              , vcvtps2udq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D0879CA"                  , vcvtps2uqq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17D08794C1A10"              , vcvtps2uqq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D08794C1A10"              , vcvtps2uqq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D2879CA"                  , vcvtps2uqq(ymm1, xmm2));
  TEST_INSTRUCTION("62F17D28794C1A08"              , vcvtps2uqq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D28794C1A08"              , vcvtps2uqq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D4879CA"                  , vcvtps2uqq(zmm1, ymm2));
  TEST_INSTRUCTION("62F17D48794C1A04"              , vcvtps2uqq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D48794C1A04"              , vcvtps2uqq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE08E6CA"                  , vcvtqq2pd(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FE08E64C1A08"              , vcvtqq2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE08E64C1A08"              , vcvtqq2pd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE28E6CA"                  , vcvtqq2pd(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FE28E64C1A04"              , vcvtqq2pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE28E64C1A04"              , vcvtqq2pd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE48E6CA"                  , vcvtqq2pd(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FE48E64C1A02"              , vcvtqq2pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE48E64C1A02"              , vcvtqq2pd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC085BCA"                  , vcvtqq2ps(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FC285BCA"                  , vcvtqq2ps(xmm1, ymm2));
  TEST_INSTRUCTION("62F1FC085B4C1A08"              , vcvtqq2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC285B4C1A04"              , vcvtqq2ps(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC485BCA"                  , vcvtqq2ps(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FC485B4C1A02"              , vcvtqq2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC485B4C1A02"              , vcvtqq2ps(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F0879CA"                  , vcvtsd2usi(ecx, xmm2));
  TEST_INSTRUCTION("62F17F08794C1A10"              , vcvtsd2usi(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F08794C1A10"              , vcvtsd2usi(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF0879CA"                  , vcvtsd2usi(rcx, xmm2));
  TEST_INSTRUCTION("62F1FF08794C1A10"              , vcvtsd2usi(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF08794C1A10"              , vcvtsd2usi(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E0879CA"                  , vcvtss2usi(ecx, xmm2));
  TEST_INSTRUCTION("62F17E08794C1A20"              , vcvtss2usi(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E08794C1A20"              , vcvtss2usi(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE0879CA"                  , vcvtss2usi(rcx, xmm2));
  TEST_INSTRUCTION("62F1FE08794C1A20"              , vcvtss2usi(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE08794C1A20"              , vcvtss2usi(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48E6CA"                  , vcvttpd2dq(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FD48E64C1A02"              , vcvttpd2dq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48E64C1A02"              , vcvttpd2dq(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD087ACA"                  , vcvttpd2qq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FD087A4C1A08"              , vcvttpd2qq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD087A4C1A08"              , vcvttpd2qq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD287ACA"                  , vcvttpd2qq(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FD287A4C1A04"              , vcvttpd2qq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD287A4C1A04"              , vcvttpd2qq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD487ACA"                  , vcvttpd2qq(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD487A4C1A02"              , vcvttpd2qq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD487A4C1A02"              , vcvttpd2qq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC0878CA"                  , vcvttpd2udq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FC2878CA"                  , vcvttpd2udq(xmm1, ymm2));
  TEST_INSTRUCTION("62F1FC08784C1A08"              , vcvttpd2udq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC28784C1A04"              , vcvttpd2udq(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC4878CA"                  , vcvttpd2udq(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FC48784C1A02"              , vcvttpd2udq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FC48784C1A02"              , vcvttpd2udq(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD0878CA"                  , vcvttpd2uqq(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FD08784C1A08"              , vcvttpd2uqq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD08784C1A08"              , vcvttpd2uqq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD2878CA"                  , vcvttpd2uqq(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FD28784C1A04"              , vcvttpd2uqq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD28784C1A04"              , vcvttpd2uqq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD4878CA"                  , vcvttpd2uqq(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD48784C1A02"              , vcvttpd2uqq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48784C1A02"              , vcvttpd2uqq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E485BCA"                  , vcvttps2dq(zmm1, zmm2));
  TEST_INSTRUCTION("62F17E485B4C1A02"              , vcvttps2dq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E485B4C1A02"              , vcvttps2dq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D087ACA"                  , vcvttps2qq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17D087A4C1A10"              , vcvttps2qq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D087A4C1A10"              , vcvttps2qq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D287ACA"                  , vcvttps2qq(ymm1, xmm2));
  TEST_INSTRUCTION("62F17D287A4C1A08"              , vcvttps2qq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D287A4C1A08"              , vcvttps2qq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D487ACA"                  , vcvttps2qq(zmm1, ymm2));
  TEST_INSTRUCTION("62F17D487A4C1A04"              , vcvttps2qq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D487A4C1A04"              , vcvttps2qq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C0878CA"                  , vcvttps2udq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17C08784C1A08"              , vcvttps2udq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C08784C1A08"              , vcvttps2udq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C2878CA"                  , vcvttps2udq(ymm1, ymm2));
  TEST_INSTRUCTION("62F17C28784C1A04"              , vcvttps2udq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C28784C1A04"              , vcvttps2udq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C4878CA"                  , vcvttps2udq(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C48784C1A02"              , vcvttps2udq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48784C1A02"              , vcvttps2udq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D0878CA"                  , vcvttps2uqq(xmm1, xmm2));
  TEST_INSTRUCTION("62F17D08784C1A10"              , vcvttps2uqq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D08784C1A10"              , vcvttps2uqq(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D2878CA"                  , vcvttps2uqq(ymm1, xmm2));
  TEST_INSTRUCTION("62F17D28784C1A08"              , vcvttps2uqq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D28784C1A08"              , vcvttps2uqq(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D4878CA"                  , vcvttps2uqq(zmm1, ymm2));
  TEST_INSTRUCTION("62F17D48784C1A04"              , vcvttps2uqq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D48784C1A04"              , vcvttps2uqq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F0878CA"                  , vcvttsd2usi(ecx, xmm2));
  TEST_INSTRUCTION("62F17F08784C1A10"              , vcvttsd2usi(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F08784C1A10"              , vcvttsd2usi(ecx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF0878CA"                  , vcvttsd2usi(rcx, xmm2));
  TEST_INSTRUCTION("62F1FF08784C1A10"              , vcvttsd2usi(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF08784C1A10"              , vcvttsd2usi(rcx, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E0878CA"                  , vcvttss2usi(ecx, xmm2));
  TEST_INSTRUCTION("62F17E08784C1A20"              , vcvttss2usi(ecx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E08784C1A20"              , vcvttss2usi(ecx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE0878CA"                  , vcvttss2usi(rcx, xmm2));
  TEST_INSTRUCTION("62F1FE08784C1A20"              , vcvttss2usi(rcx, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE08784C1A20"              , vcvttss2usi(rcx, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E087ACA"                  , vcvtudq2pd(xmm1, xmm2));
  TEST_INSTRUCTION("62F17E087A4C1A10"              , vcvtudq2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E087A4C1A10"              , vcvtudq2pd(xmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E287ACA"                  , vcvtudq2pd(ymm1, xmm2));
  TEST_INSTRUCTION("62F17E287A4C1A08"              , vcvtudq2pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E287A4C1A08"              , vcvtudq2pd(ymm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E487ACA"                  , vcvtudq2pd(zmm1, ymm2));
  TEST_INSTRUCTION("62F17E487A4C1A04"              , vcvtudq2pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E487A4C1A04"              , vcvtudq2pd(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F087ACA"                  , vcvtudq2ps(xmm1, xmm2));
  TEST_INSTRUCTION("62F17F087A4C1A08"              , vcvtudq2ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F087A4C1A08"              , vcvtudq2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F287ACA"                  , vcvtudq2ps(ymm1, ymm2));
  TEST_INSTRUCTION("62F17F287A4C1A04"              , vcvtudq2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F287A4C1A04"              , vcvtudq2ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F487ACA"                  , vcvtudq2ps(zmm1, zmm2));
  TEST_INSTRUCTION("62F17F487A4C1A02"              , vcvtudq2ps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F487A4C1A02"              , vcvtudq2ps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE087ACA"                  , vcvtuqq2pd(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FE087A4C1A08"              , vcvtuqq2pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE087A4C1A08"              , vcvtuqq2pd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE287ACA"                  , vcvtuqq2pd(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FE287A4C1A04"              , vcvtuqq2pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE287A4C1A04"              , vcvtuqq2pd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE487ACA"                  , vcvtuqq2pd(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FE487A4C1A02"              , vcvtuqq2pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE487A4C1A02"              , vcvtuqq2pd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF087ACA"                  , vcvtuqq2ps(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FF287ACA"                  , vcvtuqq2ps(xmm1, ymm2));
  TEST_INSTRUCTION("62F1FF087A4C1A08"              , vcvtuqq2ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF287A4C1A04"              , vcvtuqq2ps(xmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF487ACA"                  , vcvtuqq2ps(ymm1, zmm2));
  TEST_INSTRUCTION("62F1FF487A4C1A02"              , vcvtuqq2ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF487A4C1A02"              , vcvtuqq2ps(ymm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F16F087BCB"                  , vcvtusi2sd(xmm1, xmm2, ebx));
  TEST_INSTRUCTION("62F1EF087BCB"                  , vcvtusi2sd(xmm1, xmm2, rbx));
  TEST_INSTRUCTION("62F16F087B4C2B20"              , vcvtusi2sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16F087B4C2B20"              , vcvtusi2sd(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1EF087B4C2B10"              , vcvtusi2sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16E087BCB"                  , vcvtusi2ss(xmm1, xmm2, ebx));
  TEST_INSTRUCTION("62F1EE087BCB"                  , vcvtusi2ss(xmm1, xmm2, rbx));
  TEST_INSTRUCTION("62F16E087B4C2B20"              , vcvtusi2ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16E087B4C2B20"              , vcvtusi2ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1EE087B4C2B10"              , vcvtusi2ss(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F36D0842CB01"                , vdbpsadbw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08424C2B0801"            , vdbpsadbw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08424C2B0801"            , vdbpsadbw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2842CB01"                , vdbpsadbw(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28424C2B0401"            , vdbpsadbw(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28424C2B0401"            , vdbpsadbw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4842CB01"                , vdbpsadbw(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48424C2B0201"            , vdbpsadbw(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48424C2B0201"            , vdbpsadbw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C485ECB"                  , vdivps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C485E4C2B02"              , vdivps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485E4C2B02"              , vdivps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E0852CB"                  , vdpbf16ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26E08524C2B08"              , vdpbf16ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E08524C2B08"              , vdpbf16ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E2852CB"                  , vdpbf16ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26E28524C2B04"              , vdpbf16ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E28524C2B04"              , vdpbf16ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E4852CB"                  , vdpbf16ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26E48524C2B02"              , vdpbf16ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E48524C2B02"              , vdpbf16ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485ECB"                  , vdivpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED485E4C2B02"              , vdivpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485E4C2B02"              , vdivpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2FD0888CA"                  , vexpandpd(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08884C1A10"              , vexpandpd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08884C1A10"              , vexpandpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2888CA"                  , vexpandpd(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28884C1A10"              , vexpandpd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28884C1A10"              , vexpandpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4888CA"                  , vexpandpd(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48884C1A10"              , vexpandpd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48884C1A10"              , vexpandpd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D0888CA"                  , vexpandps(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08884C1A20"              , vexpandps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08884C1A20"              , vexpandps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2888CA"                  , vexpandps(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28884C1A20"              , vexpandps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28884C1A20"              , vexpandps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4888CA"                  , vexpandps(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48884C1A20"              , vexpandps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48884C1A20"              , vexpandps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F37D2819D101"                , vextractf32x4(xmm1, ymm2, 1));
  TEST_INSTRUCTION("62F37D4819D101"                , vextractf32x4(xmm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D28195C110801"            , vextractf32x4(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F37D48195C110801"            , vextractf32x4(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D28195C110801"            , vextractf32x4(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F37D48195C110801"            , vextractf32x4(xmmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D481BD101"                , vextractf32x8(ymm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D481B5C110401"            , vextractf32x8(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D481B5C110401"            , vextractf32x8(ymmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD2819D101"                , vextractf64x2(xmm1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD4819D101"                , vextractf64x2(xmm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD28195C110801"            , vextractf64x2(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F3FD48195C110801"            , vextractf64x2(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD28195C110801"            , vextractf64x2(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F3FD48195C110801"            , vextractf64x2(xmmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD481BD101"                , vextractf64x4(ymm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD481B5C110401"            , vextractf64x4(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD481B5C110401"            , vextractf64x4(ymmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D2839D101"                , vextracti32x4(xmm1, ymm2, 1));
  TEST_INSTRUCTION("62F37D4839D101"                , vextracti32x4(xmm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D28395C110801"            , vextracti32x4(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F37D48395C110801"            , vextracti32x4(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D28395C110801"            , vextracti32x4(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F37D48395C110801"            , vextracti32x4(xmmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D483BD101"                , vextracti32x8(ymm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D483B5C110401"            , vextracti32x8(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F37D483B5C110401"            , vextracti32x8(ymmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD2839D101"                , vextracti64x2(xmm1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD4839D101"                , vextracti64x2(xmm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD28395C110801"            , vextracti64x2(ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F3FD48395C110801"            , vextracti64x2(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD28395C110801"            , vextracti64x2(xmmword_ptr(rcx, rdx, 0, 128), ymm3, 1));
  TEST_INSTRUCTION("62F3FD48395C110801"            , vextracti64x2(xmmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD483BD101"                , vextracti64x4(ymm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD483B5C110401"            , vextracti64x4(ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3FD483B5C110401"            , vextracti64x4(ymmword_ptr(rcx, rdx, 0, 128), zmm3, 1));
  TEST_INSTRUCTION("62F3ED0854CB01"                , vfixupimmpd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08544C2B0801"            , vfixupimmpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08544C2B0801"            , vfixupimmpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2854CB01"                , vfixupimmpd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28544C2B0401"            , vfixupimmpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28544C2B0401"            , vfixupimmpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4854CB01"                , vfixupimmpd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48544C2B0201"            , vfixupimmpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48544C2B0201"            , vfixupimmpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0854CB01"                , vfixupimmps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08544C2B0801"            , vfixupimmps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08544C2B0801"            , vfixupimmps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2854CB01"                , vfixupimmps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28544C2B0401"            , vfixupimmps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28544C2B0401"            , vfixupimmps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4854CB01"                , vfixupimmps(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48544C2B0201"            , vfixupimmps(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48544C2B0201"            , vfixupimmps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0855CB01"                , vfixupimmsd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08554C2B1001"            , vfixupimmsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08554C2B1001"            , vfixupimmsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0855CB01"                , vfixupimmss(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08554C2B2001"            , vfixupimmss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08554C2B2001"            , vfixupimmss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F2ED4898CB"                  , vfmadd132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48984C2B02"              , vfmadd132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48984C2B02"              , vfmadd132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4898CB"                  , vfmadd132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48984C2B02"              , vfmadd132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48984C2B02"              , vfmadd132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A8CB"                  , vfmadd213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48A84C2B02"              , vfmadd213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A84C2B02"              , vfmadd213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A8CB"                  , vfmadd213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48A84C2B02"              , vfmadd213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A84C2B02"              , vfmadd213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B8CB"                  , vfmadd231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48B84C2B02"              , vfmadd231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B84C2B02"              , vfmadd231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B8CB"                  , vfmadd231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48B84C2B02"              , vfmadd231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B84C2B02"              , vfmadd231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4896CB"                  , vfmaddsub132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48964C2B02"              , vfmaddsub132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48964C2B02"              , vfmaddsub132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4896CB"                  , vfmaddsub132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48964C2B02"              , vfmaddsub132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48964C2B02"              , vfmaddsub132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A6CB"                  , vfmaddsub213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48A64C2B02"              , vfmaddsub213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A64C2B02"              , vfmaddsub213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A6CB"                  , vfmaddsub213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48A64C2B02"              , vfmaddsub213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A64C2B02"              , vfmaddsub213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B6CB"                  , vfmaddsub231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48B64C2B02"              , vfmaddsub231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B64C2B02"              , vfmaddsub231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B6CB"                  , vfmaddsub231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48B64C2B02"              , vfmaddsub231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B64C2B02"              , vfmaddsub231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489ACB"                  , vfmsub132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED489A4C2B02"              , vfmsub132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489A4C2B02"              , vfmsub132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489ACB"                  , vfmsub132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D489A4C2B02"              , vfmsub132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489A4C2B02"              , vfmsub132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48AACB"                  , vfmsub213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48AA4C2B02"              , vfmsub213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48AA4C2B02"              , vfmsub213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48AACB"                  , vfmsub213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48AA4C2B02"              , vfmsub213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48AA4C2B02"              , vfmsub213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BACB"                  , vfmsub231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48BA4C2B02"              , vfmsub231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BA4C2B02"              , vfmsub231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BACB"                  , vfmsub231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48BA4C2B02"              , vfmsub231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BA4C2B02"              , vfmsub231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4897CB"                  , vfmsubadd132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48974C2B02"              , vfmsubadd132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48974C2B02"              , vfmsubadd132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4897CB"                  , vfmsubadd132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48974C2B02"              , vfmsubadd132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48974C2B02"              , vfmsubadd132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A7CB"                  , vfmsubadd213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48A74C2B02"              , vfmsubadd213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48A74C2B02"              , vfmsubadd213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A7CB"                  , vfmsubadd213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48A74C2B02"              , vfmsubadd213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48A74C2B02"              , vfmsubadd213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B7CB"                  , vfmsubadd231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48B74C2B02"              , vfmsubadd231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B74C2B02"              , vfmsubadd231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B7CB"                  , vfmsubadd231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48B74C2B02"              , vfmsubadd231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48B74C2B02"              , vfmsubadd231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489CCB"                  , vfnmadd132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED489C4C2B02"              , vfnmadd132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489C4C2B02"              , vfnmadd132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489CCB"                  , vfnmadd132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D489C4C2B02"              , vfnmadd132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489C4C2B02"              , vfnmadd132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48ACCB"                  , vfnmadd213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48AC4C2B02"              , vfnmadd213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48AC4C2B02"              , vfnmadd213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48ACCB"                  , vfnmadd213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48AC4C2B02"              , vfnmadd213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48AC4C2B02"              , vfnmadd213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BCCB"                  , vfnmadd231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48BC4C2B02"              , vfnmadd231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BC4C2B02"              , vfnmadd231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BCCB"                  , vfnmadd231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48BC4C2B02"              , vfnmadd231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BC4C2B02"              , vfnmadd231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489ECB"                  , vfnmsub132pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED489E4C2B02"              , vfnmsub132pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED489E4C2B02"              , vfnmsub132pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489ECB"                  , vfnmsub132ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D489E4C2B02"              , vfnmsub132ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D489E4C2B02"              , vfnmsub132ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48AECB"                  , vfnmsub213pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48AE4C2B02"              , vfnmsub213pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48AE4C2B02"              , vfnmsub213pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48AECB"                  , vfnmsub213ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48AE4C2B02"              , vfnmsub213ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48AE4C2B02"              , vfnmsub213ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BECB"                  , vfnmsub231pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48BE4C2B02"              , vfnmsub231pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48BE4C2B02"              , vfnmsub231pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BECB"                  , vfnmsub231ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48BE4C2B02"              , vfnmsub231ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48BE4C2B02"              , vfnmsub231ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD0866CA01"                , vfpclasspd(k1, xmm2, 1));
  TEST_INSTRUCTION("62F3FD2866CA01"                , vfpclasspd(k1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD4866CA01"                , vfpclasspd(k1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD08664C1A0801"            , vfpclasspd(k1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD28664C1A0401"            , vfpclasspd(k1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48664C1A0201"            , vfpclasspd(k1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D0866CA01"                , vfpclassps(k1, xmm2, 1));
  TEST_INSTRUCTION("62F37D2866CA01"                , vfpclassps(k1, ymm2, 1));
  TEST_INSTRUCTION("62F37D4866CA01"                , vfpclassps(k1, zmm2, 1));
  TEST_INSTRUCTION("62F37D08664C1A0801"            , vfpclassps(k1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D28664C1A0401"            , vfpclassps(k1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D48664C1A0201"            , vfpclassps(k1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD0867CA01"                , vfpclasssd(k1, xmm2, 1));
  TEST_INSTRUCTION("62F3FD08674C1A1001"            , vfpclasssd(k1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD08674C1A1001"            , vfpclasssd(k1, qword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D0867CA01"                , vfpclassss(k1, xmm2, 1));
  TEST_INSTRUCTION("62F37D08674C1A2001"            , vfpclassss(k1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D08674C1A2001"            , vfpclassss(k1, dword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F2FD09924C1A10"              , k(k1).vgatherdpd(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD29924C1A10"              , k(k1).vgatherdpd(ymm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD49924C1A10"              , k(k1).vgatherdpd(zmm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D09924C1A20"              , k(k1).vgatherdps(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D29924C1A20"              , k(k1).vgatherdps(ymm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D49924C1A20"              , k(k1).vgatherdps(zmm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD09934C1A10"              , k(k1).vgatherqpd(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD29934C1A10"              , k(k1).vgatherqpd(ymm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD49934C1A10"              , k(k1).vgatherqpd(zmm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D09934C1A20"              , k(k1).vgatherqps(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D29934C1A20"              , k(k1).vgatherqps(xmm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D49934C1A20"              , k(k1).vgatherqps(ymm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD0842CA"                  , vgetexppd(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08424C1A08"              , vgetexppd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08424C1A08"              , vgetexppd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2842CA"                  , vgetexppd(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28424C1A04"              , vgetexppd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28424C1A04"              , vgetexppd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4842CA"                  , vgetexppd(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48424C1A02"              , vgetexppd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48424C1A02"              , vgetexppd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D0842CA"                  , vgetexpps(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08424C1A08"              , vgetexpps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08424C1A08"              , vgetexpps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2842CA"                  , vgetexpps(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28424C1A04"              , vgetexpps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28424C1A04"              , vgetexpps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4842CA"                  , vgetexpps(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48424C1A02"              , vgetexpps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48424C1A02"              , vgetexpps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2ED0843CB"                  , vgetexpsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08434C2B10"              , vgetexpsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08434C2B10"              , vgetexpsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0843CB"                  , vgetexpss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08434C2B20"              , vgetexpss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08434C2B20"              , vgetexpss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD0826CA01"                , vgetmantpd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F3FD08264C1A0801"            , vgetmantpd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD08264C1A0801"            , vgetmantpd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD2826CA01"                , vgetmantpd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD28264C1A0401"            , vgetmantpd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD28264C1A0401"            , vgetmantpd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD4826CA01"                , vgetmantpd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD48264C1A0201"            , vgetmantpd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48264C1A0201"            , vgetmantpd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D0826CA01"                , vgetmantps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F37D08264C1A0801"            , vgetmantps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D08264C1A0801"            , vgetmantps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D2826CA01"                , vgetmantps(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F37D28264C1A0401"            , vgetmantps(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D28264C1A0401"            , vgetmantps(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D4826CA01"                , vgetmantps(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D48264C1A0201"            , vgetmantps(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D48264C1A0201"            , vgetmantps(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0827CB01"                , vgetmantsd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08274C2B1001"            , vgetmantsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08274C2B1001"            , vgetmantsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0827CB01"                , vgetmantss(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08274C2B2001"            , vgetmantss(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08274C2B2001"            , vgetmantss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48CFCB01"                , vgf2p8affineinvqb(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48CF4C2B0201"            , vgf2p8affineinvqb(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48CF4C2B0201"            , vgf2p8affineinvqb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48CECB01"                , vgf2p8affineqb(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48CE4C2B0201"            , vgf2p8affineqb(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48CE4C2B0201"            , vgf2p8affineqb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F26D48CFCB"                  , vgf2p8mulb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48CF4C2B02"              , vgf2p8mulb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48CF4C2B02"              , vgf2p8mulb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F36D2818CB01"                , vinsertf32x4(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D28184C2B0801"            , vinsertf32x4(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28184C2B0801"            , vinsertf32x4(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4818CB01"                , vinsertf32x4(zmm1, zmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D48184C2B0801"            , vinsertf32x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48184C2B0801"            , vinsertf32x4(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481ACB01"                , vinsertf32x8(zmm1, zmm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D481A4C2B0401"            , vinsertf32x8(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481A4C2B0401"            , vinsertf32x8(zmm1, zmm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2818CB01"                , vinsertf64x2(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED28184C2B0801"            , vinsertf64x2(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28184C2B0801"            , vinsertf64x2(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4818CB01"                , vinsertf64x2(zmm1, zmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED48184C2B0801"            , vinsertf64x2(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48184C2B0801"            , vinsertf64x2(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481ACB01"                , vinsertf64x4(zmm1, zmm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED481A4C2B0401"            , vinsertf64x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481A4C2B0401"            , vinsertf64x4(zmm1, zmm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2838CB01"                , vinserti32x4(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D28384C2B0801"            , vinserti32x4(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28384C2B0801"            , vinserti32x4(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4838CB01"                , vinserti32x4(zmm1, zmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D48384C2B0801"            , vinserti32x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48384C2B0801"            , vinserti32x4(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483ACB01"                , vinserti32x8(zmm1, zmm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D483A4C2B0401"            , vinserti32x8(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483A4C2B0401"            , vinserti32x8(zmm1, zmm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2838CB01"                , vinserti64x2(ymm1, ymm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED28384C2B0801"            , vinserti64x2(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28384C2B0801"            , vinserti64x2(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4838CB01"                , vinserti64x2(zmm1, zmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED48384C2B0801"            , vinserti64x2(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48384C2B0801"            , vinserti64x2(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483ACB01"                , vinserti64x4(zmm1, zmm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED483A4C2B0401"            , vinserti64x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483A4C2B0401"            , vinserti64x4(zmm1, zmm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED485FCB"                  , vmaxpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED485F4C2B02"              , vmaxpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485F4C2B02"              , vmaxpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485FCB"                  , vmaxps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C485F4C2B02"              , vmaxps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485F4C2B02"              , vmaxps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485DCB"                  , vminpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED485D4C2B02"              , vminpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485D4C2B02"              , vminpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485DCB"                  , vminps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C485D4C2B02"              , vminps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485D4C2B02"              , vminps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1FD4828CA"                  , vmovapd(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD48284C1A02"              , vmovapd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48284C1A02"              , vmovapd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48295C1102"              , vmovapd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FD48295C1102"              , vmovapd(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C4828CA"                  , vmovaps(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C48284C1A02"              , vmovaps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48284C1A02"              , vmovaps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48295C1102"              , vmovaps(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C48295C1102"              , vmovaps(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FF4812CA"                  , vmovddup(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FF48124C1A02"              , vmovddup(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF48124C1A02"              , vmovddup(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D086FCA"                  , vmovdqa32(xmm1, xmm2));
  TEST_INSTRUCTION("62F17D086F4C1A08"              , vmovdqa32(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D086F4C1A08"              , vmovdqa32(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D087F5C1108"              , vmovdqa32(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17D087F5C1108"              , vmovdqa32(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17D286FCA"                  , vmovdqa32(ymm1, ymm2));
  TEST_INSTRUCTION("62F17D286F4C1A04"              , vmovdqa32(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D286F4C1A04"              , vmovdqa32(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D287F5C1104"              , vmovdqa32(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17D287F5C1104"              , vmovdqa32(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17D486FCA"                  , vmovdqa32(zmm1, zmm2));
  TEST_INSTRUCTION("62F17D486F4C1A02"              , vmovdqa32(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D486F4C1A02"              , vmovdqa32(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17D487F5C1102"              , vmovdqa32(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17D487F5C1102"              , vmovdqa32(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FD086FCA"                  , vmovdqa64(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FD086F4C1A08"              , vmovdqa64(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD086F4C1A08"              , vmovdqa64(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD087F5C1108"              , vmovdqa64(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FD087F5C1108"              , vmovdqa64(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FD286FCA"                  , vmovdqa64(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FD286F4C1A04"              , vmovdqa64(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD286F4C1A04"              , vmovdqa64(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD287F5C1104"              , vmovdqa64(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FD287F5C1104"              , vmovdqa64(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FD486FCA"                  , vmovdqa64(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD486F4C1A02"              , vmovdqa64(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD486F4C1A02"              , vmovdqa64(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD487F5C1102"              , vmovdqa64(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FD487F5C1102"              , vmovdqa64(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FF086FCA"                  , vmovdqu16(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FF086F4C1A08"              , vmovdqu16(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF086F4C1A08"              , vmovdqu16(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF087F5C1108"              , vmovdqu16(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FF087F5C1108"              , vmovdqu16(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FF286FCA"                  , vmovdqu16(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FF286F4C1A04"              , vmovdqu16(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF286F4C1A04"              , vmovdqu16(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF287F5C1104"              , vmovdqu16(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FF287F5C1104"              , vmovdqu16(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FF486FCA"                  , vmovdqu16(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FF486F4C1A02"              , vmovdqu16(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF486F4C1A02"              , vmovdqu16(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FF487F5C1102"              , vmovdqu16(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FF487F5C1102"              , vmovdqu16(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17E086FCA"                  , vmovdqu32(xmm1, xmm2));
  TEST_INSTRUCTION("62F17E086F4C1A08"              , vmovdqu32(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E086F4C1A08"              , vmovdqu32(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E087F5C1108"              , vmovdqu32(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17E087F5C1108"              , vmovdqu32(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17E286FCA"                  , vmovdqu32(ymm1, ymm2));
  TEST_INSTRUCTION("62F17E286F4C1A04"              , vmovdqu32(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E286F4C1A04"              , vmovdqu32(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E287F5C1104"              , vmovdqu32(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17E287F5C1104"              , vmovdqu32(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17E486FCA"                  , vmovdqu32(zmm1, zmm2));
  TEST_INSTRUCTION("62F17E486F4C1A02"              , vmovdqu32(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E486F4C1A02"              , vmovdqu32(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E487F5C1102"              , vmovdqu32(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17E487F5C1102"              , vmovdqu32(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FE086FCA"                  , vmovdqu64(xmm1, xmm2));
  TEST_INSTRUCTION("62F1FE086F4C1A08"              , vmovdqu64(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE086F4C1A08"              , vmovdqu64(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE087F5C1108"              , vmovdqu64(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FE087F5C1108"              , vmovdqu64(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F1FE286FCA"                  , vmovdqu64(ymm1, ymm2));
  TEST_INSTRUCTION("62F1FE286F4C1A04"              , vmovdqu64(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE286F4C1A04"              , vmovdqu64(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE287F5C1104"              , vmovdqu64(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FE287F5C1104"              , vmovdqu64(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F1FE486FCA"                  , vmovdqu64(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FE486F4C1A02"              , vmovdqu64(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE486F4C1A02"              , vmovdqu64(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FE487F5C1102"              , vmovdqu64(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FE487F5C1102"              , vmovdqu64(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17F086FCA"                  , vmovdqu8(xmm1, xmm2));
  TEST_INSTRUCTION("62F17F086F4C1A08"              , vmovdqu8(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F086F4C1A08"              , vmovdqu8(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F087F5C1108"              , vmovdqu8(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17F087F5C1108"              , vmovdqu8(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F17F286FCA"                  , vmovdqu8(ymm1, ymm2));
  TEST_INSTRUCTION("62F17F286F4C1A04"              , vmovdqu8(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F286F4C1A04"              , vmovdqu8(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F287F5C1104"              , vmovdqu8(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17F287F5C1104"              , vmovdqu8(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17F486FCA"                  , vmovdqu8(zmm1, zmm2));
  TEST_INSTRUCTION("62F17F486F4C1A02"              , vmovdqu8(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F486F4C1A02"              , vmovdqu8(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17F487F5C1102"              , vmovdqu8(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17F487F5C1102"              , vmovdqu8(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17D48E75C1102"              , vmovntdq(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17D48E75C1102"              , vmovntdq(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D482A4C1A02"              , vmovntdqa(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D482A4C1A02"              , vmovntdqa(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD482B5C1102"              , vmovntpd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FD482B5C1102"              , vmovntpd(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C482B5C1102"              , vmovntps(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C482B5C1102"              , vmovntps(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("C5F82B9C1180000000"            , vmovntps(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5F82B9C1180000000"            , vmovntps(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("C5FC2B9C1180000000"            , vmovntps(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("C5FC2B9C1180000000"            , vmovntps(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F17E4816CA"                  , vmovshdup(zmm1, zmm2));
  TEST_INSTRUCTION("62F17E48164C1A02"              , vmovshdup(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E48164C1A02"              , vmovshdup(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E4812CA"                  , vmovsldup(zmm1, zmm2));
  TEST_INSTRUCTION("62F17E48124C1A02"              , vmovsldup(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17E48124C1A02"              , vmovsldup(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD4810CA"                  , vmovupd(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD48104C1A02"              , vmovupd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48104C1A02"              , vmovupd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48115C1102"              , vmovupd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1FD48115C1102"              , vmovupd(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C4810CA"                  , vmovups(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C48104C1A02"              , vmovups(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48104C1A02"              , vmovups(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48115C1102"              , vmovups(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F17C48115C1102"              , vmovups(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F1ED4859CB"                  , vmulpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48594C2B02"              , vmulpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48594C2B02"              , vmulpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4859CB"                  , vmulps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48594C2B02"              , vmulps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48594C2B02"              , vmulps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED4856CB"                  , vorpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48564C2B02"              , vorpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48564C2B02"              , vorpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4856CB"                  , vorps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48564C2B02"              , vorps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48564C2B02"              , vorps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F25F0868D1"                  , vp2intersectd(k2, k3, xmm4, xmm1));
  TEST_INSTRUCTION("62F25F0868541108"              , vp2intersectd(k2, k3, xmm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F25F0868541108"              , vp2intersectd(k2, k3, xmm4, xmmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F25F2868D1"                  , vp2intersectd(k2, k3, ymm4, ymm1));
  TEST_INSTRUCTION("62F25F2868541104"              , vp2intersectd(k2, k3, ymm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F25F2868541104"              , vp2intersectd(k2, k3, ymm4, ymmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F25F4868D1"                  , vp2intersectd(k2, k3, zmm4, zmm1));
  TEST_INSTRUCTION("62F25F4868541102"              , vp2intersectd(k2, k3, zmm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F25F4868541102"              , vp2intersectd(k2, k3, zmm4, zmmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF0868D1"                  , vp2intersectq(k2, k3, xmm4, xmm1));
  TEST_INSTRUCTION("62F2DF0868541108"              , vp2intersectq(k2, k3, xmm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF0868541108"              , vp2intersectq(k2, k3, xmm4, xmmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF2868D1"                  , vp2intersectq(k2, k3, ymm4, ymm1));
  TEST_INSTRUCTION("62F2DF2868541104"              , vp2intersectq(k2, k3, ymm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF2868541104"              , vp2intersectq(k2, k3, ymm4, ymmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF4868D1"                  , vp2intersectq(k2, k3, zmm4, zmm1));
  TEST_INSTRUCTION("62F2DF4868541102"              , vp2intersectq(k2, k3, zmm4, ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F2DF4868541102"              , vp2intersectq(k2, k3, zmm4, zmmword_ptr(rcx, rdx, 0, 128)));
  TEST_INSTRUCTION("62F27D481CCA"                  , vpabsb(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D481C4C1A02"              , vpabsb(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481C4C1A02"              , vpabsb(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481ECA"                  , vpabsd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D481E4C1A02"              , vpabsd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481E4C1A02"              , vpabsd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD081FCA"                  , vpabsq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD081F4C1A08"              , vpabsq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD081F4C1A08"              , vpabsq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD281FCA"                  , vpabsq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD281F4C1A04"              , vpabsq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD281F4C1A04"              , vpabsq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481FCA"                  , vpabsq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD481F4C1A02"              , vpabsq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD481F4C1A02"              , vpabsq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481DCA"                  , vpabsw(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D481D4C1A02"              , vpabsw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D481D4C1A02"              , vpabsw(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F16D486BCB"                  , vpackssdw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D486B4C2B02"              , vpackssdw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D486B4C2B02"              , vpackssdw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4863CB"                  , vpacksswb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48634C2B02"              , vpacksswb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48634C2B02"              , vpacksswb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D482BCB"                  , vpackusdw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D482B4C2B02"              , vpackusdw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D482B4C2B02"              , vpackusdw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4867CB"                  , vpackuswb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48674C2B02"              , vpackuswb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48674C2B02"              , vpackuswb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FCCB"                  , vpaddb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48FC4C2B02"              , vpaddb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FC4C2B02"              , vpaddb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FECB"                  , vpaddd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48FE4C2B02"              , vpaddd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FE4C2B02"              , vpaddd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48D4CB"                  , vpaddq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48D44C2B02"              , vpaddq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48D44C2B02"              , vpaddq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48ECCB"                  , vpaddsb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48EC4C2B02"              , vpaddsb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EC4C2B02"              , vpaddsb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EDCB"                  , vpaddsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48ED4C2B02"              , vpaddsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48ED4C2B02"              , vpaddsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DCCB"                  , vpaddusb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DC4C2B02"              , vpaddusb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DC4C2B02"              , vpaddusb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DDCB"                  , vpaddusw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DD4C2B02"              , vpaddusw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DD4C2B02"              , vpaddusw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FDCB"                  , vpaddw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48FD4C2B02"              , vpaddw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FD4C2B02"              , vpaddw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F36D480FCB01"                , vpalignr(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D480F4C2B0201"            , vpalignr(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D480F4C2B0201"            , vpalignr(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16D08DBCB"                  , vpandd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08DB4C2B08"              , vpandd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08DB4C2B08"              , vpandd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28DBCB"                  , vpandd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28DB4C2B04"              , vpandd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28DB4C2B04"              , vpandd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DBCB"                  , vpandd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DB4C2B02"              , vpandd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DB4C2B02"              , vpandd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08DFCB"                  , vpandnd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08DF4C2B08"              , vpandnd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08DF4C2B08"              , vpandnd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28DFCB"                  , vpandnd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28DF4C2B04"              , vpandnd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28DF4C2B04"              , vpandnd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DFCB"                  , vpandnd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DF4C2B02"              , vpandnd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DF4C2B02"              , vpandnd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08DFCB"                  , vpandnq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F1ED08DF4C2B08"              , vpandnq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08DF4C2B08"              , vpandnq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28DFCB"                  , vpandnq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F1ED28DF4C2B04"              , vpandnq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28DF4C2B04"              , vpandnq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48DFCB"                  , vpandnq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48DF4C2B02"              , vpandnq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48DF4C2B02"              , vpandnq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08DBCB"                  , vpandq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F1ED08DB4C2B08"              , vpandq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08DB4C2B08"              , vpandq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28DBCB"                  , vpandq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F1ED28DB4C2B04"              , vpandq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28DB4C2B04"              , vpandq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48DBCB"                  , vpandq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48DB4C2B02"              , vpandq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48DB4C2B02"              , vpandq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E0CB"                  , vpavgb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E04C2B02"              , vpavgb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E04C2B02"              , vpavgb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E3CB"                  , vpavgw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E34C2B02"              , vpavgw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E34C2B02"              , vpavgw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0866CB"                  , vpblendmb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08664C2B08"              , vpblendmb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08664C2B08"              , vpblendmb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2866CB"                  , vpblendmb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28664C2B04"              , vpblendmb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28664C2B04"              , vpblendmb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4866CB"                  , vpblendmb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48664C2B02"              , vpblendmb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48664C2B02"              , vpblendmb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0864CB"                  , vpblendmd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08644C2B08"              , vpblendmd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08644C2B08"              , vpblendmd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2864CB"                  , vpblendmd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28644C2B04"              , vpblendmd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28644C2B04"              , vpblendmd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4864CB"                  , vpblendmd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48644C2B02"              , vpblendmd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48644C2B02"              , vpblendmd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0864CB"                  , vpblendmq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08644C2B08"              , vpblendmq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08644C2B08"              , vpblendmq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2864CB"                  , vpblendmq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28644C2B04"              , vpblendmq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28644C2B04"              , vpblendmq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4864CB"                  , vpblendmq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48644C2B02"              , vpblendmq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48644C2B02"              , vpblendmq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0866CB"                  , vpblendmw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08664C2B08"              , vpblendmw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08664C2B08"              , vpblendmw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2866CB"                  , vpblendmw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28664C2B04"              , vpblendmw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28664C2B04"              , vpblendmw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4866CB"                  , vpblendmw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48664C2B02"              , vpblendmw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48664C2B02"              , vpblendmw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27D087ACA"                  , vpbroadcastb(xmm1, edx));
  TEST_INSTRUCTION("62F27D287ACA"                  , vpbroadcastb(ymm1, edx));
  TEST_INSTRUCTION("62F27D487ACA"                  , vpbroadcastb(zmm1, edx));
  TEST_INSTRUCTION("62F27D4878CA"                  , vpbroadcastb(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48788C1A80000000"        , vpbroadcastb(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48788C1A80000000"        , vpbroadcastb(zmm1, byte_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D087CCA"                  , vpbroadcastd(xmm1, edx));
  TEST_INSTRUCTION("62F27D287CCA"                  , vpbroadcastd(ymm1, edx));
  TEST_INSTRUCTION("62F27D487CCA"                  , vpbroadcastd(zmm1, edx));
  TEST_INSTRUCTION("62F27D4858CA"                  , vpbroadcastd(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48584C1A20"              , vpbroadcastd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48584C1A20"              , vpbroadcastd(zmm1, dword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FE082ACA"                  , vpbroadcastmb2q(xmm1, k2));
  TEST_INSTRUCTION("62F2FE282ACA"                  , vpbroadcastmb2q(ymm1, k2));
  TEST_INSTRUCTION("62F2FE482ACA"                  , vpbroadcastmb2q(zmm1, k2));
  TEST_INSTRUCTION("62F27E083ACA"                  , vpbroadcastmw2d(xmm1, k2));
  TEST_INSTRUCTION("62F27E283ACA"                  , vpbroadcastmw2d(ymm1, k2));
  TEST_INSTRUCTION("62F27E483ACA"                  , vpbroadcastmw2d(zmm1, k2));
  TEST_INSTRUCTION("62F2FD087CCA"                  , vpbroadcastq(xmm1, rdx));
  TEST_INSTRUCTION("62F2FD287CCA"                  , vpbroadcastq(ymm1, rdx));
  TEST_INSTRUCTION("62F2FD487CCA"                  , vpbroadcastq(zmm1, rdx));
  TEST_INSTRUCTION("62F2FD4859CA"                  , vpbroadcastq(zmm1, xmm2));
  TEST_INSTRUCTION("62F2FD48594C1A10"              , vpbroadcastq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48594C1A10"              , vpbroadcastq(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D087BCA"                  , vpbroadcastw(xmm1, edx));
  TEST_INSTRUCTION("62F27D287BCA"                  , vpbroadcastw(ymm1, edx));
  TEST_INSTRUCTION("62F27D487BCA"                  , vpbroadcastw(zmm1, edx));
  TEST_INSTRUCTION("62F27D4879CA"                  , vpbroadcastw(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48794C1A40"              , vpbroadcastw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48794C1A40"              , vpbroadcastw(zmm1, word_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F36D4844CB01"                , vpclmulqdq(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48444C2B0201"            , vpclmulqdq(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48444C2B0201"            , vpclmulqdq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D083FCB01"                , vpcmpb(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D083F4C2B0801"            , vpcmpb(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D083F4C2B0801"            , vpcmpb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D283FCB01"                , vpcmpb(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D283F4C2B0401"            , vpcmpb(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D283F4C2B0401"            , vpcmpb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483FCB01"                , vpcmpb(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D483F4C2B0201"            , vpcmpb(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483F4C2B0201"            , vpcmpb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D081FCB01"                , vpcmpd(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D081F4C2B0801"            , vpcmpd(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D081F4C2B0801"            , vpcmpd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D281FCB01"                , vpcmpd(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D281F4C2B0401"            , vpcmpd(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D281F4C2B0401"            , vpcmpd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481FCB01"                , vpcmpd(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D481F4C2B0201"            , vpcmpd(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481F4C2B0201"            , vpcmpd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16D0874CB"                  , vpcmpeqb(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08744C2B08"              , vpcmpeqb(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08744C2B08"              , vpcmpeqb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2874CB"                  , vpcmpeqb(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28744C2B04"              , vpcmpeqb(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28744C2B04"              , vpcmpeqb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4874CB"                  , vpcmpeqb(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48744C2B02"              , vpcmpeqb(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48744C2B02"              , vpcmpeqb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D0876CB"                  , vpcmpeqd(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08764C2B08"              , vpcmpeqd(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08764C2B08"              , vpcmpeqd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2876CB"                  , vpcmpeqd(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28764C2B04"              , vpcmpeqd(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28764C2B04"              , vpcmpeqd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4876CB"                  , vpcmpeqd(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48764C2B02"              , vpcmpeqd(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48764C2B02"              , vpcmpeqd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0829CB"                  , vpcmpeqq(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08294C2B08"              , vpcmpeqq(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08294C2B08"              , vpcmpeqq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2829CB"                  , vpcmpeqq(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28294C2B04"              , vpcmpeqq(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28294C2B04"              , vpcmpeqq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4829CB"                  , vpcmpeqq(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48294C2B02"              , vpcmpeqq(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48294C2B02"              , vpcmpeqq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D0875CB"                  , vpcmpeqw(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08754C2B08"              , vpcmpeqw(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08754C2B08"              , vpcmpeqw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2875CB"                  , vpcmpeqw(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28754C2B04"              , vpcmpeqw(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28754C2B04"              , vpcmpeqw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4875CB"                  , vpcmpeqw(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48754C2B02"              , vpcmpeqw(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48754C2B02"              , vpcmpeqw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D0864CB"                  , vpcmpgtb(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08644C2B08"              , vpcmpgtb(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08644C2B08"              , vpcmpgtb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2864CB"                  , vpcmpgtb(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28644C2B04"              , vpcmpgtb(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28644C2B04"              , vpcmpgtb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4864CB"                  , vpcmpgtb(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48644C2B02"              , vpcmpgtb(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48644C2B02"              , vpcmpgtb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D0866CB"                  , vpcmpgtd(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08664C2B08"              , vpcmpgtd(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08664C2B08"              , vpcmpgtd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2866CB"                  , vpcmpgtd(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28664C2B04"              , vpcmpgtd(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28664C2B04"              , vpcmpgtd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4866CB"                  , vpcmpgtd(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48664C2B02"              , vpcmpgtd(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48664C2B02"              , vpcmpgtd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0837CB"                  , vpcmpgtq(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08374C2B08"              , vpcmpgtq(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08374C2B08"              , vpcmpgtq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2837CB"                  , vpcmpgtq(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28374C2B04"              , vpcmpgtq(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28374C2B04"              , vpcmpgtq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4837CB"                  , vpcmpgtq(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48374C2B02"              , vpcmpgtq(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48374C2B02"              , vpcmpgtq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D0865CB"                  , vpcmpgtw(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08654C2B08"              , vpcmpgtw(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08654C2B08"              , vpcmpgtw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D2865CB"                  , vpcmpgtw(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28654C2B04"              , vpcmpgtw(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28654C2B04"              , vpcmpgtw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4865CB"                  , vpcmpgtw(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48654C2B02"              , vpcmpgtw(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48654C2B02"              , vpcmpgtw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3ED081FCB01"                , vpcmpq(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED081F4C2B0801"            , vpcmpq(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED081F4C2B0801"            , vpcmpq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED281FCB01"                , vpcmpq(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED281F4C2B0401"            , vpcmpq(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED281F4C2B0401"            , vpcmpq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481FCB01"                , vpcmpq(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED481F4C2B0201"            , vpcmpq(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481F4C2B0201"            , vpcmpq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D083ECB01"                , vpcmpub(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D083E4C2B0801"            , vpcmpub(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D083E4C2B0801"            , vpcmpub(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D283ECB01"                , vpcmpub(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D283E4C2B0401"            , vpcmpub(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D283E4C2B0401"            , vpcmpub(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483ECB01"                , vpcmpub(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D483E4C2B0201"            , vpcmpub(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D483E4C2B0201"            , vpcmpub(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D081ECB01"                , vpcmpud(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D081E4C2B0801"            , vpcmpud(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D081E4C2B0801"            , vpcmpud(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D281ECB01"                , vpcmpud(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D281E4C2B0401"            , vpcmpud(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D281E4C2B0401"            , vpcmpud(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481ECB01"                , vpcmpud(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D481E4C2B0201"            , vpcmpud(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D481E4C2B0201"            , vpcmpud(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED081ECB01"                , vpcmpuq(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED081E4C2B0801"            , vpcmpuq(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED081E4C2B0801"            , vpcmpuq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED281ECB01"                , vpcmpuq(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED281E4C2B0401"            , vpcmpuq(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED281E4C2B0401"            , vpcmpuq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481ECB01"                , vpcmpuq(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED481E4C2B0201"            , vpcmpuq(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED481E4C2B0201"            , vpcmpuq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED083ECB01"                , vpcmpuw(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED083E4C2B0801"            , vpcmpuw(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED083E4C2B0801"            , vpcmpuw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED283ECB01"                , vpcmpuw(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED283E4C2B0401"            , vpcmpuw(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED283E4C2B0401"            , vpcmpuw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483ECB01"                , vpcmpuw(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED483E4C2B0201"            , vpcmpuw(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483E4C2B0201"            , vpcmpuw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED083FCB01"                , vpcmpw(k1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED083F4C2B0801"            , vpcmpw(k1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED083F4C2B0801"            , vpcmpw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED283FCB01"                , vpcmpw(k1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED283F4C2B0401"            , vpcmpw(k1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED283F4C2B0401"            , vpcmpw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483FCB01"                , vpcmpw(k1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED483F4C2B0201"            , vpcmpw(k1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED483F4C2B0201"            , vpcmpw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F27D0863D1"                  , vpcompressb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08639C1180000000"        , vpcompressb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D08639C1180000000"        , vpcompressb(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D2863D1"                  , vpcompressb(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28639C1180000000"        , vpcompressb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D28639C1180000000"        , vpcompressb(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D4863D1"                  , vpcompressb(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48639C1180000000"        , vpcompressb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D48639C1180000000"        , vpcompressb(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D088BD1"                  , vpcompressd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D088B5C1120"              , vpcompressd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D088B5C1120"              , vpcompressd(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D288BD1"                  , vpcompressd(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D288B5C1120"              , vpcompressd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D288B5C1120"              , vpcompressd(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D488BD1"                  , vpcompressd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D488B5C1120"              , vpcompressd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D488B5C1120"              , vpcompressd(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD088BD1"                  , vpcompressq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD088B5C1110"              , vpcompressq(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD088B5C1110"              , vpcompressq(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD288BD1"                  , vpcompressq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD288B5C1110"              , vpcompressq(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD288B5C1110"              , vpcompressq(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD488BD1"                  , vpcompressq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD488B5C1110"              , vpcompressq(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD488B5C1110"              , vpcompressq(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD0863D1"                  , vpcompressw(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08635C1140"              , vpcompressw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD08635C1140"              , vpcompressw(xmmword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD2863D1"                  , vpcompressw(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28635C1140"              , vpcompressw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD28635C1140"              , vpcompressw(ymmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD4863D1"                  , vpcompressw(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48635C1140"              , vpcompressw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD48635C1140"              , vpcompressw(zmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D08C4CA"                  , vpconflictd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08C44C1A08"              , vpconflictd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08C44C1A08"              , vpconflictd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28C4CA"                  , vpconflictd(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28C44C1A04"              , vpconflictd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28C44C1A04"              , vpconflictd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48C4CA"                  , vpconflictd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48C44C1A02"              , vpconflictd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48C44C1A02"              , vpconflictd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08C4CA"                  , vpconflictq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08C44C1A08"              , vpconflictq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08C44C1A08"              , vpconflictq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28C4CA"                  , vpconflictq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28C44C1A04"              , vpconflictq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28C44C1A04"              , vpconflictq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48C4CA"                  , vpconflictq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48C44C1A02"              , vpconflictq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48C44C1A02"              , vpconflictq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F26D0850CB"                  , vpdpbusd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08504C2B08"              , vpdpbusd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08504C2B08"              , vpdpbusd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2850CB"                  , vpdpbusd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28504C2B04"              , vpdpbusd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28504C2B04"              , vpdpbusd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4850CB"                  , vpdpbusd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48504C2B02"              , vpdpbusd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48504C2B02"              , vpdpbusd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0851CB"                  , vpdpbusds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08514C2B08"              , vpdpbusds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08514C2B08"              , vpdpbusds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2851CB"                  , vpdpbusds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28514C2B04"              , vpdpbusds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28514C2B04"              , vpdpbusds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4851CB"                  , vpdpbusds(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48514C2B02"              , vpdpbusds(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48514C2B02"              , vpdpbusds(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0852CB"                  , vpdpwssd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08524C2B08"              , vpdpwssd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08524C2B08"              , vpdpwssd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2852CB"                  , vpdpwssd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28524C2B04"              , vpdpwssd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28524C2B04"              , vpdpwssd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4852CB"                  , vpdpwssd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48524C2B02"              , vpdpwssd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48524C2B02"              , vpdpwssd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0853CB"                  , vpdpwssds(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08534C2B08"              , vpdpwssds(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08534C2B08"              , vpdpwssds(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2853CB"                  , vpdpwssds(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28534C2B04"              , vpdpwssds(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28534C2B04"              , vpdpwssds(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4853CB"                  , vpdpwssds(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48534C2B02"              , vpdpwssds(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48534C2B02"              , vpdpwssds(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D088DCB"                  , vpermb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D088D4C2B08"              , vpermb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D088D4C2B08"              , vpermb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D288DCB"                  , vpermb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D288D4C2B04"              , vpermb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D288D4C2B04"              , vpermb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D488DCB"                  , vpermb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D488D4C2B02"              , vpermb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D488D4C2B02"              , vpermb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4836CB"                  , vpermd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48364C2B02"              , vpermd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48364C2B02"              , vpermd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0875CB"                  , vpermi2b(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08754C2B08"              , vpermi2b(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08754C2B08"              , vpermi2b(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2875CB"                  , vpermi2b(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28754C2B04"              , vpermi2b(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28754C2B04"              , vpermi2b(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4875CB"                  , vpermi2b(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48754C2B02"              , vpermi2b(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48754C2B02"              , vpermi2b(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0876CB"                  , vpermi2d(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08764C2B08"              , vpermi2d(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08764C2B08"              , vpermi2d(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2876CB"                  , vpermi2d(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28764C2B04"              , vpermi2d(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28764C2B04"              , vpermi2d(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4876CB"                  , vpermi2d(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48764C2B02"              , vpermi2d(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48764C2B02"              , vpermi2d(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0877CB"                  , vpermi2pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08774C2B08"              , vpermi2pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08774C2B08"              , vpermi2pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2877CB"                  , vpermi2pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28774C2B04"              , vpermi2pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28774C2B04"              , vpermi2pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4877CB"                  , vpermi2pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48774C2B02"              , vpermi2pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48774C2B02"              , vpermi2pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0877CB"                  , vpermi2ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08774C2B08"              , vpermi2ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08774C2B08"              , vpermi2ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2877CB"                  , vpermi2ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28774C2B04"              , vpermi2ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28774C2B04"              , vpermi2ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4877CB"                  , vpermi2ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48774C2B02"              , vpermi2ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48774C2B02"              , vpermi2ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0876CB"                  , vpermi2q(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08764C2B08"              , vpermi2q(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08764C2B08"              , vpermi2q(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2876CB"                  , vpermi2q(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28764C2B04"              , vpermi2q(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28764C2B04"              , vpermi2q(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4876CB"                  , vpermi2q(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48764C2B02"              , vpermi2q(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48764C2B02"              , vpermi2q(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0875CB"                  , vpermi2w(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08754C2B08"              , vpermi2w(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08754C2B08"              , vpermi2w(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2875CB"                  , vpermi2w(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28754C2B04"              , vpermi2w(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28754C2B04"              , vpermi2w(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4875CB"                  , vpermi2w(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48754C2B02"              , vpermi2w(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48754C2B02"              , vpermi2w(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED480DCB"                  , vpermilpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F3FD4805CA01"                , vpermilpd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F2ED480D4C2B02"              , vpermilpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED480D4C2B02"              , vpermilpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD48054C1A0201"            , vpermilpd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48054C1A0201"            , vpermilpd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D480CCB"                  , vpermilps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F37D4804CA01"                , vpermilps(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F26D480C4C2B02"              , vpermilps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D480C4C2B02"              , vpermilps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F37D48044C1A0201"            , vpermilps(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D48044C1A0201"            , vpermilps(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F2ED2816CB"                  , vpermpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28164C2B04"              , vpermpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28164C2B04"              , vpermpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4816CB"                  , vpermpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F3FD4801CA01"                , vpermpd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F2ED48164C2B02"              , vpermpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48164C2B02"              , vpermpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD48014C1A0201"            , vpermpd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48014C1A0201"            , vpermpd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D4816CB"                  , vpermps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48164C2B02"              , vpermps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48164C2B02"              , vpermps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2836CB"                  , vpermq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28364C2B04"              , vpermq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28364C2B04"              , vpermq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4836CB"                  , vpermq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F3FD4800CA01"                , vpermq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F2ED48364C2B02"              , vpermq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48364C2B02"              , vpermq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD48004C1A0201"            , vpermq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48004C1A0201"            , vpermq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D087DCB"                  , vpermt2b(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D087D4C2B08"              , vpermt2b(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D087D4C2B08"              , vpermt2b(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287DCB"                  , vpermt2b(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D287D4C2B04"              , vpermt2b(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287D4C2B04"              , vpermt2b(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487DCB"                  , vpermt2b(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D487D4C2B02"              , vpermt2b(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487D4C2B02"              , vpermt2b(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D087ECB"                  , vpermt2d(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D087E4C2B08"              , vpermt2d(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D087E4C2B08"              , vpermt2d(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287ECB"                  , vpermt2d(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D287E4C2B04"              , vpermt2d(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287E4C2B04"              , vpermt2d(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487ECB"                  , vpermt2d(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D487E4C2B02"              , vpermt2d(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487E4C2B02"              , vpermt2d(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087FCB"                  , vpermt2pd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED087F4C2B08"              , vpermt2pd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087F4C2B08"              , vpermt2pd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287FCB"                  , vpermt2pd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED287F4C2B04"              , vpermt2pd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287F4C2B04"              , vpermt2pd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487FCB"                  , vpermt2pd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED487F4C2B02"              , vpermt2pd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487F4C2B02"              , vpermt2pd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D087FCB"                  , vpermt2ps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D087F4C2B08"              , vpermt2ps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D087F4C2B08"              , vpermt2ps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287FCB"                  , vpermt2ps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D287F4C2B04"              , vpermt2ps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D287F4C2B04"              , vpermt2ps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487FCB"                  , vpermt2ps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D487F4C2B02"              , vpermt2ps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D487F4C2B02"              , vpermt2ps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087ECB"                  , vpermt2q(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED087E4C2B08"              , vpermt2q(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087E4C2B08"              , vpermt2q(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287ECB"                  , vpermt2q(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED287E4C2B04"              , vpermt2q(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287E4C2B04"              , vpermt2q(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487ECB"                  , vpermt2q(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED487E4C2B02"              , vpermt2q(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487E4C2B02"              , vpermt2q(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087DCB"                  , vpermt2w(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED087D4C2B08"              , vpermt2w(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED087D4C2B08"              , vpermt2w(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287DCB"                  , vpermt2w(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED287D4C2B04"              , vpermt2w(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED287D4C2B04"              , vpermt2w(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487DCB"                  , vpermt2w(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED487D4C2B02"              , vpermt2w(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED487D4C2B02"              , vpermt2w(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED088DCB"                  , vpermw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED088D4C2B08"              , vpermw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED088D4C2B08"              , vpermw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED288DCB"                  , vpermw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED288D4C2B04"              , vpermw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED288D4C2B04"              , vpermw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED488DCB"                  , vpermw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED488D4C2B02"              , vpermw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED488D4C2B02"              , vpermw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27D0862CA"                  , vpexpandb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08628C1A80000000"        , vpexpandb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08628C1A80000000"        , vpexpandb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2862CA"                  , vpexpandb(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28628C1A80000000"        , vpexpandb(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28628C1A80000000"        , vpexpandb(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4862CA"                  , vpexpandb(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48628C1A80000000"        , vpexpandb(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48628C1A80000000"        , vpexpandb(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D0889CA"                  , vpexpandd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08894C1A20"              , vpexpandd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08894C1A20"              , vpexpandd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2889CA"                  , vpexpandd(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28894C1A20"              , vpexpandd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28894C1A20"              , vpexpandd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4889CA"                  , vpexpandd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48894C1A20"              , vpexpandd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48894C1A20"              , vpexpandd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD0889CA"                  , vpexpandq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08894C1A10"              , vpexpandq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08894C1A10"              , vpexpandq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2889CA"                  , vpexpandq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28894C1A10"              , vpexpandq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28894C1A10"              , vpexpandq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4889CA"                  , vpexpandq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48894C1A10"              , vpexpandq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48894C1A10"              , vpexpandq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD0862CA"                  , vpexpandw(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08624C1A40"              , vpexpandw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08624C1A40"              , vpexpandw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2862CA"                  , vpexpandw(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28624C1A40"              , vpexpandw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28624C1A40"              , vpexpandw(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4862CA"                  , vpexpandw(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48624C1A40"              , vpexpandw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48624C1A40"              , vpexpandw(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D09904C1A20"              , k(k1).vpgatherdd(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D29904C1A20"              , k(k1).vpgatherdd(ymm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D49904C1A20"              , k(k1).vpgatherdd(zmm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD09904C1A10"              , k(k1).vpgatherdq(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD29904C1A10"              , k(k1).vpgatherdq(ymm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD49904C1A10"              , k(k1).vpgatherdq(zmm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D09914C1A20"              , k(k1).vpgatherqd(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D29914C1A20"              , k(k1).vpgatherqd(xmm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F27D49914C1A20"              , k(k1).vpgatherqd(ymm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD09914C1A10"              , k(k1).vpgatherqq(xmm1, ptr(rdx, xmm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD29914C1A10"              , k(k1).vpgatherqq(ymm1, ptr(rdx, ymm3, 0, 128)));
  TEST_INSTRUCTION("62F2FD49914C1A10"              , k(k1).vpgatherqq(zmm1, ptr(rdx, zmm3, 0, 128)));
  TEST_INSTRUCTION("62F27D0844CA"                  , vplzcntd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08444C1A08"              , vplzcntd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08444C1A08"              , vplzcntd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2844CA"                  , vplzcntd(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28444C1A04"              , vplzcntd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28444C1A04"              , vplzcntd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4844CA"                  , vplzcntd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48444C1A02"              , vplzcntd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48444C1A02"              , vplzcntd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD0844CA"                  , vplzcntq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08444C1A08"              , vplzcntq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08444C1A08"              , vplzcntq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2844CA"                  , vplzcntq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28444C1A04"              , vplzcntq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28444C1A04"              , vplzcntq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4844CA"                  , vplzcntq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48444C1A02"              , vplzcntq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48444C1A02"              , vplzcntq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2ED08B5CB"                  , vpmadd52huq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08B54C2B08"              , vpmadd52huq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08B54C2B08"              , vpmadd52huq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28B5CB"                  , vpmadd52huq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28B54C2B04"              , vpmadd52huq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28B54C2B04"              , vpmadd52huq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B5CB"                  , vpmadd52huq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48B54C2B02"              , vpmadd52huq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B54C2B02"              , vpmadd52huq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08B4CB"                  , vpmadd52luq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08B44C2B08"              , vpmadd52luq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08B44C2B08"              , vpmadd52luq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28B4CB"                  , vpmadd52luq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28B44C2B04"              , vpmadd52luq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28B44C2B04"              , vpmadd52luq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B4CB"                  , vpmadd52luq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48B44C2B02"              , vpmadd52luq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48B44C2B02"              , vpmadd52luq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4804CB"                  , vpmaddubsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48044C2B02"              , vpmaddubsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48044C2B02"              , vpmaddubsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F5CB"                  , vpmaddwd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48F54C2B02"              , vpmaddwd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F54C2B02"              , vpmaddwd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483CCB"                  , vpmaxsb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483C4C2B02"              , vpmaxsb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483C4C2B02"              , vpmaxsb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483DCB"                  , vpmaxsd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483D4C2B02"              , vpmaxsd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483D4C2B02"              , vpmaxsd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083DCB"                  , vpmaxsq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED083D4C2B08"              , vpmaxsq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083D4C2B08"              , vpmaxsq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283DCB"                  , vpmaxsq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED283D4C2B04"              , vpmaxsq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283D4C2B04"              , vpmaxsq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483DCB"                  , vpmaxsq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED483D4C2B02"              , vpmaxsq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483D4C2B02"              , vpmaxsq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EECB"                  , vpmaxsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48EE4C2B02"              , vpmaxsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EE4C2B02"              , vpmaxsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DECB"                  , vpmaxub(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DE4C2B02"              , vpmaxub(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DE4C2B02"              , vpmaxub(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483FCB"                  , vpmaxud(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483F4C2B02"              , vpmaxud(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483F4C2B02"              , vpmaxud(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083FCB"                  , vpmaxuq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED083F4C2B08"              , vpmaxuq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083F4C2B08"              , vpmaxuq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283FCB"                  , vpmaxuq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED283F4C2B04"              , vpmaxuq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283F4C2B04"              , vpmaxuq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483FCB"                  , vpmaxuq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED483F4C2B02"              , vpmaxuq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483F4C2B02"              , vpmaxuq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483ECB"                  , vpmaxuw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483E4C2B02"              , vpmaxuw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483E4C2B02"              , vpmaxuw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4838CB"                  , vpminsb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48384C2B02"              , vpminsb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48384C2B02"              , vpminsb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4839CB"                  , vpminsd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48394C2B02"              , vpminsd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48394C2B02"              , vpminsd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0839CB"                  , vpminsq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08394C2B08"              , vpminsq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08394C2B08"              , vpminsq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2839CB"                  , vpminsq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28394C2B04"              , vpminsq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28394C2B04"              , vpminsq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4839CB"                  , vpminsq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48394C2B02"              , vpminsq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48394C2B02"              , vpminsq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EACB"                  , vpminsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48EA4C2B02"              , vpminsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EA4C2B02"              , vpminsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DACB"                  , vpminub(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48DA4C2B02"              , vpminub(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48DA4C2B02"              , vpminub(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483BCB"                  , vpminud(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483B4C2B02"              , vpminud(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483B4C2B02"              , vpminud(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083BCB"                  , vpminuq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED083B4C2B08"              , vpminuq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED083B4C2B08"              , vpminuq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283BCB"                  , vpminuq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED283B4C2B04"              , vpminuq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED283B4C2B04"              , vpminuq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483BCB"                  , vpminuq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED483B4C2B02"              , vpminuq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED483B4C2B02"              , vpminuq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483ACB"                  , vpminuw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D483A4C2B02"              , vpminuw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D483A4C2B02"              , vpminuw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27E0829CA"                  , vpmovb2m(k1, xmm2));
  TEST_INSTRUCTION("62F27E2829CA"                  , vpmovb2m(k1, ymm2));
  TEST_INSTRUCTION("62F27E4829CA"                  , vpmovb2m(k1, zmm2));
  TEST_INSTRUCTION("62F27E0839CA"                  , vpmovd2m(k1, xmm2));
  TEST_INSTRUCTION("62F27E2839CA"                  , vpmovd2m(k1, ymm2));
  TEST_INSTRUCTION("62F27E4839CA"                  , vpmovd2m(k1, zmm2));
  TEST_INSTRUCTION("62F27E0831D1"                  , vpmovdb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08315C1120"              , vpmovdb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08315C1120"              , vpmovdb(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2831D1"                  , vpmovdb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28315C1110"              , vpmovdb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28315C1110"              , vpmovdb(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4831D1"                  , vpmovdb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48315C1108"              , vpmovdb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48315C1108"              , vpmovdb(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0833D1"                  , vpmovdw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08335C1110"              , vpmovdw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08335C1110"              , vpmovdw(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2833D1"                  , vpmovdw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28335C1108"              , vpmovdw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28335C1108"              , vpmovdw(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4833D1"                  , vpmovdw(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48335C1104"              , vpmovdw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48335C1104"              , vpmovdw(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0828CA"                  , vpmovm2b(xmm1, k2));
  TEST_INSTRUCTION("62F27E2828CA"                  , vpmovm2b(ymm1, k2));
  TEST_INSTRUCTION("62F27E4828CA"                  , vpmovm2b(zmm1, k2));
  TEST_INSTRUCTION("62F27E0838CA"                  , vpmovm2d(xmm1, k2));
  TEST_INSTRUCTION("62F27E2838CA"                  , vpmovm2d(ymm1, k2));
  TEST_INSTRUCTION("62F27E4838CA"                  , vpmovm2d(zmm1, k2));
  TEST_INSTRUCTION("62F2FE0838CA"                  , vpmovm2q(xmm1, k2));
  TEST_INSTRUCTION("62F2FE2838CA"                  , vpmovm2q(ymm1, k2));
  TEST_INSTRUCTION("62F2FE4838CA"                  , vpmovm2q(zmm1, k2));
  TEST_INSTRUCTION("62F2FE0828CA"                  , vpmovm2w(xmm1, k2));
  TEST_INSTRUCTION("62F2FE2828CA"                  , vpmovm2w(ymm1, k2));
  TEST_INSTRUCTION("62F2FE4828CA"                  , vpmovm2w(zmm1, k2));
  TEST_INSTRUCTION("62F2FE0839CA"                  , vpmovq2m(k1, xmm2));
  TEST_INSTRUCTION("62F2FE2839CA"                  , vpmovq2m(k1, ymm2));
  TEST_INSTRUCTION("62F2FE4839CA"                  , vpmovq2m(k1, zmm2));
  TEST_INSTRUCTION("62F27E0832D1"                  , vpmovqb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08325C1140"              , vpmovqb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08325C1140"              , vpmovqb(word_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2832D1"                  , vpmovqb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28325C1120"              , vpmovqb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28325C1120"              , vpmovqb(dword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4832D1"                  , vpmovqb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48325C1110"              , vpmovqb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48325C1110"              , vpmovqb(qword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0835D1"                  , vpmovqd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08355C1110"              , vpmovqd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08355C1110"              , vpmovqd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2835D1"                  , vpmovqd(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28355C1108"              , vpmovqd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28355C1108"              , vpmovqd(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4835D1"                  , vpmovqd(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48355C1104"              , vpmovqd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48355C1104"              , vpmovqd(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0834D1"                  , vpmovqw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08345C1120"              , vpmovqw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08345C1120"              , vpmovqw(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2834D1"                  , vpmovqw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28345C1110"              , vpmovqw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28345C1110"              , vpmovqw(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4834D1"                  , vpmovqw(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48345C1108"              , vpmovqw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48345C1108"              , vpmovqw(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0821D1"                  , vpmovsdb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08215C1120"              , vpmovsdb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08215C1120"              , vpmovsdb(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2821D1"                  , vpmovsdb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28215C1110"              , vpmovsdb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28215C1110"              , vpmovsdb(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4821D1"                  , vpmovsdb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48215C1108"              , vpmovsdb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48215C1108"              , vpmovsdb(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0823D1"                  , vpmovsdw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08235C1110"              , vpmovsdw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08235C1110"              , vpmovsdw(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2823D1"                  , vpmovsdw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28235C1108"              , vpmovsdw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28235C1108"              , vpmovsdw(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4823D1"                  , vpmovsdw(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48235C1104"              , vpmovsdw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48235C1104"              , vpmovsdw(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0822D1"                  , vpmovsqb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08225C1140"              , vpmovsqb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08225C1140"              , vpmovsqb(word_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2822D1"                  , vpmovsqb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28225C1120"              , vpmovsqb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28225C1120"              , vpmovsqb(dword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4822D1"                  , vpmovsqb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48225C1110"              , vpmovsqb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48225C1110"              , vpmovsqb(qword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0825D1"                  , vpmovsqd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08255C1110"              , vpmovsqd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08255C1110"              , vpmovsqd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2825D1"                  , vpmovsqd(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28255C1108"              , vpmovsqd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28255C1108"              , vpmovsqd(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4825D1"                  , vpmovsqd(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48255C1104"              , vpmovsqd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48255C1104"              , vpmovsqd(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0824D1"                  , vpmovsqw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08245C1120"              , vpmovsqw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08245C1120"              , vpmovsqw(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2824D1"                  , vpmovsqw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28245C1110"              , vpmovsqw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28245C1110"              , vpmovsqw(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4824D1"                  , vpmovsqw(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48245C1108"              , vpmovsqw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48245C1108"              , vpmovsqw(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0820D1"                  , vpmovswb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08205C1110"              , vpmovswb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08205C1110"              , vpmovswb(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2820D1"                  , vpmovswb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28205C1108"              , vpmovswb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28205C1108"              , vpmovswb(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4820D1"                  , vpmovswb(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48205C1104"              , vpmovswb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48205C1104"              , vpmovswb(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D4821CA"                  , vpmovsxbd(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48214C1A08"              , vpmovsxbd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48214C1A08"              , vpmovsxbd(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4822CA"                  , vpmovsxbq(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48224C1A10"              , vpmovsxbq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48224C1A10"              , vpmovsxbq(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4820CA"                  , vpmovsxbw(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48204C1A04"              , vpmovsxbw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48204C1A04"              , vpmovsxbw(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4825CA"                  , vpmovsxdq(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48254C1A04"              , vpmovsxdq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48254C1A04"              , vpmovsxdq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4823CA"                  , vpmovsxwd(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48234C1A04"              , vpmovsxwd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48234C1A04"              , vpmovsxwd(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4824CA"                  , vpmovsxwq(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48244C1A08"              , vpmovsxwq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48244C1A08"              , vpmovsxwq(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27E0811D1"                  , vpmovusdb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08115C1120"              , vpmovusdb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08115C1120"              , vpmovusdb(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2811D1"                  , vpmovusdb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28115C1110"              , vpmovusdb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28115C1110"              , vpmovusdb(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4811D1"                  , vpmovusdb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48115C1108"              , vpmovusdb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48115C1108"              , vpmovusdb(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0813D1"                  , vpmovusdw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08135C1110"              , vpmovusdw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08135C1110"              , vpmovusdw(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2813D1"                  , vpmovusdw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28135C1108"              , vpmovusdw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28135C1108"              , vpmovusdw(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4813D1"                  , vpmovusdw(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48135C1104"              , vpmovusdw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48135C1104"              , vpmovusdw(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0812D1"                  , vpmovusqb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08125C1140"              , vpmovusqb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08125C1140"              , vpmovusqb(word_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2812D1"                  , vpmovusqb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28125C1120"              , vpmovusqb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28125C1120"              , vpmovusqb(dword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4812D1"                  , vpmovusqb(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48125C1110"              , vpmovusqb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48125C1110"              , vpmovusqb(qword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0815D1"                  , vpmovusqd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08155C1110"              , vpmovusqd(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08155C1110"              , vpmovusqd(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2815D1"                  , vpmovusqd(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28155C1108"              , vpmovusqd(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28155C1108"              , vpmovusqd(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4815D1"                  , vpmovusqd(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48155C1104"              , vpmovusqd(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48155C1104"              , vpmovusqd(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0814D1"                  , vpmovusqw(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08145C1120"              , vpmovusqw(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08145C1120"              , vpmovusqw(dword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2814D1"                  , vpmovusqw(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28145C1110"              , vpmovusqw(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28145C1110"              , vpmovusqw(qword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4814D1"                  , vpmovusqw(xmm1, zmm2));
  TEST_INSTRUCTION("62F27E48145C1108"              , vpmovusqw(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48145C1108"              , vpmovusqw(xmmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E0810D1"                  , vpmovuswb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08105C1110"              , vpmovuswb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08105C1110"              , vpmovuswb(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2810D1"                  , vpmovuswb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28105C1108"              , vpmovuswb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28105C1108"              , vpmovuswb(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4810D1"                  , vpmovuswb(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48105C1104"              , vpmovuswb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48105C1104"              , vpmovuswb(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FE0829CA"                  , vpmovw2m(k1, xmm2));
  TEST_INSTRUCTION("62F2FE2829CA"                  , vpmovw2m(k1, ymm2));
  TEST_INSTRUCTION("62F2FE4829CA"                  , vpmovw2m(k1, zmm2));
  TEST_INSTRUCTION("62F27E0830D1"                  , vpmovwb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27E08305C1110"              , vpmovwb(ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E08305C1110"              , vpmovwb(qword_ptr(rcx, rdx, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27E2830D1"                  , vpmovwb(xmm1, ymm2));
  TEST_INSTRUCTION("62F27E28305C1108"              , vpmovwb(ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E28305C1108"              , vpmovwb(xmmword_ptr(rcx, rdx, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27E4830D1"                  , vpmovwb(ymm1, zmm2));
  TEST_INSTRUCTION("62F27E48305C1104"              , vpmovwb(ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27E48305C1104"              , vpmovwb(ymmword_ptr(rcx, rdx, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D4831CA"                  , vpmovzxbd(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48314C1A08"              , vpmovzxbd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48314C1A08"              , vpmovzxbd(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4832CA"                  , vpmovzxbq(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48324C1A10"              , vpmovzxbq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48324C1A10"              , vpmovzxbq(zmm1, qword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4830CA"                  , vpmovzxbw(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48304C1A04"              , vpmovzxbw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48304C1A04"              , vpmovzxbw(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4835CA"                  , vpmovzxdq(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48354C1A04"              , vpmovzxdq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48354C1A04"              , vpmovzxdq(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4833CA"                  , vpmovzxwd(zmm1, ymm2));
  TEST_INSTRUCTION("62F27D48334C1A04"              , vpmovzxwd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48334C1A04"              , vpmovzxwd(zmm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4834CA"                  , vpmovzxwq(zmm1, xmm2));
  TEST_INSTRUCTION("62F27D48344C1A08"              , vpmovzxwq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48344C1A08"              , vpmovzxwq(zmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2ED4828CB"                  , vpmuldq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48284C2B02"              , vpmuldq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48284C2B02"              , vpmuldq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D480BCB"                  , vpmulhrsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D480B4C2B02"              , vpmulhrsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D480B4C2B02"              , vpmulhrsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E4CB"                  , vpmulhuw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E44C2B02"              , vpmulhuw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E44C2B02"              , vpmulhuw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E5CB"                  , vpmulhw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E54C2B02"              , vpmulhw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E54C2B02"              , vpmulhw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4840CB"                  , vpmulld(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48404C2B02"              , vpmulld(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48404C2B02"              , vpmulld(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0840CB"                  , vpmullq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08404C2B08"              , vpmullq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08404C2B08"              , vpmullq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2840CB"                  , vpmullq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28404C2B04"              , vpmullq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28404C2B04"              , vpmullq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4840CB"                  , vpmullq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48404C2B02"              , vpmullq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48404C2B02"              , vpmullq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D5CB"                  , vpmullw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48D54C2B02"              , vpmullw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D54C2B02"              , vpmullw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0883CB"                  , vpmultishiftqb(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08834C2B08"              , vpmultishiftqb(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08834C2B08"              , vpmultishiftqb(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2883CB"                  , vpmultishiftqb(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28834C2B04"              , vpmultishiftqb(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28834C2B04"              , vpmultishiftqb(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4883CB"                  , vpmultishiftqb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48834C2B02"              , vpmultishiftqb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48834C2B02"              , vpmultishiftqb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48F4CB"                  , vpmuludq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48F44C2B02"              , vpmuludq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48F44C2B02"              , vpmuludq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27D0854CA"                  , vpopcntb(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08544C1A08"              , vpopcntb(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08544C1A08"              , vpopcntb(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2854CA"                  , vpopcntb(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28544C1A04"              , vpopcntb(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28544C1A04"              , vpopcntb(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4854CA"                  , vpopcntb(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48544C1A02"              , vpopcntb(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48544C1A02"              , vpopcntb(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D0855CA"                  , vpopcntd(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D08554C1A08"              , vpopcntd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D08554C1A08"              , vpopcntd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D2855CA"                  , vpopcntd(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D28554C1A04"              , vpopcntd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D28554C1A04"              , vpopcntd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D4855CA"                  , vpopcntd(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D48554C1A02"              , vpopcntd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D48554C1A02"              , vpopcntd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD0855CA"                  , vpopcntq(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08554C1A08"              , vpopcntq(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08554C1A08"              , vpopcntq(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2855CA"                  , vpopcntq(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28554C1A04"              , vpopcntq(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28554C1A04"              , vpopcntq(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4855CA"                  , vpopcntq(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48554C1A02"              , vpopcntq(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48554C1A02"              , vpopcntq(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD0854CA"                  , vpopcntw(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD08544C1A08"              , vpopcntw(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD08544C1A08"              , vpopcntw(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD2854CA"                  , vpopcntw(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD28544C1A04"              , vpopcntw(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD28544C1A04"              , vpopcntw(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD4854CA"                  , vpopcntw(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD48544C1A02"              , vpopcntw(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD48544C1A02"              , vpopcntw(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F16D08EBCB"                  , vpord(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08EB4C2B08"              , vpord(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08EB4C2B08"              , vpord(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28EBCB"                  , vpord(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28EB4C2B04"              , vpord(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28EB4C2B04"              , vpord(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EBCB"                  , vpord(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48EB4C2B02"              , vpord(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EB4C2B02"              , vpord(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08EBCB"                  , vporq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F1ED08EB4C2B08"              , vporq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08EB4C2B08"              , vporq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28EBCB"                  , vporq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F1ED28EB4C2B04"              , vporq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28EB4C2B04"              , vporq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48EBCB"                  , vporq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48EB4C2B02"              , vporq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48EB4C2B02"              , vporq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1750872CA01"                , vprold(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F17508724C1A0801"            , vprold(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17508724C1A0801"            , vprold(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872CA01"                , vprold(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F17528724C1A0401"            , vprold(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17528724C1A0401"            , vprold(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872CA01"                , vprold(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17548724C1A0201"            , vprold(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17548724C1A0201"            , vprold(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50872CA01"                , vprolq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F1F508724C1A0801"            , vprolq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F508724C1A0801"            , vprolq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52872CA01"                , vprolq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F1F528724C1A0401"            , vprolq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F528724C1A0401"            , vprolq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54872CA01"                , vprolq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1F548724C1A0201"            , vprolq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F548724C1A0201"            , vprolq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D0815CB"                  , vprolvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08154C2B08"              , vprolvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08154C2B08"              , vprolvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2815CB"                  , vprolvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28154C2B04"              , vprolvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28154C2B04"              , vprolvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4815CB"                  , vprolvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48154C2B02"              , vprolvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48154C2B02"              , vprolvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0815CB"                  , vprolvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08154C2B08"              , vprolvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08154C2B08"              , vprolvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2815CB"                  , vprolvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28154C2B04"              , vprolvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28154C2B04"              , vprolvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4815CB"                  , vprolvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48154C2B02"              , vprolvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48154C2B02"              , vprolvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1750872C201"                , vprord(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F1750872441A0801"            , vprord(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872441A0801"            , vprord(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872C201"                , vprord(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F1752872441A0401"            , vprord(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872441A0401"            , vprord(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872C201"                , vprord(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1754872441A0201"            , vprord(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872441A0201"            , vprord(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50872C201"                , vprorq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F1F50872441A0801"            , vprorq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50872441A0801"            , vprorq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52872C201"                , vprorq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F1F52872441A0401"            , vprorq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52872441A0401"            , vprorq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54872C201"                , vprorq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1F54872441A0201"            , vprorq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54872441A0201"            , vprorq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D0814CB"                  , vprorvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08144C2B08"              , vprorvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08144C2B08"              , vprorvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2814CB"                  , vprorvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28144C2B04"              , vprorvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28144C2B04"              , vprorvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4814CB"                  , vprorvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48144C2B02"              , vprorvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48144C2B02"              , vprorvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0814CB"                  , vprorvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08144C2B08"              , vprorvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08144C2B08"              , vprorvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2814CB"                  , vprorvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28144C2B04"              , vprorvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28144C2B04"              , vprorvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4814CB"                  , vprorvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48144C2B02"              , vprorvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48144C2B02"              , vprorvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F6CB"                  , vpsadbw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48F64C2B02"              , vpsadbw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F64C2B02"              , vpsadbw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F27D09A05C1120"              , k(k1).vpscatterdd(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D29A05C1120"              , k(k1).vpscatterdd(ptr(rcx, ymm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D49A05C1120"              , k(k1).vpscatterdd(ptr(rcx, zmm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD09A05C1110"              , k(k1).vpscatterdq(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD29A05C1110"              , k(k1).vpscatterdq(ptr(rcx, xmm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD49A05C1110"              , k(k1).vpscatterdq(ptr(rcx, ymm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D09A15C1120"              , k(k1).vpscatterqd(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D29A15C1120"              , k(k1).vpscatterqd(ptr(rcx, ymm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D49A15C1120"              , k(k1).vpscatterqd(ptr(rcx, zmm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD09A15C1110"              , k(k1).vpscatterqq(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD29A15C1110"              , k(k1).vpscatterqq(ptr(rcx, ymm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD49A15C1110"              , k(k1).vpscatterqq(ptr(rcx, zmm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F36D0871CB01"                , vpshldd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08714C2B0801"            , vpshldd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08714C2B0801"            , vpshldd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2871CB01"                , vpshldd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28714C2B0401"            , vpshldd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28714C2B0401"            , vpshldd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4871CB01"                , vpshldd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48714C2B0201"            , vpshldd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48714C2B0201"            , vpshldd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0871CB01"                , vpshldq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08714C2B0801"            , vpshldq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08714C2B0801"            , vpshldq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2871CB01"                , vpshldq(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28714C2B0401"            , vpshldq(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28714C2B0401"            , vpshldq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4871CB01"                , vpshldq(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48714C2B0201"            , vpshldq(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48714C2B0201"            , vpshldq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F26D0871CB"                  , vpshldvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08714C2B08"              , vpshldvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08714C2B08"              , vpshldvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2871CB"                  , vpshldvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28714C2B04"              , vpshldvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28714C2B04"              , vpshldvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4871CB"                  , vpshldvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48714C2B02"              , vpshldvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48714C2B02"              , vpshldvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0871CB"                  , vpshldvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08714C2B08"              , vpshldvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08714C2B08"              , vpshldvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2871CB"                  , vpshldvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28714C2B04"              , vpshldvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28714C2B04"              , vpshldvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4871CB"                  , vpshldvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48714C2B02"              , vpshldvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48714C2B02"              , vpshldvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0870CB"                  , vpshldvw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08704C2B08"              , vpshldvw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08704C2B08"              , vpshldvw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2870CB"                  , vpshldvw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28704C2B04"              , vpshldvw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28704C2B04"              , vpshldvw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4870CB"                  , vpshldvw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48704C2B02"              , vpshldvw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48704C2B02"              , vpshldvw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3ED0870CB01"                , vpshldw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08704C2B0801"            , vpshldw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08704C2B0801"            , vpshldw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2870CB01"                , vpshldw(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28704C2B0401"            , vpshldw(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28704C2B0401"            , vpshldw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4870CB01"                , vpshldw(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48704C2B0201"            , vpshldw(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48704C2B0201"            , vpshldw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0873CB01"                , vpshrdd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08734C2B0801"            , vpshrdd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08734C2B0801"            , vpshrdd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2873CB01"                , vpshrdd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28734C2B0401"            , vpshrdd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28734C2B0401"            , vpshrdd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4873CB01"                , vpshrdd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48734C2B0201"            , vpshrdd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48734C2B0201"            , vpshrdd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0873CB01"                , vpshrdq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08734C2B0801"            , vpshrdq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08734C2B0801"            , vpshrdq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2873CB01"                , vpshrdq(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28734C2B0401"            , vpshrdq(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28734C2B0401"            , vpshrdq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4873CB01"                , vpshrdq(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48734C2B0201"            , vpshrdq(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48734C2B0201"            , vpshrdq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F26D0873CB"                  , vpshrdvd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08734C2B08"              , vpshrdvd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08734C2B08"              , vpshrdvd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2873CB"                  , vpshrdvd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28734C2B04"              , vpshrdvd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28734C2B04"              , vpshrdvd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4873CB"                  , vpshrdvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48734C2B02"              , vpshrdvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48734C2B02"              , vpshrdvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0873CB"                  , vpshrdvq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08734C2B08"              , vpshrdvq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08734C2B08"              , vpshrdvq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2873CB"                  , vpshrdvq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28734C2B04"              , vpshrdvq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28734C2B04"              , vpshrdvq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4873CB"                  , vpshrdvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48734C2B02"              , vpshrdvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48734C2B02"              , vpshrdvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0872CB"                  , vpshrdvw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08724C2B08"              , vpshrdvw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08724C2B08"              , vpshrdvw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2872CB"                  , vpshrdvw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28724C2B04"              , vpshrdvw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28724C2B04"              , vpshrdvw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4872CB"                  , vpshrdvw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48724C2B02"              , vpshrdvw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48724C2B02"              , vpshrdvw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3ED0872CB01"                , vpshrdw(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08724C2B0801"            , vpshrdw(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08724C2B0801"            , vpshrdw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2872CB01"                , vpshrdw(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28724C2B0401"            , vpshrdw(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28724C2B0401"            , vpshrdw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4872CB01"                , vpshrdw(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48724C2B0201"            , vpshrdw(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48724C2B0201"            , vpshrdw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F26D4800CB"                  , vpshufb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48004C2B02"              , vpshufb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48004C2B02"              , vpshufb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D088FCB"                  , vpshufbitqmb(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D088F4C2B08"              , vpshufbitqmb(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D088F4C2B08"              , vpshufbitqmb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D288FCB"                  , vpshufbitqmb(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D288F4C2B04"              , vpshufbitqmb(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D288F4C2B04"              , vpshufbitqmb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D488FCB"                  , vpshufbitqmb(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D488F4C2B02"              , vpshufbitqmb(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D488F4C2B02"              , vpshufbitqmb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F17D4870CA01"                , vpshufd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17D48704C1A0201"            , vpshufd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17D48704C1A0201"            , vpshufd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17E4870CA01"                , vpshufhw(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17E48704C1A0201"            , vpshufhw(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17E48704C1A0201"            , vpshufhw(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17F4870CA01"                , vpshuflw(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17F48704C1A0201"            , vpshuflw(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17F48704C1A0201"            , vpshuflw(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872741A0801"            , vpslld(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872741A0801"            , vpslld(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872741A0401"            , vpslld(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872741A0401"            , vpslld(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48F2CB"                  , vpslld(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754872F201"                , vpslld(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48F24C2B08"              , vpslld(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F24C2B08"              , vpslld(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754872741A0201"            , vpslld(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872741A0201"            , vpslld(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17508737C1A0801"            , vpslldq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17508737C1A0801"            , vpslldq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17528737C1A0401"            , vpslldq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17528737C1A0401"            , vpslldq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754873FA01"                , vpslldq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17548737C1A0201"            , vpslldq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17548737C1A0201"            , vpslldq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50873741A0801"            , vpsllq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50873741A0801"            , vpsllq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52873741A0401"            , vpsllq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52873741A0401"            , vpsllq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48F3CB"                  , vpsllq(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1F54873F201"                , vpsllq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1ED48F34C2B08"              , vpsllq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48F34C2B08"              , vpsllq(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1F54873741A0201"            , vpsllq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54873741A0201"            , vpsllq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D4847CB"                  , vpsllvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48474C2B02"              , vpsllvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48474C2B02"              , vpsllvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4847CB"                  , vpsllvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48474C2B02"              , vpsllvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48474C2B02"              , vpsllvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0812CB"                  , vpsllvw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08124C2B08"              , vpsllvw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08124C2B08"              , vpsllvw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2812CB"                  , vpsllvw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28124C2B04"              , vpsllvw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28124C2B04"              , vpsllvw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4812CB"                  , vpsllvw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48124C2B02"              , vpsllvw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48124C2B02"              , vpsllvw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1750871741A0801"            , vpsllw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750871741A0801"            , vpsllw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871741A0401"            , vpsllw(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871741A0401"            , vpsllw(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48F1CB"                  , vpsllw(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754871F201"                , vpsllw(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48F14C2B08"              , vpsllw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F14C2B08"              , vpsllw(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754871741A0201"            , vpsllw(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754871741A0201"            , vpsllw(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872641A0801"            , vpsrad(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872641A0801"            , vpsrad(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872641A0401"            , vpsrad(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872641A0401"            , vpsrad(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48E2CB"                  , vpsrad(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754872E201"                , vpsrad(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48E24C2B08"              , vpsrad(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E24C2B08"              , vpsrad(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754872641A0201"            , vpsrad(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872641A0201"            , vpsrad(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED08E2CB"                  , vpsraq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F1F50872E201"                , vpsraq(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F1ED08E24C2B08"              , vpsraq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08E24C2B08"              , vpsraq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1F50872641A0801"            , vpsraq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50872641A0801"            , vpsraq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED28E2CB"                  , vpsraq(ymm1, ymm2, xmm3));
  TEST_INSTRUCTION("62F1F52872E201"                , vpsraq(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F1ED28E24C2B08"              , vpsraq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28E24C2B08"              , vpsraq(ymm1, ymm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1F52872641A0401"            , vpsraq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52872641A0401"            , vpsraq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48E2CB"                  , vpsraq(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1F54872E201"                , vpsraq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1ED48E24C2B08"              , vpsraq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48E24C2B08"              , vpsraq(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1F54872641A0201"            , vpsraq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54872641A0201"            , vpsraq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D4846CB"                  , vpsravd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48464C2B02"              , vpsravd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48464C2B02"              , vpsravd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0846CB"                  , vpsravq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08464C2B08"              , vpsravq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08464C2B08"              , vpsravq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2846CB"                  , vpsravq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28464C2B04"              , vpsravq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28464C2B04"              , vpsravq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4846CB"                  , vpsravq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48464C2B02"              , vpsravq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48464C2B02"              , vpsravq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0811CB"                  , vpsravw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08114C2B08"              , vpsravw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08114C2B08"              , vpsravw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2811CB"                  , vpsravw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28114C2B04"              , vpsravw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28114C2B04"              , vpsravw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4811CB"                  , vpsravw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48114C2B02"              , vpsravw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48114C2B02"              , vpsravw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1750871641A0801"            , vpsraw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750871641A0801"            , vpsraw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871641A0401"            , vpsraw(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871641A0401"            , vpsraw(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48E1CB"                  , vpsraw(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754871E201"                , vpsraw(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48E14C2B08"              , vpsraw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E14C2B08"              , vpsraw(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754871641A0201"            , vpsraw(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754871641A0201"            , vpsraw(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872541A0801"            , vpsrld(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750872541A0801"            , vpsrld(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872541A0401"            , vpsrld(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752872541A0401"            , vpsrld(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48D2CB"                  , vpsrld(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754872D201"                , vpsrld(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48D24C2B08"              , vpsrld(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D24C2B08"              , vpsrld(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754872541A0201"            , vpsrld(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754872541A0201"            , vpsrld(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17508735C1A0801"            , vpsrldq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17508735C1A0801"            , vpsrldq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17528735C1A0401"            , vpsrldq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17528735C1A0401"            , vpsrldq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754873DA01"                , vpsrldq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F17548735C1A0201"            , vpsrldq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F17548735C1A0201"            , vpsrldq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50873541A0801"            , vpsrlq(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F50873541A0801"            , vpsrlq(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52873541A0401"            , vpsrlq(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F52873541A0401"            , vpsrlq(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48D3CB"                  , vpsrlq(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1F54873D201"                , vpsrlq(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F1ED48D34C2B08"              , vpsrlq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48D34C2B08"              , vpsrlq(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1F54873541A0201"            , vpsrlq(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1F54873541A0201"            , vpsrlq(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F26D4845CB"                  , vpsrlvd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48454C2B02"              , vpsrlvd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48454C2B02"              , vpsrlvd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4845CB"                  , vpsrlvq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48454C2B02"              , vpsrlvq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48454C2B02"              , vpsrlvq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0810CB"                  , vpsrlvw(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08104C2B08"              , vpsrlvw(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08104C2B08"              , vpsrlvw(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2810CB"                  , vpsrlvw(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28104C2B04"              , vpsrlvw(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28104C2B04"              , vpsrlvw(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4810CB"                  , vpsrlvw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48104C2B02"              , vpsrlvw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48104C2B02"              , vpsrlvw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1750871541A0801"            , vpsrlw(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1750871541A0801"            , vpsrlw(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871541A0401"            , vpsrlw(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1752871541A0401"            , vpsrlw(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48D1CB"                  , vpsrlw(zmm1, zmm2, xmm3));
  TEST_INSTRUCTION("62F1754871D201"                , vpsrlw(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F16D48D14C2B08"              , vpsrlw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D14C2B08"              , vpsrlw(zmm1, zmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1754871541A0201"            , vpsrlw(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F1754871541A0201"            , vpsrlw(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F16D48F8CB"                  , vpsubb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48F84C2B02"              , vpsubb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F84C2B02"              , vpsubb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FACB"                  , vpsubd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48FA4C2B02"              , vpsubd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48FA4C2B02"              , vpsubd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48FBCB"                  , vpsubq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48FB4C2B02"              , vpsubq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48FB4C2B02"              , vpsubq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E8CB"                  , vpsubsb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E84C2B02"              , vpsubsb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E84C2B02"              , vpsubsb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E9CB"                  , vpsubsw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48E94C2B02"              , vpsubsw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48E94C2B02"              , vpsubsw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D8CB"                  , vpsubusb(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48D84C2B02"              , vpsubusb(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D84C2B02"              , vpsubusb(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D9CB"                  , vpsubusw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48D94C2B02"              , vpsubusw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48D94C2B02"              , vpsubusw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F9CB"                  , vpsubw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48F94C2B02"              , vpsubw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48F94C2B02"              , vpsubw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F36D0825CB01"                , vpternlogd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08254C2B0801"            , vpternlogd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08254C2B0801"            , vpternlogd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2825CB01"                , vpternlogd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28254C2B0401"            , vpternlogd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28254C2B0401"            , vpternlogd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4825CB01"                , vpternlogd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48254C2B0201"            , vpternlogd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48254C2B0201"            , vpternlogd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0825CB01"                , vpternlogq(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08254C2B0801"            , vpternlogq(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08254C2B0801"            , vpternlogq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2825CB01"                , vpternlogq(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28254C2B0401"            , vpternlogq(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28254C2B0401"            , vpternlogq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4825CB01"                , vpternlogq(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48254C2B0201"            , vpternlogq(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48254C2B0201"            , vpternlogq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F26D0826CB"                  , vptestmb(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08264C2B08"              , vptestmb(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08264C2B08"              , vptestmb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2826CB"                  , vptestmb(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28264C2B04"              , vptestmb(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28264C2B04"              , vptestmb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4826CB"                  , vptestmb(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48264C2B02"              , vptestmb(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48264C2B02"              , vptestmb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D0827CB"                  , vptestmd(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D08274C2B08"              , vptestmd(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D08274C2B08"              , vptestmd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D2827CB"                  , vptestmd(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D28274C2B04"              , vptestmd(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D28274C2B04"              , vptestmd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D4827CB"                  , vptestmd(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D48274C2B02"              , vptestmd(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D48274C2B02"              , vptestmd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0827CB"                  , vptestmq(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08274C2B08"              , vptestmq(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08274C2B08"              , vptestmq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2827CB"                  , vptestmq(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28274C2B04"              , vptestmq(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28274C2B04"              , vptestmq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4827CB"                  , vptestmq(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48274C2B02"              , vptestmq(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48274C2B02"              , vptestmq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED0826CB"                  , vptestmw(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED08264C2B08"              , vptestmw(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED08264C2B08"              , vptestmw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED2826CB"                  , vptestmw(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED28264C2B04"              , vptestmw(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED28264C2B04"              , vptestmw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED4826CB"                  , vptestmw(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED48264C2B02"              , vptestmw(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED48264C2B02"              , vptestmw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E0826CB"                  , vptestnmb(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26E08264C2B08"              , vptestnmb(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E08264C2B08"              , vptestnmb(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E2826CB"                  , vptestnmb(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26E28264C2B04"              , vptestnmb(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E28264C2B04"              , vptestnmb(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E4826CB"                  , vptestnmb(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26E48264C2B02"              , vptestnmb(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E48264C2B02"              , vptestnmb(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E0827CB"                  , vptestnmd(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26E08274C2B08"              , vptestnmd(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E08274C2B08"              , vptestnmd(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E2827CB"                  , vptestnmd(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26E28274C2B04"              , vptestnmd(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E28274C2B04"              , vptestnmd(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E4827CB"                  , vptestnmd(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26E48274C2B02"              , vptestnmd(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26E48274C2B02"              , vptestnmd(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE0827CB"                  , vptestnmq(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2EE08274C2B08"              , vptestnmq(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE08274C2B08"              , vptestnmq(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE2827CB"                  , vptestnmq(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2EE28274C2B04"              , vptestnmq(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE28274C2B04"              , vptestnmq(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE4827CB"                  , vptestnmq(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2EE48274C2B02"              , vptestnmq(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE48274C2B02"              , vptestnmq(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE0826CB"                  , vptestnmw(k1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2EE08264C2B08"              , vptestnmw(k1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE08264C2B08"              , vptestnmw(k1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE2826CB"                  , vptestnmw(k1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2EE28264C2B04"              , vptestnmw(k1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE28264C2B04"              , vptestnmw(k1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE4826CB"                  , vptestnmw(k1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2EE48264C2B02"              , vptestnmw(k1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2EE48264C2B02"              , vptestnmw(k1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4868CB"                  , vpunpckhbw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48684C2B02"              , vpunpckhbw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48684C2B02"              , vpunpckhbw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D486ACB"                  , vpunpckhdq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D486A4C2B02"              , vpunpckhdq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D486A4C2B02"              , vpunpckhdq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED486DCB"                  , vpunpckhqdq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED486D4C2B02"              , vpunpckhqdq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED486D4C2B02"              , vpunpckhqdq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4869CB"                  , vpunpckhwd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48694C2B02"              , vpunpckhwd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48694C2B02"              , vpunpckhwd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4860CB"                  , vpunpcklbw(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48604C2B02"              , vpunpcklbw(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48604C2B02"              , vpunpcklbw(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4862CB"                  , vpunpckldq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48624C2B02"              , vpunpckldq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48624C2B02"              , vpunpckldq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED486CCB"                  , vpunpcklqdq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED486C4C2B02"              , vpunpcklqdq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED486C4C2B02"              , vpunpcklqdq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D4861CB"                  , vpunpcklwd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48614C2B02"              , vpunpcklwd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48614C2B02"              , vpunpcklwd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08EFCB"                  , vpxord(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F16D08EF4C2B08"              , vpxord(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D08EF4C2B08"              , vpxord(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28EFCB"                  , vpxord(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F16D28EF4C2B04"              , vpxord(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D28EF4C2B04"              , vpxord(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EFCB"                  , vpxord(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16D48EF4C2B02"              , vpxord(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16D48EF4C2B02"              , vpxord(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08EFCB"                  , vpxorq(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F1ED08EF4C2B08"              , vpxorq(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED08EF4C2B08"              , vpxorq(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28EFCB"                  , vpxorq(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F1ED28EF4C2B04"              , vpxorq(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED28EF4C2B04"              , vpxorq(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48EFCB"                  , vpxorq(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48EF4C2B02"              , vpxorq(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48EF4C2B02"              , vpxorq(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3ED0850CB01"                , vrangepd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08504C2B0801"            , vrangepd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08504C2B0801"            , vrangepd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2850CB01"                , vrangepd(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28504C2B0401"            , vrangepd(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28504C2B0401"            , vrangepd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4850CB01"                , vrangepd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48504C2B0201"            , vrangepd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48504C2B0201"            , vrangepd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0850CB01"                , vrangeps(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08504C2B0801"            , vrangeps(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08504C2B0801"            , vrangeps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2850CB01"                , vrangeps(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28504C2B0401"            , vrangeps(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28504C2B0401"            , vrangeps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4850CB01"                , vrangeps(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48504C2B0201"            , vrangeps(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48504C2B0201"            , vrangeps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0851CB01"                , vrangesd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08514C2B1001"            , vrangesd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08514C2B1001"            , vrangesd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0851CB01"                , vrangess(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08514C2B2001"            , vrangess(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08514C2B2001"            , vrangess(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F2FD084CCA"                  , vrcp14pd(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD084C4C1A08"              , vrcp14pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD084C4C1A08"              , vrcp14pd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD284CCA"                  , vrcp14pd(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD284C4C1A04"              , vrcp14pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD284C4C1A04"              , vrcp14pd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD484CCA"                  , vrcp14pd(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD484C4C1A02"              , vrcp14pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD484C4C1A02"              , vrcp14pd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D084CCA"                  , vrcp14ps(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D084C4C1A08"              , vrcp14ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D084C4C1A08"              , vrcp14ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D284CCA"                  , vrcp14ps(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D284C4C1A04"              , vrcp14ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D284C4C1A04"              , vrcp14ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D484CCA"                  , vrcp14ps(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D484C4C1A02"              , vrcp14ps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D484C4C1A02"              , vrcp14ps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2ED084DCB"                  , vrcp14sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED084D4C2B10"              , vrcp14sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED084D4C2B10"              , vrcp14sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D084DCB"                  , vrcp14ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D084D4C2B20"              , vrcp14ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D084D4C2B20"              , vrcp14ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F3FD0856CA01"                , vreducepd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F3FD08564C1A0801"            , vreducepd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD08564C1A0801"            , vreducepd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD2856CA01"                , vreducepd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD28564C1A0401"            , vreducepd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD28564C1A0401"            , vreducepd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD4856CA01"                , vreducepd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD48564C1A0201"            , vreducepd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48564C1A0201"            , vreducepd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D0856CA01"                , vreduceps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F37D08564C1A0801"            , vreduceps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D08564C1A0801"            , vreduceps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D2856CA01"                , vreduceps(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F37D28564C1A0401"            , vreduceps(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D28564C1A0401"            , vreduceps(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D4856CA01"                , vreduceps(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D48564C1A0201"            , vreduceps(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D48564C1A0201"            , vreduceps(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED0857CB01"                , vreducesd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED08574C2B1001"            , vreducesd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED08574C2B1001"            , vreducesd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D0857CB01"                , vreducess(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D08574C2B2001"            , vreducess(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D08574C2B2001"            , vreducess(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD0809CA01"                , vrndscalepd(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F3FD08094C1A0801"            , vrndscalepd(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD08094C1A0801"            , vrndscalepd(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD2809CA01"                , vrndscalepd(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F3FD28094C1A0401"            , vrndscalepd(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD28094C1A0401"            , vrndscalepd(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD4809CA01"                , vrndscalepd(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F3FD48094C1A0201"            , vrndscalepd(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3FD48094C1A0201"            , vrndscalepd(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D0808CA01"                , vrndscaleps(xmm1, xmm2, 1));
  TEST_INSTRUCTION("62F37D08084C1A0801"            , vrndscaleps(xmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D08084C1A0801"            , vrndscaleps(xmm1, xmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D2808CA01"                , vrndscaleps(ymm1, ymm2, 1));
  TEST_INSTRUCTION("62F37D28084C1A0401"            , vrndscaleps(ymm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D28084C1A0401"            , vrndscaleps(ymm1, ymmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D4808CA01"                , vrndscaleps(zmm1, zmm2, 1));
  TEST_INSTRUCTION("62F37D48084C1A0201"            , vrndscaleps(zmm1, ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F37D48084C1A0201"            , vrndscaleps(zmm1, zmmword_ptr(rdx, rbx, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED080BCB01"                , vrndscalesd(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F3ED080B4C2B1001"            , vrndscalesd(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED080B4C2B1001"            , vrndscalesd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D080ACB01"                , vrndscaless(xmm1, xmm2, xmm3, 1));
  TEST_INSTRUCTION("62F36D080A4C2B2001"            , vrndscaless(xmm1, xmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D080A4C2B2001"            , vrndscaless(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F2FD084ECA"                  , vrsqrt14pd(xmm1, xmm2));
  TEST_INSTRUCTION("62F2FD084E4C1A08"              , vrsqrt14pd(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD084E4C1A08"              , vrsqrt14pd(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD284ECA"                  , vrsqrt14pd(ymm1, ymm2));
  TEST_INSTRUCTION("62F2FD284E4C1A04"              , vrsqrt14pd(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD284E4C1A04"              , vrsqrt14pd(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD484ECA"                  , vrsqrt14pd(zmm1, zmm2));
  TEST_INSTRUCTION("62F2FD484E4C1A02"              , vrsqrt14pd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2FD484E4C1A02"              , vrsqrt14pd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D084ECA"                  , vrsqrt14ps(xmm1, xmm2));
  TEST_INSTRUCTION("62F27D084E4C1A08"              , vrsqrt14ps(xmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D084E4C1A08"              , vrsqrt14ps(xmm1, xmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D284ECA"                  , vrsqrt14ps(ymm1, ymm2));
  TEST_INSTRUCTION("62F27D284E4C1A04"              , vrsqrt14ps(ymm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D284E4C1A04"              , vrsqrt14ps(ymm1, ymmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D484ECA"                  , vrsqrt14ps(zmm1, zmm2));
  TEST_INSTRUCTION("62F27D484E4C1A02"              , vrsqrt14ps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F27D484E4C1A02"              , vrsqrt14ps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F2ED084FCB"                  , vrsqrt14sd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED084F4C2B10"              , vrsqrt14sd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED084F4C2B10"              , vrsqrt14sd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D084FCB"                  , vrsqrt14ss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D084F4C2B20"              , vrsqrt14ss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D084F4C2B20"              , vrsqrt14ss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED082CCB"                  , vscalefpd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED082C4C2B08"              , vscalefpd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED082C4C2B08"              , vscalefpd(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED282CCB"                  , vscalefpd(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F2ED282C4C2B04"              , vscalefpd(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED282C4C2B04"              , vscalefpd(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED482CCB"                  , vscalefpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F2ED482C4C2B02"              , vscalefpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED482C4C2B02"              , vscalefpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D082CCB"                  , vscalefps(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D082C4C2B08"              , vscalefps(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D082C4C2B08"              , vscalefps(xmm1, xmm2, xmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D282CCB"                  , vscalefps(ymm1, ymm2, ymm3));
  TEST_INSTRUCTION("62F26D282C4C2B04"              , vscalefps(ymm1, ymm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D282C4C2B04"              , vscalefps(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D482CCB"                  , vscalefps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F26D482C4C2B02"              , vscalefps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D482C4C2B02"              , vscalefps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED082DCB"                  , vscalefsd(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F2ED082D4C2B10"              , vscalefsd(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2ED082D4C2B10"              , vscalefsd(xmm1, xmm2, qword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D082DCB"                  , vscalefss(xmm1, xmm2, xmm3));
  TEST_INSTRUCTION("62F26D082D4C2B20"              , vscalefss(xmm1, xmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F26D082D4C2B20"              , vscalefss(xmm1, xmm2, dword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F2FD09A25C1110"              , k(k1).vscatterdpd(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD29A25C1110"              , k(k1).vscatterdpd(ptr(rcx, xmm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD49A25C1110"              , k(k1).vscatterdpd(ptr(rcx, ymm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D09A25C1120"              , k(k1).vscatterdps(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D29A25C1120"              , k(k1).vscatterdps(ptr(rcx, ymm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F27D49A25C1120"              , k(k1).vscatterdps(ptr(rcx, zmm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F2FD09A35C1110"              , k(k1).vscatterqpd(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F2FD29A35C1110"              , k(k1).vscatterqpd(ptr(rcx, ymm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F2FD49A35C1110"              , k(k1).vscatterqpd(ptr(rcx, zmm2, 0, 128), zmm3));
  TEST_INSTRUCTION("62F27D09A35C1120"              , k(k1).vscatterqps(ptr(rcx, xmm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D29A35C1120"              , k(k1).vscatterqps(ptr(rcx, ymm2, 0, 128), xmm3));
  TEST_INSTRUCTION("62F27D49A35C1120"              , k(k1).vscatterqps(ptr(rcx, zmm2, 0, 128), ymm3));
  TEST_INSTRUCTION("62F36D2823CB01"                , vshuff32x4(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28234C2B0401"            , vshuff32x4(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28234C2B0401"            , vshuff32x4(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4823CB01"                , vshuff32x4(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48234C2B0201"            , vshuff32x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48234C2B0201"            , vshuff32x4(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2823CB01"                , vshuff64x2(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28234C2B0401"            , vshuff64x2(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28234C2B0401"            , vshuff64x2(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4823CB01"                , vshuff64x2(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48234C2B0201"            , vshuff64x2(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48234C2B0201"            , vshuff64x2(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D2843CB01"                , vshufi32x4(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F36D28434C2B0401"            , vshufi32x4(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D28434C2B0401"            , vshufi32x4(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D4843CB01"                , vshufi32x4(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F36D48434C2B0201"            , vshufi32x4(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F36D48434C2B0201"            , vshufi32x4(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED2843CB01"                , vshufi64x2(ymm1, ymm2, ymm3, 1));
  TEST_INSTRUCTION("62F3ED28434C2B0401"            , vshufi64x2(ymm1, ymm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED28434C2B0401"            , vshufi64x2(ymm1, ymm2, ymmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED4843CB01"                , vshufi64x2(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F3ED48434C2B0201"            , vshufi64x2(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F3ED48434C2B0201"            , vshufi64x2(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48C6CB01"                , vshufpd(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F1ED48C64C2B0201"            , vshufpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1ED48C64C2B0201"            , vshufpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C48C6CB01"                , vshufps(zmm1, zmm2, zmm3, 1));
  TEST_INSTRUCTION("62F16C48C64C2B0201"            , vshufps(zmm1, zmm2, ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F16C48C64C2B0201"            , vshufps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128), 1));
  TEST_INSTRUCTION("62F1FD4851CA"                  , vsqrtpd(zmm1, zmm2));
  TEST_INSTRUCTION("62F1FD48514C1A02"              , vsqrtpd(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1FD48514C1A02"              , vsqrtpd(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C4851CA"                  , vsqrtps(zmm1, zmm2));
  TEST_INSTRUCTION("62F17C48514C1A02"              , vsqrtps(zmm1, ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F17C48514C1A02"              , vsqrtps(zmm1, zmmword_ptr(rdx, rbx, 0, 128)));
  TEST_INSTRUCTION("62F1ED485CCB"                  , vsubpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED485C4C2B02"              , vsubpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED485C4C2B02"              , vsubpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485CCB"                  , vsubps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C485C4C2B02"              , vsubps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C485C4C2B02"              , vsubps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED4815CB"                  , vunpckhpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48154C2B02"              , vunpckhpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48154C2B02"              , vunpckhpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4815CB"                  , vunpckhps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48154C2B02"              , vunpckhps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48154C2B02"              , vunpckhps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED4814CB"                  , vunpcklpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48144C2B02"              , vunpcklpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48144C2B02"              , vunpcklpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4814CB"                  , vunpcklps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48144C2B02"              , vunpcklps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48144C2B02"              , vunpcklps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED4857CB"                  , vxorpd(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F1ED48574C2B02"              , vxorpd(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F1ED48574C2B02"              , vxorpd(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C4857CB"                  , vxorps(zmm1, zmm2, zmm3));
  TEST_INSTRUCTION("62F16C48574C2B02"              , vxorps(zmm1, zmm2, ptr(rbx, rbp, 0, 128)));
  TEST_INSTRUCTION("62F16C48574C2B02"              , vxorps(zmm1, zmm2, zmmword_ptr(rbx, rbp, 0, 128)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx512_fp16(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("62F5560810F4"                  , vmovsh(xmm6, xmm5, xmm4));
  TEST_INSTRUCTION("62F57E0F10B4F400000010"        , k(k7).vmovsh(xmm6, word_ptr(rsp, rsi, 3, 268435456)));
  TEST_INSTRUCTION("62F57E081031"                  , vmovsh(xmm6, word_ptr(rcx)));
  TEST_INSTRUCTION("62F57E0810717F"                , vmovsh(xmm6, word_ptr(rcx, 254)));
  TEST_INSTRUCTION("62F57E8F107280"                , k(k7).z().vmovsh(xmm6, word_ptr(rdx, -256)));
  TEST_INSTRUCTION("62F57E0F11B4F400000010"        , k(k7).vmovsh(word_ptr(rsp, rsi, 3, 268435456), xmm6));
  TEST_INSTRUCTION("62F57E081131"                  , vmovsh(word_ptr(rcx), xmm6));
  TEST_INSTRUCTION("62F57E0811717F"                , vmovsh(word_ptr(rcx, 254), xmm6));
  TEST_INSTRUCTION("62F57E0F117280"                , k(k7).vmovsh(word_ptr(rdx, -256), xmm6));
  TEST_INSTRUCTION("62F57D086EF2"                  , vmovw(xmm6, edx));
  TEST_INSTRUCTION("62F57D087EF2"                  , vmovw(edx, xmm6));
  TEST_INSTRUCTION("62F57D086EB4F400000010"        , vmovw(xmm6, word_ptr(rsp, rsi, 3, 268435456)));
  TEST_INSTRUCTION("62F57D086E31"                  , vmovw(xmm6, word_ptr(rcx)));
  TEST_INSTRUCTION("62F57D086E717F"                , vmovw(xmm6, word_ptr(rcx, 254)));
  TEST_INSTRUCTION("62F57D086E717F"                , vmovw(xmm6, word_ptr(rcx, 254)));
  TEST_INSTRUCTION("62F57D086E7280"                , vmovw(xmm6, word_ptr(rdx, -256)));
  TEST_INSTRUCTION("62F57D087EB4F400000010"        , vmovw(word_ptr(rsp, esi, 3, 268435456), xmm6));
  TEST_INSTRUCTION("62F57D087E31"                  , vmovw(word_ptr(rcx), xmm6));
  TEST_INSTRUCTION("62F57D087E717F"                , vmovw(word_ptr(rcx, 254), xmm6));
  TEST_INSTRUCTION("62F57D087E7280"                , vmovw(word_ptr(rdx, -256), xmm6));
}

// Tests generated from 'llvm/test/MC/X86/intel-syntax-avx512.s' file to ensure compatibility with LLVM assembler.
//
// NOTE: Split to 4 functions as compilers can be really slow when compiling it for some reason.
static void ASMJIT_NOINLINE test_x64_assembler_avx512_llvm_1(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("62F174485808"                  , vaddps(zmm1, zmm1, zmmword_ptr(rax)));
  TEST_INSTRUCTION("62F1F54858CA"                  , vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F54D58CA"                  , k(k5).vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F5CD58CA"                  , k(k5).z().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F5CD58CA"                  , k(k5).z().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F51858CA"                  , rn_sae().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F55858CA"                  , ru_sae().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F53858CA"                  , rd_sae().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62F1F57858CA"                  , rz_sae().vaddpd(zmm1, zmm1, zmm2));
  TEST_INSTRUCTION("62919D48C2D2AB"                , vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D4BC2D2AB"                , k(k3).vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D18C2D2AB"                , sae().vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D48C2D27B"                , vcmppd(k2, zmm12, zmm26, 123));
  TEST_INSTRUCTION("62919D18C2D27B"                , sae().vcmppd(k2, zmm12, zmm26, 123));
  TEST_INSTRUCTION("62F19D48C2117B"                , vcmppd(k2, zmm12, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B19D48C294F0230100007B"      , vcmppd(k2, zmm12, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F19D58C2117B"                , vcmppd(k2, zmm12, qword_ptr(rcx)._1to8(), 123));
  TEST_INSTRUCTION("62F19D48C2527F7B"              , vcmppd(k2, zmm12, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F19D48C292002000007B"        , vcmppd(k2, zmm12, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F19D48C252807B"              , vcmppd(k2, zmm12, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F19D48C292C0DFFFFF7B"        , vcmppd(k2, zmm12, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F19D58C2527F7B"              , vcmppd(k2, zmm12, qword_ptr(rdx, 1016)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C292000400007B"        , vcmppd(k2, zmm12, qword_ptr(rdx, 1024)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C252807B"              , vcmppd(k2, zmm12, qword_ptr(rdx, -1024)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C292F8FBFFFF7B"        , vcmppd(k2, zmm12, qword_ptr(rdx, -1032)._1to8(), 123));
  TEST_INSTRUCTION("62B17440C2D6AB"                , vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17443C2D6AB"                , k(k3).vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17410C2D6AB"                , sae().vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17440C2D67B"                , vcmpps(k2, zmm17, zmm22, 123));
  TEST_INSTRUCTION("62B17410C2D67B"                , sae().vcmpps(k2, zmm17, zmm22, 123));
  TEST_INSTRUCTION("62F17440C2117B"                , vcmpps(k2, zmm17, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B17440C294F0230100007B"      , vcmpps(k2, zmm17, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F17450C2117B"                , vcmpps(k2, zmm17, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62F17440C2527F7B"              , vcmpps(k2, zmm17, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F17440C292002000007B"        , vcmpps(k2, zmm17, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F17440C252807B"              , vcmpps(k2, zmm17, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F17440C292C0DFFFFF7B"        , vcmpps(k2, zmm17, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F17450C2527F7B"              , vcmpps(k2, zmm17, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C292000200007B"        , vcmpps(k2, zmm17, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C252807B"              , vcmpps(k2, zmm17, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C292FCFDFFFF7B"        , vcmpps(k2, zmm17, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62136D0055FCAB"                , vfixupimmss(xmm15, xmm18, xmm28, 171));
  TEST_INSTRUCTION("62136D0555FCAB"                , k(k5).vfixupimmss(xmm15, xmm18, xmm28, 171));
  TEST_INSTRUCTION("62136D8555FCAB"                , k(k5).z().vfixupimmss(xmm15, xmm18, xmm28, 171));
  TEST_INSTRUCTION("62136D1055FCAB"                , sae().vfixupimmss(xmm15, xmm18, xmm28, 171));
  TEST_INSTRUCTION("62136D0055FC7B"                , vfixupimmss(xmm15, xmm18, xmm28, 123));
  TEST_INSTRUCTION("62136D1055FC7B"                , sae().vfixupimmss(xmm15, xmm18, xmm28, 123));
  TEST_INSTRUCTION("62736D0055397B"                , vfixupimmss(xmm15, xmm18, dword_ptr(rcx), 123));
  TEST_INSTRUCTION("62336D0055BCF0230100007B"      , vfixupimmss(xmm15, xmm18, dword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62736D00557A7F7B"              , vfixupimmss(xmm15, xmm18, dword_ptr(rdx, 508), 123));
  TEST_INSTRUCTION("62736D0055BA000200007B"        , vfixupimmss(xmm15, xmm18, dword_ptr(rdx, 512), 123));
  TEST_INSTRUCTION("62736D00557A807B"              , vfixupimmss(xmm15, xmm18, dword_ptr(rdx, -512), 123));
  TEST_INSTRUCTION("62736D0055BAFCFDFFFF7B"        , vfixupimmss(xmm15, xmm18, dword_ptr(rdx, -516), 123));
  TEST_INSTRUCTION("6273AD0055EDAB"                , vfixupimmsd(xmm13, xmm26, xmm5, 171));
  TEST_INSTRUCTION("6273AD0655EDAB"                , k(k6).vfixupimmsd(xmm13, xmm26, xmm5, 171));
  TEST_INSTRUCTION("6273AD8655EDAB"                , k(k6).z().vfixupimmsd(xmm13, xmm26, xmm5, 171));
  TEST_INSTRUCTION("6273AD1055EDAB"                , sae().vfixupimmsd(xmm13, xmm26, xmm5, 171));
  TEST_INSTRUCTION("6273AD0055ED7B"                , vfixupimmsd(xmm13, xmm26, xmm5, 123));
  TEST_INSTRUCTION("6273AD1055ED7B"                , sae().vfixupimmsd(xmm13, xmm26, xmm5, 123));
  TEST_INSTRUCTION("6273AD0055297B"                , vfixupimmsd(xmm13, xmm26, qword_ptr(rcx), 123));
  TEST_INSTRUCTION("6233AD0055ACF0230100007B"      , vfixupimmsd(xmm13, xmm26, qword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("6273AD00556A7F7B"              , vfixupimmsd(xmm13, xmm26, qword_ptr(rdx, 1016), 123));
  TEST_INSTRUCTION("6273AD0055AA000400007B"        , vfixupimmsd(xmm13, xmm26, qword_ptr(rdx, 1024), 123));
  TEST_INSTRUCTION("6273AD00556A807B"              , vfixupimmsd(xmm13, xmm26, qword_ptr(rdx, -1024), 123));
  TEST_INSTRUCTION("6273AD0055AAF8FBFFFF7B"        , vfixupimmsd(xmm13, xmm26, qword_ptr(rdx, -1032), 123));
  TEST_INSTRUCTION("62E1FD082F39"                  , vcomisd(xmm23, qword_ptr(rcx)));
  TEST_INSTRUCTION("62E17C082F01"                  , vcomiss(xmm16, dword_ptr(rcx)));
  TEST_INSTRUCTION("62717E0A1129"                  , k(k2).vmovss(dword_ptr(rcx), xmm13));
  TEST_INSTRUCTION("C4217A11ACF034120000"          , vmovss(dword_ptr(rax, r14, 3, 4660), xmm13));
  TEST_INSTRUCTION("C57A11AAFC010000"              , vmovss(dword_ptr(rdx, 508), xmm13));
  TEST_INSTRUCTION("C57A11AA00020000"              , vmovss(dword_ptr(rdx, 512), xmm13));
  TEST_INSTRUCTION("C57A11AA00FEFFFF"              , vmovss(dword_ptr(rdx, -512), xmm13));
  TEST_INSTRUCTION("C57A11AAFCFDFFFF"              , vmovss(dword_ptr(rdx, -516), xmm13));
  TEST_INSTRUCTION("C5FA11AAFC010000"              , vmovss(dword_ptr(rdx, 508), xmm5));
  TEST_INSTRUCTION("C5FA11AA00020000"              , vmovss(dword_ptr(rdx, 512), xmm5));
  TEST_INSTRUCTION("C5FA11AA00FEFFFF"              , vmovss(dword_ptr(rdx, -512), xmm5));
  TEST_INSTRUCTION("C5FA11AAFCFDFFFF"              , vmovss(dword_ptr(rdx, -516), xmm5));
  TEST_INSTRUCTION("C57A1129"                      , vmovss(dword_ptr(rcx), xmm13));
  TEST_INSTRUCTION("C5FA1011"                      , vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F17E0C1011"                  , k(k4).vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F17E8C1011"                  , k(k4).z().vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("6261FF081009"                  , vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6261FF0B1009"                  , k(k3).vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6261FF8B1009"                  , k(k3).z().vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6221FF08108CF023010000"        , vmovsd(xmm25, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261FF08104A7F"                , vmovsd(xmm25, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6261FF08108A00040000"          , vmovsd(xmm25, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6261FF08104A80"                , vmovsd(xmm25, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6261FF08108AF8FBFFFF"          , vmovsd(xmm25, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("6271A54058C6"                  , vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A54758C6"                  , k(k7).vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A5C758C6"                  , k(k7).z().vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A51058C6"                  , rn_sae().vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A55058C6"                  , ru_sae().vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A53058C6"                  , rd_sae().vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A57058C6"                  , rz_sae().vaddpd(zmm8, zmm27, zmm6));
  TEST_INSTRUCTION("6271A5405801"                  , vaddpd(zmm8, zmm27, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6231A5405884F023010000"        , vaddpd(zmm8, zmm27, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6271A5505801"                  , vaddpd(zmm8, zmm27, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6271A54058427F"                , vaddpd(zmm8, zmm27, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6271A540588200200000"          , vaddpd(zmm8, zmm27, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6271A540584280"                , vaddpd(zmm8, zmm27, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6271A5405882C0DFFFFF"          , vaddpd(zmm8, zmm27, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6271A55058427F"                , vaddpd(zmm8, zmm27, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6271A550588200040000"          , vaddpd(zmm8, zmm27, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6271A550584280"                , vaddpd(zmm8, zmm27, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6271A5505882F8FBFFFF"          , vaddpd(zmm8, zmm27, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62E1144858D2"                  , vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E1144C58D2"                  , k(k4).vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E114CC58D2"                  , k(k4).z().vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E1141858D2"                  , rn_sae().vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E1145858D2"                  , ru_sae().vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E1143858D2"                  , rd_sae().vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E1147858D2"                  , rz_sae().vaddps(zmm18, zmm13, zmm2));
  TEST_INSTRUCTION("62E114485811"                  , vaddps(zmm18, zmm13, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A114485894F023010000"        , vaddps(zmm18, zmm13, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E114585811"                  , vaddps(zmm18, zmm13, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E1144858527F"                , vaddps(zmm18, zmm13, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E11448589200200000"          , vaddps(zmm18, zmm13, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E11448585280"                , vaddps(zmm18, zmm13, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E114485892C0DFFFFF"          , vaddps(zmm18, zmm13, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E1145858527F"                , vaddps(zmm18, zmm13, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E11458589200020000"          , vaddps(zmm18, zmm13, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E11458585280"                , vaddps(zmm18, zmm13, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E114585892FCFDFFFF"          , vaddps(zmm18, zmm13, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62D1F70058D8"                  , vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F70358D8"                  , k(k3).vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F78358D8"                  , k(k3).z().vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F71058D8"                  , rn_sae().vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F75058D8"                  , ru_sae().vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F73058D8"                  , rd_sae().vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62D1F77058D8"                  , rz_sae().vaddsd(xmm3, xmm17, xmm8));
  TEST_INSTRUCTION("62F1F7005819"                  , vaddsd(xmm3, xmm17, qword_ptr(rcx)));
  TEST_INSTRUCTION("62B1F700589CF023010000"        , vaddsd(xmm3, xmm17, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1F700585A7F"                , vaddsd(xmm3, xmm17, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62F1F700589A00040000"          , vaddsd(xmm3, xmm17, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62F1F700585A80"                , vaddsd(xmm3, xmm17, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62F1F700589AF8FBFFFF"          , vaddsd(xmm3, xmm17, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62B1560858FB"                  , vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1560A58FB"                  , k(k2).vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1568A58FB"                  , k(k2).z().vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1561858FB"                  , rn_sae().vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1565858FB"                  , ru_sae().vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1563858FB"                  , rd_sae().vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("62B1567858FB"                  , rz_sae().vaddss(xmm7, xmm5, xmm19));
  TEST_INSTRUCTION("C5D25839"                      , vaddss(xmm7, xmm5, dword_ptr(rcx)));
  TEST_INSTRUCTION("C4A15258BCF023010000"          , vaddss(xmm7, xmm5, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C5D258BAFC010000"              , vaddss(xmm7, xmm5, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C5D258BA00020000"              , vaddss(xmm7, xmm5, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C5D258BA00FEFFFF"              , vaddss(xmm7, xmm5, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C5D258BAFCFDFFFF"              , vaddss(xmm7, xmm5, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62136D4003CAAB"                , valignd(zmm9, zmm18, zmm26, 171));
  TEST_INSTRUCTION("62136D4403CAAB"                , k(k4).valignd(zmm9, zmm18, zmm26, 171));
  TEST_INSTRUCTION("62136DC403CAAB"                , k(k4).z().valignd(zmm9, zmm18, zmm26, 171));
  TEST_INSTRUCTION("62136D4003CA7B"                , valignd(zmm9, zmm18, zmm26, 123));
  TEST_INSTRUCTION("62736D4003097B"                , valignd(zmm9, zmm18, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62336D40038CF0230100007B"      , valignd(zmm9, zmm18, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62736D5003097B"                , valignd(zmm9, zmm18, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62736D40034A7F7B"              , valignd(zmm9, zmm18, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62736D40038A002000007B"        , valignd(zmm9, zmm18, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62736D40034A807B"              , valignd(zmm9, zmm18, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62736D40038AC0DFFFFF7B"        , valignd(zmm9, zmm18, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62736D50034A7F7B"              , valignd(zmm9, zmm18, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62736D50038A000200007B"        , valignd(zmm9, zmm18, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62736D50034A807B"              , valignd(zmm9, zmm18, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62736D50038AFCFDFFFF7B"        , valignd(zmm9, zmm18, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62529D4065C4"                  , vblendmpd(zmm8, zmm28, zmm12));
  TEST_INSTRUCTION("62529D4165C4"                  , k(k1).vblendmpd(zmm8, zmm28, zmm12));
  TEST_INSTRUCTION("62529DC165C4"                  , k(k1).z().vblendmpd(zmm8, zmm28, zmm12));
  TEST_INSTRUCTION("62729D406501"                  , vblendmpd(zmm8, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62329D406584F023010000"        , vblendmpd(zmm8, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62729D506501"                  , vblendmpd(zmm8, zmm28, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62729D4065427F"                , vblendmpd(zmm8, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62729D40658200200000"          , vblendmpd(zmm8, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62729D40654280"                , vblendmpd(zmm8, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62729D406582C0DFFFFF"          , vblendmpd(zmm8, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62729D5065427F"                , vblendmpd(zmm8, zmm28, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62729D50658200040000"          , vblendmpd(zmm8, zmm28, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62729D50654280"                , vblendmpd(zmm8, zmm28, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62729D506582F8FBFFFF"          , vblendmpd(zmm8, zmm28, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62721D4065FC"                  , vblendmps(zmm15, zmm28, zmm4));
  TEST_INSTRUCTION("62721D4365FC"                  , k(k3).vblendmps(zmm15, zmm28, zmm4));
  TEST_INSTRUCTION("62721DC365FC"                  , k(k3).z().vblendmps(zmm15, zmm28, zmm4));
  TEST_INSTRUCTION("62721D406539"                  , vblendmps(zmm15, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62321D4065BCF023010000"        , vblendmps(zmm15, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62721D506539"                  , vblendmps(zmm15, zmm28, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62721D40657A7F"                , vblendmps(zmm15, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62721D4065BA00200000"          , vblendmps(zmm15, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62721D40657A80"                , vblendmps(zmm15, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62721D4065BAC0DFFFFF"          , vblendmps(zmm15, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62721D50657A7F"                , vblendmps(zmm15, zmm28, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62721D5065BA00020000"          , vblendmps(zmm15, zmm28, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62721D50657A80"                , vblendmps(zmm15, zmm28, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62721D5065BAFCFDFFFF"          , vblendmps(zmm15, zmm28, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F27D481A19"                  , vbroadcastf32x4(zmm3, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62F27D4F1A19"                  , k(k7).vbroadcastf32x4(zmm3, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62F27DCF1A19"                  , k(k7).z().vbroadcastf32x4(zmm3, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B27D481A9CF023010000"        , vbroadcastf32x4(zmm3, xmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F27D481A5A7F"                , vbroadcastf32x4(zmm3, xmmword_ptr(rdx, 2032)));
  TEST_INSTRUCTION("62F27D481A9A00080000"          , vbroadcastf32x4(zmm3, xmmword_ptr(rdx, 2048)));
  TEST_INSTRUCTION("62F27D481A5A80"                , vbroadcastf32x4(zmm3, xmmword_ptr(rdx, -2048)));
  TEST_INSTRUCTION("62F27D481A9AF0F7FFFF"          , vbroadcastf32x4(zmm3, xmmword_ptr(rdx, -2064)));
  TEST_INSTRUCTION("6262FD481B09"                  , vbroadcastf64x4(zmm25, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6262FD4E1B09"                  , k(k6).vbroadcastf64x4(zmm25, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6262FDCE1B09"                  , k(k6).z().vbroadcastf64x4(zmm25, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6222FD481B8CF023010000"        , vbroadcastf64x4(zmm25, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262FD481B4A7F"                , vbroadcastf64x4(zmm25, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("6262FD481B8A00100000"          , vbroadcastf64x4(zmm25, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("6262FD481B4A80"                , vbroadcastf64x4(zmm25, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("6262FD481B8AE0EFFFFF"          , vbroadcastf64x4(zmm25, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("62627D485A31"                  , vbroadcasti32x4(zmm30, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62627D4B5A31"                  , k(k3).vbroadcasti32x4(zmm30, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62627DCB5A31"                  , k(k3).z().vbroadcasti32x4(zmm30, xmmword_ptr(rcx)));
  TEST_INSTRUCTION("62227D485AB4F023010000"        , vbroadcasti32x4(zmm30, xmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62627D485A727F"                , vbroadcasti32x4(zmm30, xmmword_ptr(rdx, 2032)));
  TEST_INSTRUCTION("62627D485AB200080000"          , vbroadcasti32x4(zmm30, xmmword_ptr(rdx, 2048)));
  TEST_INSTRUCTION("62627D485A7280"                , vbroadcasti32x4(zmm30, xmmword_ptr(rdx, -2048)));
  TEST_INSTRUCTION("62627D485AB2F0F7FFFF"          , vbroadcasti32x4(zmm30, xmmword_ptr(rdx, -2064)));
  TEST_INSTRUCTION("6272FD485B29"                  , vbroadcasti64x4(zmm13, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6272FD4C5B29"                  , k(k4).vbroadcasti64x4(zmm13, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6272FDCC5B29"                  , k(k4).z().vbroadcasti64x4(zmm13, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("6232FD485BACF023010000"        , vbroadcasti64x4(zmm13, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6272FD485B6A7F"                , vbroadcasti64x4(zmm13, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("6272FD485BAA00100000"          , vbroadcasti64x4(zmm13, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("6272FD485B6A80"                , vbroadcasti64x4(zmm13, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("6272FD485BAAE0EFFFFF"          , vbroadcasti64x4(zmm13, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("6262FD481931"                  , vbroadcastsd(zmm30, qword_ptr(rcx)));
  TEST_INSTRUCTION("6262FD4C1931"                  , k(k4).vbroadcastsd(zmm30, qword_ptr(rcx)));
  TEST_INSTRUCTION("6262FDCC1931"                  , k(k4).z().vbroadcastsd(zmm30, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222FD4819B4F023010000"        , vbroadcastsd(zmm30, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262FD4819727F"                , vbroadcastsd(zmm30, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262FD4819B200040000"          , vbroadcastsd(zmm30, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262FD48197280"                , vbroadcastsd(zmm30, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262FD4819B2F8FBFFFF"          , vbroadcastsd(zmm30, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62A2FD4819EE"                  , vbroadcastsd(zmm21, xmm22));
  TEST_INSTRUCTION("62A2FD4F19EE"                  , k(k7).vbroadcastsd(zmm21, xmm22));
  TEST_INSTRUCTION("62A2FDCF19EE"                  , k(k7).z().vbroadcastsd(zmm21, xmm22));
  TEST_INSTRUCTION("62F27D481819"                  , vbroadcastss(zmm3, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F27D4C1819"                  , k(k4).vbroadcastss(zmm3, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F27DCC1819"                  , k(k4).z().vbroadcastss(zmm3, dword_ptr(rcx)));
  TEST_INSTRUCTION("62B27D48189CF023010000"        , vbroadcastss(zmm3, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F27D48185A7F"                , vbroadcastss(zmm3, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62F27D48189A00020000"          , vbroadcastss(zmm3, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62F27D48185A80"                , vbroadcastss(zmm3, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62F27D48189AFCFDFFFF"          , vbroadcastss(zmm3, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62A27D4818D2"                  , vbroadcastss(zmm18, xmm18));
  TEST_INSTRUCTION("62A27D4A18D2"                  , k(k2).vbroadcastss(zmm18, xmm18));
  TEST_INSTRUCTION("62A27DCA18D2"                  , k(k2).z().vbroadcastss(zmm18, xmm18));
  TEST_INSTRUCTION("62919D48C2D2AB"                , vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D4BC2D2AB"                , k(k3).vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D18C2D2AB"                , sae().vcmppd(k2, zmm12, zmm26, 171));
  TEST_INSTRUCTION("62919D48C2D27B"                , vcmppd(k2, zmm12, zmm26, 123));
  TEST_INSTRUCTION("62919D18C2D27B"                , sae().vcmppd(k2, zmm12, zmm26, 123));
  TEST_INSTRUCTION("62F19D48C2117B"                , vcmppd(k2, zmm12, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B19D48C294F0230100007B"      , vcmppd(k2, zmm12, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F19D58C2117B"                , vcmppd(k2, zmm12, qword_ptr(rcx)._1to8(), 123));
  TEST_INSTRUCTION("62F19D48C2527F7B"              , vcmppd(k2, zmm12, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F19D48C292002000007B"        , vcmppd(k2, zmm12, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F19D48C252807B"              , vcmppd(k2, zmm12, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F19D48C292C0DFFFFF7B"        , vcmppd(k2, zmm12, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F19D58C2527F7B"              , vcmppd(k2, zmm12, qword_ptr(rdx, 1016)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C292000400007B"        , vcmppd(k2, zmm12, qword_ptr(rdx, 1024)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C252807B"              , vcmppd(k2, zmm12, qword_ptr(rdx, -1024)._1to8(), 123));
  TEST_INSTRUCTION("62F19D58C292F8FBFFFF7B"        , vcmppd(k2, zmm12, qword_ptr(rdx, -1032)._1to8(), 123));
  TEST_INSTRUCTION("62B17440C2D6AB"                , vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17443C2D6AB"                , k(k3).vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17410C2D6AB"                , sae().vcmpps(k2, zmm17, zmm22, 171));
  TEST_INSTRUCTION("62B17440C2D67B"                , vcmpps(k2, zmm17, zmm22, 123));
  TEST_INSTRUCTION("62B17410C2D67B"                , sae().vcmpps(k2, zmm17, zmm22, 123));
  TEST_INSTRUCTION("62F17440C2117B"                , vcmpps(k2, zmm17, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B17440C294F0230100007B"      , vcmpps(k2, zmm17, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F17450C2117B"                , vcmpps(k2, zmm17, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62F17440C2527F7B"              , vcmpps(k2, zmm17, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F17440C292002000007B"        , vcmpps(k2, zmm17, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F17440C252807B"              , vcmpps(k2, zmm17, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F17440C292C0DFFFFF7B"        , vcmpps(k2, zmm17, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F17450C2527F7B"              , vcmpps(k2, zmm17, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C292000200007B"        , vcmpps(k2, zmm17, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C252807B"              , vcmpps(k2, zmm17, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62F17450C292FCFDFFFF7B"        , vcmpps(k2, zmm17, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62F1E700C2ECAB"                , vcmpsd(k5, xmm19, xmm4, 171));
  TEST_INSTRUCTION("62F1E701C2ECAB"                , k(k1).vcmpsd(k5, xmm19, xmm4, 171));
  TEST_INSTRUCTION("62F1E710C2ECAB"                , sae().vcmpsd(k5, xmm19, xmm4, 171));
  TEST_INSTRUCTION("62F1E700C2EC7B"                , vcmpsd(k5, xmm19, xmm4, 123));
  TEST_INSTRUCTION("62F1E710C2EC7B"                , sae().vcmpsd(k5, xmm19, xmm4, 123));
  TEST_INSTRUCTION("62F1E700C2297B"                , vcmpsd(k5, xmm19, qword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B1E700C2ACF0230100007B"      , vcmpsd(k5, xmm19, qword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F1E700C26A7F7B"              , vcmpsd(k5, xmm19, qword_ptr(rdx, 1016), 123));
  TEST_INSTRUCTION("62F1E700C2AA000400007B"        , vcmpsd(k5, xmm19, qword_ptr(rdx, 1024), 123));
  TEST_INSTRUCTION("62F1E700C26A807B"              , vcmpsd(k5, xmm19, qword_ptr(rdx, -1024), 123));
  TEST_INSTRUCTION("62F1E700C2AAF8FBFFFF7B"        , vcmpsd(k5, xmm19, qword_ptr(rdx, -1032), 123));
  TEST_INSTRUCTION("62D10608C2E4AB"                , vcmpss(k4, xmm15, xmm12, 171));
  TEST_INSTRUCTION("62D1060DC2E4AB"                , k(k5).vcmpss(k4, xmm15, xmm12, 171));
  TEST_INSTRUCTION("62D10618C2E4AB"                , sae().vcmpss(k4, xmm15, xmm12, 171));
  TEST_INSTRUCTION("62D10608C2E47B"                , vcmpss(k4, xmm15, xmm12, 123));
  TEST_INSTRUCTION("62D10618C2E47B"                , sae().vcmpss(k4, xmm15, xmm12, 123));
  TEST_INSTRUCTION("62F10608C2217B"                , vcmpss(k4, xmm15, dword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B10608C2A4F0230100007B"      , vcmpss(k4, xmm15, dword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F10608C2627F7B"              , vcmpss(k4, xmm15, dword_ptr(rdx, 508), 123));
  TEST_INSTRUCTION("62F10608C2A2000200007B"        , vcmpss(k4, xmm15, dword_ptr(rdx, 512), 123));
  TEST_INSTRUCTION("62F10608C262807B"              , vcmpss(k4, xmm15, dword_ptr(rdx, -512), 123));
  TEST_INSTRUCTION("62F10608C2A2FCFDFFFF7B"        , vcmpss(k4, xmm15, dword_ptr(rdx, -516), 123));
  TEST_INSTRUCTION("62A1FD082FFD"                  , vcomisd(xmm23, xmm21));
  TEST_INSTRUCTION("62A1FD182FFD"                  , sae().vcomisd(xmm23, xmm21));
  TEST_INSTRUCTION("62E1FD082F39"                  , vcomisd(xmm23, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A1FD082FBCF023010000"        , vcomisd(xmm23, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1FD082F7A7F"                , vcomisd(xmm23, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E1FD082FBA00040000"          , vcomisd(xmm23, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E1FD082F7A80"                , vcomisd(xmm23, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E1FD082FBAF8FBFFFF"          , vcomisd(xmm23, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62117C082FF4"                  , vcomiss(xmm14, xmm28));
  TEST_INSTRUCTION("62117C182FF4"                  , sae().vcomiss(xmm14, xmm28));
  TEST_INSTRUCTION("C5782F31"                      , vcomiss(xmm14, dword_ptr(rcx)));
  TEST_INSTRUCTION("C421782FB4F023010000"          , vcomiss(xmm14, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C5782FB2FC010000"              , vcomiss(xmm14, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C5782FB200020000"              , vcomiss(xmm14, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C5782FB200FEFFFF"              , vcomiss(xmm14, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C5782FB2FCFDFFFF"              , vcomiss(xmm14, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6272FD488A09"                  , vcompresspd(zmmword_ptr(rcx), zmm9));
  TEST_INSTRUCTION("6272FD4C8A09"                  , k(k4).vcompresspd(zmmword_ptr(rcx), zmm9));
  TEST_INSTRUCTION("6232FD488A8CF023010000"        , vcompresspd(zmmword_ptr(rax, r14, 3, 291), zmm9));
  TEST_INSTRUCTION("6272FD488A4A7F"                , vcompresspd(zmmword_ptr(rdx, 1016), zmm9));
  TEST_INSTRUCTION("6272FD488A8A00040000"          , vcompresspd(zmmword_ptr(rdx, 1024), zmm9));
  TEST_INSTRUCTION("6272FD488A4A80"                , vcompresspd(zmmword_ptr(rdx, -1024), zmm9));
  TEST_INSTRUCTION("6272FD488A8AF8FBFFFF"          , vcompresspd(zmmword_ptr(rdx, -1032), zmm9));
  TEST_INSTRUCTION("62D2FD488AE0"                  , vcompresspd(zmm8, zmm4));
  TEST_INSTRUCTION("62D2FD4E8AE0"                  , k(k6).vcompresspd(zmm8, zmm4));
  TEST_INSTRUCTION("62D2FDCE8AE0"                  , k(k6).z().vcompresspd(zmm8, zmm4));
  TEST_INSTRUCTION("62727D488A11"                  , vcompressps(zmmword_ptr(rcx), zmm10));
  TEST_INSTRUCTION("62727D4F8A11"                  , k(k7).vcompressps(zmmword_ptr(rcx), zmm10));
  TEST_INSTRUCTION("62327D488A94F023010000"        , vcompressps(zmmword_ptr(rax, r14, 3, 291), zmm10));
  TEST_INSTRUCTION("62727D488A527F"                , vcompressps(zmmword_ptr(rdx, 508), zmm10));
  TEST_INSTRUCTION("62727D488A9200020000"          , vcompressps(zmmword_ptr(rdx, 512), zmm10));
  TEST_INSTRUCTION("62727D488A5280"                , vcompressps(zmmword_ptr(rdx, -512), zmm10));
  TEST_INSTRUCTION("62727D488A92FCFDFFFF"          , vcompressps(zmmword_ptr(rdx, -516), zmm10));
  TEST_INSTRUCTION("62727D488AF4"                  , vcompressps(zmm4, zmm14));
  TEST_INSTRUCTION("62727D4A8AF4"                  , k(k2).vcompressps(zmm4, zmm14));
  TEST_INSTRUCTION("62727DCA8AF4"                  , k(k2).z().vcompressps(zmm4, zmm14));
  TEST_INSTRUCTION("62817E48E6F0"                  , vcvtdq2pd(zmm22, ymm24));
  TEST_INSTRUCTION("62817E4CE6F0"                  , k(k4).vcvtdq2pd(zmm22, ymm24));
  TEST_INSTRUCTION("62817ECCE6F0"                  , k(k4).z().vcvtdq2pd(zmm22, ymm24));
  TEST_INSTRUCTION("62E17E48E631"                  , vcvtdq2pd(zmm22, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17E48E6B4F023010000"        , vcvtdq2pd(zmm22, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17E58E631"                  , vcvtdq2pd(zmm22, dword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E17E48E6727F"                , vcvtdq2pd(zmm22, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("62E17E48E6B200100000"          , vcvtdq2pd(zmm22, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("62E17E48E67280"                , vcvtdq2pd(zmm22, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("62E17E48E6B2E0EFFFFF"          , vcvtdq2pd(zmm22, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("62E17E58E6727F"                , vcvtdq2pd(zmm22, dword_ptr(rdx, 508)._1to8()));
  TEST_INSTRUCTION("62E17E58E6B200020000"          , vcvtdq2pd(zmm22, dword_ptr(rdx, 512)._1to8()));
  TEST_INSTRUCTION("62E17E58E67280"                , vcvtdq2pd(zmm22, dword_ptr(rdx, -512)._1to8()));
  TEST_INSTRUCTION("62E17E58E6B2FCFDFFFF"          , vcvtdq2pd(zmm22, dword_ptr(rdx, -516)._1to8()));
  TEST_INSTRUCTION("62917C485BF9"                  , vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917C4D5BF9"                  , k(k5).vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917CCD5BF9"                  , k(k5).z().vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917C185BF9"                  , rn_sae().vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917C585BF9"                  , ru_sae().vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917C385BF9"                  , rd_sae().vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62917C785BF9"                  , rz_sae().vcvtdq2ps(zmm7, zmm25));
  TEST_INSTRUCTION("62F17C485B39"                  , vcvtdq2ps(zmm7, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B17C485BBCF023010000"        , vcvtdq2ps(zmm7, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F17C585B39"                  , vcvtdq2ps(zmm7, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F17C485B7A7F"                , vcvtdq2ps(zmm7, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F17C485BBA00200000"          , vcvtdq2ps(zmm7, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F17C485B7A80"                , vcvtdq2ps(zmm7, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F17C485BBAC0DFFFFF"          , vcvtdq2ps(zmm7, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F17C585B7A7F"                , vcvtdq2ps(zmm7, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F17C585BBA00020000"          , vcvtdq2ps(zmm7, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F17C585B7A80"                , vcvtdq2ps(zmm7, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F17C585BBAFCFDFFFF"          , vcvtdq2ps(zmm7, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6241FF48E6C7"                  , vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FF4BE6C7"                  , k(k3).vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FFCBE6C7"                  , k(k3).z().vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FF18E6C7"                  , rn_sae().vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FF58E6C7"                  , ru_sae().vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FF38E6C7"                  , rd_sae().vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6241FF78E6C7"                  , rz_sae().vcvtpd2dq(ymm24, zmm15));
  TEST_INSTRUCTION("6261FF48E601"                  , vcvtpd2dq(ymm24, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6221FF48E684F023010000"        , vcvtpd2dq(ymm24, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261FF58E601"                  , vcvtpd2dq(ymm24, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6261FF48E6427F"                , vcvtpd2dq(ymm24, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6261FF48E68200200000"          , vcvtpd2dq(ymm24, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6261FF48E64280"                , vcvtpd2dq(ymm24, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6261FF48E682C0DFFFFF"          , vcvtpd2dq(ymm24, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6261FF58E6427F"                , vcvtpd2dq(ymm24, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6261FF58E68200040000"          , vcvtpd2dq(ymm24, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6261FF58E64280"                , vcvtpd2dq(ymm24, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6261FF58E682F8FBFFFF"          , vcvtpd2dq(ymm24, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62B1FD485AEF"                  , vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FD4D5AEF"                  , k(k5).vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FDCD5AEF"                  , k(k5).z().vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FD185AEF"                  , rn_sae().vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FD585AEF"                  , ru_sae().vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FD385AEF"                  , rd_sae().vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62B1FD785AEF"                  , rz_sae().vcvtpd2ps(ymm5, zmm23));
  TEST_INSTRUCTION("62F1FD485A29"                  , vcvtpd2ps(ymm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1FD485AACF023010000"        , vcvtpd2ps(ymm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1FD585A29"                  , vcvtpd2ps(ymm5, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F1FD485A6A7F"                , vcvtpd2ps(ymm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1FD485AAA00200000"          , vcvtpd2ps(ymm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F1FD485A6A80"                , vcvtpd2ps(ymm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1FD485AAAC0DFFFFF"          , vcvtpd2ps(ymm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F1FD585A6A7F"                , vcvtpd2ps(ymm5, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F1FD585AAA00040000"          , vcvtpd2ps(ymm5, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F1FD585A6A80"                , vcvtpd2ps(ymm5, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F1FD585AAAF8FBFFFF"          , vcvtpd2ps(ymm5, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("6231FC4879FB"                  , vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FC4F79FB"                  , k(k7).vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FCCF79FB"                  , k(k7).z().vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FC1879FB"                  , rn_sae().vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FC5879FB"                  , ru_sae().vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FC3879FB"                  , rd_sae().vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6231FC7879FB"                  , rz_sae().vcvtpd2udq(ymm15, zmm19));
  TEST_INSTRUCTION("6271FC487939"                  , vcvtpd2udq(ymm15, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6231FC4879BCF023010000"        , vcvtpd2udq(ymm15, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6271FC587939"                  , vcvtpd2udq(ymm15, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6271FC48797A7F"                , vcvtpd2udq(ymm15, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6271FC4879BA00200000"          , vcvtpd2udq(ymm15, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6271FC48797A80"                , vcvtpd2udq(ymm15, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6271FC4879BAC0DFFFFF"          , vcvtpd2udq(ymm15, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6271FC58797A7F"                , vcvtpd2udq(ymm15, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6271FC5879BA00040000"          , vcvtpd2udq(ymm15, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6271FC58797A80"                , vcvtpd2udq(ymm15, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6271FC5879BAF8FBFFFF"          , vcvtpd2udq(ymm15, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62127D4813EB"                  , vcvtph2ps(zmm13, ymm27));
  TEST_INSTRUCTION("62127D4B13EB"                  , k(k3).vcvtph2ps(zmm13, ymm27));
  TEST_INSTRUCTION("62127DCB13EB"                  , k(k3).z().vcvtph2ps(zmm13, ymm27));
  TEST_INSTRUCTION("62127D1813EB"                  , sae().vcvtph2ps(zmm13, ymm27));
  TEST_INSTRUCTION("62727D481329"                  , vcvtph2ps(zmm13, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("62327D4813ACF023010000"        , vcvtph2ps(zmm13, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62727D48136A7F"                , vcvtph2ps(zmm13, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("62727D4813AA00100000"          , vcvtph2ps(zmm13, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("62727D48136A80"                , vcvtph2ps(zmm13, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("62727D4813AAE0EFFFFF"          , vcvtph2ps(zmm13, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("62117D485BE0"                  , vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117D4C5BE0"                  , k(k4).vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117DCC5BE0"                  , k(k4).z().vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117D185BE0"                  , rn_sae().vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117D585BE0"                  , ru_sae().vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117D385BE0"                  , rd_sae().vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62117D785BE0"                  , rz_sae().vcvtps2dq(zmm12, zmm24));
  TEST_INSTRUCTION("62717D485B21"                  , vcvtps2dq(zmm12, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62317D485BA4F023010000"        , vcvtps2dq(zmm12, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62717D585B21"                  , vcvtps2dq(zmm12, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62717D485B627F"                , vcvtps2dq(zmm12, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62717D485BA200200000"          , vcvtps2dq(zmm12, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62717D485B6280"                , vcvtps2dq(zmm12, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62717D485BA2C0DFFFFF"          , vcvtps2dq(zmm12, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62717D585B627F"                , vcvtps2dq(zmm12, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62717D585BA200020000"          , vcvtps2dq(zmm12, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62717D585B6280"                , vcvtps2dq(zmm12, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62717D585BA2FCFDFFFF"          , vcvtps2dq(zmm12, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62717C485AEE"                  , vcvtps2pd(zmm13, ymm6));
  TEST_INSTRUCTION("62717C4B5AEE"                  , k(k3).vcvtps2pd(zmm13, ymm6));
  TEST_INSTRUCTION("62717CCB5AEE"                  , k(k3).z().vcvtps2pd(zmm13, ymm6));
  TEST_INSTRUCTION("62717C185AEE"                  , sae().vcvtps2pd(zmm13, ymm6));
  TEST_INSTRUCTION("62717C485A29"                  , vcvtps2pd(zmm13, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("62317C485AACF023010000"        , vcvtps2pd(zmm13, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62717C585A29"                  , vcvtps2pd(zmm13, dword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62717C485A6A7F"                , vcvtps2pd(zmm13, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("62717C485AAA00100000"          , vcvtps2pd(zmm13, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("62717C485A6A80"                , vcvtps2pd(zmm13, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("62717C485AAAE0EFFFFF"          , vcvtps2pd(zmm13, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("62717C585A6A7F"                , vcvtps2pd(zmm13, dword_ptr(rdx, 508)._1to8()));
  TEST_INSTRUCTION("62717C585AAA00020000"          , vcvtps2pd(zmm13, dword_ptr(rdx, 512)._1to8()));
  TEST_INSTRUCTION("62717C585A6A80"                , vcvtps2pd(zmm13, dword_ptr(rdx, -512)._1to8()));
  TEST_INSTRUCTION("62717C585AAAFCFDFFFF"          , vcvtps2pd(zmm13, dword_ptr(rdx, -516)._1to8()));
  TEST_INSTRUCTION("62537D481DF3AB"                , vcvtps2ph(ymm11, zmm14, 171));
  TEST_INSTRUCTION("62537D4E1DF3AB"                , k(k6).vcvtps2ph(ymm11, zmm14, 171));
  TEST_INSTRUCTION("62537DCE1DF3AB"                , k(k6).z().vcvtps2ph(ymm11, zmm14, 171));
  TEST_INSTRUCTION("62537D181DF3AB"                , sae().vcvtps2ph(ymm11, zmm14, 171));
  TEST_INSTRUCTION("62537D481DF37B"                , vcvtps2ph(ymm11, zmm14, 123));
  TEST_INSTRUCTION("62537D181DF37B"                , sae().vcvtps2ph(ymm11, zmm14, 123));
  TEST_INSTRUCTION("62117C4879E2"                  , vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117C4C79E2"                  , k(k4).vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117CCC79E2"                  , k(k4).z().vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117C1879E2"                  , rn_sae().vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117C5879E2"                  , ru_sae().vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117C3879E2"                  , rd_sae().vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62117C7879E2"                  , rz_sae().vcvtps2udq(zmm12, zmm26));
  TEST_INSTRUCTION("62717C487921"                  , vcvtps2udq(zmm12, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62317C4879A4F023010000"        , vcvtps2udq(zmm12, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62717C587921"                  , vcvtps2udq(zmm12, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62717C4879627F"                , vcvtps2udq(zmm12, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62717C4879A200200000"          , vcvtps2udq(zmm12, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62717C48796280"                , vcvtps2udq(zmm12, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62717C4879A2C0DFFFFF"          , vcvtps2udq(zmm12, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62717C5879627F"                , vcvtps2udq(zmm12, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62717C5879A200020000"          , vcvtps2udq(zmm12, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62717C58796280"                , vcvtps2udq(zmm12, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62717C5879A2FCFDFFFF"          , vcvtps2udq(zmm12, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F17F182DC7"                  , rn_sae().vcvtsd2si(eax, xmm7));
  TEST_INSTRUCTION("62F17F582DC7"                  , ru_sae().vcvtsd2si(eax, xmm7));
  TEST_INSTRUCTION("62F17F382DC7"                  , rd_sae().vcvtsd2si(eax, xmm7));
  TEST_INSTRUCTION("62F17F782DC7"                  , rz_sae().vcvtsd2si(eax, xmm7));
  TEST_INSTRUCTION("62F17F182DEF"                  , rn_sae().vcvtsd2si(ebp, xmm7));
  TEST_INSTRUCTION("62F17F582DEF"                  , ru_sae().vcvtsd2si(ebp, xmm7));
  TEST_INSTRUCTION("62F17F382DEF"                  , rd_sae().vcvtsd2si(ebp, xmm7));
  TEST_INSTRUCTION("62F17F782DEF"                  , rz_sae().vcvtsd2si(ebp, xmm7));
  TEST_INSTRUCTION("62717F182DEF"                  , rn_sae().vcvtsd2si(r13d, xmm7));
  TEST_INSTRUCTION("62717F582DEF"                  , ru_sae().vcvtsd2si(r13d, xmm7));
  TEST_INSTRUCTION("62717F382DEF"                  , rd_sae().vcvtsd2si(r13d, xmm7));
  TEST_INSTRUCTION("62717F782DEF"                  , rz_sae().vcvtsd2si(r13d, xmm7));
  TEST_INSTRUCTION("62D1FF182DC2"                  , rn_sae().vcvtsd2si(rax, xmm10));
  TEST_INSTRUCTION("62D1FF582DC2"                  , ru_sae().vcvtsd2si(rax, xmm10));
  TEST_INSTRUCTION("62D1FF382DC2"                  , rd_sae().vcvtsd2si(rax, xmm10));
  TEST_INSTRUCTION("62D1FF782DC2"                  , rz_sae().vcvtsd2si(rax, xmm10));
  TEST_INSTRUCTION("6251FF182DC2"                  , rn_sae().vcvtsd2si(r8, xmm10));
  TEST_INSTRUCTION("6251FF582DC2"                  , ru_sae().vcvtsd2si(r8, xmm10));
  TEST_INSTRUCTION("6251FF382DC2"                  , rd_sae().vcvtsd2si(r8, xmm10));
  TEST_INSTRUCTION("6251FF782DC2"                  , rz_sae().vcvtsd2si(r8, xmm10));
  TEST_INSTRUCTION("62C1B7085ACC"                  , vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B70E5ACC"                  , k(k6).vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B78E5ACC"                  , k(k6).z().vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B7185ACC"                  , rn_sae().vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B7585ACC"                  , ru_sae().vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B7385ACC"                  , rd_sae().vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62C1B7785ACC"                  , rz_sae().vcvtsd2ss(xmm17, xmm9, xmm12));
  TEST_INSTRUCTION("62E1B7085A09"                  , vcvtsd2ss(xmm17, xmm9, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A1B7085A8CF023010000"        , vcvtsd2ss(xmm17, xmm9, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1B7085A4A7F"                , vcvtsd2ss(xmm17, xmm9, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E1B7085A8A00040000"          , vcvtsd2ss(xmm17, xmm9, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E1B7085A4A80"                , vcvtsd2ss(xmm17, xmm9, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E1B7085A8AF8FBFFFF"          , vcvtsd2ss(xmm17, xmm9, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("C5AB2AF8"                      , vcvtsi2sd(xmm7, xmm10, eax));
  TEST_INSTRUCTION("C5AB2AFD"                      , vcvtsi2sd(xmm7, xmm10, ebp));
  TEST_INSTRUCTION("C4C12B2AFD"                    , vcvtsi2sd(xmm7, xmm10, r13d));
  TEST_INSTRUCTION("C5AB2A39"                      , vcvtsi2sd(xmm7, xmm10, dword_ptr(rcx)));
  TEST_INSTRUCTION("C4A12B2ABCF023010000"          , vcvtsi2sd(xmm7, xmm10, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C5AB2ABAFC010000"              , vcvtsi2sd(xmm7, xmm10, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C5AB2ABA00020000"              , vcvtsi2sd(xmm7, xmm10, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C5AB2ABA00FEFFFF"              , vcvtsi2sd(xmm7, xmm10, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C5AB2ABAFCFDFFFF"              , vcvtsi2sd(xmm7, xmm10, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62619F082AE8"                  , vcvtsi2sd(xmm29, xmm12, rax));
  TEST_INSTRUCTION("62619F182AE8"                  , rn_sae().vcvtsi2sd(xmm29, xmm12, rax));
  TEST_INSTRUCTION("62619F582AE8"                  , ru_sae().vcvtsi2sd(xmm29, xmm12, rax));
  TEST_INSTRUCTION("62619F382AE8"                  , rd_sae().vcvtsi2sd(xmm29, xmm12, rax));
  TEST_INSTRUCTION("62619F782AE8"                  , rz_sae().vcvtsi2sd(xmm29, xmm12, rax));
  TEST_INSTRUCTION("62419F082AE8"                  , vcvtsi2sd(xmm29, xmm12, r8));
  TEST_INSTRUCTION("62419F182AE8"                  , rn_sae().vcvtsi2sd(xmm29, xmm12, r8));
  TEST_INSTRUCTION("62419F582AE8"                  , ru_sae().vcvtsi2sd(xmm29, xmm12, r8));
  TEST_INSTRUCTION("62419F382AE8"                  , rd_sae().vcvtsi2sd(xmm29, xmm12, r8));
  TEST_INSTRUCTION("62419F782AE8"                  , rz_sae().vcvtsi2sd(xmm29, xmm12, r8));
  TEST_INSTRUCTION("62619F082A29"                  , vcvtsi2sd(xmm29, xmm12, qword_ptr(rcx)));
  TEST_INSTRUCTION("62219F082AACF023010000"        , vcvtsi2sd(xmm29, xmm12, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62619F082A6A7F"                , vcvtsi2sd(xmm29, xmm12, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62619F082AAA00040000"          , vcvtsi2sd(xmm29, xmm12, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62619F082A6A80"                , vcvtsi2sd(xmm29, xmm12, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62619F082AAAF8FBFFFF"          , vcvtsi2sd(xmm29, xmm12, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("C52A2AF8"                      , vcvtsi2ss(xmm15, xmm10, eax));
  TEST_INSTRUCTION("62712E182AF8"                  , rn_sae().vcvtsi2ss(xmm15, xmm10, eax));
  TEST_INSTRUCTION("62712E582AF8"                  , ru_sae().vcvtsi2ss(xmm15, xmm10, eax));
  TEST_INSTRUCTION("62712E382AF8"                  , rd_sae().vcvtsi2ss(xmm15, xmm10, eax));
  TEST_INSTRUCTION("62712E782AF8"                  , rz_sae().vcvtsi2ss(xmm15, xmm10, eax));
  TEST_INSTRUCTION("C52A2AFD"                      , vcvtsi2ss(xmm15, xmm10, ebp));
  TEST_INSTRUCTION("62712E182AFD"                  , rn_sae().vcvtsi2ss(xmm15, xmm10, ebp));
  TEST_INSTRUCTION("62712E582AFD"                  , ru_sae().vcvtsi2ss(xmm15, xmm10, ebp));
  TEST_INSTRUCTION("62712E382AFD"                  , rd_sae().vcvtsi2ss(xmm15, xmm10, ebp));
  TEST_INSTRUCTION("62712E782AFD"                  , rz_sae().vcvtsi2ss(xmm15, xmm10, ebp));
  TEST_INSTRUCTION("C4412A2AFD"                    , vcvtsi2ss(xmm15, xmm10, r13d));
  TEST_INSTRUCTION("62512E182AFD"                  , rn_sae().vcvtsi2ss(xmm15, xmm10, r13d));
  TEST_INSTRUCTION("62512E582AFD"                  , ru_sae().vcvtsi2ss(xmm15, xmm10, r13d));
  TEST_INSTRUCTION("62512E382AFD"                  , rd_sae().vcvtsi2ss(xmm15, xmm10, r13d));
  TEST_INSTRUCTION("62512E782AFD"                  , rz_sae().vcvtsi2ss(xmm15, xmm10, r13d));
  TEST_INSTRUCTION("C52A2A39"                      , vcvtsi2ss(xmm15, xmm10, dword_ptr(rcx)));
  TEST_INSTRUCTION("C4212A2ABCF023010000"          , vcvtsi2ss(xmm15, xmm10, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C52A2ABAFC010000"              , vcvtsi2ss(xmm15, xmm10, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C52A2ABA00020000"              , vcvtsi2ss(xmm15, xmm10, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C52A2ABA00FEFFFF"              , vcvtsi2ss(xmm15, xmm10, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C52A2ABAFCFDFFFF"              , vcvtsi2ss(xmm15, xmm10, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62E1AE082AC0"                  , vcvtsi2ss(xmm16, xmm10, rax));
  TEST_INSTRUCTION("62E1AE182AC0"                  , rn_sae().vcvtsi2ss(xmm16, xmm10, rax));
  TEST_INSTRUCTION("62E1AE582AC0"                  , ru_sae().vcvtsi2ss(xmm16, xmm10, rax));
  TEST_INSTRUCTION("62E1AE382AC0"                  , rd_sae().vcvtsi2ss(xmm16, xmm10, rax));
  TEST_INSTRUCTION("62E1AE782AC0"                  , rz_sae().vcvtsi2ss(xmm16, xmm10, rax));
  TEST_INSTRUCTION("62C1AE082AC0"                  , vcvtsi2ss(xmm16, xmm10, r8));
  TEST_INSTRUCTION("62C1AE182AC0"                  , rn_sae().vcvtsi2ss(xmm16, xmm10, r8));
  TEST_INSTRUCTION("62C1AE582AC0"                  , ru_sae().vcvtsi2ss(xmm16, xmm10, r8));
  TEST_INSTRUCTION("62C1AE382AC0"                  , rd_sae().vcvtsi2ss(xmm16, xmm10, r8));
  TEST_INSTRUCTION("62C1AE782AC0"                  , rz_sae().vcvtsi2ss(xmm16, xmm10, r8));
  TEST_INSTRUCTION("62E1AE082A01"                  , vcvtsi2ss(xmm16, xmm10, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A1AE082A84F023010000"        , vcvtsi2ss(xmm16, xmm10, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1AE082A427F"                , vcvtsi2ss(xmm16, xmm10, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E1AE082A8200040000"          , vcvtsi2ss(xmm16, xmm10, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E1AE082A4280"                , vcvtsi2ss(xmm16, xmm10, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E1AE082A82F8FBFFFF"          , vcvtsi2ss(xmm16, xmm10, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62614E085AE6"                  , vcvtss2sd(xmm28, xmm6, xmm6));
  TEST_INSTRUCTION("62614E0B5AE6"                  , k(k3).vcvtss2sd(xmm28, xmm6, xmm6));
  TEST_INSTRUCTION("62614E8B5AE6"                  , k(k3).z().vcvtss2sd(xmm28, xmm6, xmm6));
  TEST_INSTRUCTION("62614E185AE6"                  , sae().vcvtss2sd(xmm28, xmm6, xmm6));
  TEST_INSTRUCTION("62614E085A21"                  , vcvtss2sd(xmm28, xmm6, dword_ptr(rcx)));
  TEST_INSTRUCTION("62214E085AA4F023010000"        , vcvtss2sd(xmm28, xmm6, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62614E085A627F"                , vcvtss2sd(xmm28, xmm6, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62614E085AA200020000"          , vcvtss2sd(xmm28, xmm6, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62614E085A6280"                , vcvtss2sd(xmm28, xmm6, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62614E085AA2FCFDFFFF"          , vcvtss2sd(xmm28, xmm6, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62B17E182DC6"                  , rn_sae().vcvtss2si(eax, xmm22));
  TEST_INSTRUCTION("62B17E582DC6"                  , ru_sae().vcvtss2si(eax, xmm22));
  TEST_INSTRUCTION("62B17E382DC6"                  , rd_sae().vcvtss2si(eax, xmm22));
  TEST_INSTRUCTION("62B17E782DC6"                  , rz_sae().vcvtss2si(eax, xmm22));
  TEST_INSTRUCTION("62B17E182DEE"                  , rn_sae().vcvtss2si(ebp, xmm22));
  TEST_INSTRUCTION("62B17E582DEE"                  , ru_sae().vcvtss2si(ebp, xmm22));
  TEST_INSTRUCTION("62B17E382DEE"                  , rd_sae().vcvtss2si(ebp, xmm22));
  TEST_INSTRUCTION("62B17E782DEE"                  , rz_sae().vcvtss2si(ebp, xmm22));
  TEST_INSTRUCTION("62317E182DEE"                  , rn_sae().vcvtss2si(r13d, xmm22));
  TEST_INSTRUCTION("62317E582DEE"                  , ru_sae().vcvtss2si(r13d, xmm22));
  TEST_INSTRUCTION("62317E382DEE"                  , rd_sae().vcvtss2si(r13d, xmm22));
  TEST_INSTRUCTION("62317E782DEE"                  , rz_sae().vcvtss2si(r13d, xmm22));
  TEST_INSTRUCTION("6291FE182DC5"                  , rn_sae().vcvtss2si(rax, xmm29));
  TEST_INSTRUCTION("6291FE582DC5"                  , ru_sae().vcvtss2si(rax, xmm29));
  TEST_INSTRUCTION("6291FE382DC5"                  , rd_sae().vcvtss2si(rax, xmm29));
  TEST_INSTRUCTION("6291FE782DC5"                  , rz_sae().vcvtss2si(rax, xmm29));
  TEST_INSTRUCTION("6211FE182DC5"                  , rn_sae().vcvtss2si(r8, xmm29));
  TEST_INSTRUCTION("6211FE582DC5"                  , ru_sae().vcvtss2si(r8, xmm29));
  TEST_INSTRUCTION("6211FE382DC5"                  , rd_sae().vcvtss2si(r8, xmm29));
  TEST_INSTRUCTION("6211FE782DC5"                  , rz_sae().vcvtss2si(r8, xmm29));
  TEST_INSTRUCTION("6241FD48E6D9"                  , vcvttpd2dq(ymm27, zmm9));
  TEST_INSTRUCTION("6241FD4DE6D9"                  , k(k5).vcvttpd2dq(ymm27, zmm9));
  TEST_INSTRUCTION("6241FDCDE6D9"                  , k(k5).z().vcvttpd2dq(ymm27, zmm9));
  TEST_INSTRUCTION("6241FD18E6D9"                  , sae().vcvttpd2dq(ymm27, zmm9));
  TEST_INSTRUCTION("6261FD48E619"                  , vcvttpd2dq(ymm27, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6221FD48E69CF023010000"        , vcvttpd2dq(ymm27, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261FD58E619"                  , vcvttpd2dq(ymm27, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6261FD48E65A7F"                , vcvttpd2dq(ymm27, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6261FD48E69A00200000"          , vcvttpd2dq(ymm27, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6261FD48E65A80"                , vcvttpd2dq(ymm27, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6261FD48E69AC0DFFFFF"          , vcvttpd2dq(ymm27, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6261FD58E65A7F"                , vcvttpd2dq(ymm27, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6261FD58E69A00040000"          , vcvttpd2dq(ymm27, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6261FD58E65A80"                , vcvttpd2dq(ymm27, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6261FD58E69AF8FBFFFF"          , vcvttpd2dq(ymm27, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62117E485BF1"                  , vcvttps2dq(zmm14, zmm25));
  TEST_INSTRUCTION("62117E4B5BF1"                  , k(k3).vcvttps2dq(zmm14, zmm25));
  TEST_INSTRUCTION("62117ECB5BF1"                  , k(k3).z().vcvttps2dq(zmm14, zmm25));
  TEST_INSTRUCTION("62117E185BF1"                  , sae().vcvttps2dq(zmm14, zmm25));
  TEST_INSTRUCTION("62717E485B31"                  , vcvttps2dq(zmm14, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62317E485BB4F023010000"        , vcvttps2dq(zmm14, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62717E585B31"                  , vcvttps2dq(zmm14, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62717E485B727F"                , vcvttps2dq(zmm14, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62717E485BB200200000"          , vcvttps2dq(zmm14, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62717E485B7280"                , vcvttps2dq(zmm14, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62717E485BB2C0DFFFFF"          , vcvttps2dq(zmm14, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62717E585B727F"                , vcvttps2dq(zmm14, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62717E585BB200020000"          , vcvttps2dq(zmm14, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62717E585B7280"                , vcvttps2dq(zmm14, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62717E585BB2FCFDFFFF"          , vcvttps2dq(zmm14, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F17F182CC3"                  , sae().vcvttsd2si(eax, xmm3));
  TEST_INSTRUCTION("62F17F182CEB"                  , sae().vcvttsd2si(ebp, xmm3));
  TEST_INSTRUCTION("62717F182CEB"                  , sae().vcvttsd2si(r13d, xmm3));
  TEST_INSTRUCTION("62F1FF182CC1"                  , sae().vcvttsd2si(rax, xmm1));
  TEST_INSTRUCTION("6271FF182CC1"                  , sae().vcvttsd2si(r8, xmm1));
  TEST_INSTRUCTION("62D17E182CC6"                  , sae().vcvttss2si(eax, xmm14));
  TEST_INSTRUCTION("62D17E182CEE"                  , sae().vcvttss2si(ebp, xmm14));
  TEST_INSTRUCTION("62517E182CEE"                  , sae().vcvttss2si(r13d, xmm14));
  TEST_INSTRUCTION("62B1FE182CC5"                  , sae().vcvttss2si(rax, xmm21));
  TEST_INSTRUCTION("6231FE182CC5"                  , sae().vcvttss2si(r8, xmm21));
  TEST_INSTRUCTION("62C17E487AD6"                  , vcvtudq2pd(zmm18, ymm14));
  TEST_INSTRUCTION("62C17E4B7AD6"                  , k(k3).vcvtudq2pd(zmm18, ymm14));
  TEST_INSTRUCTION("62C17ECB7AD6"                  , k(k3).z().vcvtudq2pd(zmm18, ymm14));
  TEST_INSTRUCTION("62E17E487A11"                  , vcvtudq2pd(zmm18, ymmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17E487A94F023010000"        , vcvtudq2pd(zmm18, ymmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17E587A11"                  , vcvtudq2pd(zmm18, dword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E17E487A527F"                , vcvtudq2pd(zmm18, ymmword_ptr(rdx, 4064)));
  TEST_INSTRUCTION("62E17E487A9200100000"          , vcvtudq2pd(zmm18, ymmword_ptr(rdx, 4096)));
  TEST_INSTRUCTION("62E17E487A5280"                , vcvtudq2pd(zmm18, ymmword_ptr(rdx, -4096)));
  TEST_INSTRUCTION("62E17E487A92E0EFFFFF"          , vcvtudq2pd(zmm18, ymmword_ptr(rdx, -4128)));
  TEST_INSTRUCTION("62E17E587A527F"                , vcvtudq2pd(zmm18, dword_ptr(rdx, 508)._1to8()));
  TEST_INSTRUCTION("62E17E587A9200020000"          , vcvtudq2pd(zmm18, dword_ptr(rdx, 512)._1to8()));
  TEST_INSTRUCTION("62E17E587A5280"                , vcvtudq2pd(zmm18, dword_ptr(rdx, -512)._1to8()));
  TEST_INSTRUCTION("62E17E587A92FCFDFFFF"          , vcvtudq2pd(zmm18, dword_ptr(rdx, -516)._1to8()));
  TEST_INSTRUCTION("62E17F487AD7"                  , vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F4A7AD7"                  , k(k2).vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17FCA7AD7"                  , k(k2).z().vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F187AD7"                  , rn_sae().vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F587AD7"                  , ru_sae().vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F387AD7"                  , rd_sae().vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F787AD7"                  , rz_sae().vcvtudq2ps(zmm18, zmm7));
  TEST_INSTRUCTION("62E17F487A11"                  , vcvtudq2ps(zmm18, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17F487A94F023010000"        , vcvtudq2ps(zmm18, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17F587A11"                  , vcvtudq2ps(zmm18, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E17F487A527F"                , vcvtudq2ps(zmm18, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E17F487A9200200000"          , vcvtudq2ps(zmm18, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E17F487A5280"                , vcvtudq2ps(zmm18, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E17F487A92C0DFFFFF"          , vcvtudq2ps(zmm18, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E17F587A527F"                , vcvtudq2ps(zmm18, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E17F587A9200020000"          , vcvtudq2ps(zmm18, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E17F587A5280"                , vcvtudq2ps(zmm18, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E17F587A92FCFDFFFF"          , vcvtudq2ps(zmm18, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62C1CD485ED3"                  , vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CD4C5ED3"                  , k(k4).vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CDCC5ED3"                  , k(k4).z().vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CD185ED3"                  , rn_sae().vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CD585ED3"                  , ru_sae().vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CD385ED3"                  , rd_sae().vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62C1CD785ED3"                  , rz_sae().vdivpd(zmm18, zmm6, zmm11));
  TEST_INSTRUCTION("62E1CD485E11"                  , vdivpd(zmm18, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A1CD485E94F023010000"        , vdivpd(zmm18, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1CD585E11"                  , vdivpd(zmm18, zmm6, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E1CD485E527F"                , vdivpd(zmm18, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E1CD485E9200200000"          , vdivpd(zmm18, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E1CD485E5280"                , vdivpd(zmm18, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E1CD485E92C0DFFFFF"          , vdivpd(zmm18, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E1CD585E527F"                , vdivpd(zmm18, zmm6, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E1CD585E9200040000"          , vdivpd(zmm18, zmm6, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E1CD585E5280"                , vdivpd(zmm18, zmm6, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E1CD585E92F8FBFFFF"          , vdivpd(zmm18, zmm6, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("628144405EFC"                  , vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144425EFC"                  , k(k2).vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144C25EFC"                  , k(k2).z().vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144105EFC"                  , rn_sae().vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144505EFC"                  , ru_sae().vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144305EFC"                  , rd_sae().vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("628144705EFC"                  , rz_sae().vdivps(zmm23, zmm23, zmm28));
  TEST_INSTRUCTION("62E144405E39"                  , vdivps(zmm23, zmm23, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A144405EBCF023010000"        , vdivps(zmm23, zmm23, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E144505E39"                  , vdivps(zmm23, zmm23, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E144405E7A7F"                , vdivps(zmm23, zmm23, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E144405EBA00200000"          , vdivps(zmm23, zmm23, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E144405E7A80"                , vdivps(zmm23, zmm23, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E144405EBAC0DFFFFF"          , vdivps(zmm23, zmm23, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E144505E7A7F"                , vdivps(zmm23, zmm23, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E144505EBA00020000"          , vdivps(zmm23, zmm23, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E144505E7A80"                , vdivps(zmm23, zmm23, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E144505EBAFCFDFFFF"          , vdivps(zmm23, zmm23, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("622197085EEE"                  , vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("6221970B5EEE"                  , k(k3).vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("6221978B5EEE"                  , k(k3).z().vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("622197185EEE"                  , rn_sae().vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("622197585EEE"                  , ru_sae().vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("622197385EEE"                  , rd_sae().vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("622197785EEE"                  , rz_sae().vdivsd(xmm29, xmm13, xmm22));
  TEST_INSTRUCTION("626197085E29"                  , vdivsd(xmm29, xmm13, qword_ptr(rcx)));
  TEST_INSTRUCTION("622197085EACF023010000"        , vdivsd(xmm29, xmm13, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("626197085E6A7F"                , vdivsd(xmm29, xmm13, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("626197085EAA00040000"          , vdivsd(xmm29, xmm13, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("626197085E6A80"                , vdivsd(xmm29, xmm13, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("626197085EAAF8FBFFFF"          , vdivsd(xmm29, xmm13, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62A14E085EE9"                  , vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E0D5EE9"                  , k(k5).vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E8D5EE9"                  , k(k5).z().vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E185EE9"                  , rn_sae().vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E585EE9"                  , ru_sae().vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E385EE9"                  , rd_sae().vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62A14E785EE9"                  , rz_sae().vdivss(xmm21, xmm6, xmm17));
  TEST_INSTRUCTION("62E14E085E29"                  , vdivss(xmm21, xmm6, dword_ptr(rcx)));
  TEST_INSTRUCTION("62A14E085EACF023010000"        , vdivss(xmm21, xmm6, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E14E085E6A7F"                , vdivss(xmm21, xmm6, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62E14E085EAA00020000"          , vdivss(xmm21, xmm6, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62E14E085E6A80"                , vdivss(xmm21, xmm6, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62E14E085EAAFCFDFFFF"          , vdivss(xmm21, xmm6, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6262FD488801"                  , vexpandpd(zmm24, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6262FD4C8801"                  , k(k4).vexpandpd(zmm24, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6262FDCC8801"                  , k(k4).z().vexpandpd(zmm24, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222FD488884F023010000"        , vexpandpd(zmm24, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262FD4888427F"                , vexpandpd(zmm24, zmmword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262FD48888200040000"          , vexpandpd(zmm24, zmmword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262FD48884280"                , vexpandpd(zmm24, zmmword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262FD488882F8FBFFFF"          , vexpandpd(zmm24, zmmword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62C2FD4888FF"                  , vexpandpd(zmm23, zmm15));
  TEST_INSTRUCTION("62C2FD4D88FF"                  , k(k5).vexpandpd(zmm23, zmm15));
  TEST_INSTRUCTION("62C2FDCD88FF"                  , k(k5).z().vexpandpd(zmm23, zmm15));
  TEST_INSTRUCTION("62F27D488821"                  , vexpandps(zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62F27D4E8821"                  , k(k6).vexpandps(zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62F27DCE8821"                  , k(k6).z().vexpandps(zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B27D4888A4F023010000"        , vexpandps(zmm4, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F27D4888627F"                , vexpandps(zmm4, zmmword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62F27D4888A200020000"          , vexpandps(zmm4, zmmword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62F27D48886280"                , vexpandps(zmm4, zmmword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62F27D4888A2FCFDFFFF"          , vexpandps(zmm4, zmmword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62527D4888F1"                  , vexpandps(zmm14, zmm9));
  TEST_INSTRUCTION("62527D4A88F1"                  , k(k2).vexpandps(zmm14, zmm9));
  TEST_INSTRUCTION("62527DCA88F1"                  , k(k2).z().vexpandps(zmm14, zmm9));
  TEST_INSTRUCTION("62C37D4819EFAB"                , vextractf32x4(xmm15, zmm21, 171));
  TEST_INSTRUCTION("62C37D4919EFAB"                , k(k1).vextractf32x4(xmm15, zmm21, 171));
  TEST_INSTRUCTION("62C37DC919EFAB"                , k(k1).z().vextractf32x4(xmm15, zmm21, 171));
  TEST_INSTRUCTION("62C37D4819EF7B"                , vextractf32x4(xmm15, zmm21, 123));
  TEST_INSTRUCTION("6243FD481BC3AB"                , vextractf64x4(ymm11, zmm24, 171));
  TEST_INSTRUCTION("6243FD4D1BC3AB"                , k(k5).vextractf64x4(ymm11, zmm24, 171));
  TEST_INSTRUCTION("6243FDCD1BC3AB"                , k(k5).z().vextractf64x4(ymm11, zmm24, 171));
  TEST_INSTRUCTION("6243FD481BC37B"                , vextractf64x4(ymm11, zmm24, 123));
  TEST_INSTRUCTION("62C37D4839C5AB"                , vextracti32x4(xmm13, zmm16, 171));
  TEST_INSTRUCTION("62C37D4D39C5AB"                , k(k5).vextracti32x4(xmm13, zmm16, 171));
  TEST_INSTRUCTION("62C37DCD39C5AB"                , k(k5).z().vextracti32x4(xmm13, zmm16, 171));
  TEST_INSTRUCTION("62C37D4839C57B"                , vextracti32x4(xmm13, zmm16, 123));
  TEST_INSTRUCTION("62C3FD483BC5AB"                , vextracti64x4(ymm13, zmm16, 171));
  TEST_INSTRUCTION("62C3FD4B3BC5AB"                , k(k3).vextracti64x4(ymm13, zmm16, 171));
  TEST_INSTRUCTION("62C3FDCB3BC5AB"                , k(k3).z().vextracti64x4(ymm13, zmm16, 171));
  TEST_INSTRUCTION("62C3FD483BC57B"                , vextracti64x4(ymm13, zmm16, 123));
  TEST_INSTRUCTION("62637D0817C0AB"                , vextractps(eax, xmm24, 171));
  TEST_INSTRUCTION("62637D0817C07B"                , vextractps(eax, xmm24, 123));
  TEST_INSTRUCTION("62437D0817C07B"                , vextractps(r8d, xmm24, 123));
  TEST_INSTRUCTION("62637D0817017B"                , vextractps(dword_ptr(rcx), xmm24, 123));
  TEST_INSTRUCTION("62237D081784F0230100007B"      , vextractps(dword_ptr(rax, r14, 3, 291), xmm24, 123));
  TEST_INSTRUCTION("62637D0817427F7B"              , vextractps(dword_ptr(rdx, 508), xmm24, 123));
  TEST_INSTRUCTION("62637D081782000200007B"        , vextractps(dword_ptr(rdx, 512), xmm24, 123));
  TEST_INSTRUCTION("62637D081742807B"              , vextractps(dword_ptr(rdx, -512), xmm24, 123));
  TEST_INSTRUCTION("62637D081782FCFDFFFF7B"        , vextractps(dword_ptr(rdx, -516), xmm24, 123));
  TEST_INSTRUCTION("6222FD4098D5"                  , vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FD4598D5"                  , k(k5).vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FDC598D5"                  , k(k5).z().vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FD1098D5"                  , rn_sae().vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FD5098D5"                  , ru_sae().vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FD3098D5"                  , rd_sae().vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6222FD7098D5"                  , rz_sae().vfmadd132pd(zmm26, zmm16, zmm21));
  TEST_INSTRUCTION("6262FD409811"                  , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222FD409894F023010000"        , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262FD509811"                  , vfmadd132pd(zmm26, zmm16, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6262FD4098527F"                , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6262FD40989200200000"          , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6262FD40985280"                , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6262FD409892C0DFFFFF"          , vfmadd132pd(zmm26, zmm16, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6262FD5098527F"                , vfmadd132pd(zmm26, zmm16, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6262FD50989200040000"          , vfmadd132pd(zmm26, zmm16, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6262FD50985280"                , vfmadd132pd(zmm26, zmm16, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6262FD509892F8FBFFFF"          , vfmadd132pd(zmm26, zmm16, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62925D4098C9"                  , vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925D4198C9"                  , k(k1).vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925DC198C9"                  , k(k1).z().vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925D1098C9"                  , rn_sae().vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925D5098C9"                  , ru_sae().vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925D3098C9"                  , rd_sae().vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62925D7098C9"                  , rz_sae().vfmadd132ps(zmm1, zmm20, zmm25));
  TEST_INSTRUCTION("62F25D409809"                  , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B25D40988CF023010000"        , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F25D509809"                  , vfmadd132ps(zmm1, zmm20, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F25D40984A7F"                , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F25D40988A00200000"          , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F25D40984A80"                , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F25D40988AC0DFFFFF"          , vfmadd132ps(zmm1, zmm20, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F25D50984A7F"                , vfmadd132ps(zmm1, zmm20, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F25D50988A00020000"          , vfmadd132ps(zmm1, zmm20, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F25D50984A80"                , vfmadd132ps(zmm1, zmm20, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F25D50988AFCFDFFFF"          , vfmadd132ps(zmm1, zmm20, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6262F50099E3"                  , vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F50299E3"                  , k(k2).vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F58299E3"                  , k(k2).z().vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F51099E3"                  , rn_sae().vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F55099E3"                  , ru_sae().vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F53099E3"                  , rd_sae().vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F57099E3"                  , rz_sae().vfmadd132sd(xmm28, xmm17, xmm3));
  TEST_INSTRUCTION("6262F5009921"                  , vfmadd132sd(xmm28, xmm17, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222F50099A4F023010000"        , vfmadd132sd(xmm28, xmm17, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262F50099627F"                , vfmadd132sd(xmm28, xmm17, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262F50099A200040000"          , vfmadd132sd(xmm28, xmm17, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262F500996280"                , vfmadd132sd(xmm28, xmm17, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262F50099A2F8FBFFFF"          , vfmadd132sd(xmm28, xmm17, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("6222750099F6"                  , vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222750399F6"                  , k(k3).vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222758399F6"                  , k(k3).z().vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222751099F6"                  , rn_sae().vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222755099F6"                  , ru_sae().vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222753099F6"                  , rd_sae().vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("6222757099F6"                  , rz_sae().vfmadd132ss(xmm30, xmm17, xmm22));
  TEST_INSTRUCTION("626275009931"                  , vfmadd132ss(xmm30, xmm17, dword_ptr(rcx)));
  TEST_INSTRUCTION("6222750099B4F023010000"        , vfmadd132ss(xmm30, xmm17, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262750099727F"                , vfmadd132ss(xmm30, xmm17, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("6262750099B200020000"          , vfmadd132ss(xmm30, xmm17, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62627500997280"                , vfmadd132ss(xmm30, xmm17, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("6262750099B2FCFDFFFF"          , vfmadd132ss(xmm30, xmm17, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6282FD40A8D1"                  , vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FD43A8D1"                  , k(k3).vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FDC3A8D1"                  , k(k3).z().vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FD10A8D1"                  , rn_sae().vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FD50A8D1"                  , ru_sae().vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FD30A8D1"                  , rd_sae().vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("6282FD70A8D1"                  , rz_sae().vfmadd213pd(zmm18, zmm16, zmm25));
  TEST_INSTRUCTION("62E2FD40A811"                  , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A2FD40A894F023010000"        , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2FD50A811"                  , vfmadd213pd(zmm18, zmm16, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E2FD40A8527F"                , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E2FD40A89200200000"          , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E2FD40A85280"                , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E2FD40A892C0DFFFFF"          , vfmadd213pd(zmm18, zmm16, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E2FD50A8527F"                , vfmadd213pd(zmm18, zmm16, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E2FD50A89200040000"          , vfmadd213pd(zmm18, zmm16, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E2FD50A85280"                , vfmadd213pd(zmm18, zmm16, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E2FD50A892F8FBFFFF"          , vfmadd213pd(zmm18, zmm16, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62C26540A8E6"                  , vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C26544A8E6"                  , k(k4).vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C265C4A8E6"                  , k(k4).z().vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C26510A8E6"                  , rn_sae().vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C26550A8E6"                  , ru_sae().vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C26530A8E6"                  , rd_sae().vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62C26570A8E6"                  , rz_sae().vfmadd213ps(zmm20, zmm19, zmm14));
  TEST_INSTRUCTION("62E26540A821"                  , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A26540A8A4F023010000"        , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E26550A821"                  , vfmadd213ps(zmm20, zmm19, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E26540A8627F"                , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E26540A8A200200000"          , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E26540A86280"                , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E26540A8A2C0DFFFFF"          , vfmadd213ps(zmm20, zmm19, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E26550A8627F"                , vfmadd213ps(zmm20, zmm19, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E26550A8A200020000"          , vfmadd213ps(zmm20, zmm19, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E26550A86280"                , vfmadd213ps(zmm20, zmm19, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E26550A8A2FCFDFFFF"          , vfmadd213ps(zmm20, zmm19, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6242AD00A9C5"                  , vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD03A9C5"                  , k(k3).vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD83A9C5"                  , k(k3).z().vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD10A9C5"                  , rn_sae().vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD50A9C5"                  , ru_sae().vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD30A9C5"                  , rd_sae().vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6242AD70A9C5"                  , rz_sae().vfmadd213sd(xmm24, xmm26, xmm13));
  TEST_INSTRUCTION("6262AD00A901"                  , vfmadd213sd(xmm24, xmm26, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222AD00A984F023010000"        , vfmadd213sd(xmm24, xmm26, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262AD00A9427F"                , vfmadd213sd(xmm24, xmm26, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262AD00A98200040000"          , vfmadd213sd(xmm24, xmm26, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262AD00A94280"                , vfmadd213sd(xmm24, xmm26, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262AD00A982F8FBFFFF"          , vfmadd213sd(xmm24, xmm26, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62224D00A9F0"                  , vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D01A9F0"                  , k(k1).vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D81A9F0"                  , k(k1).z().vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D10A9F0"                  , rn_sae().vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D50A9F0"                  , ru_sae().vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D30A9F0"                  , rd_sae().vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62224D70A9F0"                  , rz_sae().vfmadd213ss(xmm30, xmm22, xmm16));
  TEST_INSTRUCTION("62624D00A931"                  , vfmadd213ss(xmm30, xmm22, dword_ptr(rcx)));
  TEST_INSTRUCTION("62224D00A9B4F023010000"        , vfmadd213ss(xmm30, xmm22, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62624D00A9727F"                , vfmadd213ss(xmm30, xmm22, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62624D00A9B200020000"          , vfmadd213ss(xmm30, xmm22, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62624D00A97280"                , vfmadd213ss(xmm30, xmm22, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62624D00A9B2FCFDFFFF"          , vfmadd213ss(xmm30, xmm22, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6242CD48B8F1"                  , vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CD4CB8F1"                  , k(k4).vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CDCCB8F1"                  , k(k4).z().vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CD18B8F1"                  , rn_sae().vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CD58B8F1"                  , ru_sae().vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CD38B8F1"                  , rd_sae().vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6242CD78B8F1"                  , rz_sae().vfmadd231pd(zmm30, zmm6, zmm9));
  TEST_INSTRUCTION("6262CD48B831"                  , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222CD48B8B4F023010000"        , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262CD58B831"                  , vfmadd231pd(zmm30, zmm6, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6262CD48B8727F"                , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6262CD48B8B200200000"          , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6262CD48B87280"                , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6262CD48B8B2C0DFFFFF"          , vfmadd231pd(zmm30, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6262CD58B8727F"                , vfmadd231pd(zmm30, zmm6, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6262CD58B8B200040000"          , vfmadd231pd(zmm30, zmm6, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6262CD58B87280"                , vfmadd231pd(zmm30, zmm6, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6262CD58B8B2F8FBFFFF"          , vfmadd231pd(zmm30, zmm6, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62021D40B8D9"                  , vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021D43B8D9"                  , k(k3).vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021DC3B8D9"                  , k(k3).z().vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021D10B8D9"                  , rn_sae().vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021D50B8D9"                  , ru_sae().vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021D30B8D9"                  , rd_sae().vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62021D70B8D9"                  , rz_sae().vfmadd231ps(zmm27, zmm28, zmm25));
  TEST_INSTRUCTION("62621D40B819"                  , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62221D40B89CF023010000"        , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62621D50B819"                  , vfmadd231ps(zmm27, zmm28, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62621D40B85A7F"                , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62621D40B89A00200000"          , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62621D40B85A80"                , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62621D40B89AC0DFFFFF"          , vfmadd231ps(zmm27, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62621D50B85A7F"                , vfmadd231ps(zmm27, zmm28, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62621D50B89A00020000"          , vfmadd231ps(zmm27, zmm28, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62621D50B85A80"                , vfmadd231ps(zmm27, zmm28, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62621D50B89AFCFDFFFF"          , vfmadd231ps(zmm27, zmm28, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("C4C2F1B9E6"                    , vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F509B9E6"                  , k(k1).vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F589B9E6"                  , k(k1).z().vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F518B9E6"                  , rn_sae().vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F558B9E6"                  , ru_sae().vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F538B9E6"                  , rd_sae().vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("62D2F578B9E6"                  , rz_sae().vfmadd231sd(xmm4, xmm1, xmm14));
  TEST_INSTRUCTION("C4E2F1B921"                    , vfmadd231sd(xmm4, xmm1, qword_ptr(rcx)));
  TEST_INSTRUCTION("C4A2F1B9A4F023010000"          , vfmadd231sd(xmm4, xmm1, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C4E2F1B9A2F8030000"            , vfmadd231sd(xmm4, xmm1, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C4E2F1B9A200040000"            , vfmadd231sd(xmm4, xmm1, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C4E2F1B9A200FCFFFF"            , vfmadd231sd(xmm4, xmm1, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C4E2F1B9A2F8FBFFFF"            , vfmadd231sd(xmm4, xmm1, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62420508B9EA"                  , vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("6242050CB9EA"                  , k(k4).vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("6242058CB9EA"                  , k(k4).z().vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("62420518B9EA"                  , rn_sae().vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("62420558B9EA"                  , ru_sae().vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("62420538B9EA"                  , rd_sae().vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("62420578B9EA"                  , rz_sae().vfmadd231ss(xmm29, xmm15, xmm10));
  TEST_INSTRUCTION("62620508B929"                  , vfmadd231ss(xmm29, xmm15, dword_ptr(rcx)));
  TEST_INSTRUCTION("62220508B9ACF023010000"        , vfmadd231ss(xmm29, xmm15, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62620508B96A7F"                , vfmadd231ss(xmm29, xmm15, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62620508B9AA00020000"          , vfmadd231ss(xmm29, xmm15, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62620508B96A80"                , vfmadd231ss(xmm29, xmm15, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62620508B9AAFCFDFFFF"          , vfmadd231ss(xmm29, xmm15, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62A2B54096E5"                  , vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B54296E5"                  , k(k2).vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B5C296E5"                  , k(k2).z().vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B51096E5"                  , rn_sae().vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B55096E5"                  , ru_sae().vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B53096E5"                  , rd_sae().vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62A2B57096E5"                  , rz_sae().vfmaddsub132pd(zmm20, zmm25, zmm21));
  TEST_INSTRUCTION("62E2B5409621"                  , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A2B54096A4F023010000"        , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2B5509621"                  , vfmaddsub132pd(zmm20, zmm25, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E2B54096627F"                , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E2B54096A200200000"          , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E2B540966280"                , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E2B54096A2C0DFFFFF"          , vfmaddsub132pd(zmm20, zmm25, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E2B55096627F"                , vfmaddsub132pd(zmm20, zmm25, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E2B55096A200040000"          , vfmaddsub132pd(zmm20, zmm25, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E2B550966280"                , vfmaddsub132pd(zmm20, zmm25, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E2B55096A2F8FBFFFF"          , vfmaddsub132pd(zmm20, zmm25, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("6232354896D4"                  , vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("6232354B96D4"                  , k(k3).vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("623235CB96D4"                  , k(k3).z().vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("6232351896D4"                  , rn_sae().vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("6232355896D4"                  , ru_sae().vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("6232353896D4"                  , rd_sae().vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("6232357896D4"                  , rz_sae().vfmaddsub132ps(zmm10, zmm9, zmm20));
  TEST_INSTRUCTION("627235489611"                  , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("623235489694F023010000"        , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("627235589611"                  , vfmaddsub132ps(zmm10, zmm9, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("6272354896527F"                , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62723548969200200000"          , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62723548965280"                , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("627235489692C0DFFFFF"          , vfmaddsub132ps(zmm10, zmm9, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6272355896527F"                , vfmaddsub132ps(zmm10, zmm9, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62723558969200020000"          , vfmaddsub132ps(zmm10, zmm9, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62723558965280"                , vfmaddsub132ps(zmm10, zmm9, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("627235589692FCFDFFFF"          , vfmaddsub132ps(zmm10, zmm9, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6242CD48A6D2"                  , vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CD4EA6D2"                  , k(k6).vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CDCEA6D2"                  , k(k6).z().vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CD18A6D2"                  , rn_sae().vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CD58A6D2"                  , ru_sae().vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CD38A6D2"                  , rd_sae().vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6242CD78A6D2"                  , rz_sae().vfmaddsub213pd(zmm26, zmm6, zmm10));
  TEST_INSTRUCTION("6262CD48A611"                  , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222CD48A694F023010000"        , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262CD58A611"                  , vfmaddsub213pd(zmm26, zmm6, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6262CD48A6527F"                , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6262CD48A69200200000"          , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6262CD48A65280"                , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6262CD48A692C0DFFFFF"          , vfmaddsub213pd(zmm26, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6262CD58A6527F"                , vfmaddsub213pd(zmm26, zmm6, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6262CD58A69200040000"          , vfmaddsub213pd(zmm26, zmm6, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6262CD58A65280"                , vfmaddsub213pd(zmm26, zmm6, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6262CD58A692F8FBFFFF"          , vfmaddsub213pd(zmm26, zmm6, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62823D40A6CC"                  , vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823D46A6CC"                  , k(k6).vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823DC6A6CC"                  , k(k6).z().vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823D10A6CC"                  , rn_sae().vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823D50A6CC"                  , ru_sae().vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823D30A6CC"                  , rd_sae().vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62823D70A6CC"                  , rz_sae().vfmaddsub213ps(zmm17, zmm24, zmm28));
  TEST_INSTRUCTION("62E23D40A609"                  , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A23D40A68CF023010000"        , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E23D50A609"                  , vfmaddsub213ps(zmm17, zmm24, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E23D40A64A7F"                , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E23D40A68A00200000"          , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E23D40A64A80"                , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E23D40A68AC0DFFFFF"          , vfmaddsub213ps(zmm17, zmm24, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E23D50A64A7F"                , vfmaddsub213ps(zmm17, zmm24, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E23D50A68A00020000"          , vfmaddsub213ps(zmm17, zmm24, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E23D50A64A80"                , vfmaddsub213ps(zmm17, zmm24, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E23D50A68AFCFDFFFF"          , vfmaddsub213ps(zmm17, zmm24, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6212A540B6C8"                  , vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A547B6C8"                  , k(k7).vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A5C7B6C8"                  , k(k7).z().vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A510B6C8"                  , rn_sae().vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A550B6C8"                  , ru_sae().vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A530B6C8"                  , rd_sae().vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6212A570B6C8"                  , rz_sae().vfmaddsub231pd(zmm9, zmm27, zmm24));
  TEST_INSTRUCTION("6272A540B609"                  , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6232A540B68CF023010000"        , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6272A550B609"                  , vfmaddsub231pd(zmm9, zmm27, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6272A540B64A7F"                , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6272A540B68A00200000"          , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6272A540B64A80"                , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6272A540B68AC0DFFFFF"          , vfmaddsub231pd(zmm9, zmm27, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6272A550B64A7F"                , vfmaddsub231pd(zmm9, zmm27, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6272A550B68A00040000"          , vfmaddsub231pd(zmm9, zmm27, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6272A550B64A80"                , vfmaddsub231pd(zmm9, zmm27, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6272A550B68AF8FBFFFF"          , vfmaddsub231pd(zmm9, zmm27, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62325540B6FB"                  , vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62325546B6FB"                  , k(k6).vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("623255C6B6FB"                  , k(k6).z().vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62325510B6FB"                  , rn_sae().vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62325550B6FB"                  , ru_sae().vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62325530B6FB"                  , rd_sae().vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62325570B6FB"                  , rz_sae().vfmaddsub231ps(zmm15, zmm21, zmm19));
  TEST_INSTRUCTION("62725540B639"                  , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62325540B6BCF023010000"        , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62725550B639"                  , vfmaddsub231ps(zmm15, zmm21, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62725540B67A7F"                , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62725540B6BA00200000"          , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62725540B67A80"                , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62725540B6BAC0DFFFFF"          , vfmaddsub231ps(zmm15, zmm21, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62725550B67A7F"                , vfmaddsub231ps(zmm15, zmm21, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62725550B6BA00020000"          , vfmaddsub231ps(zmm15, zmm21, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62725550B67A80"                , vfmaddsub231ps(zmm15, zmm21, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62725550B6BAFCFDFFFF"          , vfmaddsub231ps(zmm15, zmm21, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62829D489AF3"                  , vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829D4A9AF3"                  , k(k2).vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829DCA9AF3"                  , k(k2).z().vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829D189AF3"                  , rn_sae().vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829D589AF3"                  , ru_sae().vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829D389AF3"                  , rd_sae().vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62829D789AF3"                  , rz_sae().vfmsub132pd(zmm22, zmm12, zmm27));
  TEST_INSTRUCTION("62E29D489A31"                  , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A29D489AB4F023010000"        , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E29D589A31"                  , vfmsub132pd(zmm22, zmm12, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E29D489A727F"                , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E29D489AB200200000"          , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E29D489A7280"                , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E29D489AB2C0DFFFFF"          , vfmsub132pd(zmm22, zmm12, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E29D589A727F"                , vfmsub132pd(zmm22, zmm12, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E29D589AB200040000"          , vfmsub132pd(zmm22, zmm12, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E29D589A7280"                , vfmsub132pd(zmm22, zmm12, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E29D589AB2F8FBFFFF"          , vfmsub132pd(zmm22, zmm12, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62B215489AC8"                  , vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B2154C9AC8"                  , k(k4).vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B215CC9AC8"                  , k(k4).z().vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B215189AC8"                  , rn_sae().vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B215589AC8"                  , ru_sae().vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B215389AC8"                  , rd_sae().vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62B215789AC8"                  , rz_sae().vfmsub132ps(zmm1, zmm13, zmm16));
  TEST_INSTRUCTION("62F215489A09"                  , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B215489A8CF023010000"        , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F215589A09"                  , vfmsub132ps(zmm1, zmm13, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F215489A4A7F"                , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F215489A8A00200000"          , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F215489A4A80"                , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F215489A8AC0DFFFFF"          , vfmsub132ps(zmm1, zmm13, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F215589A4A7F"                , vfmsub132ps(zmm1, zmm13, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F215589A8A00020000"          , vfmsub132ps(zmm1, zmm13, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F215589A4A80"                , vfmsub132ps(zmm1, zmm13, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F215589A8AFCFDFFFF"          , vfmsub132ps(zmm1, zmm13, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6212BD089BE3"                  , vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD0B9BE3"                  , k(k3).vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD8B9BE3"                  , k(k3).z().vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD189BE3"                  , rn_sae().vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD589BE3"                  , ru_sae().vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD389BE3"                  , rd_sae().vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("6212BD789BE3"                  , rz_sae().vfmsub132sd(xmm12, xmm8, xmm27));
  TEST_INSTRUCTION("C462B99B21"                    , vfmsub132sd(xmm12, xmm8, qword_ptr(rcx)));
  TEST_INSTRUCTION("C422B99BA4F023010000"          , vfmsub132sd(xmm12, xmm8, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C462B99BA2F8030000"            , vfmsub132sd(xmm12, xmm8, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C462B99BA200040000"            , vfmsub132sd(xmm12, xmm8, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C462B99BA200FCFFFF"            , vfmsub132sd(xmm12, xmm8, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C462B99BA2F8FBFFFF"            , vfmsub132sd(xmm12, xmm8, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62024D009BF3"                  , vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D039BF3"                  , k(k3).vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D839BF3"                  , k(k3).z().vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D109BF3"                  , rn_sae().vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D509BF3"                  , ru_sae().vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D309BF3"                  , rd_sae().vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62024D709BF3"                  , rz_sae().vfmsub132ss(xmm30, xmm22, xmm27));
  TEST_INSTRUCTION("62624D009B31"                  , vfmsub132ss(xmm30, xmm22, dword_ptr(rcx)));
  TEST_INSTRUCTION("62224D009BB4F023010000"        , vfmsub132ss(xmm30, xmm22, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62624D009B727F"                , vfmsub132ss(xmm30, xmm22, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62624D009BB200020000"          , vfmsub132ss(xmm30, xmm22, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62624D009B7280"                , vfmsub132ss(xmm30, xmm22, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62624D009BB2FCFDFFFF"          , vfmsub132ss(xmm30, xmm22, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62F2AD48AAEC"                  , vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD49AAEC"                  , k(k1).vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2ADC9AAEC"                  , k(k1).z().vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD18AAEC"                  , rn_sae().vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD58AAEC"                  , ru_sae().vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD38AAEC"                  , rd_sae().vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD78AAEC"                  , rz_sae().vfmsub213pd(zmm5, zmm10, zmm4));
  TEST_INSTRUCTION("62F2AD48AA29"                  , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2AD48AAACF023010000"        , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2AD58AA29"                  , vfmsub213pd(zmm5, zmm10, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F2AD48AA6A7F"                , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2AD48AAAA00200000"          , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F2AD48AA6A80"                , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2AD48AAAAC0DFFFFF"          , vfmsub213pd(zmm5, zmm10, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2AD58AA6A7F"                , vfmsub213pd(zmm5, zmm10, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F2AD58AAAA00040000"          , vfmsub213pd(zmm5, zmm10, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F2AD58AA6A80"                , vfmsub213pd(zmm5, zmm10, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F2AD58AAAAF8FBFFFF"          , vfmsub213pd(zmm5, zmm10, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62C24D40AAF2"                  , vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24D46AAF2"                  , k(k6).vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24DC6AAF2"                  , k(k6).z().vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24D10AAF2"                  , rn_sae().vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24D50AAF2"                  , ru_sae().vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24D30AAF2"                  , rd_sae().vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62C24D70AAF2"                  , rz_sae().vfmsub213ps(zmm22, zmm22, zmm10));
  TEST_INSTRUCTION("62E24D40AA31"                  , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A24D40AAB4F023010000"        , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E24D50AA31"                  , vfmsub213ps(zmm22, zmm22, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E24D40AA727F"                , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E24D40AAB200200000"          , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E24D40AA7280"                , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E24D40AAB2C0DFFFFF"          , vfmsub213ps(zmm22, zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E24D50AA727F"                , vfmsub213ps(zmm22, zmm22, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E24D50AAB200020000"          , vfmsub213ps(zmm22, zmm22, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E24D50AA7280"                , vfmsub213ps(zmm22, zmm22, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E24D50AAB2FCFDFFFF"          , vfmsub213ps(zmm22, zmm22, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("C4C2B9ABF4"                    , vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD09ABF4"                  , k(k1).vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD89ABF4"                  , k(k1).z().vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD18ABF4"                  , rn_sae().vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD58ABF4"                  , ru_sae().vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD38ABF4"                  , rd_sae().vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("62D2BD78ABF4"                  , rz_sae().vfmsub213sd(xmm6, xmm8, xmm12));
  TEST_INSTRUCTION("C4E2B9AB31"                    , vfmsub213sd(xmm6, xmm8, qword_ptr(rcx)));
  TEST_INSTRUCTION("C4A2B9ABB4F023010000"          , vfmsub213sd(xmm6, xmm8, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C4E2B9ABB2F8030000"            , vfmsub213sd(xmm6, xmm8, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C4E2B9ABB200040000"            , vfmsub213sd(xmm6, xmm8, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C4E2B9ABB200FCFFFF"            , vfmsub213sd(xmm6, xmm8, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C4E2B9ABB2F8FBFFFF"            , vfmsub213sd(xmm6, xmm8, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62021508ABF2"                  , vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021509ABF2"                  , k(k1).vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021589ABF2"                  , k(k1).z().vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021518ABF2"                  , rn_sae().vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021558ABF2"                  , ru_sae().vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021538ABF2"                  , rd_sae().vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62021578ABF2"                  , rz_sae().vfmsub213ss(xmm30, xmm13, xmm26));
  TEST_INSTRUCTION("62621508AB31"                  , vfmsub213ss(xmm30, xmm13, dword_ptr(rcx)));
  TEST_INSTRUCTION("62221508ABB4F023010000"        , vfmsub213ss(xmm30, xmm13, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62621508AB727F"                , vfmsub213ss(xmm30, xmm13, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62621508ABB200020000"          , vfmsub213ss(xmm30, xmm13, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62621508AB7280"                , vfmsub213ss(xmm30, xmm13, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62621508ABB2FCFDFFFF"          , vfmsub213ss(xmm30, xmm13, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62D29D48BAEB"                  , vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29D4ABAEB"                  , k(k2).vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29DCABAEB"                  , k(k2).z().vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29D18BAEB"                  , rn_sae().vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29D58BAEB"                  , ru_sae().vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29D38BAEB"                  , rd_sae().vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62D29D78BAEB"                  , rz_sae().vfmsub231pd(zmm5, zmm12, zmm11));
  TEST_INSTRUCTION("62F29D48BA29"                  , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B29D48BAACF023010000"        , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F29D58BA29"                  , vfmsub231pd(zmm5, zmm12, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F29D48BA6A7F"                , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F29D48BAAA00200000"          , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F29D48BA6A80"                , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F29D48BAAAC0DFFFFF"          , vfmsub231pd(zmm5, zmm12, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F29D58BA6A7F"                , vfmsub231pd(zmm5, zmm12, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F29D58BAAA00040000"          , vfmsub231pd(zmm5, zmm12, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F29D58BA6A80"                , vfmsub231pd(zmm5, zmm12, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F29D58BAAAF8FBFFFF"          , vfmsub231pd(zmm5, zmm12, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62925540BAF3"                  , vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62925543BAF3"                  , k(k3).vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("629255C3BAF3"                  , k(k3).z().vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62925510BAF3"                  , rn_sae().vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62925550BAF3"                  , ru_sae().vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62925530BAF3"                  , rd_sae().vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62925570BAF3"                  , rz_sae().vfmsub231ps(zmm6, zmm21, zmm27));
  TEST_INSTRUCTION("62F25540BA31"                  , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B25540BAB4F023010000"        , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F25550BA31"                  , vfmsub231ps(zmm6, zmm21, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F25540BA727F"                , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F25540BAB200200000"          , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F25540BA7280"                , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F25540BAB2C0DFFFFF"          , vfmsub231ps(zmm6, zmm21, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F25550BA727F"                , vfmsub231ps(zmm6, zmm21, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F25550BAB200020000"          , vfmsub231ps(zmm6, zmm21, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F25550BA7280"                , vfmsub231ps(zmm6, zmm21, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F25550BAB2FCFDFFFF"          , vfmsub231ps(zmm6, zmm21, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("C4E2A1BBDE"                    , vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A50FBBDE"                  , k(k7).vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A58FBBDE"                  , k(k7).z().vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A518BBDE"                  , rn_sae().vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A558BBDE"                  , ru_sae().vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A538BBDE"                  , rd_sae().vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("62F2A578BBDE"                  , rz_sae().vfmsub231sd(xmm3, xmm11, xmm6));
  TEST_INSTRUCTION("C4E2A1BB19"                    , vfmsub231sd(xmm3, xmm11, qword_ptr(rcx)));
  TEST_INSTRUCTION("C4A2A1BB9CF023010000"          , vfmsub231sd(xmm3, xmm11, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C4E2A1BB9AF8030000"            , vfmsub231sd(xmm3, xmm11, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C4E2A1BB9A00040000"            , vfmsub231sd(xmm3, xmm11, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C4E2A1BB9A00FCFFFF"            , vfmsub231sd(xmm3, xmm11, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C4E2A1BB9AF8FBFFFF"            , vfmsub231sd(xmm3, xmm11, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62626508BBED"                  , vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("6262650EBBED"                  , k(k6).vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("6262658EBBED"                  , k(k6).z().vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("62626518BBED"                  , rn_sae().vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("62626558BBED"                  , ru_sae().vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("62626538BBED"                  , rd_sae().vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("62626578BBED"                  , rz_sae().vfmsub231ss(xmm29, xmm3, xmm5));
  TEST_INSTRUCTION("62626508BB29"                  , vfmsub231ss(xmm29, xmm3, dword_ptr(rcx)));
  TEST_INSTRUCTION("62226508BBACF023010000"        , vfmsub231ss(xmm29, xmm3, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62626508BB6A7F"                , vfmsub231ss(xmm29, xmm3, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62626508BBAA00020000"          , vfmsub231ss(xmm29, xmm3, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62626508BB6A80"                , vfmsub231ss(xmm29, xmm3, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62626508BBAAFCFDFFFF"          , vfmsub231ss(xmm29, xmm3, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62A29D4097EA"                  , vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29D4797EA"                  , k(k7).vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29DC797EA"                  , k(k7).z().vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29D1097EA"                  , rn_sae().vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29D5097EA"                  , ru_sae().vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29D3097EA"                  , rd_sae().vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62A29D7097EA"                  , rz_sae().vfmsubadd132pd(zmm21, zmm28, zmm18));
  TEST_INSTRUCTION("62E29D409729"                  , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A29D4097ACF023010000"        , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E29D509729"                  , vfmsubadd132pd(zmm21, zmm28, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E29D40976A7F"                , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E29D4097AA00200000"          , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E29D40976A80"                , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E29D4097AAC0DFFFFF"          , vfmsubadd132pd(zmm21, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E29D50976A7F"                , vfmsubadd132pd(zmm21, zmm28, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E29D5097AA00040000"          , vfmsubadd132pd(zmm21, zmm28, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E29D50976A80"                , vfmsubadd132pd(zmm21, zmm28, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E29D5097AAF8FBFFFF"          , vfmsubadd132pd(zmm21, zmm28, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62B2154897D5"                  , vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B2154F97D5"                  , k(k7).vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B215CF97D5"                  , k(k7).z().vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B2151897D5"                  , rn_sae().vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B2155897D5"                  , ru_sae().vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B2153897D5"                  , rd_sae().vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62B2157897D5"                  , rz_sae().vfmsubadd132ps(zmm2, zmm13, zmm21));
  TEST_INSTRUCTION("62F215489711"                  , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B215489794F023010000"        , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F215589711"                  , vfmsubadd132ps(zmm2, zmm13, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F2154897527F"                , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F21548979200200000"          , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F21548975280"                , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F215489792C0DFFFFF"          , vfmsubadd132ps(zmm2, zmm13, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2155897527F"                , vfmsubadd132ps(zmm2, zmm13, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F21558979200020000"          , vfmsubadd132ps(zmm2, zmm13, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F21558975280"                , vfmsubadd132ps(zmm2, zmm13, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F215589792FCFDFFFF"          , vfmsubadd132ps(zmm2, zmm13, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F2C540A7D2"                  , vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C546A7D2"                  , k(k6).vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C5C6A7D2"                  , k(k6).z().vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C510A7D2"                  , rn_sae().vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C550A7D2"                  , ru_sae().vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C530A7D2"                  , rd_sae().vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C570A7D2"                  , rz_sae().vfmsubadd213pd(zmm2, zmm23, zmm2));
  TEST_INSTRUCTION("62F2C540A711"                  , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2C540A794F023010000"        , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2C550A711"                  , vfmsubadd213pd(zmm2, zmm23, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F2C540A7527F"                , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2C540A79200200000"          , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F2C540A75280"                , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2C540A792C0DFFFFF"          , vfmsubadd213pd(zmm2, zmm23, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2C550A7527F"                , vfmsubadd213pd(zmm2, zmm23, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F2C550A79200040000"          , vfmsubadd213pd(zmm2, zmm23, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F2C550A75280"                , vfmsubadd213pd(zmm2, zmm23, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F2C550A792F8FBFFFF"          , vfmsubadd213pd(zmm2, zmm23, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62C21D48A7F6"                  , vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21D4EA7F6"                  , k(k6).vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21DCEA7F6"                  , k(k6).z().vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21D18A7F6"                  , rn_sae().vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21D58A7F6"                  , ru_sae().vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21D38A7F6"                  , rd_sae().vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62C21D78A7F6"                  , rz_sae().vfmsubadd213ps(zmm22, zmm12, zmm14));
  TEST_INSTRUCTION("62E21D48A731"                  , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A21D48A7B4F023010000"        , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E21D58A731"                  , vfmsubadd213ps(zmm22, zmm12, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E21D48A7727F"                , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E21D48A7B200200000"          , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E21D48A77280"                , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E21D48A7B2C0DFFFFF"          , vfmsubadd213ps(zmm22, zmm12, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E21D58A7727F"                , vfmsubadd213ps(zmm22, zmm12, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E21D58A7B200020000"          , vfmsubadd213ps(zmm22, zmm12, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E21D58A77280"                , vfmsubadd213ps(zmm22, zmm12, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E21D58A7B2FCFDFFFF"          , vfmsubadd213ps(zmm22, zmm12, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62A2A540B7C5"                  , vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A542B7C5"                  , k(k2).vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A5C2B7C5"                  , k(k2).z().vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A510B7C5"                  , rn_sae().vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A550B7C5"                  , ru_sae().vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A530B7C5"                  , rd_sae().vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62A2A570B7C5"                  , rz_sae().vfmsubadd231pd(zmm16, zmm27, zmm21));
  TEST_INSTRUCTION("62E2A540B701"                  , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A2A540B784F023010000"        , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2A550B701"                  , vfmsubadd231pd(zmm16, zmm27, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E2A540B7427F"                , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E2A540B78200200000"          , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E2A540B74280"                , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E2A540B782C0DFFFFF"          , vfmsubadd231pd(zmm16, zmm27, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E2A550B7427F"                , vfmsubadd231pd(zmm16, zmm27, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E2A550B78200040000"          , vfmsubadd231pd(zmm16, zmm27, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E2A550B74280"                , vfmsubadd231pd(zmm16, zmm27, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E2A550B782F8FBFFFF"          , vfmsubadd231pd(zmm16, zmm27, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62726540B7C1"                  , vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726542B7C1"                  , k(k2).vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("627265C2B7C1"                  , k(k2).z().vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726510B7C1"                  , rn_sae().vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726550B7C1"                  , ru_sae().vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726530B7C1"                  , rd_sae().vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726570B7C1"                  , rz_sae().vfmsubadd231ps(zmm8, zmm19, zmm1));
  TEST_INSTRUCTION("62726540B701"                  , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62326540B784F023010000"        , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62726550B701"                  , vfmsubadd231ps(zmm8, zmm19, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62726540B7427F"                , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62726540B78200200000"          , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62726540B74280"                , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62726540B782C0DFFFFF"          , vfmsubadd231ps(zmm8, zmm19, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62726550B7427F"                , vfmsubadd231ps(zmm8, zmm19, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62726550B78200020000"          , vfmsubadd231ps(zmm8, zmm19, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62726550B74280"                , vfmsubadd231ps(zmm8, zmm19, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62726550B782FCFDFFFF"          , vfmsubadd231ps(zmm8, zmm19, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62728D489CE1"                  , vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D4F9CE1"                  , k(k7).vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728DCF9CE1"                  , k(k7).z().vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D189CE1"                  , rn_sae().vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D589CE1"                  , ru_sae().vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D389CE1"                  , rd_sae().vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D789CE1"                  , rz_sae().vfnmadd132pd(zmm12, zmm14, zmm1));
  TEST_INSTRUCTION("62728D489C21"                  , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62328D489CA4F023010000"        , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62728D589C21"                  , vfnmadd132pd(zmm12, zmm14, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62728D489C627F"                , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62728D489CA200200000"          , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62728D489C6280"                , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62728D489CA2C0DFFFFF"          , vfnmadd132pd(zmm12, zmm14, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62728D589C627F"                , vfnmadd132pd(zmm12, zmm14, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62728D589CA200040000"          , vfnmadd132pd(zmm12, zmm14, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62728D589C6280"                , vfnmadd132pd(zmm12, zmm14, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62728D589CA2F8FBFFFF"          , vfnmadd132pd(zmm12, zmm14, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62C27D409CEA"                  , vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27D459CEA"                  , k(k5).vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27DC59CEA"                  , k(k5).z().vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27D109CEA"                  , rn_sae().vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27D509CEA"                  , ru_sae().vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27D309CEA"                  , rd_sae().vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62C27D709CEA"                  , rz_sae().vfnmadd132ps(zmm21, zmm16, zmm10));
  TEST_INSTRUCTION("62E27D409C29"                  , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A27D409CACF023010000"        , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E27D509C29"                  , vfnmadd132ps(zmm21, zmm16, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E27D409C6A7F"                , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E27D409CAA00200000"          , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E27D409C6A80"                , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E27D409CAAC0DFFFFF"          , vfnmadd132ps(zmm21, zmm16, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E27D509C6A7F"                , vfnmadd132ps(zmm21, zmm16, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E27D509CAA00020000"          , vfnmadd132ps(zmm21, zmm16, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E27D509C6A80"                , vfnmadd132ps(zmm21, zmm16, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E27D509CAAFCFDFFFF"          , vfnmadd132ps(zmm21, zmm16, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62C2E5089DDB"                  , vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E50A9DDB"                  , k(k2).vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E58A9DDB"                  , k(k2).z().vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E5189DDB"                  , rn_sae().vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E5589DDB"                  , ru_sae().vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E5389DDB"                  , rd_sae().vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62C2E5789DDB"                  , rz_sae().vfnmadd132sd(xmm19, xmm3, xmm11));
  TEST_INSTRUCTION("62E2E5089D19"                  , vfnmadd132sd(xmm19, xmm3, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A2E5089D9CF023010000"        , vfnmadd132sd(xmm19, xmm3, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2E5089D5A7F"                , vfnmadd132sd(xmm19, xmm3, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E2E5089D9A00040000"          , vfnmadd132sd(xmm19, xmm3, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E2E5089D5A80"                , vfnmadd132sd(xmm19, xmm3, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E2E5089D9AF8FBFFFF"          , vfnmadd132sd(xmm19, xmm3, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("622275089DCF"                  , vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("6222750B9DCF"                  , k(k3).vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("6222758B9DCF"                  , k(k3).z().vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("622275189DCF"                  , rn_sae().vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("622275589DCF"                  , ru_sae().vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("622275389DCF"                  , rd_sae().vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("622275789DCF"                  , rz_sae().vfnmadd132ss(xmm25, xmm1, xmm23));
  TEST_INSTRUCTION("626275089D09"                  , vfnmadd132ss(xmm25, xmm1, dword_ptr(rcx)));
  TEST_INSTRUCTION("622275089D8CF023010000"        , vfnmadd132ss(xmm25, xmm1, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("626275089D4A7F"                , vfnmadd132ss(xmm25, xmm1, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("626275089D8A00020000"          , vfnmadd132ss(xmm25, xmm1, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("626275089D4A80"                , vfnmadd132ss(xmm25, xmm1, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("626275089D8AFCFDFFFF"          , vfnmadd132ss(xmm25, xmm1, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62C2FD40ACC9"                  , vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FD44ACC9"                  , k(k4).vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FDC4ACC9"                  , k(k4).z().vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FD10ACC9"                  , rn_sae().vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FD50ACC9"                  , ru_sae().vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FD30ACC9"                  , rd_sae().vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62C2FD70ACC9"                  , rz_sae().vfnmadd213pd(zmm17, zmm16, zmm9));
  TEST_INSTRUCTION("62E2FD40AC09"                  , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A2FD40AC8CF023010000"        , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2FD50AC09"                  , vfnmadd213pd(zmm17, zmm16, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E2FD40AC4A7F"                , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E2FD40AC8A00200000"          , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E2FD40AC4A80"                , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E2FD40AC8AC0DFFFFF"          , vfnmadd213pd(zmm17, zmm16, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E2FD50AC4A7F"                , vfnmadd213pd(zmm17, zmm16, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E2FD50AC8A00040000"          , vfnmadd213pd(zmm17, zmm16, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E2FD50AC4A80"                , vfnmadd213pd(zmm17, zmm16, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E2FD50AC8AF8FBFFFF"          , vfnmadd213pd(zmm17, zmm16, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62622D48ACD6"                  , vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D4EACD6"                  , k(k6).vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622DCEACD6"                  , k(k6).z().vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D18ACD6"                  , rn_sae().vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D58ACD6"                  , ru_sae().vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D38ACD6"                  , rd_sae().vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D78ACD6"                  , rz_sae().vfnmadd213ps(zmm26, zmm10, zmm6));
  TEST_INSTRUCTION("62622D48AC11"                  , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62222D48AC94F023010000"        , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62622D58AC11"                  , vfnmadd213ps(zmm26, zmm10, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62622D48AC527F"                , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62622D48AC9200200000"          , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62622D48AC5280"                , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62622D48AC92C0DFFFFF"          , vfnmadd213ps(zmm26, zmm10, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62622D58AC527F"                , vfnmadd213ps(zmm26, zmm10, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62622D58AC9200020000"          , vfnmadd213ps(zmm26, zmm10, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62622D58AC5280"                , vfnmadd213ps(zmm26, zmm10, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62622D58AC92FCFDFFFF"          , vfnmadd213ps(zmm26, zmm10, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6272A500ADEA"                  , vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A507ADEA"                  , k(k7).vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A587ADEA"                  , k(k7).z().vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A510ADEA"                  , rn_sae().vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A550ADEA"                  , ru_sae().vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A530ADEA"                  , rd_sae().vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A570ADEA"                  , rz_sae().vfnmadd213sd(xmm13, xmm27, xmm2));
  TEST_INSTRUCTION("6272A500AD29"                  , vfnmadd213sd(xmm13, xmm27, qword_ptr(rcx)));
  TEST_INSTRUCTION("6232A500ADACF023010000"        , vfnmadd213sd(xmm13, xmm27, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6272A500AD6A7F"                , vfnmadd213sd(xmm13, xmm27, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6272A500ADAA00040000"          , vfnmadd213sd(xmm13, xmm27, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6272A500AD6A80"                , vfnmadd213sd(xmm13, xmm27, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6272A500ADAAF8FBFFFF"          , vfnmadd213sd(xmm13, xmm27, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62024508ADEC"                  , vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("6202450AADEC"                  , k(k2).vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("6202458AADEC"                  , k(k2).z().vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("62024518ADEC"                  , rn_sae().vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("62024558ADEC"                  , ru_sae().vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("62024538ADEC"                  , rd_sae().vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("62024578ADEC"                  , rz_sae().vfnmadd213ss(xmm29, xmm7, xmm28));
  TEST_INSTRUCTION("62624508AD29"                  , vfnmadd213ss(xmm29, xmm7, dword_ptr(rcx)));
  TEST_INSTRUCTION("62224508ADACF023010000"        , vfnmadd213ss(xmm29, xmm7, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62624508AD6A7F"                , vfnmadd213ss(xmm29, xmm7, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62624508ADAA00020000"          , vfnmadd213ss(xmm29, xmm7, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62624508AD6A80"                , vfnmadd213ss(xmm29, xmm7, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62624508ADAAFCFDFFFF"          , vfnmadd213ss(xmm29, xmm7, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6232A548BCE0"                  , vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A54EBCE0"                  , k(k6).vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A5CEBCE0"                  , k(k6).z().vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A518BCE0"                  , rn_sae().vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A558BCE0"                  , ru_sae().vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A538BCE0"                  , rd_sae().vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6232A578BCE0"                  , rz_sae().vfnmadd231pd(zmm12, zmm11, zmm16));
  TEST_INSTRUCTION("6272A548BC21"                  , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6232A548BCA4F023010000"        , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6272A558BC21"                  , vfnmadd231pd(zmm12, zmm11, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6272A548BC627F"                , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6272A548BCA200200000"          , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6272A548BC6280"                , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6272A548BCA2C0DFFFFF"          , vfnmadd231pd(zmm12, zmm11, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6272A558BC627F"                , vfnmadd231pd(zmm12, zmm11, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6272A558BCA200040000"          , vfnmadd231pd(zmm12, zmm11, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6272A558BC6280"                , vfnmadd231pd(zmm12, zmm11, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6272A558BCA2F8FBFFFF"          , vfnmadd231pd(zmm12, zmm11, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62124548BCF0"                  , vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("6212454DBCF0"                  , k(k5).vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("621245CDBCF0"                  , k(k5).z().vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("62124518BCF0"                  , rn_sae().vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("62124558BCF0"                  , ru_sae().vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("62124538BCF0"                  , rd_sae().vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("62124578BCF0"                  , rz_sae().vfnmadd231ps(zmm14, zmm7, zmm24));
  TEST_INSTRUCTION("62724548BC31"                  , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62324548BCB4F023010000"        , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62724558BC31"                  , vfnmadd231ps(zmm14, zmm7, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62724548BC727F"                , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62724548BCB200200000"          , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62724548BC7280"                , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62724548BCB2C0DFFFFF"          , vfnmadd231ps(zmm14, zmm7, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62724558BC727F"                , vfnmadd231ps(zmm14, zmm7, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62724558BCB200020000"          , vfnmadd231ps(zmm14, zmm7, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62724558BC7280"                , vfnmadd231ps(zmm14, zmm7, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62724558BCB2FCFDFFFF"          , vfnmadd231ps(zmm14, zmm7, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62B2A508BDF2"                  , vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A50BBDF2"                  , k(k3).vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A58BBDF2"                  , k(k3).z().vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A518BDF2"                  , rn_sae().vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A558BDF2"                  , ru_sae().vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A538BDF2"                  , rd_sae().vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("62B2A578BDF2"                  , rz_sae().vfnmadd231sd(xmm6, xmm11, xmm18));
  TEST_INSTRUCTION("C4E2A1BD31"                    , vfnmadd231sd(xmm6, xmm11, qword_ptr(rcx)));
  TEST_INSTRUCTION("C4A2A1BDB4F023010000"          , vfnmadd231sd(xmm6, xmm11, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C4E2A1BDB2F8030000"            , vfnmadd231sd(xmm6, xmm11, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C4E2A1BDB200040000"            , vfnmadd231sd(xmm6, xmm11, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C4E2A1BDB200FCFFFF"            , vfnmadd231sd(xmm6, xmm11, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C4E2A1BDB2F8FBFFFF"            , vfnmadd231sd(xmm6, xmm11, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62226D08BDD9"                  , vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D09BDD9"                  , k(k1).vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D89BDD9"                  , k(k1).z().vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D18BDD9"                  , rn_sae().vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D58BDD9"                  , ru_sae().vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D38BDD9"                  , rd_sae().vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62226D78BDD9"                  , rz_sae().vfnmadd231ss(xmm27, xmm2, xmm17));
  TEST_INSTRUCTION("62626D08BD19"                  , vfnmadd231ss(xmm27, xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("62226D08BD9CF023010000"        , vfnmadd231ss(xmm27, xmm2, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62626D08BD5A7F"                , vfnmadd231ss(xmm27, xmm2, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62626D08BD9A00020000"          , vfnmadd231ss(xmm27, xmm2, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62626D08BD5A80"                , vfnmadd231ss(xmm27, xmm2, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62626D08BD9AFCFDFFFF"          , vfnmadd231ss(xmm27, xmm2, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6262D5489EE6"                  , vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D54A9EE6"                  , k(k2).vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5CA9EE6"                  , k(k2).z().vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5189EE6"                  , rn_sae().vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5589EE6"                  , ru_sae().vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5389EE6"                  , rd_sae().vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5789EE6"                  , rz_sae().vfnmsub132pd(zmm28, zmm5, zmm6));
  TEST_INSTRUCTION("6262D5489E21"                  , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222D5489EA4F023010000"        , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262D5589E21"                  , vfnmsub132pd(zmm28, zmm5, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6262D5489E627F"                , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6262D5489EA200200000"          , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6262D5489E6280"                , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6262D5489EA2C0DFFFFF"          , vfnmsub132pd(zmm28, zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6262D5589E627F"                , vfnmsub132pd(zmm28, zmm5, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6262D5589EA200040000"          , vfnmsub132pd(zmm28, zmm5, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6262D5589E6280"                , vfnmsub132pd(zmm28, zmm5, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6262D5589EA2F8FBFFFF"          , vfnmsub132pd(zmm28, zmm5, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62F26D409EE6"                  , vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D429EE6"                  , k(k2).vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26DC29EE6"                  , k(k2).z().vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D109EE6"                  , rn_sae().vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D509EE6"                  , ru_sae().vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D309EE6"                  , rd_sae().vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D709EE6"                  , rz_sae().vfnmsub132ps(zmm4, zmm18, zmm6));
  TEST_INSTRUCTION("62F26D409E21"                  , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B26D409EA4F023010000"        , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F26D509E21"                  , vfnmsub132ps(zmm4, zmm18, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F26D409E627F"                , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F26D409EA200200000"          , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F26D409E6280"                , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F26D409EA2C0DFFFFF"          , vfnmsub132ps(zmm4, zmm18, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F26D509E627F"                , vfnmsub132ps(zmm4, zmm18, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F26D509EA200020000"          , vfnmsub132ps(zmm4, zmm18, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F26D509E6280"                , vfnmsub132ps(zmm4, zmm18, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F26D509EA2FCFDFFFF"          , vfnmsub132ps(zmm4, zmm18, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6242A5089FD5"                  , vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A50E9FD5"                  , k(k6).vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A58E9FD5"                  , k(k6).z().vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A5189FD5"                  , rn_sae().vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A5589FD5"                  , ru_sae().vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A5389FD5"                  , rd_sae().vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6242A5789FD5"                  , rz_sae().vfnmsub132sd(xmm26, xmm11, xmm13));
  TEST_INSTRUCTION("6262A5089F11"                  , vfnmsub132sd(xmm26, xmm11, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222A5089F94F023010000"        , vfnmsub132sd(xmm26, xmm11, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262A5089F527F"                , vfnmsub132sd(xmm26, xmm11, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262A5089F9200040000"          , vfnmsub132sd(xmm26, xmm11, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262A5089F5280"                , vfnmsub132sd(xmm26, xmm11, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262A5089F92F8FBFFFF"          , vfnmsub132sd(xmm26, xmm11, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62824D009FF8"                  , vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D069FF8"                  , k(k6).vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D869FF8"                  , k(k6).z().vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D109FF8"                  , rn_sae().vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D509FF8"                  , ru_sae().vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D309FF8"                  , rd_sae().vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62824D709FF8"                  , rz_sae().vfnmsub132ss(xmm23, xmm22, xmm24));
  TEST_INSTRUCTION("62E24D009F39"                  , vfnmsub132ss(xmm23, xmm22, dword_ptr(rcx)));
  TEST_INSTRUCTION("62A24D009FBCF023010000"        , vfnmsub132ss(xmm23, xmm22, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E24D009F7A7F"                , vfnmsub132ss(xmm23, xmm22, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62E24D009FBA00020000"          , vfnmsub132ss(xmm23, xmm22, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62E24D009F7A80"                , vfnmsub132ss(xmm23, xmm22, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62E24D009FBAFCFDFFFF"          , vfnmsub132ss(xmm23, xmm22, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62C2ED40AEFB"                  , vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2ED42AEFB"                  , k(k2).vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2EDC2AEFB"                  , k(k2).z().vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2ED10AEFB"                  , rn_sae().vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2ED50AEFB"                  , ru_sae().vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2ED30AEFB"                  , rd_sae().vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62C2ED70AEFB"                  , rz_sae().vfnmsub213pd(zmm23, zmm18, zmm11));
  TEST_INSTRUCTION("62E2ED40AE39"                  , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A2ED40AEBCF023010000"        , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2ED50AE39"                  , vfnmsub213pd(zmm23, zmm18, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E2ED40AE7A7F"                , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E2ED40AEBA00200000"          , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E2ED40AE7A80"                , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E2ED40AEBAC0DFFFFF"          , vfnmsub213pd(zmm23, zmm18, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E2ED50AE7A7F"                , vfnmsub213pd(zmm23, zmm18, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E2ED50AEBA00040000"          , vfnmsub213pd(zmm23, zmm18, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E2ED50AE7A80"                , vfnmsub213pd(zmm23, zmm18, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E2ED50AEBAF8FBFFFF"          , vfnmsub213pd(zmm23, zmm18, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62E21548AEEA"                  , vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E2154BAEEA"                  , k(k3).vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E215CBAEEA"                  , k(k3).z().vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E21518AEEA"                  , rn_sae().vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E21558AEEA"                  , ru_sae().vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E21538AEEA"                  , rd_sae().vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E21578AEEA"                  , rz_sae().vfnmsub213ps(zmm21, zmm13, zmm2));
  TEST_INSTRUCTION("62E21548AE29"                  , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A21548AEACF023010000"        , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E21558AE29"                  , vfnmsub213ps(zmm21, zmm13, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E21548AE6A7F"                , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E21548AEAA00200000"          , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E21548AE6A80"                , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E21548AEAAC0DFFFFF"          , vfnmsub213ps(zmm21, zmm13, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E21558AE6A7F"                , vfnmsub213ps(zmm21, zmm13, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E21558AEAA00020000"          , vfnmsub213ps(zmm21, zmm13, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E21558AE6A80"                , vfnmsub213ps(zmm21, zmm13, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E21558AEAAFCFDFFFF"          , vfnmsub213ps(zmm21, zmm13, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6202C500AFEC"                  , vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C503AFEC"                  , k(k3).vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C583AFEC"                  , k(k3).z().vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C510AFEC"                  , rn_sae().vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C550AFEC"                  , ru_sae().vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C530AFEC"                  , rd_sae().vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6202C570AFEC"                  , rz_sae().vfnmsub213sd(xmm29, xmm23, xmm28));
  TEST_INSTRUCTION("6262C500AF29"                  , vfnmsub213sd(xmm29, xmm23, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222C500AFACF023010000"        , vfnmsub213sd(xmm29, xmm23, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262C500AF6A7F"                , vfnmsub213sd(xmm29, xmm23, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262C500AFAA00040000"          , vfnmsub213sd(xmm29, xmm23, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262C500AF6A80"                , vfnmsub213sd(xmm29, xmm23, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262C500AFAAF8FBFFFF"          , vfnmsub213sd(xmm29, xmm23, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62521D00AFF4"                  , vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D04AFF4"                  , k(k4).vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D84AFF4"                  , k(k4).z().vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D10AFF4"                  , rn_sae().vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D50AFF4"                  , ru_sae().vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D30AFF4"                  , rd_sae().vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62521D70AFF4"                  , rz_sae().vfnmsub213ss(xmm14, xmm28, xmm12));
  TEST_INSTRUCTION("62721D00AF31"                  , vfnmsub213ss(xmm14, xmm28, dword_ptr(rcx)));
  TEST_INSTRUCTION("62321D00AFB4F023010000"        , vfnmsub213ss(xmm14, xmm28, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62721D00AF727F"                , vfnmsub213ss(xmm14, xmm28, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62721D00AFB200020000"          , vfnmsub213ss(xmm14, xmm28, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62721D00AF7280"                , vfnmsub213ss(xmm14, xmm28, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62721D00AFB2FCFDFFFF"          , vfnmsub213ss(xmm14, xmm28, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6202DD48BEE8"                  , vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DD4FBEE8"                  , k(k7).vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DDCFBEE8"                  , k(k7).z().vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DD18BEE8"                  , rn_sae().vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DD58BEE8"                  , ru_sae().vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DD38BEE8"                  , rd_sae().vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6202DD78BEE8"                  , rz_sae().vfnmsub231pd(zmm29, zmm4, zmm24));
  TEST_INSTRUCTION("6262DD48BE29"                  , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6222DD48BEACF023010000"        , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262DD58BE29"                  , vfnmsub231pd(zmm29, zmm4, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6262DD48BE6A7F"                , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6262DD48BEAA00200000"          , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6262DD48BE6A80"                , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6262DD48BEAAC0DFFFFF"          , vfnmsub231pd(zmm29, zmm4, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6262DD58BE6A7F"                , vfnmsub231pd(zmm29, zmm4, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6262DD58BEAA00040000"          , vfnmsub231pd(zmm29, zmm4, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6262DD58BE6A80"                , vfnmsub231pd(zmm29, zmm4, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6262DD58BEAAF8FBFFFF"          , vfnmsub231pd(zmm29, zmm4, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62524D48BEC5"                  , vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524D4ABEC5"                  , k(k2).vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524DCABEC5"                  , k(k2).z().vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524D18BEC5"                  , rn_sae().vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524D58BEC5"                  , ru_sae().vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524D38BEC5"                  , rd_sae().vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62524D78BEC5"                  , rz_sae().vfnmsub231ps(zmm8, zmm6, zmm13));
  TEST_INSTRUCTION("62724D48BE01"                  , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62324D48BE84F023010000"        , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62724D58BE01"                  , vfnmsub231ps(zmm8, zmm6, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62724D48BE427F"                , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62724D48BE8200200000"          , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62724D48BE4280"                , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62724D48BE82C0DFFFFF"          , vfnmsub231ps(zmm8, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62724D58BE427F"                , vfnmsub231ps(zmm8, zmm6, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62724D58BE8200020000"          , vfnmsub231ps(zmm8, zmm6, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62724D58BE4280"                , vfnmsub231ps(zmm8, zmm6, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62724D58BE82FCFDFFFF"          , vfnmsub231ps(zmm8, zmm6, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62D2DD00BFF6"                  , vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD01BFF6"                  , k(k1).vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD81BFF6"                  , k(k1).z().vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD10BFF6"                  , rn_sae().vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD50BFF6"                  , ru_sae().vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD30BFF6"                  , rd_sae().vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62D2DD70BFF6"                  , rz_sae().vfnmsub231sd(xmm6, xmm20, xmm14));
  TEST_INSTRUCTION("62F2DD00BF31"                  , vfnmsub231sd(xmm6, xmm20, qword_ptr(rcx)));
  TEST_INSTRUCTION("62B2DD00BFB4F023010000"        , vfnmsub231sd(xmm6, xmm20, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2DD00BF727F"                , vfnmsub231sd(xmm6, xmm20, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62F2DD00BFB200040000"          , vfnmsub231sd(xmm6, xmm20, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62F2DD00BF7280"                , vfnmsub231sd(xmm6, xmm20, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62F2DD00BFB2F8FBFFFF"          , vfnmsub231sd(xmm6, xmm20, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62421508BFD2"                  , vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("6242150CBFD2"                  , k(k4).vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("6242158CBFD2"                  , k(k4).z().vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("62421518BFD2"                  , rn_sae().vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("62421558BFD2"                  , ru_sae().vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("62421538BFD2"                  , rd_sae().vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("62421578BFD2"                  , rz_sae().vfnmsub231ss(xmm26, xmm13, xmm10));
  TEST_INSTRUCTION("62621508BF11"                  , vfnmsub231ss(xmm26, xmm13, dword_ptr(rcx)));
  TEST_INSTRUCTION("62221508BF94F023010000"        , vfnmsub231ss(xmm26, xmm13, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62621508BF527F"                , vfnmsub231ss(xmm26, xmm13, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62621508BF9200020000"          , vfnmsub231ss(xmm26, xmm13, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62621508BF5280"                , vfnmsub231ss(xmm26, xmm13, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62621508BF92FCFDFFFF"          , vfnmsub231ss(xmm26, xmm13, dword_ptr(rdx, -516)));
}

static void ASMJIT_NOINLINE test_x64_assembler_avx512_llvm_2(AssemblerTester<x86::Assembler>& tester) noexcept {
  using namespace x86;

  TEST_INSTRUCTION("6212FD4842F1"                  , vgetexppd(zmm14, zmm25));
  TEST_INSTRUCTION("6212FD4D42F1"                  , k(k5).vgetexppd(zmm14, zmm25));
  TEST_INSTRUCTION("6212FDCD42F1"                  , k(k5).z().vgetexppd(zmm14, zmm25));
  TEST_INSTRUCTION("6212FD1842F1"                  , sae().vgetexppd(zmm14, zmm25));
  TEST_INSTRUCTION("6272FD484231"                  , vgetexppd(zmm14, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6232FD4842B4F023010000"        , vgetexppd(zmm14, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6272FD584231"                  , vgetexppd(zmm14, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6272FD4842727F"                , vgetexppd(zmm14, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6272FD4842B200200000"          , vgetexppd(zmm14, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6272FD48427280"                , vgetexppd(zmm14, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6272FD4842B2C0DFFFFF"          , vgetexppd(zmm14, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6272FD5842727F"                , vgetexppd(zmm14, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6272FD5842B200040000"          , vgetexppd(zmm14, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6272FD58427280"                , vgetexppd(zmm14, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6272FD5842B2F8FBFFFF"          , vgetexppd(zmm14, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62F27D4842CE"                  , vgetexpps(zmm1, zmm6));
  TEST_INSTRUCTION("62F27D4B42CE"                  , k(k3).vgetexpps(zmm1, zmm6));
  TEST_INSTRUCTION("62F27DCB42CE"                  , k(k3).z().vgetexpps(zmm1, zmm6));
  TEST_INSTRUCTION("62F27D1842CE"                  , sae().vgetexpps(zmm1, zmm6));
  TEST_INSTRUCTION("62F27D484209"                  , vgetexpps(zmm1, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B27D48428CF023010000"        , vgetexpps(zmm1, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F27D584209"                  , vgetexpps(zmm1, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F27D48424A7F"                , vgetexpps(zmm1, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F27D48428A00200000"          , vgetexpps(zmm1, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F27D48424A80"                , vgetexpps(zmm1, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F27D48428AC0DFFFFF"          , vgetexpps(zmm1, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F27D58424A7F"                , vgetexpps(zmm1, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F27D58428A00020000"          , vgetexpps(zmm1, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F27D58424A80"                , vgetexpps(zmm1, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F27D58428AFCFDFFFF"          , vgetexpps(zmm1, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F2C50843D2"                  , vgetexpsd(xmm2, xmm7, xmm2));
  TEST_INSTRUCTION("62F2C50D43D2"                  , k(k5).vgetexpsd(xmm2, xmm7, xmm2));
  TEST_INSTRUCTION("62F2C58D43D2"                  , k(k5).z().vgetexpsd(xmm2, xmm7, xmm2));
  TEST_INSTRUCTION("62F2C51843D2"                  , sae().vgetexpsd(xmm2, xmm7, xmm2));
  TEST_INSTRUCTION("62F2C5084311"                  , vgetexpsd(xmm2, xmm7, qword_ptr(rcx)));
  TEST_INSTRUCTION("62B2C5084394F023010000"        , vgetexpsd(xmm2, xmm7, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2C50843527F"                , vgetexpsd(xmm2, xmm7, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62F2C508439200040000"          , vgetexpsd(xmm2, xmm7, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62F2C508435280"                , vgetexpsd(xmm2, xmm7, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62F2C5084392F8FBFFFF"          , vgetexpsd(xmm2, xmm7, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("6282750843E2"                  , vgetexpss(xmm20, xmm1, xmm26));
  TEST_INSTRUCTION("6282750F43E2"                  , k(k7).vgetexpss(xmm20, xmm1, xmm26));
  TEST_INSTRUCTION("6282758F43E2"                  , k(k7).z().vgetexpss(xmm20, xmm1, xmm26));
  TEST_INSTRUCTION("6282751843E2"                  , sae().vgetexpss(xmm20, xmm1, xmm26));
  TEST_INSTRUCTION("62E275084321"                  , vgetexpss(xmm20, xmm1, dword_ptr(rcx)));
  TEST_INSTRUCTION("62A2750843A4F023010000"        , vgetexpss(xmm20, xmm1, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E2750843627F"                , vgetexpss(xmm20, xmm1, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62E2750843A200020000"          , vgetexpss(xmm20, xmm1, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62E27508436280"                , vgetexpss(xmm20, xmm1, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62E2750843A2FCFDFFFF"          , vgetexpss(xmm20, xmm1, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("6293FD4826D2AB"                , vgetmantpd(zmm2, zmm26, 171));
  TEST_INSTRUCTION("6293FD4F26D2AB"                , k(k7).vgetmantpd(zmm2, zmm26, 171));
  TEST_INSTRUCTION("6293FDCF26D2AB"                , k(k7).z().vgetmantpd(zmm2, zmm26, 171));
  TEST_INSTRUCTION("6293FD1826D2AB"                , sae().vgetmantpd(zmm2, zmm26, 171));
  TEST_INSTRUCTION("6293FD4826D27B"                , vgetmantpd(zmm2, zmm26, 123));
  TEST_INSTRUCTION("6293FD1826D27B"                , sae().vgetmantpd(zmm2, zmm26, 123));
  TEST_INSTRUCTION("62F3FD4826117B"                , vgetmantpd(zmm2, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B3FD482694F0230100007B"      , vgetmantpd(zmm2, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F3FD5826117B"                , vgetmantpd(zmm2, qword_ptr(rcx)._1to8(), 123));
  TEST_INSTRUCTION("62F3FD4826527F7B"              , vgetmantpd(zmm2, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F3FD482692002000007B"        , vgetmantpd(zmm2, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F3FD482652807B"              , vgetmantpd(zmm2, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F3FD482692C0DFFFFF7B"        , vgetmantpd(zmm2, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F3FD5826527F7B"              , vgetmantpd(zmm2, qword_ptr(rdx, 1016)._1to8(), 123));
  TEST_INSTRUCTION("62F3FD582692000400007B"        , vgetmantpd(zmm2, qword_ptr(rdx, 1024)._1to8(), 123));
  TEST_INSTRUCTION("62F3FD582652807B"              , vgetmantpd(zmm2, qword_ptr(rdx, -1024)._1to8(), 123));
  TEST_INSTRUCTION("62F3FD582692F8FBFFFF7B"        , vgetmantpd(zmm2, qword_ptr(rdx, -1032)._1to8(), 123));
  TEST_INSTRUCTION("62837D4826F4AB"                , vgetmantps(zmm22, zmm28, 171));
  TEST_INSTRUCTION("62837D4B26F4AB"                , k(k3).vgetmantps(zmm22, zmm28, 171));
  TEST_INSTRUCTION("62837DCB26F4AB"                , k(k3).z().vgetmantps(zmm22, zmm28, 171));
  TEST_INSTRUCTION("62837D1826F4AB"                , sae().vgetmantps(zmm22, zmm28, 171));
  TEST_INSTRUCTION("62837D4826F47B"                , vgetmantps(zmm22, zmm28, 123));
  TEST_INSTRUCTION("62837D1826F47B"                , sae().vgetmantps(zmm22, zmm28, 123));
  TEST_INSTRUCTION("62E37D4826317B"                , vgetmantps(zmm22, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62A37D4826B4F0230100007B"      , vgetmantps(zmm22, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62E37D5826317B"                , vgetmantps(zmm22, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62E37D4826727F7B"              , vgetmantps(zmm22, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62E37D4826B2002000007B"        , vgetmantps(zmm22, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62E37D482672807B"              , vgetmantps(zmm22, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62E37D4826B2C0DFFFFF7B"        , vgetmantps(zmm22, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62E37D5826727F7B"              , vgetmantps(zmm22, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62E37D5826B2000200007B"        , vgetmantps(zmm22, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62E37D582672807B"              , vgetmantps(zmm22, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62E37D5826B2FCFDFFFF7B"        , vgetmantps(zmm22, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62D3A50027D8AB"                , vgetmantsd(xmm3, xmm27, xmm8, 171));
  TEST_INSTRUCTION("62D3A50627D8AB"                , k(k6).vgetmantsd(xmm3, xmm27, xmm8, 171));
  TEST_INSTRUCTION("62D3A58627D8AB"                , k(k6).z().vgetmantsd(xmm3, xmm27, xmm8, 171));
  TEST_INSTRUCTION("62D3A51027D8AB"                , sae().vgetmantsd(xmm3, xmm27, xmm8, 171));
  TEST_INSTRUCTION("62D3A50027D87B"                , vgetmantsd(xmm3, xmm27, xmm8, 123));
  TEST_INSTRUCTION("62D3A51027D87B"                , sae().vgetmantsd(xmm3, xmm27, xmm8, 123));
  TEST_INSTRUCTION("62F3A50027197B"                , vgetmantsd(xmm3, xmm27, qword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B3A500279CF0230100007B"      , vgetmantsd(xmm3, xmm27, qword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F3A500275A7F7B"              , vgetmantsd(xmm3, xmm27, qword_ptr(rdx, 1016), 123));
  TEST_INSTRUCTION("62F3A500279A000400007B"        , vgetmantsd(xmm3, xmm27, qword_ptr(rdx, 1024), 123));
  TEST_INSTRUCTION("62F3A500275A807B"              , vgetmantsd(xmm3, xmm27, qword_ptr(rdx, -1024), 123));
  TEST_INSTRUCTION("62F3A500279AF8FBFFFF7B"        , vgetmantsd(xmm3, xmm27, qword_ptr(rdx, -1032), 123));
  TEST_INSTRUCTION("62D36D0827DCAB"                , vgetmantss(xmm3, xmm2, xmm12, 171));
  TEST_INSTRUCTION("62D36D0F27DCAB"                , k(k7).vgetmantss(xmm3, xmm2, xmm12, 171));
  TEST_INSTRUCTION("62D36D8F27DCAB"                , k(k7).z().vgetmantss(xmm3, xmm2, xmm12, 171));
  TEST_INSTRUCTION("62D36D1827DCAB"                , sae().vgetmantss(xmm3, xmm2, xmm12, 171));
  TEST_INSTRUCTION("62D36D0827DC7B"                , vgetmantss(xmm3, xmm2, xmm12, 123));
  TEST_INSTRUCTION("62D36D1827DC7B"                , sae().vgetmantss(xmm3, xmm2, xmm12, 123));
  TEST_INSTRUCTION("62F36D0827197B"                , vgetmantss(xmm3, xmm2, dword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B36D08279CF0230100007B"      , vgetmantss(xmm3, xmm2, dword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F36D08275A7F7B"              , vgetmantss(xmm3, xmm2, dword_ptr(rdx, 508), 123));
  TEST_INSTRUCTION("62F36D08279A000200007B"        , vgetmantss(xmm3, xmm2, dword_ptr(rdx, 512), 123));
  TEST_INSTRUCTION("62F36D08275A807B"              , vgetmantss(xmm3, xmm2, dword_ptr(rdx, -512), 123));
  TEST_INSTRUCTION("62F36D08279AFCFDFFFF7B"        , vgetmantss(xmm3, xmm2, dword_ptr(rdx, -516), 123));
  TEST_INSTRUCTION("62732D4018DBAB"                , vinsertf32x4(zmm11, zmm26, xmm3, 171));
  TEST_INSTRUCTION("62732D4118DBAB"                , k(k1).vinsertf32x4(zmm11, zmm26, xmm3, 171));
  TEST_INSTRUCTION("62732DC118DBAB"                , k(k1).z().vinsertf32x4(zmm11, zmm26, xmm3, 171));
  TEST_INSTRUCTION("62732D4018DB7B"                , vinsertf32x4(zmm11, zmm26, xmm3, 123));
  TEST_INSTRUCTION("62732D4018197B"                , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62332D40189CF0230100007B"      , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62732D40185A7F7B"              , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rdx, 2032), 123));
  TEST_INSTRUCTION("62732D40189A000800007B"        , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rdx, 2048), 123));
  TEST_INSTRUCTION("62732D40185A807B"              , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rdx, -2048), 123));
  TEST_INSTRUCTION("62732D40189AF0F7FFFF7B"        , vinsertf32x4(zmm11, zmm26, xmmword_ptr(rdx, -2064), 123));
  TEST_INSTRUCTION("62F3D5481ACFAB"                , vinsertf64x4(zmm1, zmm5, ymm7, 171));
  TEST_INSTRUCTION("62F3D5491ACFAB"                , k(k1).vinsertf64x4(zmm1, zmm5, ymm7, 171));
  TEST_INSTRUCTION("62F3D5C91ACFAB"                , k(k1).z().vinsertf64x4(zmm1, zmm5, ymm7, 171));
  TEST_INSTRUCTION("62F3D5481ACF7B"                , vinsertf64x4(zmm1, zmm5, ymm7, 123));
  TEST_INSTRUCTION("62F3D5481A097B"                , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B3D5481A8CF0230100007B"      , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F3D5481A4A7F7B"              , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rdx, 4064), 123));
  TEST_INSTRUCTION("62F3D5481A8A001000007B"        , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rdx, 4096), 123));
  TEST_INSTRUCTION("62F3D5481A4A807B"              , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rdx, -4096), 123));
  TEST_INSTRUCTION("62F3D5481A8AE0EFFFFF7B"        , vinsertf64x4(zmm1, zmm5, ymmword_ptr(rdx, -4128), 123));
  TEST_INSTRUCTION("62C3154838CAAB"                , vinserti32x4(zmm17, zmm13, xmm10, 171));
  TEST_INSTRUCTION("62C3154E38CAAB"                , k(k6).vinserti32x4(zmm17, zmm13, xmm10, 171));
  TEST_INSTRUCTION("62C315CE38CAAB"                , k(k6).z().vinserti32x4(zmm17, zmm13, xmm10, 171));
  TEST_INSTRUCTION("62C3154838CA7B"                , vinserti32x4(zmm17, zmm13, xmm10, 123));
  TEST_INSTRUCTION("62E3154838097B"                , vinserti32x4(zmm17, zmm13, xmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62A31548388CF0230100007B"      , vinserti32x4(zmm17, zmm13, xmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62E31548384A7F7B"              , vinserti32x4(zmm17, zmm13, xmmword_ptr(rdx, 2032), 123));
  TEST_INSTRUCTION("62E31548388A000800007B"        , vinserti32x4(zmm17, zmm13, xmmword_ptr(rdx, 2048), 123));
  TEST_INSTRUCTION("62E31548384A807B"              , vinserti32x4(zmm17, zmm13, xmmword_ptr(rdx, -2048), 123));
  TEST_INSTRUCTION("62E31548388AF0F7FFFF7B"        , vinserti32x4(zmm17, zmm13, xmmword_ptr(rdx, -2064), 123));
  TEST_INSTRUCTION("62F3B5403AE4AB"                , vinserti64x4(zmm4, zmm25, ymm4, 171));
  TEST_INSTRUCTION("62F3B5413AE4AB"                , k(k1).vinserti64x4(zmm4, zmm25, ymm4, 171));
  TEST_INSTRUCTION("62F3B5C13AE4AB"                , k(k1).z().vinserti64x4(zmm4, zmm25, ymm4, 171));
  TEST_INSTRUCTION("62F3B5403AE47B"                , vinserti64x4(zmm4, zmm25, ymm4, 123));
  TEST_INSTRUCTION("62F3B5403A217B"                , vinserti64x4(zmm4, zmm25, ymmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B3B5403AA4F0230100007B"      , vinserti64x4(zmm4, zmm25, ymmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F3B5403A627F7B"              , vinserti64x4(zmm4, zmm25, ymmword_ptr(rdx, 4064), 123));
  TEST_INSTRUCTION("62F3B5403AA2001000007B"        , vinserti64x4(zmm4, zmm25, ymmword_ptr(rdx, 4096), 123));
  TEST_INSTRUCTION("62F3B5403A62807B"              , vinserti64x4(zmm4, zmm25, ymmword_ptr(rdx, -4096), 123));
  TEST_INSTRUCTION("62F3B5403AA2E0EFFFFF7B"        , vinserti64x4(zmm4, zmm25, ymmword_ptr(rdx, -4128), 123));
  TEST_INSTRUCTION("6263750021F5AB"                , vinsertps(xmm30, xmm17, xmm5, 171));
  TEST_INSTRUCTION("6263750021F57B"                , vinsertps(xmm30, xmm17, xmm5, 123));
  TEST_INSTRUCTION("6263750021317B"                , vinsertps(xmm30, xmm17, dword_ptr(rcx), 123));
  TEST_INSTRUCTION("6223750021B4F0230100007B"      , vinsertps(xmm30, xmm17, dword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("6263750021727F7B"              , vinsertps(xmm30, xmm17, dword_ptr(rdx, 508), 123));
  TEST_INSTRUCTION("6263750021B2000200007B"        , vinsertps(xmm30, xmm17, dword_ptr(rdx, 512), 123));
  TEST_INSTRUCTION("626375002172807B"              , vinsertps(xmm30, xmm17, dword_ptr(rdx, -512), 123));
  TEST_INSTRUCTION("6263750021B2FCFDFFFF7B"        , vinsertps(xmm30, xmm17, dword_ptr(rdx, -516), 123));
  TEST_INSTRUCTION("62219D405FF4"                  , vmaxpd(zmm30, zmm28, zmm20));
  TEST_INSTRUCTION("62219D415FF4"                  , k(k1).vmaxpd(zmm30, zmm28, zmm20));
  TEST_INSTRUCTION("62219DC15FF4"                  , k(k1).z().vmaxpd(zmm30, zmm28, zmm20));
  TEST_INSTRUCTION("62219D105FF4"                  , sae().vmaxpd(zmm30, zmm28, zmm20));
  TEST_INSTRUCTION("62619D405F31"                  , vmaxpd(zmm30, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62219D405FB4F023010000"        , vmaxpd(zmm30, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62619D505F31"                  , vmaxpd(zmm30, zmm28, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62619D405F727F"                , vmaxpd(zmm30, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62619D405FB200200000"          , vmaxpd(zmm30, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62619D405F7280"                , vmaxpd(zmm30, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62619D405FB2C0DFFFFF"          , vmaxpd(zmm30, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62619D505F727F"                , vmaxpd(zmm30, zmm28, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62619D505FB200040000"          , vmaxpd(zmm30, zmm28, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62619D505F7280"                , vmaxpd(zmm30, zmm28, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62619D505FB2F8FBFFFF"          , vmaxpd(zmm30, zmm28, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62214C485FCC"                  , vmaxps(zmm25, zmm6, zmm20));
  TEST_INSTRUCTION("62214C495FCC"                  , k(k1).vmaxps(zmm25, zmm6, zmm20));
  TEST_INSTRUCTION("62214CC95FCC"                  , k(k1).z().vmaxps(zmm25, zmm6, zmm20));
  TEST_INSTRUCTION("62214C185FCC"                  , sae().vmaxps(zmm25, zmm6, zmm20));
  TEST_INSTRUCTION("62614C485F09"                  , vmaxps(zmm25, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62214C485F8CF023010000"        , vmaxps(zmm25, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62614C585F09"                  , vmaxps(zmm25, zmm6, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62614C485F4A7F"                , vmaxps(zmm25, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62614C485F8A00200000"          , vmaxps(zmm25, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62614C485F4A80"                , vmaxps(zmm25, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62614C485F8AC0DFFFFF"          , vmaxps(zmm25, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62614C585F4A7F"                , vmaxps(zmm25, zmm6, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62614C585F8A00020000"          , vmaxps(zmm25, zmm6, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62614C585F4A80"                , vmaxps(zmm25, zmm6, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62614C585F8AFCFDFFFF"          , vmaxps(zmm25, zmm6, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6281E7005FE1"                  , vmaxsd(xmm20, xmm19, xmm25));
  TEST_INSTRUCTION("6281E7035FE1"                  , k(k3).vmaxsd(xmm20, xmm19, xmm25));
  TEST_INSTRUCTION("6281E7835FE1"                  , k(k3).z().vmaxsd(xmm20, xmm19, xmm25));
  TEST_INSTRUCTION("6281E7105FE1"                  , sae().vmaxsd(xmm20, xmm19, xmm25));
  TEST_INSTRUCTION("62E1E7005F21"                  , vmaxsd(xmm20, xmm19, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A1E7005FA4F023010000"        , vmaxsd(xmm20, xmm19, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1E7005F627F"                , vmaxsd(xmm20, xmm19, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E1E7005FA200040000"          , vmaxsd(xmm20, xmm19, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E1E7005F6280"                , vmaxsd(xmm20, xmm19, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E1E7005FA2F8FBFFFF"          , vmaxsd(xmm20, xmm19, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("C55A5FC6"                      , vmaxss(xmm8, xmm4, xmm6));
  TEST_INSTRUCTION("62715E0C5FC6"                  , k(k4).vmaxss(xmm8, xmm4, xmm6));
  TEST_INSTRUCTION("62715E8C5FC6"                  , k(k4).z().vmaxss(xmm8, xmm4, xmm6));
  TEST_INSTRUCTION("62715E185FC6"                  , sae().vmaxss(xmm8, xmm4, xmm6));
  TEST_INSTRUCTION("C55A5F01"                      , vmaxss(xmm8, xmm4, dword_ptr(rcx)));
  TEST_INSTRUCTION("C4215A5F84F023010000"          , vmaxss(xmm8, xmm4, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C55A5F82FC010000"              , vmaxss(xmm8, xmm4, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C55A5F8200020000"              , vmaxss(xmm8, xmm4, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C55A5F8200FEFFFF"              , vmaxss(xmm8, xmm4, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C55A5F82FCFDFFFF"              , vmaxss(xmm8, xmm4, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62B1CD485DF6"                  , vminpd(zmm6, zmm6, zmm22));
  TEST_INSTRUCTION("62B1CD4F5DF6"                  , k(k7).vminpd(zmm6, zmm6, zmm22));
  TEST_INSTRUCTION("62B1CDCF5DF6"                  , k(k7).z().vminpd(zmm6, zmm6, zmm22));
  TEST_INSTRUCTION("62B1CD185DF6"                  , sae().vminpd(zmm6, zmm6, zmm22));
  TEST_INSTRUCTION("62F1CD485D31"                  , vminpd(zmm6, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1CD485DB4F023010000"        , vminpd(zmm6, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1CD585D31"                  , vminpd(zmm6, zmm6, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F1CD485D727F"                , vminpd(zmm6, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1CD485DB200200000"          , vminpd(zmm6, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F1CD485D7280"                , vminpd(zmm6, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1CD485DB2C0DFFFFF"          , vminpd(zmm6, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F1CD585D727F"                , vminpd(zmm6, zmm6, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F1CD585DB200040000"          , vminpd(zmm6, zmm6, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F1CD585D7280"                , vminpd(zmm6, zmm6, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F1CD585DB2F8FBFFFF"          , vminpd(zmm6, zmm6, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62F164485DDF"                  , vminps(zmm3, zmm3, zmm7));
  TEST_INSTRUCTION("62F1644B5DDF"                  , k(k3).vminps(zmm3, zmm3, zmm7));
  TEST_INSTRUCTION("62F164CB5DDF"                  , k(k3).z().vminps(zmm3, zmm3, zmm7));
  TEST_INSTRUCTION("62F164185DDF"                  , sae().vminps(zmm3, zmm3, zmm7));
  TEST_INSTRUCTION("62F164485D19"                  , vminps(zmm3, zmm3, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B164485D9CF023010000"        , vminps(zmm3, zmm3, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F164585D19"                  , vminps(zmm3, zmm3, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F164485D5A7F"                , vminps(zmm3, zmm3, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F164485D9A00200000"          , vminps(zmm3, zmm3, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F164485D5A80"                , vminps(zmm3, zmm3, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F164485D9AC0DFFFFF"          , vminps(zmm3, zmm3, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F164585D5A7F"                , vminps(zmm3, zmm3, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F164585D9A00020000"          , vminps(zmm3, zmm3, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F164585D5A80"                , vminps(zmm3, zmm3, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F164585D9AFCFDFFFF"          , vminps(zmm3, zmm3, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6291B7005DEA"                  , vminsd(xmm5, xmm25, xmm26));
  TEST_INSTRUCTION("6291B7035DEA"                  , k(k3).vminsd(xmm5, xmm25, xmm26));
  TEST_INSTRUCTION("6291B7835DEA"                  , k(k3).z().vminsd(xmm5, xmm25, xmm26));
  TEST_INSTRUCTION("6291B7105DEA"                  , sae().vminsd(xmm5, xmm25, xmm26));
  TEST_INSTRUCTION("62F1B7005D29"                  , vminsd(xmm5, xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("62B1B7005DACF023010000"        , vminsd(xmm5, xmm25, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1B7005D6A7F"                , vminsd(xmm5, xmm25, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62F1B7005DAA00040000"          , vminsd(xmm5, xmm25, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62F1B7005D6A80"                , vminsd(xmm5, xmm25, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62F1B7005DAAF8FBFFFF"          , vminsd(xmm5, xmm25, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("623176005DD3"                  , vminss(xmm10, xmm17, xmm19));
  TEST_INSTRUCTION("623176055DD3"                  , k(k5).vminss(xmm10, xmm17, xmm19));
  TEST_INSTRUCTION("623176855DD3"                  , k(k5).z().vminss(xmm10, xmm17, xmm19));
  TEST_INSTRUCTION("623176105DD3"                  , sae().vminss(xmm10, xmm17, xmm19));
  TEST_INSTRUCTION("627176005D11"                  , vminss(xmm10, xmm17, dword_ptr(rcx)));
  TEST_INSTRUCTION("623176005D94F023010000"        , vminss(xmm10, xmm17, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("627176005D527F"                , vminss(xmm10, xmm17, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("627176005D9200020000"          , vminss(xmm10, xmm17, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("627176005D5280"                , vminss(xmm10, xmm17, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("627176005D92FCFDFFFF"          , vminss(xmm10, xmm17, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62D1FD4828FE"                  , vmovapd(zmm7, zmm14));
  TEST_INSTRUCTION("62D1FD4D28FE"                  , k(k5).vmovapd(zmm7, zmm14));
  TEST_INSTRUCTION("62D1FDCD28FE"                  , k(k5).z().vmovapd(zmm7, zmm14));
  TEST_INSTRUCTION("62F1FD482839"                  , vmovapd(zmm7, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1FD4828BCF023010000"        , vmovapd(zmm7, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1FD48287A7F"                , vmovapd(zmm7, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1FD4828BA00200000"          , vmovapd(zmm7, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F1FD48287A80"                , vmovapd(zmm7, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1FD4828BAC0DFFFFF"          , vmovapd(zmm7, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62D17C4828E9"                  , vmovaps(zmm5, zmm9));
  TEST_INSTRUCTION("62D17C4928E9"                  , k(k1).vmovaps(zmm5, zmm9));
  TEST_INSTRUCTION("62D17CC928E9"                  , k(k1).z().vmovaps(zmm5, zmm9));
  TEST_INSTRUCTION("62F17C482829"                  , vmovaps(zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B17C4828ACF023010000"        , vmovaps(zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F17C48286A7F"                , vmovaps(zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F17C4828AA00200000"          , vmovaps(zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F17C48286A80"                , vmovaps(zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F17C4828AAC0DFFFFF"          , vmovaps(zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62617D086ED0"                  , vmovd(xmm26, eax));
  TEST_INSTRUCTION("62617D086ED5"                  , vmovd(xmm26, ebp));
  TEST_INSTRUCTION("62417D086ED5"                  , vmovd(xmm26, r13d));
  TEST_INSTRUCTION("62617D086E11"                  , vmovd(xmm26, dword_ptr(rcx)));
  TEST_INSTRUCTION("62217D086E94F023010000"        , vmovd(xmm26, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62617D086E527F"                , vmovd(xmm26, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62617D086E9200020000"          , vmovd(xmm26, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62617D086E5280"                , vmovd(xmm26, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62617D086E92FCFDFFFF"          , vmovd(xmm26, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("C5F97E29"                      , vmovd(dword_ptr(rcx), xmm5));
  TEST_INSTRUCTION("C4A1797EACF023010000"          , vmovd(dword_ptr(rax, r14, 3, 291), xmm5));
  TEST_INSTRUCTION("C5F97EAAFC010000"              , vmovd(dword_ptr(rdx, 508), xmm5));
  TEST_INSTRUCTION("C5F97EAA00020000"              , vmovd(dword_ptr(rdx, 512), xmm5));
  TEST_INSTRUCTION("C5F97EAA00FEFFFF"              , vmovd(dword_ptr(rdx, -512), xmm5));
  TEST_INSTRUCTION("C5F97EAAFCFDFFFF"              , vmovd(dword_ptr(rdx, -516), xmm5));
  TEST_INSTRUCTION("6291FF4812ED"                  , vmovddup(zmm5, zmm29));
  TEST_INSTRUCTION("6291FF4C12ED"                  , k(k4).vmovddup(zmm5, zmm29));
  TEST_INSTRUCTION("6291FFCC12ED"                  , k(k4).z().vmovddup(zmm5, zmm29));
  TEST_INSTRUCTION("62F1FF481229"                  , vmovddup(zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1FF4812ACF023010000"        , vmovddup(zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1FF48126A7F"                , vmovddup(zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1FF4812AA00200000"          , vmovddup(zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F1FF48126A80"                , vmovddup(zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1FF4812AAC0DFFFFF"          , vmovddup(zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62A17D486FF2"                  , vmovdqa32(zmm22, zmm18));
  TEST_INSTRUCTION("62A17D4E6FF2"                  , k(k6).vmovdqa32(zmm22, zmm18));
  TEST_INSTRUCTION("62A17DCE6FF2"                  , k(k6).z().vmovdqa32(zmm22, zmm18));
  TEST_INSTRUCTION("62E17D486F31"                  , vmovdqa32(zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17D486FB4F023010000"        , vmovdqa32(zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17D486F727F"                , vmovdqa32(zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E17D486FB200200000"          , vmovdqa32(zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E17D486F7280"                , vmovdqa32(zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E17D486FB2C0DFFFFF"          , vmovdqa32(zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62C1FD486FF4"                  , vmovdqa64(zmm22, zmm12));
  TEST_INSTRUCTION("62C1FD4D6FF4"                  , k(k5).vmovdqa64(zmm22, zmm12));
  TEST_INSTRUCTION("62C1FDCD6FF4"                  , k(k5).z().vmovdqa64(zmm22, zmm12));
  TEST_INSTRUCTION("62E1FD486F31"                  , vmovdqa64(zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A1FD486FB4F023010000"        , vmovdqa64(zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1FD486F727F"                , vmovdqa64(zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E1FD486FB200200000"          , vmovdqa64(zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E1FD486F7280"                , vmovdqa64(zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E1FD486FB2C0DFFFFF"          , vmovdqa64(zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62917E486FE8"                  , vmovdqu32(zmm5, zmm24));
  TEST_INSTRUCTION("62917E4D6FE8"                  , k(k5).vmovdqu32(zmm5, zmm24));
  TEST_INSTRUCTION("62917ECD6FE8"                  , k(k5).z().vmovdqu32(zmm5, zmm24));
  TEST_INSTRUCTION("62F17E486F29"                  , vmovdqu32(zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B17E486FACF023010000"        , vmovdqu32(zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F17E486F6A7F"                , vmovdqu32(zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F17E486FAA00200000"          , vmovdqu32(zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F17E486F6A80"                , vmovdqu32(zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F17E486FAAC0DFFFFF"          , vmovdqu32(zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62D1FE486FF7"                  , vmovdqu64(zmm6, zmm15));
  TEST_INSTRUCTION("62D1FE4B6FF7"                  , k(k3).vmovdqu64(zmm6, zmm15));
  TEST_INSTRUCTION("62D1FECB6FF7"                  , k(k3).z().vmovdqu64(zmm6, zmm15));
  TEST_INSTRUCTION("62F1FE486F31"                  , vmovdqu64(zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1FE486FB4F023010000"        , vmovdqu64(zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F1FE486F727F"                , vmovdqu64(zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1FE486FB200200000"          , vmovdqu64(zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F1FE486F7280"                , vmovdqu64(zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1FE486FB2C0DFFFFF"          , vmovdqu64(zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62A1740812D7"                  , vmovhlps(xmm18, xmm1, xmm23));
  TEST_INSTRUCTION("62E19D001619"                  , vmovhpd(xmm19, xmm28, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A19D00169CF023010000"        , vmovhpd(xmm19, xmm28, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E19D00165A7F"                , vmovhpd(xmm19, xmm28, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E19D00169A00040000"          , vmovhpd(xmm19, xmm28, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E19D00165A80"                , vmovhpd(xmm19, xmm28, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E19D00169AF8FBFFFF"          , vmovhpd(xmm19, xmm28, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("C5791739"                      , vmovhpd(qword_ptr(rcx), xmm15));
  TEST_INSTRUCTION("C4217917BCF023010000"          , vmovhpd(qword_ptr(rax, r14, 3, 291), xmm15));
  TEST_INSTRUCTION("C57917BAF8030000"              , vmovhpd(qword_ptr(rdx, 1016), xmm15));
  TEST_INSTRUCTION("C57917BA00040000"              , vmovhpd(qword_ptr(rdx, 1024), xmm15));
  TEST_INSTRUCTION("C57917BA00FCFFFF"              , vmovhpd(qword_ptr(rdx, -1024), xmm15));
  TEST_INSTRUCTION("C57917BAF8FBFFFF"              , vmovhpd(qword_ptr(rdx, -1032), xmm15));
  TEST_INSTRUCTION("62E174001621"                  , vmovhps(xmm20, xmm17, qword_ptr(rcx)));
  TEST_INSTRUCTION("62A1740016A4F023010000"        , vmovhps(xmm20, xmm17, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1740016627F"                , vmovhps(xmm20, xmm17, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62E1740016A200040000"          , vmovhps(xmm20, xmm17, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62E17400166280"                , vmovhps(xmm20, xmm17, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62E1740016A2F8FBFFFF"          , vmovhps(xmm20, xmm17, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62E17C081711"                  , vmovhps(qword_ptr(rcx), xmm18));
  TEST_INSTRUCTION("62A17C081794F023010000"        , vmovhps(qword_ptr(rax, r14, 3, 291), xmm18));
  TEST_INSTRUCTION("62E17C0817527F"                , vmovhps(qword_ptr(rdx, 1016), xmm18));
  TEST_INSTRUCTION("62E17C08179200040000"          , vmovhps(qword_ptr(rdx, 1024), xmm18));
  TEST_INSTRUCTION("62E17C08175280"                , vmovhps(qword_ptr(rdx, -1024), xmm18));
  TEST_INSTRUCTION("62E17C081792F8FBFFFF"          , vmovhps(qword_ptr(rdx, -1032), xmm18));
  TEST_INSTRUCTION("6211140816EC"                  , vmovlhps(xmm13, xmm13, xmm28));
  TEST_INSTRUCTION("6261CD081229"                  , vmovlpd(xmm29, xmm6, qword_ptr(rcx)));
  TEST_INSTRUCTION("6221CD0812ACF023010000"        , vmovlpd(xmm29, xmm6, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261CD08126A7F"                , vmovlpd(xmm29, xmm6, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6261CD0812AA00040000"          , vmovlpd(xmm29, xmm6, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6261CD08126A80"                , vmovlpd(xmm29, xmm6, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6261CD0812AAF8FBFFFF"          , vmovlpd(xmm29, xmm6, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("C5791339"                      , vmovlpd(qword_ptr(rcx), xmm15));
  TEST_INSTRUCTION("C4217913BCF023010000"          , vmovlpd(qword_ptr(rax, r14, 3, 291), xmm15));
  TEST_INSTRUCTION("C57913BAF8030000"              , vmovlpd(qword_ptr(rdx, 1016), xmm15));
  TEST_INSTRUCTION("C57913BA00040000"              , vmovlpd(qword_ptr(rdx, 1024), xmm15));
  TEST_INSTRUCTION("C57913BA00FCFFFF"              , vmovlpd(qword_ptr(rdx, -1024), xmm15));
  TEST_INSTRUCTION("C57913BAF8FBFFFF"              , vmovlpd(qword_ptr(rdx, -1032), xmm15));
  TEST_INSTRUCTION("62F15C001239"                  , vmovlps(xmm7, xmm20, qword_ptr(rcx)));
  TEST_INSTRUCTION("62B15C0012BCF023010000"        , vmovlps(xmm7, xmm20, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F15C00127A7F"                , vmovlps(xmm7, xmm20, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("62F15C0012BA00040000"          , vmovlps(xmm7, xmm20, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("62F15C00127A80"                , vmovlps(xmm7, xmm20, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("62F15C0012BAF8FBFFFF"          , vmovlps(xmm7, xmm20, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62617C081319"                  , vmovlps(qword_ptr(rcx), xmm27));
  TEST_INSTRUCTION("62217C08139CF023010000"        , vmovlps(qword_ptr(rax, r14, 3, 291), xmm27));
  TEST_INSTRUCTION("62617C08135A7F"                , vmovlps(qword_ptr(rdx, 1016), xmm27));
  TEST_INSTRUCTION("62617C08139A00040000"          , vmovlps(qword_ptr(rdx, 1024), xmm27));
  TEST_INSTRUCTION("62617C08135A80"                , vmovlps(qword_ptr(rdx, -1024), xmm27));
  TEST_INSTRUCTION("62617C08139AF8FBFFFF"          , vmovlps(qword_ptr(rdx, -1032), xmm27));
  TEST_INSTRUCTION("62617D48E701"                  , vmovntdq(zmmword_ptr(rcx), zmm24));
  TEST_INSTRUCTION("62217D48E784F023010000"        , vmovntdq(zmmword_ptr(rax, r14, 3, 291), zmm24));
  TEST_INSTRUCTION("62617D48E7427F"                , vmovntdq(zmmword_ptr(rdx, 8128), zmm24));
  TEST_INSTRUCTION("62617D48E78200200000"          , vmovntdq(zmmword_ptr(rdx, 8192), zmm24));
  TEST_INSTRUCTION("62617D48E74280"                , vmovntdq(zmmword_ptr(rdx, -8192), zmm24));
  TEST_INSTRUCTION("62617D48E782C0DFFFFF"          , vmovntdq(zmmword_ptr(rdx, -8256), zmm24));
  TEST_INSTRUCTION("62E27D482A09"                  , vmovntdqa(zmm17, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A27D482A8CF023010000"        , vmovntdqa(zmm17, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E27D482A4A7F"                , vmovntdqa(zmm17, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E27D482A8A00200000"          , vmovntdqa(zmm17, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E27D482A4A80"                , vmovntdqa(zmm17, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E27D482A8AC0DFFFFF"          , vmovntdqa(zmm17, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E1FD482B09"                  , vmovntpd(zmmword_ptr(rcx), zmm17));
  TEST_INSTRUCTION("62A1FD482B8CF023010000"        , vmovntpd(zmmword_ptr(rax, r14, 3, 291), zmm17));
  TEST_INSTRUCTION("62E1FD482B4A7F"                , vmovntpd(zmmword_ptr(rdx, 8128), zmm17));
  TEST_INSTRUCTION("62E1FD482B8A00200000"          , vmovntpd(zmmword_ptr(rdx, 8192), zmm17));
  TEST_INSTRUCTION("62E1FD482B4A80"                , vmovntpd(zmmword_ptr(rdx, -8192), zmm17));
  TEST_INSTRUCTION("62E1FD482B8AC0DFFFFF"          , vmovntpd(zmmword_ptr(rdx, -8256), zmm17));
  TEST_INSTRUCTION("62F17C482B29"                  , vmovntps(zmmword_ptr(rcx), zmm5));
  TEST_INSTRUCTION("62B17C482BACF023010000"        , vmovntps(zmmword_ptr(rax, r14, 3, 291), zmm5));
  TEST_INSTRUCTION("62F17C482B6A7F"                , vmovntps(zmmword_ptr(rdx, 8128), zmm5));
  TEST_INSTRUCTION("62F17C482BAA00200000"          , vmovntps(zmmword_ptr(rdx, 8192), zmm5));
  TEST_INSTRUCTION("62F17C482B6A80"                , vmovntps(zmmword_ptr(rdx, -8192), zmm5));
  TEST_INSTRUCTION("62F17C482BAAC0DFFFFF"          , vmovntps(zmmword_ptr(rdx, -8256), zmm5));
  TEST_INSTRUCTION("6261FF081009"                  , vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6261FF0B1009"                  , k(k3).vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6261FF8B1009"                  , k(k3).z().vmovsd(xmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6221FF08108CF023010000"        , vmovsd(xmm25, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261FF08104A7F"                , vmovsd(xmm25, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6261FF08108A00040000"          , vmovsd(xmm25, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6261FF08104A80"                , vmovsd(xmm25, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6261FF08108AF8FBFFFF"          , vmovsd(xmm25, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("6261FF081109"                  , vmovsd(qword_ptr(rcx), xmm25));
  TEST_INSTRUCTION("6261FF0A1109"                  , k(k2).vmovsd(qword_ptr(rcx), xmm25));
  TEST_INSTRUCTION("6221FF08118CF023010000"        , vmovsd(qword_ptr(rax, r14, 3, 291), xmm25));
  TEST_INSTRUCTION("6261FF08114A7F"                , vmovsd(qword_ptr(rdx, 1016), xmm25));
  TEST_INSTRUCTION("6261FF08118A00040000"          , vmovsd(qword_ptr(rdx, 1024), xmm25));
  TEST_INSTRUCTION("6261FF08114A80"                , vmovsd(qword_ptr(rdx, -1024), xmm25));
  TEST_INSTRUCTION("6261FF08118AF8FBFFFF"          , vmovsd(qword_ptr(rdx, -1032), xmm25));
  TEST_INSTRUCTION("6221E70810DB"                  , vmovsd(xmm27, xmm3, xmm19));
  TEST_INSTRUCTION("6221E70B10DB"                  , k(k3).vmovsd(xmm27, xmm3, xmm19));
  TEST_INSTRUCTION("6221E78B10DB"                  , k(k3).z().vmovsd(xmm27, xmm3, xmm19));
  TEST_INSTRUCTION("62817E4816C3"                  , vmovshdup(zmm16, zmm27));
  TEST_INSTRUCTION("62817E4C16C3"                  , k(k4).vmovshdup(zmm16, zmm27));
  TEST_INSTRUCTION("62817ECC16C3"                  , k(k4).z().vmovshdup(zmm16, zmm27));
  TEST_INSTRUCTION("62E17E481601"                  , vmovshdup(zmm16, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17E481684F023010000"        , vmovshdup(zmm16, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17E4816427F"                , vmovshdup(zmm16, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E17E48168200200000"          , vmovshdup(zmm16, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E17E48164280"                , vmovshdup(zmm16, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E17E481682C0DFFFFF"          , vmovshdup(zmm16, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62517E4812EE"                  , vmovsldup(zmm13, zmm14));
  TEST_INSTRUCTION("62517E4E12EE"                  , k(k6).vmovsldup(zmm13, zmm14));
  TEST_INSTRUCTION("62517ECE12EE"                  , k(k6).z().vmovsldup(zmm13, zmm14));
  TEST_INSTRUCTION("62717E481229"                  , vmovsldup(zmm13, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62317E4812ACF023010000"        , vmovsldup(zmm13, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62717E48126A7F"                , vmovsldup(zmm13, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62717E4812AA00200000"          , vmovsldup(zmm13, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62717E48126A80"                , vmovsldup(zmm13, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62717E4812AAC0DFFFFF"          , vmovsldup(zmm13, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("C5FA1011"                      , vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F17E0C1011"                  , k(k4).vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("62F17E8C1011"                  , k(k4).z().vmovss(xmm2, dword_ptr(rcx)));
  TEST_INSTRUCTION("C4A17A1094F023010000"          , vmovss(xmm2, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C5FA1092FC010000"              , vmovss(xmm2, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("C5FA109200020000"              , vmovss(xmm2, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("C5FA109200FEFFFF"              , vmovss(xmm2, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("C5FA1092FCFDFFFF"              , vmovss(xmm2, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("C5FA1129"                      , vmovss(dword_ptr(rcx), xmm5));
  TEST_INSTRUCTION("62F17E0E1129"                  , k(k6).vmovss(dword_ptr(rcx), xmm5));
  TEST_INSTRUCTION("C4A17A11ACF023010000"          , vmovss(dword_ptr(rax, r14, 3, 291), xmm5));
  TEST_INSTRUCTION("C5FA11AAFC010000"              , vmovss(dword_ptr(rdx, 508), xmm5));
  TEST_INSTRUCTION("C5FA11AA00020000"              , vmovss(dword_ptr(rdx, 512), xmm5));
  TEST_INSTRUCTION("C5FA11AA00FEFFFF"              , vmovss(dword_ptr(rdx, -512), xmm5));
  TEST_INSTRUCTION("C5FA11AAFCFDFFFF"              , vmovss(dword_ptr(rdx, -516), xmm5));
  TEST_INSTRUCTION("6201360810E2"                  , vmovss(xmm28, xmm9, xmm26));
  TEST_INSTRUCTION("6201360C10E2"                  , k(k4).vmovss(xmm28, xmm9, xmm26));
  TEST_INSTRUCTION("6201368C10E2"                  , k(k4).z().vmovss(xmm28, xmm9, xmm26));
  TEST_INSTRUCTION("6241FD4810D9"                  , vmovupd(zmm27, zmm9));
  TEST_INSTRUCTION("6241FD4A10D9"                  , k(k2).vmovupd(zmm27, zmm9));
  TEST_INSTRUCTION("6241FDCA10D9"                  , k(k2).z().vmovupd(zmm27, zmm9));
  TEST_INSTRUCTION("6261FD481019"                  , vmovupd(zmm27, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6221FD48109CF023010000"        , vmovupd(zmm27, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261FD48105A7F"                , vmovupd(zmm27, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6261FD48109A00200000"          , vmovupd(zmm27, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6261FD48105A80"                , vmovupd(zmm27, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6261FD48109AC0DFFFFF"          , vmovupd(zmm27, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62A17C4810F6"                  , vmovups(zmm22, zmm22));
  TEST_INSTRUCTION("62A17C4B10F6"                  , k(k3).vmovups(zmm22, zmm22));
  TEST_INSTRUCTION("62A17CCB10F6"                  , k(k3).z().vmovups(zmm22, zmm22));
  TEST_INSTRUCTION("62E17C481031"                  , vmovups(zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A17C4810B4F023010000"        , vmovups(zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E17C4810727F"                , vmovups(zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E17C4810B200200000"          , vmovups(zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E17C48107280"                , vmovups(zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E17C4810B2C0DFFFFF"          , vmovups(zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6221DD4859C7"                  , vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DD4E59C7"                  , k(k6).vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DDCE59C7"                  , k(k6).z().vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DD1859C7"                  , rn_sae().vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DD5859C7"                  , ru_sae().vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DD3859C7"                  , rd_sae().vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6221DD7859C7"                  , rz_sae().vmulpd(zmm24, zmm4, zmm23));
  TEST_INSTRUCTION("6261DD485901"                  , vmulpd(zmm24, zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6221DD485984F023010000"        , vmulpd(zmm24, zmm4, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6261DD585901"                  , vmulpd(zmm24, zmm4, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6261DD4859427F"                , vmulpd(zmm24, zmm4, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6261DD48598200200000"          , vmulpd(zmm24, zmm4, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6261DD48594280"                , vmulpd(zmm24, zmm4, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6261DD485982C0DFFFFF"          , vmulpd(zmm24, zmm4, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6261DD5859427F"                , vmulpd(zmm24, zmm4, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6261DD58598200040000"          , vmulpd(zmm24, zmm4, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6261DD58594280"                , vmulpd(zmm24, zmm4, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6261DD585982F8FBFFFF"          , vmulpd(zmm24, zmm4, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62914C4859D8"                  , vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914C4C59D8"                  , k(k4).vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914CCC59D8"                  , k(k4).z().vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914C1859D8"                  , rn_sae().vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914C5859D8"                  , ru_sae().vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914C3859D8"                  , rd_sae().vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62914C7859D8"                  , rz_sae().vmulps(zmm3, zmm6, zmm24));
  TEST_INSTRUCTION("62F14C485919"                  , vmulps(zmm3, zmm6, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B14C48599CF023010000"        , vmulps(zmm3, zmm6, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F14C585919"                  , vmulps(zmm3, zmm6, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F14C48595A7F"                , vmulps(zmm3, zmm6, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F14C48599A00200000"          , vmulps(zmm3, zmm6, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F14C48595A80"                , vmulps(zmm3, zmm6, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F14C48599AC0DFFFFF"          , vmulps(zmm3, zmm6, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F14C58595A7F"                , vmulps(zmm3, zmm6, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F14C58599A00020000"          , vmulps(zmm3, zmm6, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F14C58595A80"                , vmulps(zmm3, zmm6, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F14C58599AFCFDFFFF"          , vmulps(zmm3, zmm6, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6231DF0859EA"                  , vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF0A59EA"                  , k(k2).vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF8A59EA"                  , k(k2).z().vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF1859EA"                  , rn_sae().vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF5859EA"                  , ru_sae().vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF3859EA"                  , rd_sae().vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("6231DF7859EA"                  , rz_sae().vmulsd(xmm13, xmm4, xmm18));
  TEST_INSTRUCTION("C55B5929"                      , vmulsd(xmm13, xmm4, qword_ptr(rcx)));
  TEST_INSTRUCTION("C4215B59ACF023010000"          , vmulsd(xmm13, xmm4, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("C55B59AAF8030000"              , vmulsd(xmm13, xmm4, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("C55B59AA00040000"              , vmulsd(xmm13, xmm4, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("C55B59AA00FCFFFF"              , vmulsd(xmm13, xmm4, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("C55B59AAF8FBFFFF"              , vmulsd(xmm13, xmm4, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62C12E0859F6"                  , vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E0C59F6"                  , k(k4).vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E8C59F6"                  , k(k4).z().vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E1859F6"                  , rn_sae().vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E5859F6"                  , ru_sae().vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E3859F6"                  , rd_sae().vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62C12E7859F6"                  , rz_sae().vmulss(xmm22, xmm10, xmm14));
  TEST_INSTRUCTION("62E12E085931"                  , vmulss(xmm22, xmm10, dword_ptr(rcx)));
  TEST_INSTRUCTION("62A12E0859B4F023010000"        , vmulss(xmm22, xmm10, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E12E0859727F"                , vmulss(xmm22, xmm10, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62E12E0859B200020000"          , vmulss(xmm22, xmm10, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62E12E08597280"                , vmulss(xmm22, xmm10, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62E12E0859B2FCFDFFFF"          , vmulss(xmm22, xmm10, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62527D481EFE"                  , vpabsd(zmm15, zmm14));
  TEST_INSTRUCTION("62527D4E1EFE"                  , k(k6).vpabsd(zmm15, zmm14));
  TEST_INSTRUCTION("62527DCE1EFE"                  , k(k6).z().vpabsd(zmm15, zmm14));
  TEST_INSTRUCTION("62727D481E39"                  , vpabsd(zmm15, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62327D481EBCF023010000"        , vpabsd(zmm15, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62727D581E39"                  , vpabsd(zmm15, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62727D481E7A7F"                , vpabsd(zmm15, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62727D481EBA00200000"          , vpabsd(zmm15, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62727D481E7A80"                , vpabsd(zmm15, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62727D481EBAC0DFFFFF"          , vpabsd(zmm15, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62727D581E7A7F"                , vpabsd(zmm15, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62727D581EBA00020000"          , vpabsd(zmm15, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62727D581E7A80"                , vpabsd(zmm15, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62727D581EBAFCFDFFFF"          , vpabsd(zmm15, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6292FD481FE8"                  , vpabsq(zmm5, zmm24));
  TEST_INSTRUCTION("6292FD4E1FE8"                  , k(k6).vpabsq(zmm5, zmm24));
  TEST_INSTRUCTION("6292FDCE1FE8"                  , k(k6).z().vpabsq(zmm5, zmm24));
  TEST_INSTRUCTION("62F2FD481F29"                  , vpabsq(zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2FD481FACF023010000"        , vpabsq(zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2FD581F29"                  , vpabsq(zmm5, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F2FD481F6A7F"                , vpabsq(zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2FD481FAA00200000"          , vpabsq(zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F2FD481F6A80"                , vpabsq(zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2FD481FAAC0DFFFFF"          , vpabsq(zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2FD581F6A7F"                , vpabsq(zmm5, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F2FD581FAA00040000"          , vpabsq(zmm5, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F2FD581F6A80"                , vpabsq(zmm5, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F2FD581FAAF8FBFFFF"          , vpabsq(zmm5, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62215548FED4"                  , vpaddd(zmm26, zmm5, zmm20));
  TEST_INSTRUCTION("62215549FED4"                  , k(k1).vpaddd(zmm26, zmm5, zmm20));
  TEST_INSTRUCTION("622155C9FED4"                  , k(k1).z().vpaddd(zmm26, zmm5, zmm20));
  TEST_INSTRUCTION("62615548FE11"                  , vpaddd(zmm26, zmm5, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62215548FE94F023010000"        , vpaddd(zmm26, zmm5, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62615558FE11"                  , vpaddd(zmm26, zmm5, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62615548FE527F"                , vpaddd(zmm26, zmm5, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62615548FE9200200000"          , vpaddd(zmm26, zmm5, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62615548FE5280"                , vpaddd(zmm26, zmm5, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62615548FE92C0DFFFFF"          , vpaddd(zmm26, zmm5, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62615558FE527F"                , vpaddd(zmm26, zmm5, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62615558FE9200020000"          , vpaddd(zmm26, zmm5, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62615558FE5280"                , vpaddd(zmm26, zmm5, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62615558FE92FCFDFFFF"          , vpaddd(zmm26, zmm5, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("6251B540D4C6"                  , vpaddq(zmm8, zmm25, zmm14));
  TEST_INSTRUCTION("6251B543D4C6"                  , k(k3).vpaddq(zmm8, zmm25, zmm14));
  TEST_INSTRUCTION("6251B5C3D4C6"                  , k(k3).z().vpaddq(zmm8, zmm25, zmm14));
  TEST_INSTRUCTION("6271B540D401"                  , vpaddq(zmm8, zmm25, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("6231B540D484F023010000"        , vpaddq(zmm8, zmm25, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6271B550D401"                  , vpaddq(zmm8, zmm25, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("6271B540D4427F"                , vpaddq(zmm8, zmm25, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("6271B540D48200200000"          , vpaddq(zmm8, zmm25, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("6271B540D44280"                , vpaddq(zmm8, zmm25, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("6271B540D482C0DFFFFF"          , vpaddq(zmm8, zmm25, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("6271B550D4427F"                , vpaddq(zmm8, zmm25, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("6271B550D48200040000"          , vpaddq(zmm8, zmm25, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("6271B550D44280"                , vpaddq(zmm8, zmm25, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("6271B550D482F8FBFFFF"          , vpaddq(zmm8, zmm25, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62814D40DBD9"                  , vpandd(zmm19, zmm22, zmm25));
  TEST_INSTRUCTION("62814D41DBD9"                  , k(k1).vpandd(zmm19, zmm22, zmm25));
  TEST_INSTRUCTION("62814DC1DBD9"                  , k(k1).z().vpandd(zmm19, zmm22, zmm25));
  TEST_INSTRUCTION("62E14D40DB19"                  , vpandd(zmm19, zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A14D40DB9CF023010000"        , vpandd(zmm19, zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E14D50DB19"                  , vpandd(zmm19, zmm22, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62E14D40DB5A7F"                , vpandd(zmm19, zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E14D40DB9A00200000"          , vpandd(zmm19, zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E14D40DB5A80"                , vpandd(zmm19, zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E14D40DB9AC0DFFFFF"          , vpandd(zmm19, zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E14D50DB5A7F"                , vpandd(zmm19, zmm22, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62E14D50DB9A00020000"          , vpandd(zmm19, zmm22, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62E14D50DB5A80"                , vpandd(zmm19, zmm22, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62E14D50DB9AFCFDFFFF"          , vpandd(zmm19, zmm22, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62411D40DFF7"                  , vpandnd(zmm30, zmm28, zmm15));
  TEST_INSTRUCTION("62411D43DFF7"                  , k(k3).vpandnd(zmm30, zmm28, zmm15));
  TEST_INSTRUCTION("62411DC3DFF7"                  , k(k3).z().vpandnd(zmm30, zmm28, zmm15));
  TEST_INSTRUCTION("62611D40DF31"                  , vpandnd(zmm30, zmm28, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62211D40DFB4F023010000"        , vpandnd(zmm30, zmm28, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62611D50DF31"                  , vpandnd(zmm30, zmm28, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62611D40DF727F"                , vpandnd(zmm30, zmm28, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62611D40DFB200200000"          , vpandnd(zmm30, zmm28, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62611D40DF7280"                , vpandnd(zmm30, zmm28, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62611D40DFB2C0DFFFFF"          , vpandnd(zmm30, zmm28, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62611D50DF727F"                , vpandnd(zmm30, zmm28, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62611D50DFB200020000"          , vpandnd(zmm30, zmm28, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62611D50DF7280"                , vpandnd(zmm30, zmm28, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62611D50DFB2FCFDFFFF"          , vpandnd(zmm30, zmm28, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62A1C548DFE3"                  , vpandnq(zmm20, zmm7, zmm19));
  TEST_INSTRUCTION("62A1C54DDFE3"                  , k(k5).vpandnq(zmm20, zmm7, zmm19));
  TEST_INSTRUCTION("62A1C5CDDFE3"                  , k(k5).z().vpandnq(zmm20, zmm7, zmm19));
  TEST_INSTRUCTION("62E1C548DF21"                  , vpandnq(zmm20, zmm7, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A1C548DFA4F023010000"        , vpandnq(zmm20, zmm7, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1C558DF21"                  , vpandnq(zmm20, zmm7, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E1C548DF627F"                , vpandnq(zmm20, zmm7, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E1C548DFA200200000"          , vpandnq(zmm20, zmm7, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E1C548DF6280"                , vpandnq(zmm20, zmm7, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E1C548DFA2C0DFFFFF"          , vpandnq(zmm20, zmm7, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E1C558DF627F"                , vpandnq(zmm20, zmm7, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E1C558DFA200040000"          , vpandnq(zmm20, zmm7, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E1C558DF6280"                , vpandnq(zmm20, zmm7, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E1C558DFA2F8FBFFFF"          , vpandnq(zmm20, zmm7, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("6281DD48DBCA"                  , vpandq(zmm17, zmm4, zmm26));
  TEST_INSTRUCTION("6281DD4FDBCA"                  , k(k7).vpandq(zmm17, zmm4, zmm26));
  TEST_INSTRUCTION("6281DDCFDBCA"                  , k(k7).z().vpandq(zmm17, zmm4, zmm26));
  TEST_INSTRUCTION("62E1DD48DB09"                  , vpandq(zmm17, zmm4, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62A1DD48DB8CF023010000"        , vpandq(zmm17, zmm4, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62E1DD58DB09"                  , vpandq(zmm17, zmm4, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62E1DD48DB4A7F"                , vpandq(zmm17, zmm4, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62E1DD48DB8A00200000"          , vpandq(zmm17, zmm4, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62E1DD48DB4A80"                , vpandq(zmm17, zmm4, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62E1DD48DB8AC0DFFFFF"          , vpandq(zmm17, zmm4, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62E1DD58DB4A7F"                , vpandq(zmm17, zmm4, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62E1DD58DB8A00040000"          , vpandq(zmm17, zmm4, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62E1DD58DB4A80"                , vpandq(zmm17, zmm4, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62E1DD58DB8AF8FBFFFF"          , vpandq(zmm17, zmm4, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62D2354064EB"                  , vpblendmd(zmm5, zmm25, zmm11));
  TEST_INSTRUCTION("62D2354364EB"                  , k(k3).vpblendmd(zmm5, zmm25, zmm11));
  TEST_INSTRUCTION("62D235C364EB"                  , k(k3).z().vpblendmd(zmm5, zmm25, zmm11));
  TEST_INSTRUCTION("62F235406429"                  , vpblendmd(zmm5, zmm25, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2354064ACF023010000"        , vpblendmd(zmm5, zmm25, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F235506429"                  , vpblendmd(zmm5, zmm25, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F23540646A7F"                , vpblendmd(zmm5, zmm25, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2354064AA00200000"          , vpblendmd(zmm5, zmm25, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F23540646A80"                , vpblendmd(zmm5, zmm25, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2354064AAC0DFFFFF"          , vpblendmd(zmm5, zmm25, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F23550646A7F"                , vpblendmd(zmm5, zmm25, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F2355064AA00020000"          , vpblendmd(zmm5, zmm25, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F23550646A80"                , vpblendmd(zmm5, zmm25, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F2355064AAFCFDFFFF"          , vpblendmd(zmm5, zmm25, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62627D485811"                  , vpbroadcastd(zmm26, dword_ptr(rcx)));
  TEST_INSTRUCTION("62627D4A5811"                  , k(k2).vpbroadcastd(zmm26, dword_ptr(rcx)));
  TEST_INSTRUCTION("62627DCA5811"                  , k(k2).z().vpbroadcastd(zmm26, dword_ptr(rcx)));
  TEST_INSTRUCTION("62227D485894F023010000"        , vpbroadcastd(zmm26, dword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62627D4858527F"                , vpbroadcastd(zmm26, dword_ptr(rdx, 508)));
  TEST_INSTRUCTION("62627D48589200020000"          , vpbroadcastd(zmm26, dword_ptr(rdx, 512)));
  TEST_INSTRUCTION("62627D48585280"                , vpbroadcastd(zmm26, dword_ptr(rdx, -512)));
  TEST_INSTRUCTION("62627D485892FCFDFFFF"          , vpbroadcastd(zmm26, dword_ptr(rdx, -516)));
  TEST_INSTRUCTION("62327D4858D6"                  , vpbroadcastd(zmm10, xmm22));
  TEST_INSTRUCTION("62327D4F58D6"                  , k(k7).vpbroadcastd(zmm10, xmm22));
  TEST_INSTRUCTION("62327DCF58D6"                  , k(k7).z().vpbroadcastd(zmm10, xmm22));
  TEST_INSTRUCTION("62727D487CD8"                  , vpbroadcastd(zmm11, eax));
  TEST_INSTRUCTION("62727D4E7CD8"                  , k(k6).vpbroadcastd(zmm11, eax));
  TEST_INSTRUCTION("62727DCE7CD8"                  , k(k6).z().vpbroadcastd(zmm11, eax));
  TEST_INSTRUCTION("62727D487CDD"                  , vpbroadcastd(zmm11, ebp));
  TEST_INSTRUCTION("62527D487CDD"                  , vpbroadcastd(zmm11, r13d));
  TEST_INSTRUCTION("6262FD485909"                  , vpbroadcastq(zmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6262FD4A5909"                  , k(k2).vpbroadcastq(zmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6262FDCA5909"                  , k(k2).z().vpbroadcastq(zmm25, qword_ptr(rcx)));
  TEST_INSTRUCTION("6222FD48598CF023010000"        , vpbroadcastq(zmm25, qword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("6262FD48594A7F"                , vpbroadcastq(zmm25, qword_ptr(rdx, 1016)));
  TEST_INSTRUCTION("6262FD48598A00040000"          , vpbroadcastq(zmm25, qword_ptr(rdx, 1024)));
  TEST_INSTRUCTION("6262FD48594A80"                , vpbroadcastq(zmm25, qword_ptr(rdx, -1024)));
  TEST_INSTRUCTION("6262FD48598AF8FBFFFF"          , vpbroadcastq(zmm25, qword_ptr(rdx, -1032)));
  TEST_INSTRUCTION("62F2FD4859DD"                  , vpbroadcastq(zmm3, xmm5));
  TEST_INSTRUCTION("62F2FD4D59DD"                  , k(k5).vpbroadcastq(zmm3, xmm5));
  TEST_INSTRUCTION("62F2FDCD59DD"                  , k(k5).z().vpbroadcastq(zmm3, xmm5));
  TEST_INSTRUCTION("62F2FD487CC8"                  , vpbroadcastq(zmm1, rax));
  TEST_INSTRUCTION("62F2FD4E7CC8"                  , k(k6).vpbroadcastq(zmm1, rax));
  TEST_INSTRUCTION("62F2FDCE7CC8"                  , k(k6).z().vpbroadcastq(zmm1, rax));
  TEST_INSTRUCTION("62D2FD487CC8"                  , vpbroadcastq(zmm1, r8));
  TEST_INSTRUCTION("62D335401FEAAB"                , vpcmpd(k5, zmm25, zmm10, 171));
  TEST_INSTRUCTION("62D335431FEAAB"                , k(k3).vpcmpd(k5, zmm25, zmm10, 171));
  TEST_INSTRUCTION("62D335401FEA7B"                , vpcmpd(k5, zmm25, zmm10, 123));
  TEST_INSTRUCTION("62F335401F297B"                , vpcmpd(k5, zmm25, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B335401FACF0230100007B"      , vpcmpd(k5, zmm25, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F335501F297B"                , vpcmpd(k5, zmm25, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62F335401F6A7F7B"              , vpcmpd(k5, zmm25, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F335401FAA002000007B"        , vpcmpd(k5, zmm25, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F335401F6A807B"              , vpcmpd(k5, zmm25, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F335401FAAC0DFFFFF7B"        , vpcmpd(k5, zmm25, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F335501F6A7F7B"              , vpcmpd(k5, zmm25, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62F335501FAA000200007B"        , vpcmpd(k5, zmm25, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62F335501F6A807B"              , vpcmpd(k5, zmm25, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62F335501FAAFCFDFFFF7B"        , vpcmpd(k5, zmm25, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62D16D4876EA"                  , vpcmpeqd(k5, zmm2, zmm10));
  TEST_INSTRUCTION("62D16D4F76EA"                  , k(k7).vpcmpeqd(k5, zmm2, zmm10));
  TEST_INSTRUCTION("62F16D487629"                  , vpcmpeqd(k5, zmm2, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B16D4876ACF023010000"        , vpcmpeqd(k5, zmm2, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F16D587629"                  , vpcmpeqd(k5, zmm2, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F16D48766A7F"                , vpcmpeqd(k5, zmm2, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F16D4876AA00200000"          , vpcmpeqd(k5, zmm2, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F16D48766A80"                , vpcmpeqd(k5, zmm2, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F16D4876AAC0DFFFFF"          , vpcmpeqd(k5, zmm2, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F16D58766A7F"                , vpcmpeqd(k5, zmm2, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F16D5876AA00020000"          , vpcmpeqd(k5, zmm2, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F16D58766A80"                , vpcmpeqd(k5, zmm2, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F16D5876AAFCFDFFFF"          , vpcmpeqd(k5, zmm2, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62F2CD4029DA"                  , vpcmpeqq(k3, zmm22, zmm2));
  TEST_INSTRUCTION("62F2CD4629DA"                  , k(k6).vpcmpeqq(k3, zmm22, zmm2));
  TEST_INSTRUCTION("62F2CD402919"                  , vpcmpeqq(k3, zmm22, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2CD40299CF023010000"        , vpcmpeqq(k3, zmm22, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2CD502919"                  , vpcmpeqq(k3, zmm22, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F2CD40295A7F"                , vpcmpeqq(k3, zmm22, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2CD40299A00200000"          , vpcmpeqq(k3, zmm22, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F2CD40295A80"                , vpcmpeqq(k3, zmm22, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2CD40299AC0DFFFFF"          , vpcmpeqq(k3, zmm22, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2CD50295A7F"                , vpcmpeqq(k3, zmm22, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F2CD50299A00040000"          , vpcmpeqq(k3, zmm22, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F2CD50295A80"                , vpcmpeqq(k3, zmm22, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F2CD50299AF8FBFFFF"          , vpcmpeqq(k3, zmm22, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62D1554066E8"                  , vpcmpgtd(k5, zmm21, zmm8));
  TEST_INSTRUCTION("62D1554566E8"                  , k(k5).vpcmpgtd(k5, zmm21, zmm8));
  TEST_INSTRUCTION("62F155406629"                  , vpcmpgtd(k5, zmm21, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B1554066ACF023010000"        , vpcmpgtd(k5, zmm21, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F155506629"                  , vpcmpgtd(k5, zmm21, dword_ptr(rcx)._1to16()));
  TEST_INSTRUCTION("62F15540666A7F"                , vpcmpgtd(k5, zmm21, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F1554066AA00200000"          , vpcmpgtd(k5, zmm21, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F15540666A80"                , vpcmpgtd(k5, zmm21, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F1554066AAC0DFFFFF"          , vpcmpgtd(k5, zmm21, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F15550666A7F"                , vpcmpgtd(k5, zmm21, dword_ptr(rdx, 508)._1to16()));
  TEST_INSTRUCTION("62F1555066AA00020000"          , vpcmpgtd(k5, zmm21, dword_ptr(rdx, 512)._1to16()));
  TEST_INSTRUCTION("62F15550666A80"                , vpcmpgtd(k5, zmm21, dword_ptr(rdx, -512)._1to16()));
  TEST_INSTRUCTION("62F1555066AAFCFDFFFF"          , vpcmpgtd(k5, zmm21, dword_ptr(rdx, -516)._1to16()));
  TEST_INSTRUCTION("62B2DD4037D1"                  , vpcmpgtq(k2, zmm20, zmm17));
  TEST_INSTRUCTION("62B2DD4337D1"                  , k(k3).vpcmpgtq(k2, zmm20, zmm17));
  TEST_INSTRUCTION("62F2DD403711"                  , vpcmpgtq(k2, zmm20, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62B2DD403794F023010000"        , vpcmpgtq(k2, zmm20, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62F2DD503711"                  , vpcmpgtq(k2, zmm20, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62F2DD4037527F"                , vpcmpgtq(k2, zmm20, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62F2DD40379200200000"          , vpcmpgtq(k2, zmm20, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62F2DD40375280"                , vpcmpgtq(k2, zmm20, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62F2DD403792C0DFFFFF"          , vpcmpgtq(k2, zmm20, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62F2DD5037527F"                , vpcmpgtq(k2, zmm20, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62F2DD50379200040000"          , vpcmpgtq(k2, zmm20, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62F2DD50375280"                , vpcmpgtq(k2, zmm20, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62F2DD503792F8FBFFFF"          , vpcmpgtq(k2, zmm20, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62939D401FECAB"                , vpcmpq(k5, zmm28, zmm28, 171));
  TEST_INSTRUCTION("62939D431FECAB"                , k(k3).vpcmpq(k5, zmm28, zmm28, 171));
  TEST_INSTRUCTION("62939D401FEC7B"                , vpcmpq(k5, zmm28, zmm28, 123));
  TEST_INSTRUCTION("62F39D401F297B"                , vpcmpq(k5, zmm28, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B39D401FACF0230100007B"      , vpcmpq(k5, zmm28, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F39D501F297B"                , vpcmpq(k5, zmm28, qword_ptr(rcx)._1to8(), 123));
  TEST_INSTRUCTION("62F39D401F6A7F7B"              , vpcmpq(k5, zmm28, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F39D401FAA002000007B"        , vpcmpq(k5, zmm28, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F39D401F6A807B"              , vpcmpq(k5, zmm28, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F39D401FAAC0DFFFFF7B"        , vpcmpq(k5, zmm28, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F39D501F6A7F7B"              , vpcmpq(k5, zmm28, qword_ptr(rdx, 1016)._1to8(), 123));
  TEST_INSTRUCTION("62F39D501FAA000400007B"        , vpcmpq(k5, zmm28, qword_ptr(rdx, 1024)._1to8(), 123));
  TEST_INSTRUCTION("62F39D501F6A807B"              , vpcmpq(k5, zmm28, qword_ptr(rdx, -1024)._1to8(), 123));
  TEST_INSTRUCTION("62F39D501FAAF8FBFFFF7B"        , vpcmpq(k5, zmm28, qword_ptr(rdx, -1032)._1to8(), 123));
  TEST_INSTRUCTION("62F335401ED7AB"                , vpcmpud(k2, zmm25, zmm7, 171));
  TEST_INSTRUCTION("62F335411ED7AB"                , k(k1).vpcmpud(k2, zmm25, zmm7, 171));
  TEST_INSTRUCTION("62F335401ED77B"                , vpcmpud(k2, zmm25, zmm7, 123));
  TEST_INSTRUCTION("62F335401E117B"                , vpcmpud(k2, zmm25, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B335401E94F0230100007B"      , vpcmpud(k2, zmm25, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F335501E117B"                , vpcmpud(k2, zmm25, dword_ptr(rcx)._1to16(), 123));
  TEST_INSTRUCTION("62F335401E527F7B"              , vpcmpud(k2, zmm25, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F335401E92002000007B"        , vpcmpud(k2, zmm25, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F335401E52807B"              , vpcmpud(k2, zmm25, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F335401E92C0DFFFFF7B"        , vpcmpud(k2, zmm25, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F335501E527F7B"              , vpcmpud(k2, zmm25, dword_ptr(rdx, 508)._1to16(), 123));
  TEST_INSTRUCTION("62F335501E92000200007B"        , vpcmpud(k2, zmm25, dword_ptr(rdx, 512)._1to16(), 123));
  TEST_INSTRUCTION("62F335501E52807B"              , vpcmpud(k2, zmm25, dword_ptr(rdx, -512)._1to16(), 123));
  TEST_INSTRUCTION("62F335501E92FCFDFFFF7B"        , vpcmpud(k2, zmm25, dword_ptr(rdx, -516)._1to16(), 123));
  TEST_INSTRUCTION("62D38D481ED8AB"                , vpcmpuq(k3, zmm14, zmm8, 171));
  TEST_INSTRUCTION("62D38D4A1ED8AB"                , k(k2).vpcmpuq(k3, zmm14, zmm8, 171));
  TEST_INSTRUCTION("62D38D481ED87B"                , vpcmpuq(k3, zmm14, zmm8, 123));
  TEST_INSTRUCTION("62F38D481E197B"                , vpcmpuq(k3, zmm14, zmmword_ptr(rcx), 123));
  TEST_INSTRUCTION("62B38D481E9CF0230100007B"      , vpcmpuq(k3, zmm14, zmmword_ptr(rax, r14, 3, 291), 123));
  TEST_INSTRUCTION("62F38D581E197B"                , vpcmpuq(k3, zmm14, qword_ptr(rcx)._1to8(), 123));
  TEST_INSTRUCTION("62F38D481E5A7F7B"              , vpcmpuq(k3, zmm14, zmmword_ptr(rdx, 8128), 123));
  TEST_INSTRUCTION("62F38D481E9A002000007B"        , vpcmpuq(k3, zmm14, zmmword_ptr(rdx, 8192), 123));
  TEST_INSTRUCTION("62F38D481E5A807B"              , vpcmpuq(k3, zmm14, zmmword_ptr(rdx, -8192), 123));
  TEST_INSTRUCTION("62F38D481E9AC0DFFFFF7B"        , vpcmpuq(k3, zmm14, zmmword_ptr(rdx, -8256), 123));
  TEST_INSTRUCTION("62F38D581E5A7F7B"              , vpcmpuq(k3, zmm14, qword_ptr(rdx, 1016)._1to8(), 123));
  TEST_INSTRUCTION("62F38D581E9A000400007B"        , vpcmpuq(k3, zmm14, qword_ptr(rdx, 1024)._1to8(), 123));
  TEST_INSTRUCTION("62F38D581E5A807B"              , vpcmpuq(k3, zmm14, qword_ptr(rdx, -1024)._1to8(), 123));
  TEST_INSTRUCTION("62F38D581E9AF8FBFFFF7B"        , vpcmpuq(k3, zmm14, qword_ptr(rdx, -1032)._1to8(), 123));
  TEST_INSTRUCTION("62228D4864D9"                  , vpblendmq(zmm27, zmm14, zmm17));
  TEST_INSTRUCTION("62228D4D64D9"                  , k(k5).vpblendmq(zmm27, zmm14, zmm17));
  TEST_INSTRUCTION("62228DCD64D9"                  , k(k5).z().vpblendmq(zmm27, zmm14, zmm17));
  TEST_INSTRUCTION("62628D486419"                  , vpblendmq(zmm27, zmm14, zmmword_ptr(rcx)));
  TEST_INSTRUCTION("62228D48649CF023010000"        , vpblendmq(zmm27, zmm14, zmmword_ptr(rax, r14, 3, 291)));
  TEST_INSTRUCTION("62628D586419"                  , vpblendmq(zmm27, zmm14, qword_ptr(rcx)._1to8()));
  TEST_INSTRUCTION("62628D48645A7F"                , vpblendmq(zmm27, zmm14, zmmword_ptr(rdx, 8128)));
  TEST_INSTRUCTION("62628D48649A00200000"          , vpblendmq(zmm27, zmm14, zmmword_ptr(rdx, 8192)));
  TEST_INSTRUCTION("62628D48645A80"                , vpblendmq(zmm27, zmm14, zmmword_ptr(rdx, -8192)));
  TEST_INSTRUCTION("62628D48649AC0DFFFFF"          , vpblendmq(zmm27, zmm14, zmmword_ptr(rdx, -8256)));
  TEST_INSTRUCTION("62628D58645A7F"                , vpblendmq(zmm27, zmm14, qword_ptr(rdx, 1016)._1to8()));
  TEST_INSTRUCTION("62628D58649A00040000"          , vpblendmq(zmm27, zmm14, qword_ptr(rdx, 1024)._1to8()));
  TEST_INSTRUCTION("62628D58645A80"                , vpblendmq(zmm27, zmm14, qword_ptr(rdx, -1024)._1to8()));
  TEST_INSTRUCTION("62628D58649AF8FBFFFF"          , vpblendmq(zmm27, zmm14, qword_ptr(rdx, -1032)._1to8()));
  TEST_INSTRUCTION("62E27D488B39"                  , vpcompressd(zmmword_ptr(rcx), zmm23));
  TEST_INSTRUCTION("62E27D4F8B39"                  , k(k7).vpcompressd(zmmword_ptr(rcx), zmm23));
  TEST_INSTRUCTION("62A27D488BBCF023010000"        , vpcompressd(zmmword_ptr(rax, r14, 3, 291), zmm23));
  TEST_INSTRUCTION("62E27D488B7A7F"                , vpcompressd(zmmword_ptr(rdx, 508), zmm23));
  TEST_INSTRUCTION("62E27D488BBA00020000"          , vpcompressd(zmmword_ptr(rdx, 512), zmm23));
  TEST_INSTRUCTION("62E27D488B7A80"                , vpcompressd(zmmword_ptr(rdx, -512), zmm23));
  TEST_INSTRUCTION("62E27D488BBAFCFDFFFF"          , vpcompressd(zmmword_ptr(rdx, -516), zmm23));
  TEST_INSTRUCTION("62A27D488BD0"                  , vpcompressd(zmm16, zmm18));
  TEST_INSTRUCTION("62A27D4A8BD0"                  , k(k2).vpcompressd(zmm16, zmm18));
  TEST_INSTRUCTION("62A27DCA8BD0"                  , k(k2).z().vpcompressd(zmm16, zmm18));
  TEST_INSTRUCTION("62C21D4036F1"                  , vpermd(zmm22, zmm28, zmm9));
  TEST_INSTRUCTION("62C21D4136F1"                  , k(k1).vpermd(zmm22, zmm28, zmm9));
  TEST_